/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public class NVRTC {
    public static final int NVRTC_SUCCESS = 0;
    public static final int NVRTC_ERROR_OUT_OF_MEMORY = 1;
    public static final int NVRTC_ERROR_PROGRAM_CREATION_FAILURE = 2;
    public static final int NVRTC_ERROR_INVALID_INPUT = 3;
    public static final int NVRTC_ERROR_INVALID_PROGRAM = 4;
    public static final int NVRTC_ERROR_INVALID_OPTION = 5;
    public static final int NVRTC_ERROR_COMPILATION = 6;
    public static final int NVRTC_ERROR_BUILTIN_OPERATION_FAILURE = 7;
    public static final int NVRTC_ERROR_NO_NAME_EXPRESSIONS_AFTER_COMPILATION = 8;
    public static final int NVRTC_ERROR_NO_LOWERED_NAMES_BEFORE_COMPILATION = 9;
    public static final int NVRTC_ERROR_NAME_EXPRESSION_NOT_VALID = 10;
    public static final int NVRTC_ERROR_INTERNAL_ERROR = 11;
    private static final SharedLibrary NVRTC = CUDA.getToolkitLibrary(NVRTC.class, (Configuration<String>)Configuration.CUDA_NVRTC_LIBRARY_NAME, "nvrtc");
    private static final SharedLibrary NVRTC_BUILTINS = CUDA.getToolkitLibrary(NVRTC.class, (Configuration<String>)Configuration.CUDA_NVRTC_BUILTINS_LIBRARY_NAME, "nvrtc-builtins");

    protected NVRTC() {
        throw new UnsupportedOperationException();
    }

    public static SharedLibrary getLibrary() {
        return NVRTC;
    }

    public static long nnvrtcGetErrorString(int result) {
        long __functionAddress = Functions.GetErrorString;
        return JNI.callP((int)result, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String nvrtcGetErrorString(@NativeType(value="nvrtcResult") int result) {
        long __result = org.lwjgl.cuda.NVRTC.nnvrtcGetErrorString(result);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static int nnvrtcVersion(long major, long minor) {
        long __functionAddress = Functions.Version;
        return JNI.callPPI((long)major, (long)minor, (long)__functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcVersion(@NativeType(value="int *") IntBuffer major, @NativeType(value="int *") IntBuffer minor) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)major, (int)1);
            Checks.check((Buffer)minor, (int)1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcVersion(MemoryUtil.memAddress((IntBuffer)major), MemoryUtil.memAddress((IntBuffer)minor));
    }

    public static int nnvrtcCreateProgram(long prog, long src, long name, int numHeaders, long headers, long includeNames) {
        long __functionAddress = Functions.CreateProgram;
        return JNI.callPPPPPI((long)prog, (long)src, (long)name, (int)numHeaders, (long)headers, (long)includeNames, (long)__functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcCreateProgram(@NativeType(value="nvrtcProgram *") PointerBuffer prog, @NativeType(value="char const *") ByteBuffer src, @Nullable @NativeType(value="char const *") ByteBuffer name, @Nullable @NativeType(value="char const * const *") PointerBuffer headers, @Nullable @NativeType(value="char const * const *") PointerBuffer includeNames) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)prog, (int)1);
            Checks.checkNT1((ByteBuffer)src);
            Checks.checkNT1Safe((ByteBuffer)name);
            Checks.checkSafe((CustomBuffer)includeNames, (int)Checks.remainingSafe((CustomBuffer)headers));
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcCreateProgram(MemoryUtil.memAddress((CustomBuffer)prog), MemoryUtil.memAddress((ByteBuffer)src), MemoryUtil.memAddressSafe((ByteBuffer)name), Checks.remainingSafe((CustomBuffer)headers), MemoryUtil.memAddressSafe((Pointer)headers), MemoryUtil.memAddressSafe((Pointer)includeNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="nvrtcResult")
    public static int nvrtcCreateProgram(@NativeType(value="nvrtcProgram *") PointerBuffer prog, @NativeType(value="char const *") CharSequence src, @Nullable @NativeType(value="char const *") CharSequence name, @Nullable @NativeType(value="char const * const *") PointerBuffer headers, @Nullable @NativeType(value="char const * const *") PointerBuffer includeNames) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)prog, (int)1);
            Checks.checkSafe((CustomBuffer)includeNames, (int)Checks.remainingSafe((CustomBuffer)headers));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(src, true);
            long srcEncoded = stack.getPointerAddress();
            stack.nASCIISafe(name, true);
            long nameEncoded = name == null ? 0L : stack.getPointerAddress();
            int n = org.lwjgl.cuda.NVRTC.nnvrtcCreateProgram(MemoryUtil.memAddress((CustomBuffer)prog), srcEncoded, nameEncoded, Checks.remainingSafe((CustomBuffer)headers), MemoryUtil.memAddressSafe((Pointer)headers), MemoryUtil.memAddressSafe((Pointer)includeNames));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nnvrtcDestroyProgram(long prog) {
        long __functionAddress = Functions.DestroyProgram;
        return JNI.callPI((long)prog, (long)__functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcDestroyProgram(@NativeType(value="nvrtcProgram *") PointerBuffer prog) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)prog, (int)1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcDestroyProgram(MemoryUtil.memAddress((CustomBuffer)prog));
    }

    public static int nnvrtcCompileProgram(long prog, int numOptions, long options) {
        long __functionAddress = Functions.CompileProgram;
        if (Checks.CHECKS) {
            Checks.check((long)prog);
        }
        return JNI.callPPI((long)prog, (int)numOptions, (long)options, (long)__functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcCompileProgram(@NativeType(value="nvrtcProgram") long prog, @Nullable @NativeType(value="char const * const *") PointerBuffer options) {
        return org.lwjgl.cuda.NVRTC.nnvrtcCompileProgram(prog, Checks.remainingSafe((CustomBuffer)options), MemoryUtil.memAddressSafe((Pointer)options));
    }

    public static int nnvrtcGetPTXSize(long prog, long ptxSizeRet) {
        long __functionAddress = Functions.GetPTXSize;
        if (Checks.CHECKS) {
            Checks.check((long)prog);
        }
        return JNI.callPPI((long)prog, (long)ptxSizeRet, (long)__functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetPTXSize(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="size_t *") PointerBuffer ptxSizeRet) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ptxSizeRet, (int)1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcGetPTXSize(prog, MemoryUtil.memAddress((CustomBuffer)ptxSizeRet));
    }

    public static int nnvrtcGetPTX(long prog, long ptx) {
        long __functionAddress = Functions.GetPTX;
        if (Checks.CHECKS) {
            Checks.check((long)prog);
        }
        return JNI.callPPI((long)prog, (long)ptx, (long)__functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetPTX(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char *") ByteBuffer ptx) {
        return org.lwjgl.cuda.NVRTC.nnvrtcGetPTX(prog, MemoryUtil.memAddress((ByteBuffer)ptx));
    }

    public static int nnvrtcGetProgramLogSize(long prog, long logSizeRet) {
        long __functionAddress = Functions.GetProgramLogSize;
        if (Checks.CHECKS) {
            Checks.check((long)prog);
        }
        return JNI.callPPI((long)prog, (long)logSizeRet, (long)__functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetProgramLogSize(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="size_t *") PointerBuffer logSizeRet) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)logSizeRet, (int)1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcGetProgramLogSize(prog, MemoryUtil.memAddress((CustomBuffer)logSizeRet));
    }

    public static int nnvrtcGetProgramLog(long prog, long log) {
        long __functionAddress = Functions.GetProgramLog;
        if (Checks.CHECKS) {
            Checks.check((long)prog);
        }
        return JNI.callPPI((long)prog, (long)log, (long)__functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetProgramLog(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char *") ByteBuffer log) {
        return org.lwjgl.cuda.NVRTC.nnvrtcGetProgramLog(prog, MemoryUtil.memAddress((ByteBuffer)log));
    }

    public static int nnvrtcAddNameExpression(long prog, long name_expression) {
        long __functionAddress = Functions.AddNameExpression;
        if (Checks.CHECKS) {
            Checks.check((long)prog);
        }
        return JNI.callPPI((long)prog, (long)name_expression, (long)__functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcAddNameExpression(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char const * const") ByteBuffer name_expression) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name_expression);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcAddNameExpression(prog, MemoryUtil.memAddress((ByteBuffer)name_expression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="nvrtcResult")
    public static int nvrtcAddNameExpression(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char const * const") CharSequence name_expression) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name_expression, true);
            long name_expressionEncoded = stack.getPointerAddress();
            int n = org.lwjgl.cuda.NVRTC.nnvrtcAddNameExpression(prog, name_expressionEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nnvrtcGetLoweredName(long prog, long name_expression, long lowered_name) {
        long __functionAddress = Functions.GetLoweredName;
        if (Checks.CHECKS) {
            Checks.check((long)prog);
        }
        return JNI.callPPPI((long)prog, (long)name_expression, (long)lowered_name, (long)__functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetLoweredName(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char const * const") ByteBuffer name_expression, @NativeType(value="char const **") PointerBuffer lowered_name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name_expression);
            Checks.check((CustomBuffer)lowered_name, (int)1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcGetLoweredName(prog, MemoryUtil.memAddress((ByteBuffer)name_expression), MemoryUtil.memAddress((CustomBuffer)lowered_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="nvrtcResult")
    public static int nvrtcGetLoweredName(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char const * const") CharSequence name_expression, @NativeType(value="char const **") PointerBuffer lowered_name) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)lowered_name, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name_expression, true);
            long name_expressionEncoded = stack.getPointerAddress();
            int n = org.lwjgl.cuda.NVRTC.nnvrtcGetLoweredName(prog, name_expressionEncoded, MemoryUtil.memAddress((CustomBuffer)lowered_name));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static /* synthetic */ SharedLibrary access$000() {
        return NVRTC;
    }

    public static final class Functions {
        public static final long GetErrorString = APIUtil.apiGetFunctionAddress((FunctionProvider)org.lwjgl.cuda.NVRTC.access$000(), (String)"nvrtcGetErrorString");
        public static final long Version = APIUtil.apiGetFunctionAddress((FunctionProvider)org.lwjgl.cuda.NVRTC.access$000(), (String)"nvrtcVersion");
        public static final long CreateProgram = APIUtil.apiGetFunctionAddress((FunctionProvider)org.lwjgl.cuda.NVRTC.access$000(), (String)"nvrtcCreateProgram");
        public static final long DestroyProgram = APIUtil.apiGetFunctionAddress((FunctionProvider)org.lwjgl.cuda.NVRTC.access$000(), (String)"nvrtcDestroyProgram");
        public static final long CompileProgram = APIUtil.apiGetFunctionAddress((FunctionProvider)org.lwjgl.cuda.NVRTC.access$000(), (String)"nvrtcCompileProgram");
        public static final long GetPTXSize = APIUtil.apiGetFunctionAddress((FunctionProvider)org.lwjgl.cuda.NVRTC.access$000(), (String)"nvrtcGetPTXSize");
        public static final long GetPTX = APIUtil.apiGetFunctionAddress((FunctionProvider)org.lwjgl.cuda.NVRTC.access$000(), (String)"nvrtcGetPTX");
        public static final long GetProgramLogSize = APIUtil.apiGetFunctionAddress((FunctionProvider)org.lwjgl.cuda.NVRTC.access$000(), (String)"nvrtcGetProgramLogSize");
        public static final long GetProgramLog = APIUtil.apiGetFunctionAddress((FunctionProvider)org.lwjgl.cuda.NVRTC.access$000(), (String)"nvrtcGetProgramLog");
        public static final long AddNameExpression = APIUtil.apiGetFunctionAddress((FunctionProvider)org.lwjgl.cuda.NVRTC.access$000(), (String)"nvrtcAddNameExpression");
        public static final long GetLoweredName = APIUtil.apiGetFunctionAddress((FunctionProvider)org.lwjgl.cuda.NVRTC.access$000(), (String)"nvrtcGetLoweredName");

        private Functions() {
        }
    }
}

