/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.diff;

import ca.sqlpower.architect.diff.SQLObjectComparator;
import ca.sqlpower.object.SPObjectUUIDComparator;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class SQLIndexComparator
implements Comparator<SQLIndex>,
Serializable {
    private static Logger logger = Logger.getLogger(SQLIndexComparator.class);
    private Comparator<SQLObject> comparator;

    public SQLIndexComparator() {
        this(false);
    }

    public SQLIndexComparator(boolean useUUID) {
        this.comparator = useUUID ? new SPObjectUUIDComparator() : new SQLObjectComparator();
    }

    @Override
    public int compare(SQLIndex source, SQLIndex target) {
        if (source == target) {
            return 0;
        }
        if (source == null) {
            return -1;
        }
        if (target == null) {
            return 1;
        }
        int result = this.compareString(source.getQualifier(), target.getQualifier());
        if (result != 0) {
            return result;
        }
        result = this.compareString(source.getType(), target.getType());
        if (result != 0) {
            return result;
        }
        result = this.compareString(source.getFilterCondition(), target.getFilterCondition());
        if (result != 0) {
            return result;
        }
        Boolean sourceVal = source.isUnique();
        result = sourceVal.compareTo(target.isUnique());
        if (result != 0) {
            return result;
        }
        sourceVal = source.isClustered();
        result = sourceVal.compareTo(target.isClustered());
        if (result != 0) {
            return result;
        }
        sourceVal = source.isPrimaryKeyIndex();
        result = sourceVal.compareTo(target.isPrimaryKeyIndex());
        if (result != 0) {
            return result;
        }
        TreeSet<SQLObject> sourceCol = new TreeSet<SQLObject>(this.comparator);
        TreeSet<SQLObject> targetCol = new TreeSet<SQLObject>(this.comparator);
        sourceCol.addAll(source.getChildren(SQLIndex.Column.class));
        targetCol.addAll(target.getChildren(SQLIndex.Column.class));
        return this.compareColumns(sourceCol, targetCol);
    }

    public int compareColumns(Set<SQLIndex.Column> source, Set<SQLIndex.Column> target) {
        boolean targetContinue;
        boolean sourceContinue;
        Iterator<SQLIndex.Column> sourceIter = source.iterator();
        Iterator<SQLIndex.Column> targetIter = target.iterator();
        do {
            SQLIndex.AscendDescend targetVal;
            SQLIndex.Column targetColumn;
            SQLIndex.Column sourceColumn;
            if (sourceIter.hasNext()) {
                sourceContinue = true;
                sourceColumn = sourceIter.next();
            } else {
                sourceContinue = false;
                sourceColumn = null;
            }
            if (targetIter.hasNext()) {
                targetContinue = true;
                targetColumn = targetIter.next();
            } else {
                targetContinue = false;
                targetColumn = null;
            }
            int result = this.comparator.compare((SQLObject)sourceColumn, (SQLObject)targetColumn);
            if (result != 0) {
                return result;
            }
            if (sourceColumn == null || targetColumn == null) continue;
            SQLIndex.AscendDescend sourceVal = sourceColumn.getAscendingOrDescending();
            if (sourceVal == null) {
                sourceVal = SQLIndex.AscendDescend.UNSPECIFIED;
            }
            if ((targetVal = targetColumn.getAscendingOrDescending()) == null) {
                targetVal = SQLIndex.AscendDescend.UNSPECIFIED;
            }
            if ((result = sourceVal.compareTo((Enum)targetVal)) == 0) continue;
            return result;
        } while (sourceContinue || targetContinue);
        return 0;
    }

    @SuppressWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="It's just a pre-check for null==null or reference equality by luck. Falls back to String.equals() at the end of the method.")
    public int compareString(String source, String target) {
        if (source == target) {
            return 0;
        }
        if (source == null) {
            return -1;
        }
        if (target == null) {
            return 1;
        }
        return source.compareTo(target);
    }
}

