/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.jstestdriver.ext;

import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.JsTestDriver;
import com.google.jstestdriver.TestCase;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.browser.DocType;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.DefaultConfiguration;
import com.google.jstestdriver.embedded.JsTestDriverBuilder;
import com.google.jstestdriver.hooks.TestListener;
import com.google.jstestdriver.model.BasePaths;
import com.google.jstestdriver.runner.RunnerMode;
import java.io.File;
import java.util.concurrent.Semaphore;

public class RunTests {
    private Semaphore s;

    public static void main(String[] args) {
        assert (args.length == 5);
        String serverURL = args[0];
        String baseFolder = args[1];
        String configFile = args[2];
        String tests = args[3];
        boolean strict = Boolean.parseBoolean(args[4]);
        new RunTests().runTests(serverURL, baseFolder, configFile, tests, strict);
    }

    public void runTests(String serverURL, String baseFolder, String configFile, String tests, boolean strict) {
        JsTestDriver testRunner = new JsTestDriverBuilder().setServer(serverURL).setRunnerMode(RunnerMode.QUIET).addBasePaths(new File[]{new File(baseFolder)}).raiseExceptionOnTestFailure(false).addTestListener((TestListener)new MyListener()).setDefaultConfiguration((Configuration)new ServerConfiguration(strict)).build();
        if ("all".equals(tests)) {
            testRunner.runAllTests(configFile);
        }
    }

    class MyListener
    implements TestListener {
        public void onTestComplete(TestResult tr) {
            StringBuilder sb = new StringBuilder();
            sb.append("nb-easel-json:{");
            sb.append("\"testCase\":\"" + this.encode(tr.getTestCaseName()) + "\"");
            sb.append(", \"testName\":\"" + this.encode(tr.getTestName()) + "\"");
            sb.append(", \"result\":\"" + this.encode(tr.getResult().toString()) + "\"");
            sb.append(", \"duration\":" + (long)tr.getTime() + "");
            sb.append(", \"browserName\":\"" + this.encode(tr.getBrowserInfo().getName()) + "\"");
            sb.append(", \"browserVersion\":\"" + this.encode(tr.getBrowserInfo().getVersion()) + "\"");
            sb.append(", \"browserOS\":\"" + this.encode(tr.getBrowserInfo().getOs()) + "\"");
            sb.append(", \"stack\":\"" + this.encode(tr.getStack()) + "\"");
            sb.append(", \"message\":\"" + ("[]".equals(tr.getMessage()) ? "" : this.encode(tr.getMessage())) + "\"");
            sb.append(", \"log\":\"" + this.encode(tr.getLog()) + "\"");
            sb.append("}");
            System.out.println(sb.toString());
        }

        private String encode(String s) {
            if (s == null) {
                return "";
            }
            return s.replace("\\", "\\\\").replace("/", "\\/").replace("\"", "\\\"").replace("\t", " ").replace("\n", "\\u000d").replace("\r", " ").replace("\b", " ").replace("\f", " ");
        }

        public void onFileLoad(BrowserInfo bi, FileResult fr) {
        }

        public void onTestRegistered(BrowserInfo bi, TestCase tc) {
        }

        public void finish() {
        }
    }

    static class ServerConfiguration
    extends DefaultConfiguration {
        private boolean strictMode;

        public ServerConfiguration(boolean strictMode) {
            super(new BasePaths(new File[]{new File(".")}));
            this.strictMode = strictMode;
        }

        public DocType getDocType() {
            return this.strictMode ? DocType.STRICT : DocType.QUIRKS;
        }
    }
}

