/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.queries;

import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.modules.java.j2seplatform.api.J2SEPlatformCreator;
import org.netbeans.modules.java.j2seplatform.queries.Bundle;
import org.netbeans.modules.java.j2seplatform.queries.SelectRootsPanel;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class SourceJavadocAttacherUtil {
    private static final RequestProcessor RP = new RequestProcessor(SelectRootsPanel.class);

    private SourceJavadocAttacherUtil() {
    }

    public static void callListener(@NonNull SourceJavadocAttacher.AttachmentListener listener, boolean success) {
        if (success) {
            listener.attachmentSucceeded();
        } else {
            listener.attachmentFailed();
        }
    }

    private static Collection<SourceJavadocAttacherImplementation.Definer> filterPlugins(URL root, Collection<? extends SourceJavadocAttacherImplementation.Definer> plugins) {
        if (plugins == null || plugins.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        ArrayList<SourceJavadocAttacherImplementation.Definer> filtered = new ArrayList<SourceJavadocAttacherImplementation.Definer>();
        for (SourceJavadocAttacherImplementation.Definer definer : plugins) {
            if (definer instanceof SourceJavadocAttacherImplementation.Definer2) {
                SourceJavadocAttacherImplementation.Definer2 d2 = (SourceJavadocAttacherImplementation.Definer2)definer;
                if (!d2.accepts(root)) continue;
                filtered.add(definer);
                continue;
            }
            filtered.add(definer);
        }
        return filtered;
    }

    private static List<? extends URI> waitAttachUsingPlugins(@NonNull URL root, boolean source, @NullAllowed Collection<? extends SourceJavadocAttacherImplementation.Definer> plugins) {
        if (plugins == null || plugins.isEmpty()) {
            return null;
        }
        Downloader h = new Downloader(plugins, root, source);
        BaseProgressUtils.runOffEventDispatchThread((Runnable)h, (String)(source ? Bundle.TITLE_ObtainingSource() : Bundle.TITLE_ObtainingJavadoc()), (AtomicBoolean)h, (boolean)false);
        List<? extends URI> r = h.getResult();
        return r != null && !r.isEmpty() ? r : null;
    }

    @CheckForNull
    public static List<? extends URI> selectJavadoc(@NonNull URL root, @NonNull List<? extends URI> attachedRoots, @NonNull Callable<List<? extends String>> browseCall, @NonNull Function<String, Collection<? extends URI>> convertor, @NullAllowed Collection<? extends SourceJavadocAttacherImplementation.Definer> plugins) {
        assert (root != null);
        assert (browseCall != null);
        assert (convertor != null);
        String action = NbBundle.getMessage(J2SEPlatformCreator.class, (String)"API_Ask_attachJavadocQuestion");
        if ("yes".equalsIgnoreCase(action)) {
            return SourceJavadocAttacherUtil.waitAttachUsingPlugins(root, false, SourceJavadocAttacherUtil.filterPlugins(root, plugins));
        }
        if ("ask".equalsIgnoreCase(action)) {
            SelectRootsPanel selectJavadoc = new SelectRootsPanel(1, root, attachedRoots, browseCall, convertor, SourceJavadocAttacherUtil.filterPlugins(root, plugins));
            DialogDescriptor dd = new DialogDescriptor((Object)selectJavadoc, Bundle.TXT_SelectJavadoc());
            dd.setButtonListener((ActionListener)selectJavadoc);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
                try {
                    return selectJavadoc.getRoots();
                }
                catch (Exception e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.TXT_InvalidJavadocRoot(), 0));
                }
            }
        }
        return null;
    }

    @CheckForNull
    public static List<? extends URI> selectSources(@NonNull URL root, @NonNull List<? extends URI> attachedRoots, @NonNull Callable<List<? extends String>> browseCall, @NonNull Function<String, Collection<? extends URI>> convertor, Collection<? extends SourceJavadocAttacherImplementation.Definer> plugins) {
        assert (root != null);
        assert (browseCall != null);
        assert (convertor != null);
        String action = NbBundle.getMessage(J2SEPlatformCreator.class, (String)"API_Ask_attachSourcesQuestion");
        if ("yes".equalsIgnoreCase(action)) {
            return SourceJavadocAttacherUtil.waitAttachUsingPlugins(root, true, SourceJavadocAttacherUtil.filterPlugins(root, plugins));
        }
        if ("ask".equalsIgnoreCase(action)) {
            SelectRootsPanel selectSources = new SelectRootsPanel(0, root, attachedRoots, browseCall, convertor, SourceJavadocAttacherUtil.filterPlugins(root, plugins));
            DialogDescriptor dd = new DialogDescriptor((Object)selectSources, Bundle.TXT_SelectSources());
            dd.setButtonListener((ActionListener)selectSources);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
                try {
                    return selectSources.getRoots();
                }
                catch (Exception e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.TXT_InvalidSourceRoot(), 0));
                }
            }
        }
        return null;
    }

    @NonNull
    public static Callable<List<? extends String>> createDefaultBrowseCall(final @NonNull String title, final @NonNull String filterDescription, final @NonNull File[] currentFolder) {
        assert (title != null);
        assert (filterDescription != null);
        assert (currentFolder != null);
        Callable<List<? extends String>> call = new Callable<List<? extends String>>(){

            @Override
            public List<? extends String> call() throws Exception {
                JFileChooser chooser = new JFileChooser();
                chooser.setMultiSelectionEnabled(true);
                chooser.setFileSelectionMode(2);
                if (Utilities.isMac()) {
                    chooser.putClientProperty("JFileChooser.packageIsTraversable", "always");
                }
                chooser.setDialogTitle(title);
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        try {
                            return f.isDirectory() || FileUtil.isArchiveFile((URL)Utilities.toURI((File)f).toURL());
                        }
                        catch (MalformedURLException ex) {
                            return false;
                        }
                    }

                    @Override
                    public String getDescription() {
                        return filterDescription;
                    }
                };
                chooser.setFileFilter(filter);
                chooser.setApproveButtonText(Bundle.TXT_Select());
                chooser.setApproveButtonMnemonic(Bundle.MNE_Select().charAt(0));
                if (currentFolder[0] != null) {
                    chooser.setCurrentDirectory(currentFolder[0]);
                }
                if (chooser.showOpenDialog(null) == 0) {
                    currentFolder[0] = chooser.getCurrentDirectory();
                    File[] files = SourceJavadocAttacherUtil.filter(chooser.getSelectedFiles(), filter);
                    ArrayList<String> result = new ArrayList<String>(files.length);
                    for (File f : files) {
                        result.add(f.getAbsolutePath());
                    }
                    return result;
                }
                return null;
            }
        };
        return call;
    }

    public static Function<String, Collection<? extends URI>> createDefaultURIConvertor(final boolean forSources) {
        return new Function<String, Collection<? extends URI>>(){

            @Override
            public Collection<? extends URI> call(String param) throws Exception {
                File f = new File(param);
                assert (f.isAbsolute()) : param;
                FileObject fo = FileUtil.toFileObject((File)f);
                if (fo.isData()) {
                    fo = FileUtil.getArchiveRoot((FileObject)fo);
                }
                ArrayList<URI> result = new ArrayList<URI>();
                if (forSources) {
                    for (FileObject root : JavadocAndSourceRootDetection.findSourceRoots((FileObject)fo, null)) {
                        result.add(root.toURL().toURI());
                    }
                } else {
                    FileObject root = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)fo);
                    if (root != null) {
                        result.add(root.toURL().toURI());
                    }
                }
                return result;
            }
        };
    }

    private static File[] filter(@NonNull File[] files, @NonNull FileFilter filter) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            if (!filter.accept(file)) continue;
            result.add(file);
        }
        return result.toArray(new File[result.size()]);
    }

    public static interface Function<P, R> {
        public R call(P var1) throws Exception;
    }

    static class Downloader
    extends AtomicBoolean
    implements Callable<Boolean>,
    Runnable,
    Cancellable {
        private final Collection<? extends SourceJavadocAttacherImplementation.Definer> plugins;
        private final URL root;
        private final boolean source;
        private volatile List<? extends URI> result = Collections.emptyList();

        public Downloader(Collection<? extends SourceJavadocAttacherImplementation.Definer> plugins, URL root, boolean source) {
            this.plugins = plugins;
            this.root = root;
            this.source = source;
        }

        @Override
        public Boolean call() {
            return this.get();
        }

        public boolean cancel() {
            return this.compareAndSet(false, true);
        }

        String getTitle() {
            return this.source ? Bundle.TITLE_ObtainingSource() : Bundle.TITLE_ObtainingJavadoc();
        }

        public List<? extends URI> getResult() {
            return this.result;
        }

        public void runAsync(Consumer<List<? extends URI>> callback) {
            RequestProcessor.Task t = RP.post((Runnable)this);
            t.addTaskListener(x -> callback.accept(this.result));
        }

        @Override
        public void run() {
            for (SourceJavadocAttacherImplementation.Definer definer : this.plugins) {
                List s;
                if (this.get()) {
                    return;
                }
                List list = s = this.source ? definer.getSources(this.root, (Callable)this) : definer.getJavadoc(this.root, (Callable)this);
                if (s == null && !s.isEmpty()) continue;
                ArrayList<? extends URI> r = new ArrayList<URI>();
                for (URL u : s) {
                    try {
                        r.add(u.toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                if (r.isEmpty()) continue;
                this.result = r;
                return;
            }
        }
    }
}

