/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.debug.meta;

import org.apache.bsf.debug.jsdi.JsCallbacks;
import org.apache.bsf.debug.jsdi.JsContext;
import org.apache.bsf.debug.jsdi.JsEngine;
import org.apache.bsf.debug.jsdi.JsObject;
import org.apache.bsf.debug.util.DebugLog;
import org.apache.bsf.debug.util.Dispatcher;
import org.apache.bsf.debug.util.ResultCell;
import org.apache.bsf.debug.util.SocketConnection;

public class JsEngineDispatcher
extends Dispatcher {
    public JsEngineDispatcher(SocketConnection socketConnection) {
        super(socketConnection);
    }

    public void dispatch(ResultCell resultCell) throws Exception {
        JsEngine jsEngine = (JsEngine)((Object)resultCell.selfSkel);
        switch (resultCell.methodId) {
            case 900: {
                resultCell.booleanResult(true);
                break;
            }
            case 411: {
                JsCallbacks jsCallbacks = (JsCallbacks)resultCell.readObject();
                jsEngine.setDebugger(jsCallbacks);
                resultCell.voidResult();
                break;
            }
            case 401: {
                int n = resultCell.readInt();
                DebugLog.stdoutPrintln("\tdepth=" + n, 3);
                JsContext jsContext = jsEngine.getContext(n);
                DebugLog.stdoutPrintln("\tcx=" + jsContext, 3);
                resultCell.objectResult(jsContext);
                break;
            }
            case 402: {
                int n = jsEngine.getContextCount();
                resultCell.intResult(n);
                break;
            }
            case 412: {
                String string = jsEngine.getThread();
                resultCell.objectResult(string);
                break;
            }
            case 413: {
                String string = jsEngine.getThreadGroup();
                resultCell.objectResult(string);
                break;
            }
            case 404: {
                jsEngine.run();
                resultCell.voidResult();
                break;
            }
            case 405: {
                jsEngine.stepIn();
                resultCell.voidResult();
                break;
            }
            case 406: {
                jsEngine.stepOut();
                resultCell.voidResult();
                break;
            }
            case 407: {
                jsEngine.stepOver();
                resultCell.voidResult();
                break;
            }
            case 409: {
                JsObject jsObject = jsEngine.getGlobalObject();
                resultCell.objectResult(jsObject);
                break;
            }
            case 410: {
                JsObject jsObject = jsEngine.getUndefinedValue();
                resultCell.objectResult(jsObject);
            }
        }
    }
}

