/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.InitializeInstanceElementsNodeGen;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PrivateFieldAddNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.function.SetFunctionNameNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class InitializeInstanceElementsNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    @Executed
    protected JavaScriptNode constructorNode;
    @Node.Child
    @Executed(with={"constructorNode"})
    protected JSTargetableNode fieldsNode;
    @Node.Child
    @Executed(with={"constructorNode"})
    protected JSTargetableNode brandNode;
    protected final JSContext context;

    protected InitializeInstanceElementsNode(JSContext context, JavaScriptNode targetNode, JavaScriptNode constructorNode) {
        this.context = context;
        this.targetNode = targetNode;
        this.constructorNode = constructorNode;
        if (constructorNode != null) {
            this.fieldsNode = PropertyNode.createGetHidden(context, null, JSFunction.CLASS_FIELDS_ID);
            this.brandNode = PropertyNode.createGetHidden(context, null, JSFunction.PRIVATE_BRAND_ID);
        }
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode targetNode, JavaScriptNode constructorNode) {
        return InitializeInstanceElementsNodeGen.create(context, targetNode, constructorNode);
    }

    public static InitializeInstanceElementsNode create(JSContext context) {
        return InitializeInstanceElementsNodeGen.create(context, null, null);
    }

    public final Object executeStaticFields(Object targetConstructor, Object[][] staticFields) {
        return this.executeEvaluated(targetConstructor, (Object)Undefined.instance, staticFields, (Object)Undefined.instance);
    }

    protected abstract Object executeEvaluated(Object var1, Object var2, Object[][] var3, Object var4);

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    @Specialization
    protected static Object withFields(Object target, Object constructor, Object[][] fields, Object brand, @Cached(value="createBrandAddNode(brand, context)") @Cached.Shared(value="privateBrandAdd") PrivateFieldAddNode privateBrandAddNode, @Cached(value="createFieldNodes(fields, context)") DefineFieldNode[] fieldNodes) {
        InitializeInstanceElementsNode.privateBrandAdd(target, constructor, fields, brand, privateBrandAddNode);
        int size = fieldNodes.length;
        assert (size == fields.length);
        for (int i = 0; i < size; ++i) {
            Object[] field = fields[i];
            Object key = field[0];
            Object initializer = field[1];
            fieldNodes[i].defineField(target, key, initializer);
        }
        return target;
    }

    @Specialization
    protected static Object privateBrandAdd(Object target, Object constructor, Object fields, Object brand, @Cached(value="createBrandAddNode(brand, context)") @Cached.Shared(value="privateBrandAdd") PrivateFieldAddNode privateBrandAddNode) {
        assert (privateBrandAddNode != null == (brand != Undefined.instance));
        if (privateBrandAddNode != null) {
            privateBrandAddNode.execute(target, brand, constructor);
        }
        return target;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return InitializeInstanceElementsNode.create(this.context, InitializeInstanceElementsNode.cloneUninitialized(this.targetNode, materializedTags), InitializeInstanceElementsNode.cloneUninitialized(this.constructorNode, materializedTags));
    }

    static PrivateFieldAddNode createBrandAddNode(Object brand, JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        if (brand != Undefined.instance) {
            return PrivateFieldAddNode.create(context);
        }
        return null;
    }

    static DefineFieldNode[] createFieldNodes(Object[][] fields, JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        int size = fields.length;
        DefineFieldNode[] fieldNodes = new DefineFieldNode[size];
        for (int i = 0; i < size; ++i) {
            Object[] field = fields[i];
            Object key = field[0];
            Object initializer = field[1];
            boolean isAnonymousFunctionDefinition = (Boolean)field[2];
            JavaScriptBaseNode writeNode = key instanceof HiddenKey ? PrivateFieldAddNode.create(context) : WriteElementNode.create(context, true, true);
            JSFunctionCallNode callNode = null;
            if (initializer != Undefined.instance) {
                callNode = JSFunctionCallNode.createCall();
            }
            SetFunctionNameNode setFunctionNameNode = null;
            if (isAnonymousFunctionDefinition) {
                setFunctionNameNode = SetFunctionNameNode.create();
            }
            fieldNodes[i] = new DefineFieldNode(writeNode, callNode, setFunctionNameNode);
        }
        return fieldNodes;
    }

    static final class DefineFieldNode
    extends JavaScriptBaseNode {
        @Node.Child
        JavaScriptBaseNode writeNode;
        @Node.Child
        JSFunctionCallNode callNode;
        @Node.Child
        SetFunctionNameNode setFunctionNameNode;

        DefineFieldNode(JavaScriptBaseNode writeNode, JSFunctionCallNode callNode, SetFunctionNameNode setFunctionNameNode) {
            this.writeNode = writeNode;
            this.callNode = callNode;
            this.setFunctionNameNode = setFunctionNameNode;
        }

        void defineField(Object target, Object key, Object initializer) {
            assert (this.callNode != null == (initializer != Undefined.instance));
            Object value = Undefined.instance;
            if (this.callNode != null) {
                value = this.callNode.executeCall(JSArguments.createZeroArg(target, initializer));
                if (this.setFunctionNameNode != null) {
                    this.setFunctionNameNode.execute(value, key);
                }
            }
            if (this.writeNode instanceof PrivateFieldAddNode) {
                assert (key instanceof HiddenKey) : key;
                ((PrivateFieldAddNode)this.writeNode).execute(target, key, value);
            } else {
                assert (JSRuntime.isPropertyKey(key)) : key;
                ((WriteElementNode)this.writeNode).executeWithTargetAndIndexAndValue(target, key, value);
            }
        }
    }
}

