/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.MapPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNode;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNodeGen;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSHashMap;

public final class MapPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<MapPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new MapPrototypeBuiltins();

    protected MapPrototypeBuiltins() {
        super("Map.prototype", MapPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, MapPrototype builtinEnum) {
        switch (builtinEnum) {
            case clear: {
                return MapPrototypeBuiltinsFactory.JSMapClearNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case delete: {
                return MapPrototypeBuiltinsFactory.JSMapDeleteNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case set: {
                return MapPrototypeBuiltinsFactory.JSMapSetNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case get: {
                return MapPrototypeBuiltinsFactory.JSMapGetNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case has: {
                return MapPrototypeBuiltinsFactory.JSMapHasNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case forEach: {
                return MapPrototypeBuiltinsFactory.JSMapForEachNodeGen.create(context, builtin, MapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case keys: {
                return MapPrototypeBuiltinsFactory.CreateMapIteratorNodeGen.create(context, builtin, 1, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case values: {
                return MapPrototypeBuiltinsFactory.CreateMapIteratorNodeGen.create(context, builtin, 2, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case entries: {
                return MapPrototypeBuiltinsFactory.CreateMapIteratorNodeGen.create(context, builtin, 3, MapPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class CreateMapIteratorNode
    extends JSBuiltinNode {
        private final int iterationKind;
        @Node.Child
        private CreateObjectNode.CreateObjectWithPrototypeNode createObjectNode;
        @Node.Child
        private PropertySetNode setNextIndexNode;
        @Node.Child
        private PropertySetNode setIteratedObjectNode;
        @Node.Child
        private PropertySetNode setIterationKindNode;

        public CreateMapIteratorNode(JSContext context, JSBuiltin builtin, int iterationKind) {
            super(context, builtin);
            this.iterationKind = iterationKind;
            this.createObjectNode = CreateObjectNode.createOrdinaryWithPrototype(context);
            this.setIteratedObjectNode = PropertySetNode.createSetHidden(JSRuntime.ITERATED_OBJECT_ID, context);
            this.setNextIndexNode = PropertySetNode.createSetHidden(JSRuntime.ITERATOR_NEXT_INDEX, context);
            this.setIterationKindNode = PropertySetNode.createSetHidden(JSMap.MAP_ITERATION_KIND_ID, context);
        }

        @Specialization(guards={"isJSMap(map)"})
        protected DynamicObject doMap(VirtualFrame frame, DynamicObject map) {
            DynamicObject iterator = this.createObjectNode.execute(frame, this.getContext().getRealm().getMapIteratorPrototype());
            this.setIteratedObjectNode.setValue(iterator, map);
            this.setNextIndexNode.setValue(iterator, JSMap.getInternalMap(map).getEntries());
            this.setIterationKindNode.setValueInt(iterator, this.iterationKind);
            return iterator;
        }

        @Specialization(guards={"!isJSMap(thisObj)"})
        protected DynamicObject doIncompatibleReceiver(Object thisObj) {
            throw Errors.createTypeError("not a Map");
        }
    }

    public static abstract class JSMapForEachNode
    extends JSBuiltinNode {
        public JSMapForEachNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSMap(thisObj)", "isCallable.executeBoolean(callback)"}, limit="1")
        protected Object forEachFunction(DynamicObject thisObj, Object callback, Object thisArg, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable, @Cached(value="createCall()") JSFunctionCallNode callNode) {
            JSHashMap map = JSMap.getInternalMap(thisObj);
            JSHashMap.Cursor cursor = map.getEntries();
            while (cursor.advance()) {
                Object value = cursor.getValue();
                Object key = cursor.getKey();
                callNode.executeCall(JSArguments.create(thisArg, callback, value, key, thisObj));
            }
            return Undefined.instance;
        }

        @Specialization(guards={"isJSMap(thisObj)", "!isCallable.executeBoolean(callback)"}, limit="1")
        protected static Object forEachFunctionNoFunction(Object thisObj, Object callback, Object thisArg, @Cached @Cached.Shared(value="isCallable") IsCallableNode isCallable) {
            throw Errors.createTypeErrorCallableExpected();
        }

        @Specialization(guards={"!isJSMap(thisObj)"})
        protected static Object notMap(Object thisObj, Object callback, Object thisArg) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    public static abstract class JSMapHasNode
    extends JSMapOperation {
        public JSMapHasNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSMap(thisObj)"})
        protected boolean has(DynamicObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSMap.getInternalMap(thisObj).has(normalizedKey);
        }

        @Specialization(guards={"!isJSMap(thisObj)"})
        protected static boolean notMap(Object thisObj, Object key) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    public static abstract class JSMapSetNode
    extends JSMapOperation {
        public JSMapSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSMap(thisObj)"})
        protected DynamicObject set(DynamicObject thisObj, Object key, Object value) {
            Object normalizedKey = this.normalize(key);
            JSMap.getInternalMap(thisObj).put(normalizedKey, value);
            return thisObj;
        }

        @Specialization(guards={"!isJSMap(thisObj)"})
        protected static DynamicObject notMap(Object thisObj, Object key, Object value) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    public static abstract class JSMapGetNode
    extends JSMapOperation {
        public JSMapGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSMap(thisObj)"})
        protected Object get(DynamicObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            Object value = JSMap.getInternalMap(thisObj).get(normalizedKey);
            return JSRuntime.nullToUndefined(value);
        }

        @Specialization(guards={"!isJSMap(thisObj)"})
        protected static Object notMap(Object thisObj, Object key) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    public static abstract class JSMapDeleteNode
    extends JSMapOperation {
        public JSMapDeleteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSMap(thisObj)"})
        protected boolean delete(DynamicObject thisObj, Object key) {
            Object normalizedKey = this.normalize(key);
            return JSMap.getInternalMap(thisObj).remove(normalizedKey);
        }

        @Specialization(guards={"!isJSMap(thisObj)"})
        protected static boolean notMap(Object thisObj, Object key) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    public static abstract class JSMapClearNode
    extends JSBuiltinNode {
        public JSMapClearNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSMap(thisObj)"})
        protected static DynamicObject clear(DynamicObject thisObj) {
            JSMap.getInternalMap(thisObj).clear();
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSMap(thisObj)"})
        protected static DynamicObject notMap(Object thisObj) {
            throw Errors.createTypeErrorMapExpected();
        }
    }

    public static abstract class JSMapOperation
    extends JSBuiltinNode {
        @Node.Child
        private JSCollectionsNormalizeNode normalizeNode;

        public JSMapOperation(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected Object normalize(Object value) {
            if (this.normalizeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.normalizeNode = (JSCollectionsNormalizeNode)this.insert(JSCollectionsNormalizeNodeGen.create());
            }
            return this.normalizeNode.execute(value);
        }
    }

    public static enum MapPrototype implements BuiltinEnum<MapPrototype>
    {
        clear(0),
        delete(1),
        set(2),
        get(1),
        has(1),
        forEach(1),
        keys(0),
        values(0),
        entries(0);

        private final int length;

        private MapPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

