/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileFilter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.WeakSet;

final class DeepListener
extends WeakReference<FileChangeListener>
implements FileChangeListener,
Runnable,
Callable<Boolean>,
FileFilter {
    static final Logger LOG = Logger.getLogger(FileUtil.class.getName() + ".recursive");
    private final File path;
    private FileObject watching;
    private boolean removed;
    private final Callable<Boolean> stop;
    private final FileFilter filter;
    private static List<DeepListener> keep = new ArrayList<DeepListener>();
    private final int hash;
    private Set<FileEvent> delivered = Collections.synchronizedSet(new WeakSet());

    DeepListener(FileChangeListener listener, File path, FileFilter ff, Callable<Boolean> stop) {
        super(listener, BaseUtilities.activeReferenceQueue());
        this.path = path;
        this.stop = stop;
        this.filter = ff;
        this.hash = 11 * listener.hashCode() + 7 * path.hashCode();
    }

    final void init() {
        keep.add(this);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, null, new Throwable("listening to " + this.path));
        }
        this.relisten();
    }

    @Override
    public void run() {
        FileObject fo = FileUtil.toFileObject(this.path);
        if (fo != null) {
            fo.removeRecursiveListener(this);
        }
        this.removed = true;
        keep.remove(this);
    }

    private synchronized void relisten() {
        FileObject fo = FileUtil.toFileObject(this.path);
        if (fo == this.watching) {
            return;
        }
        if (this.watching != null) {
            this.watching.removeRecursiveListener(this);
            this.watching = null;
        }
        if (fo != null) {
            this.watching = fo;
            fo.addRecursiveListener(this);
        }
    }

    @Override
    public void fileRenamed(FileRenameEvent fe) {
        this.fileRenamed(fe, false);
    }

    public void fileRenamed(FileRenameEvent fe, boolean fromHolder) {
        this.relisten();
        FileChangeListener listener = this.get(fe, fromHolder);
        if (listener == null) {
            return;
        }
        listener.fileRenamed(fe);
    }

    @Override
    public void fileFolderCreated(FileEvent fe) {
        this.relisten();
        this.fileFolderCreated(fe, false);
    }

    public void fileFolderCreated(FileEvent fe, boolean fromHolder) {
        this.relisten();
        FileChangeListener listener = this.get(fe, fromHolder);
        if (listener == null) {
            return;
        }
        listener.fileFolderCreated(fe);
    }

    @Override
    public void fileDeleted(FileEvent fe) {
        this.fileDeleted(fe, false);
    }

    public void fileDeleted(FileEvent fe, boolean fromHolder) {
        this.relisten();
        FileChangeListener listener = this.get(fe, fromHolder);
        if (listener == null) {
            return;
        }
        listener.fileDeleted(fe);
    }

    @Override
    public void fileDataCreated(FileEvent fe) {
        this.fileDataCreated(fe, false);
    }

    public void fileDataCreated(FileEvent fe, boolean fromHolder) {
        this.relisten();
        FileChangeListener listener = this.get(fe, fromHolder);
        if (listener == null) {
            return;
        }
        listener.fileDataCreated(fe);
    }

    @Override
    public void fileChanged(FileEvent fe) {
        this.fileChanged(fe, false);
    }

    public void fileChanged(FileEvent fe, boolean fromHolder) {
        FileChangeListener listener = this.get(fe, fromHolder);
        if (listener == null) {
            return;
        }
        listener.fileChanged(fe);
    }

    @Override
    public void fileAttributeChanged(FileAttributeEvent fe) {
        FileChangeListener listener = this.get(fe, false);
        if (listener == null) {
            return;
        }
        listener.fileAttributeChanged(fe);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeepListener other = (DeepListener)obj;
        if (!(this.path == other.path || this.path != null && this.path.equals(other.path))) {
            return false;
        }
        FileChangeListener ref = (FileChangeListener)this.get();
        return ref == other.get() || ref != null && ref.equals(other.get());
    }

    public int hashCode() {
        return this.hash;
    }

    private FileChangeListener get(FileEvent fe, boolean fromHolder) {
        if (this.removed) {
            return null;
        }
        if (fromHolder && fe.getFile() != fe.getSource()) {
            return null;
        }
        if (!this.delivered.add(fe)) {
            return null;
        }
        return (FileChangeListener)this.get();
    }

    @Override
    public Boolean call() throws Exception {
        return this.stop != null ? this.stop.call() : null;
    }

    @Override
    public boolean accept(File pathname) {
        return this.filter == null || this.filter.accept(pathname);
    }

    public String toString() {
        return "DeepListener{" + this.get() + "@" + this.path + '}';
    }
}

