/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.transform;

import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.transform.STRTransformImpl;
import com.sun.xml.wss.logging.impl.dsig.LogStringsMessages;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMSTRTransform
extends TransformService {
    private STRTransformParameterSpec params;
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");
    public static final String WSSE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String WSU = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";

    @Override
    public void init(TransformParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            throw new InvalidAlgorithmParameterException("params are required");
        }
        this.params = (STRTransformParameterSpec)params;
    }

    @Override
    public void init(XMLStructure params, XMLCryptoContext xMLCryptoContext) throws InvalidAlgorithmParameterException {
        DOMStructure domParams = (DOMStructure)params;
        try {
            this.unmarshalParams(domParams.getNode(), xMLCryptoContext);
        }
        catch (MarshalException me) {
            throw new InvalidAlgorithmParameterException(me.getMessage());
        }
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    @Override
    public void marshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        Node pn = ((DOMStructure)parent).getNode();
        Document ownerDoc = XMLUtil.getOwnerDocument(pn);
        String prefix = null;
        String dsPrefix = null;
        if (context != null) {
            prefix = context.getNamespacePrefix(WSSE, "wsse");
            dsPrefix = context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", context.getDefaultNamespacePrefix());
        }
        Element transformParamElem = XMLUtil.createElement(ownerDoc, "TransformationParameters", WSSE, prefix);
        CanonicalizationMethod cm = this.params.getCanonicalizationMethod();
        Element c14nElem = XMLUtil.createElement(ownerDoc, "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        c14nElem.setAttributeNS(null, "Algorithm", cm.getAlgorithm());
        C14NMethodParameterSpec cs = (C14NMethodParameterSpec)cm.getParameterSpec();
        if (cs != null) {
            TransformService cmSpi = null;
            try {
                cmSpi = TransformService.getInstance(cm.getAlgorithm(), "DOM");
                cmSpi.init(cs);
                cmSpi.marshalParams(new DOMStructure(c14nElem), context);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1321_STR_MARSHAL_TRANSFORM_ERROR(), e);
                throw new MarshalException(e);
            }
        }
        transformParamElem.appendChild(c14nElem);
        pn.appendChild(transformParamElem);
    }

    @Override
    public Data transform(Data data, XMLCryptoContext xc) throws TransformException {
        OutputStream outputStream = null;
        new STRTransformImpl();
        return STRTransformImpl.transform(data, xc, outputStream);
    }

    @Override
    public Data transform(Data data, XMLCryptoContext xc, OutputStream outputStream) throws TransformException {
        new STRTransformImpl();
        return STRTransformImpl.transform(data, xc, outputStream);
    }

    public void unmarshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException, InvalidAlgorithmParameterException {
        Element transformElem = (Element)((DOMStructure)parent).getNode();
        Element tpElem = XMLUtil.getFirstChildElement(transformElem);
        this.unmarshalParams(tpElem, context);
    }

    private void unmarshalParams(Node tpElem, XMLCryptoContext context) throws MarshalException, InvalidAlgorithmParameterException {
        NodeList nl;
        Element c14nElem = null;
        c14nElem = tpElem.getNodeType() == 9 ? (Element)((Document)tpElem).getFirstChild() : XMLUtil.getFirstChildElement(tpElem);
        if (!"CanonicalizationMethod".equals(c14nElem.getLocalName()) && (nl = c14nElem.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod")).getLength() > 0) {
            c14nElem = (Element)nl.item(0);
        }
        if (c14nElem == null) {
            throw new InvalidAlgorithmParameterException("Cannont find CanonicalizationMethod in TransformationParameters element");
        }
        String c14nAlg = c14nElem.getAttributeNodeNS(null, "Algorithm").getValue();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "C14 Algo=" + c14nAlg);
        }
        Object cs = null;
        Element paramsElem = XMLUtil.getFirstChildElement(c14nElem);
        TransformService cmSpi = null;
        try {
            cmSpi = TransformService.getInstance(c14nAlg, "DOM");
            if (paramsElem != null) {
                cmSpi.init(new DOMStructure(paramsElem), context);
            }
            STRC14NMethod cm = new STRC14NMethod(cmSpi);
            this.params = new STRTransformParameterSpec(cm);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1320_STR_UN_TRANSFORM_ERROR(), e);
            throw new MarshalException(e);
        }
    }

    @Override
    public boolean isFeatureSupported(String str) {
        return false;
    }

    public static class STRTransformParameterSpec
    implements TransformParameterSpec {
        private CanonicalizationMethod c14nMethod;

        public STRTransformParameterSpec(CanonicalizationMethod c14nMethod) {
            this.c14nMethod = c14nMethod;
        }

        public CanonicalizationMethod getCanonicalizationMethod() {
            return this.c14nMethod;
        }
    }

    private static class STRC14NMethod
    implements CanonicalizationMethod {
        private TransformService cmSpi;

        STRC14NMethod(TransformService cmSpi) {
            this.cmSpi = cmSpi;
        }

        @Override
        public String getAlgorithm() {
            return this.cmSpi.getAlgorithm();
        }

        @Override
        public AlgorithmParameterSpec getParameterSpec() {
            return this.cmSpi.getParameterSpec();
        }

        @Override
        public boolean isFeatureSupported(String feature) {
            return false;
        }

        @Override
        public Data transform(Data data, XMLCryptoContext context) throws TransformException {
            return this.cmSpi.transform(data, context);
        }

        @Override
        public Data transform(Data data, XMLCryptoContext context, OutputStream os) throws TransformException {
            return this.cmSpi.transform(data, context, os);
        }
    }
}

