/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.security.core.ai.IdentityType;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.STSIssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.SecondaryIssuedTokenParameters;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.mex.client.MetadataClient;
import com.sun.xml.ws.mex.client.PortInfo;
import com.sun.xml.ws.mex.client.schema.Metadata;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.secext10.BinarySecurityTokenType;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.STSIssuedTokenFeature;
import com.sun.xml.ws.security.trust.TrustPlugin;
import com.sun.xml.ws.security.trust.WSTrustClientContract;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.ActAs;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.SecondaryParameters;
import com.sun.xml.ws.security.trust.elements.UseKey;
import com.sun.xml.ws.security.trust.elements.ValidateTarget;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.wss.WSITXMLFactory;
import com.sun.xml.wss.impl.dsig.WSSPolicyConsumerImpl;
import com.sun.xml.wss.jaxws.impl.Constants;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.Dispatch;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TrustPluginImpl
implements TrustPlugin {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");

    @Override
    public void process(IssuedTokenContext itc) throws WSTrustException {
        String signWith = null;
        String encryptWith = null;
        String appliesTo = itc.getEndpointAddress();
        STSIssuedTokenConfiguration stsConfig = (STSIssuedTokenConfiguration)itc.getSecurityPolicy().get(0);
        String stsURI = stsConfig.getSTSEndpoint();
        if (stsURI == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0029_COULD_NOT_GET_STS_LOCATION(appliesTo));
            throw new WebServiceException(LogStringsMessages.WST_0029_COULD_NOT_GET_STS_LOCATION(appliesTo));
        }
        Token oboToken = stsConfig.getOBOToken();
        BaseSTSResponse result = null;
        try {
            RequestSecurityToken request = this.createRequest(stsConfig, appliesTo, oboToken);
            result = this.invokeRST(request, stsConfig);
            WSTrustClientContract contract = WSTrustFactory.createWSTrustClientContract();
            contract.handleRSTR(request, result, itc);
            KeyPair keyPair = (KeyPair)stsConfig.getOtherOptions().get("UseKey-RSAKeyPair");
            if (keyPair != null) {
                itc.setProofKeyPair(keyPair);
            }
            if ((encryptWith = stsConfig.getEncryptWith()) != null) {
                itc.setEncryptWith(encryptWith);
            }
            if ((signWith = stsConfig.getSignWith()) != null) {
                itc.setSignWith(signWith);
            }
        }
        catch (RemoteException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo), ex);
        }
        catch (URISyntaxException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo), ex);
            throw new WSTrustException(LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, appliesTo));
        }
    }

    @Override
    public void processValidate(IssuedTokenContext itc) throws WSTrustException {
        STSIssuedTokenConfiguration stsConfig = (STSIssuedTokenConfiguration)itc.getSecurityPolicy().get(0);
        String stsURI = stsConfig.getSTSEndpoint();
        if (stsURI == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0029_COULD_NOT_GET_STS_LOCATION(null));
            throw new WebServiceException(LogStringsMessages.WST_0029_COULD_NOT_GET_STS_LOCATION(null));
        }
        BaseSTSResponse result = null;
        try {
            Token token = itc.getTarget();
            RequestSecurityToken request = this.createRequestForValidatation(stsConfig, token);
            result = this.invokeRST(request, stsConfig);
            WSTrustClientContract contract = WSTrustFactory.createWSTrustClientContract();
            contract.handleRSTR(request, result, itc);
        }
        catch (RemoteException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, null), ex);
            throw new WSTrustException(LogStringsMessages.WST_0016_PROBLEM_IT_CTX(stsURI, null), ex);
        }
    }

    private RequestSecurityToken createRequest(STSIssuedTokenConfiguration stsConfig, String appliesTo, Token oboToken) throws URISyntaxException, WSTrustException, NumberFormatException {
        SecondaryIssuedTokenParameters sitp;
        long lfValue;
        Integer lf;
        Token actAsToken;
        WSTrustVersion wstVer = WSTrustVersion.getInstance(stsConfig.getProtocol());
        WSTrustElementFactory fact = WSTrustElementFactory.newInstance(wstVer);
        URI requestType = URI.create(wstVer.getIssueRequestTypeURI());
        AppliesTo applTo = null;
        if (appliesTo != null) {
            applTo = WSTrustUtil.createAppliesTo(appliesTo);
            if (stsConfig.getOtherOptions().containsKey("Identity")) {
                this.addServerIdentity(applTo, stsConfig.getOtherOptions().get("Identity"));
            }
        }
        RequestSecurityToken rst = fact.createRSTForIssue(null, requestType, null, applTo, null, null, null);
        if (oboToken != null) {
            OnBehalfOf obo = fact.createOnBehalfOf(oboToken);
            rst.setOnBehalfOf(obo);
        }
        if ((actAsToken = (Token)stsConfig.getOtherOptions().get("ActAs")) != null) {
            ActAs actAs = fact.createActAs(actAsToken);
            rst.setActAs(actAs);
        }
        if ((lf = (Integer)stsConfig.getOtherOptions().get("LifeTime")) != null && (lfValue = lf.longValue()) > 0L) {
            long currentTime = WSTrustUtil.getCurrentTimeWithOffset();
            Lifetime lifetime = WSTrustUtil.createLifetime(currentTime, lfValue, wstVer);
            rst.setLifetime(lifetime);
        }
        String tokenType = null;
        String keyType = null;
        long keySize = -1L;
        Object signWith = null;
        Object encryptWith = null;
        String signatureAlgorithm = null;
        String encryptionAlgorithm = null;
        String keyWrapAlgorithm = null;
        String canonicalizationAlgorithm = null;
        Claims claims = null;
        if (wstVer.getNamespaceURI().equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI()) && (sitp = stsConfig.getSecondaryIssuedTokenParameters()) != null) {
            SecondaryParameters sp = fact.createSecondaryParameters();
            tokenType = sitp.getTokenType();
            if (tokenType != null) {
                sp.setTokenType(URI.create(tokenType));
            }
            if ((keyType = sitp.getKeyType()) != null) {
                sp.setKeyType(URI.create(keyType));
            }
            if ((keySize = sitp.getKeySize()) > 0L) {
                sp.setKeySize(keySize);
            }
            if ((signatureAlgorithm = sitp.getSignatureAlgorithm()) != null) {
                sp.setSignatureAlgorithm(URI.create(signatureAlgorithm));
            }
            if ((encryptionAlgorithm = sitp.getEncryptionAlgorithm()) != null) {
                sp.setEncryptionAlgorithm(URI.create(encryptionAlgorithm));
            }
            if ((canonicalizationAlgorithm = sitp.getCanonicalizationAlgorithm()) != null) {
                sp.setCanonicalizationAlgorithm(URI.create(canonicalizationAlgorithm));
            }
            if ((keyWrapAlgorithm = sitp.getKeyWrapAlgorithm()) != null) {
                sp.setKeyWrapAlgorithm(URI.create(keyWrapAlgorithm));
            }
            if ((claims = sitp.getClaims()) != null) {
                sp.setClaims(claims);
            }
            rst.setSecondaryParameters(sp);
        }
        if (tokenType == null && (tokenType = stsConfig.getTokenType()) != null) {
            rst.setTokenType(URI.create(tokenType));
        }
        if (keyType == null && (keyType = stsConfig.getKeyType()) != null) {
            rst.setKeyType(URI.create(keyType));
        }
        if (keySize < 1L && (keySize = stsConfig.getKeySize()) > 0L) {
            rst.setKeySize(keySize);
        }
        if (signatureAlgorithm == null && (signatureAlgorithm = stsConfig.getSignatureAlgorithm()) != null) {
            rst.setSignatureAlgorithm(URI.create(signatureAlgorithm));
        }
        if (encryptionAlgorithm == null && (encryptionAlgorithm = stsConfig.getEncryptionAlgorithm()) != null) {
            rst.setEncryptionAlgorithm(URI.create(encryptionAlgorithm));
        }
        if (canonicalizationAlgorithm == null && (canonicalizationAlgorithm = stsConfig.getCanonicalizationAlgorithm()) != null) {
            rst.setCanonicalizationAlgorithm(URI.create(canonicalizationAlgorithm));
        }
        if (claims == null && (claims = stsConfig.getClaims()) != null) {
            rst.setClaims(fact.createClaims(claims));
        }
        int len = 32;
        if (keySize > 0L) {
            len = (int)keySize / 8;
        }
        if (wstVer.getSymmetricKeyTypeURI().equals(keyType)) {
            SecureRandom secRandom = new SecureRandom();
            byte[] nonce = new byte[len];
            secRandom.nextBytes(nonce);
            BinarySecret binarySecret = fact.createBinarySecret(nonce, wstVer.getNonceBinarySecretTypeURI());
            Entropy entropy = fact.createEntropy(binarySecret);
            rst.setEntropy(entropy);
            rst.setComputedKeyAlgorithm(URI.create(wstVer.getCKPSHA1algorithmURI()));
        } else if (wstVer.getPublicKeyTypeURI().equals(keyType) && keySize > 1L) {
            KeyPairGenerator kpg;
            try {
                kpg = KeyPairGenerator.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new WSTrustException("Unable to create key pairs for UseKey", ex);
            }
            kpg.initialize((int)keySize);
            KeyPair keyPair = kpg.generateKeyPair();
            KeyInfo keyInfo = this.createKeyInfo(keyPair.getPublic());
            DocumentBuilderFactory docFactory = WSITXMLFactory.createDocumentBuilderFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING);
            Document doc = null;
            try {
                doc = docFactory.newDocumentBuilder().newDocument();
                keyInfo.marshal(new DOMStructure(doc), null);
            }
            catch (ParserConfigurationException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0039_ERROR_CREATING_DOCFACTORY(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0039_ERROR_CREATING_DOCFACTORY(), ex);
            }
            catch (MarshalException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0039_ERROR_CREATING_DOCFACTORY(), ex);
                throw new WSTrustException(LogStringsMessages.WST_0039_ERROR_CREATING_DOCFACTORY(), ex);
            }
            GenericToken token = new GenericToken(doc.getDocumentElement());
            UseKey useKey = fact.createUseKey(token, null);
            rst.setUseKey(useKey);
            stsConfig.getOtherOptions().put("UseKey-RSAKeyPair", keyPair);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WST_1006_CREATED_RST_ISSUE(WSTrustUtil.elemToString(rst, wstVer)));
        }
        return rst;
    }

    private RequestSecurityToken createRequestForValidatation(STSIssuedTokenConfiguration stsConfig, Token token) {
        WSTrustVersion wstVer = WSTrustVersion.getInstance(stsConfig.getProtocol());
        WSTrustElementFactory fact = WSTrustElementFactory.newInstance(wstVer);
        URI requestType = URI.create(wstVer.getValidateRequestTypeURI());
        URI tokenType = URI.create(wstVer.getValidateStatuesTokenType());
        RequestSecurityToken rst = fact.createRSTForValidate(tokenType, requestType);
        if (wstVer.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
            rst.getAny().add(token.getTokenValue());
        } else {
            ValidateTarget vt = fact.createValidateTarget(token);
            rst.setValidateTarget(vt);
        }
        return rst;
    }

    private BaseSTSResponse invokeRST(RequestSecurityToken request, STSIssuedTokenConfiguration stsConfig) throws RemoteException, WSTrustException {
        String stsURI = stsConfig.getSTSEndpoint();
        STSIssuedTokenConfiguration rtConfig = (STSIssuedTokenConfiguration)stsConfig.getOtherOptions().get("RunTimeConfig");
        Dispatch<Message> dispatch = null;
        WSTrustVersion wstVer = WSTrustVersion.getInstance(stsConfig.getProtocol());
        WSTrustElementFactory fact = WSTrustElementFactory.newInstance(wstVer);
        dispatch = rtConfig != null ? (Dispatch<Message>)rtConfig.getOtherOptions().get(stsURI) : (Dispatch)stsConfig.getOtherOptions().get(stsURI);
        if (dispatch == null) {
            URI wsdlLocation = null;
            QName serviceName = null;
            QName portName = null;
            String metadataStr = stsConfig.getSTSMEXAddress();
            if (metadataStr != null) {
                wsdlLocation = URI.create(metadataStr);
            } else {
                String namespace = stsConfig.getSTSNamespace();
                String wsdlLocationStr = stsConfig.getSTSWSDLLocation();
                if (wsdlLocationStr == null) {
                    wsdlLocationStr = stsURI;
                } else {
                    String portNameStr;
                    String serviceNameStr = stsConfig.getSTSServiceName();
                    if (serviceNameStr != null && namespace != null) {
                        serviceName = new QName(namespace, serviceNameStr);
                    }
                    if ((portNameStr = stsConfig.getSTSPortName()) != null && namespace != null) {
                        portName = new QName(namespace, portNameStr);
                    }
                }
                wsdlLocation = URI.create(wsdlLocationStr);
            }
            if (serviceName == null || portName == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, LogStringsMessages.WST_1012_SERVICE_PORTNAME_MEX(serviceName, portName));
                }
                QName[] names = TrustPluginImpl.doMexRequest(wsdlLocation.toString(), stsURI);
                serviceName = names[0];
                portName = names[1];
            }
            Service service = null;
            try {
                String url = wsdlLocation.toString();
                Container container = (Container)stsConfig.getOtherOptions().get("CONTAINER");
                if (container != null) {
                    WSService.InitParams initParams = new WSService.InitParams();
                    initParams.setContainer(container);
                    service = WSService.create(new URL(url), serviceName, initParams);
                } else {
                    service = Service.create(new URL(url), serviceName);
                }
            }
            catch (MalformedURLException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0041_SERVICE_NOT_CREATED(wsdlLocation.toString()), ex);
                throw new WebServiceException(LogStringsMessages.WST_0041_SERVICE_NOT_CREATED(wsdlLocation.toString()), ex);
            }
            WebServiceFeature[] wsFeatures = null;
            wsFeatures = rtConfig != null ? new WebServiceFeature[]{new RespectBindingFeature(), new AddressingFeature(false), new STSIssuedTokenFeature(rtConfig)} : new WebServiceFeature[]{new RespectBindingFeature(), new AddressingFeature(false)};
            dispatch = service.createDispatch(portName, Message.class, Service.Mode.MESSAGE, wsFeatures);
            if (rtConfig != null) {
                rtConfig.getOtherOptions().put(stsURI, dispatch);
            } else {
                stsConfig.getOtherOptions().put(stsURI, dispatch);
            }
        }
        if (stsURI != null) {
            dispatch.getRequestContext().put("javax.xml.ws.service.endpoint.address", stsURI);
        }
        dispatch.getRequestContext().put("isTrustMessage", "true");
        dispatch.getRequestContext().put("trustAction", this.getAction(wstVer, request.getRequestType().toString()));
        this.setMessageProperties(dispatch.getRequestContext(), stsConfig);
        Message reqMsg = Messages.createUsingPayload(fact.toSource(request), ((WSBinding)dispatch.getBinding()).getSOAPVersion());
        Message respMsg = dispatch.invoke(reqMsg);
        Source respSrc = respMsg.readPayloadAsSource();
        BaseSTSResponse resp = this.parseRSTR(respSrc, wstVer);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WST_1007_CREATED_RSTR_ISSUE(WSTrustUtil.elemToString(resp, wstVer)));
        }
        return resp;
    }

    protected static QName[] doMexRequest(String wsdlLocation, String stsURI) throws WSTrustException {
        QName[] serviceInfo = new QName[2];
        MetadataClient mexClient = new MetadataClient();
        Metadata metadata = mexClient.retrieveMetadata(wsdlLocation);
        if (metadata != null) {
            List<PortInfo> ports = mexClient.getServiceInformation(metadata);
            for (PortInfo port : ports) {
                String uri = port.getAddress();
                if (!URI.create(uri).getPath().equals(URI.create(stsURI).getPath())) continue;
                serviceInfo[0] = port.getServiceName();
                serviceInfo[1] = port.getPortName();
                break;
            }
            if (serviceInfo[0] == null || serviceInfo[1] == null) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0042_NO_MATCHING_SERVICE_MEX(stsURI));
                throw new WSTrustException(LogStringsMessages.WST_0042_NO_MATCHING_SERVICE_MEX(stsURI));
            }
        } else {
            log.log(Level.SEVERE, LogStringsMessages.WST_0017_SERVICE_PORTNAME_ERROR(wsdlLocation));
            throw new WSTrustException(LogStringsMessages.WST_0017_SERVICE_PORTNAME_ERROR(wsdlLocation));
        }
        return serviceInfo;
    }

    private KeyInfo createKeyInfo(PublicKey pubKey) throws WSTrustException {
        KeyInfoFactory kif = WSSPolicyConsumerImpl.getInstance().getKeyInfoFactory();
        KeyValue kv = null;
        try {
            kv = kif.newKeyValue(pubKey);
        }
        catch (KeyException ex) {
            throw new WSTrustException("Unable to create key value", ex);
        }
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(kv);
        KeyInfo ki = kif.newKeyInfo(kvs);
        return ki;
    }

    private String getAction(WSTrustVersion wstVer, String requestType) {
        if (wstVer.getIssueRequestTypeURI().equals(requestType)) {
            return wstVer.getIssueRequestAction();
        }
        if (wstVer.getValidateRequestTypeURI().equals(requestType)) {
            return wstVer.getValidateRequestAction();
        }
        if (wstVer.getRenewRequestTypeURI().equals(requestType)) {
            return wstVer.getRenewRequestAction();
        }
        if (wstVer.getCancelRequestTypeURI().equals(requestType)) {
            return wstVer.getCancelRequestAction();
        }
        return wstVer.getIssueRequestAction();
    }

    private BaseSTSResponse parseRSTR(Source source, WSTrustVersion wstVer) throws WSTrustException {
        BaseSTSResponse rstr;
        Element ele = null;
        try {
            DOMResult result = new DOMResult();
            Transformer tf = WSITXMLFactory.createTransformerFactory(WSITXMLFactory.DISABLE_SECURE_PROCESSING).newTransformer();
            tf.transform(source, result);
            Node node = result.getNode();
            if (node instanceof Document) {
                ele = ((Document)node).getDocumentElement();
            } else if (node instanceof Element) {
                ele = (Element)node;
            }
        }
        catch (Exception xe) {
            throw new WSTrustException("Error occurred while trying to parse RSTR stream", xe);
        }
        RequestedSecurityToken rdst = null;
        WSTrustElementFactory fact = WSTrustElementFactory.newInstance(wstVer);
        NodeList list = ele.getElementsByTagNameNS(ele.getNamespaceURI(), "RequestedSecurityToken");
        if (list.getLength() > 0) {
            Element issuedToken = (Element)list.item(0).getChildNodes().item(0);
            GenericToken token = new GenericToken(issuedToken);
            rdst = fact.createRequestedSecurityToken(token);
        }
        if (wstVer.getNamespaceURI().equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI())) {
            rstr = fact.createRSTRCollectionFrom(ele);
            rstr.getRequestSecurityTokenResponses().get(0).setRequestedSecurityToken(rdst);
        } else {
            rstr = fact.createRSTRFrom(ele);
            ((RequestSecurityTokenResponse)rstr).setRequestedSecurityToken(rdst);
        }
        return rstr;
    }

    private void setMessageProperties(Map<String, Object> context, STSIssuedTokenConfiguration stsConfig) {
        context.putAll(stsConfig.getOtherOptions());
        if (context.containsKey(Constants.SC_ASSERTION)) {
            context.remove(Constants.SC_ASSERTION);
        }
    }

    private void addServerIdentity(AppliesTo aplTo, Object identity) throws WSTrustException {
        if (identity instanceof Element) {
            aplTo.getAny().add(identity);
        } else if (identity instanceof X509Certificate) {
            String id = UUID.randomUUID().toString();
            BinarySecurityTokenType bst = new BinarySecurityTokenType();
            bst.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            bst.setId(id);
            bst.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
            try {
                bst.setValue(((X509Certificate)identity).getEncoded());
            }
            catch (CertificateEncodingException ex) {
                throw new WSTrustException(ex.getMessage());
            }
            JAXBElement<BinarySecurityTokenType> bstElem = new ObjectFactory().createBinarySecurityToken(bst);
            IdentityType idElem = new IdentityType();
            idElem.getDnsOrSpnOrUpn().add(bstElem);
            aplTo.getAny().add(new com.sun.xml.security.core.ai.ObjectFactory().createIdentity(idElem));
        }
    }
}

