/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class ConvertToARM {
    private static final Logger LOG = Logger.getLogger(ConvertToARMFix.class.getName());
    private static final SpecificationVersion JDK_17 = new SpecificationVersion("1.7");
    private static final SpecificationVersion JDK_9 = new SpecificationVersion("9");
    private static final String AUTO_CLOSEABLE = "java.lang.AutoCloseable";
    private static final String PTR_ENC_NONE_NO_TRY = "$CV $var = $init; $stms$; $var.close();";
    private static final String PTR_ENC_NONE_NO_TRY_FIN = "final $CV $var = $init; $stms$; $var.close();";
    private static final String PTR_ENC_NONE_NO_TRY_EFIN = "$stms$; $var.close();";
    private static final String PTR_ENC_NONE_TRY = "$CV $var = $init; try { $stms$; } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_NONE_TRY_FIN = "final $CV $var = $init; try { $stms$; } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_NONE_TRY_EFIN = "try { $stms$; } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_NONE_TRY_NULL = "$CV $var = null; try { $var = $init; $stms$; } catch $catches$ finally {if ($var != null) $var.close(); $finstms$;}";
    private static final String PTR_ENC_NONE_TRY_NULL2 = "$CV $var = null; try { $var = $init; $stms$; } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_NONE_TRY_NULL2_SHADOW = "$CV_x $var_x = null; try { $var_x = $init_x; $stms_x$; } catch $catches_x$ finally {$var_x.close(); $finstms_x$;}";
    private static final String PTR_ENC_ENCLOSED = "try { $CV $var = $init; $stms$; $var.close(); $suff$; } catch $catches$ finally { $finstms$; }";
    private static final String PTR_ENC_ENCLOSED2 = "try { $CV $var = $init; $stms$; $var.close(); $suff$; } catch $catches$";
    private static final String PTR_ENC_ENCLOSED3 = "try { $CV $var = $init; $stms$; $var.close(); $suff$; } finally { $finstms$; }";
    private static final String PTR_ENC_ENCLOSED_FIN = "try { final $CV $var = $init; $stms$; $var.close(); $suff$; } catch $catches$ finally { $finstms$; }";
    private static final String PTR_ENC_ENCLOSED_FIN2 = "try { final $CV $var = $init; $stms$; $var.close(); $suff$; } catch $catches$";
    private static final String PTR_ENC_ENCLOSED_FIN3 = "try { final $CV $var = $init; $stms$; $var.close(); $suff$; } finally { $finstms$; }";
    private static final String PTR_ENC_ENCLOSED_INIT = "$CV $var = $init; try { $stms$; $var.close(); $suff$; } catch $catches$ finally { $finstms$;}";
    private static final String PTR_ENC_ENCLOSED_INIT2 = "$CV $var = $init; try { $stms$; $var.close(); $suff$; } catch $catches$ finally { $finstms$;}";
    private static final String PTR_ENC_ENCLOSED_INIT3 = "$CV $var = $init; try { $stms$; $var.close(); $suff$; } finally { $finstms$;}";
    private static final String PTR_ENC_ENCLOSED_INIT_FIN = "final $CV $var = $init; try { $stms$; $var.close(); $suff$; } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_ENCLOSED_INIT_FIN2 = "final $CV $var = $init; try { $stms$; $var.close(); $suff$; } catch $catches$;";
    private static final String PTR_ENC_ENCLOSED_INIT_FIN3 = "final $CV $var = $init; try { $stms$; $var.close(); $suff$; } finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_OUT_NO_TRY = "$CV $var = $init; try($armres$) {$stms$;} $var.close();";
    private static final String PTR_ENC_OUT_NO_TRY_SHADOW = "$CV_x $var_x = $init_x; try($armres_x$) {$stms_x$;} $var_s.close();";
    private static final String PTR_ENC_OUT_NO_TRY_FIN = "final $CV $var = $init; try($armres$) {$stms$;} $var.close();";
    private static final String PTR_ENC_OUT_NO_TRY_FIN_SHADOW = "final $CV_x $var_x = $init_x; try($armres_x$) {$stms_x$;} $var_x.close();";
    private static final String PTR_ENC_OUT_NO_TRY_EFIN = "try($armres$) {$stms$;} $var.close();";
    private static final String PTR_ENC_OUT_NO_TRY_EFIN_SHADOW = "try($armres_x$) {$stms_x$;} $var_x.close();";
    private static final String PTR_ENC_OUT_TRY = "$CV $var = $init; try { try($armres$) {$stms$;} } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_OUT_TRY_SHADOW = "$CV_x $var_x = $init_x; try { try($armres_x$) {$stms_x$;} } catch $catches_x$ finally {$var_x.close(); $finstms_x$;}";
    private static final String PTR_ENC_OUT_TRY_FIN = "final $CV $var = $init; try { try($armres$) {$stms$;} } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_OUT_TRY_FIN_SHADOW = "final $CV_x $var_x = $init_x; try { try($armres_x$) {$stms_x$;} } catch $catches_x$ finally {$var_x.close(); $finstms_x$;}";
    private static final String PTR_ENC_OUT_TRY_EFIN = "try { try($armres$) {$stms$;} } catch $catches$ finally {$var.close(); $finstms$;}";
    private static final String PTR_ENC_OUT_TRY_EFIN_SHADOW = "try { try($armres_x$) {$stms_x$;} } catch $catches_x$ finally {$var_x.close(); $finstms_x$;}";
    private static final String PTR_ENC_OUT_TRY_NULL = "$CV $var = null; try { $var = $init; try($armres$) {$stms$;} } catch $catches$ finally {if ($var != null) $var.close(); $finstms$;}";
    private static final String PTR_ENC_OUT_TRY_NULL_SHADOW = "$CV_x $var_x = null; try { $var_x = $init_x; try($armres_x$) {$stms_x$;} } catch $catches_x$ finally {if ($var_x != null) $var_x.close(); $finstms_x$;}";
    private static final String PTR_ENC_IN_NO_TRY = "try($armres$) {$CV $var = $init; $stms$; $var.close(); $suff$;} catch $catches$";
    private static final String PTR_ENC_IN_NO_TRY_SHADOW = "try($armres_x$) {$CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$";
    private static final String PTR_ENC_IN_NO_TRY2 = "try($armres$) {$CV $var = $init; $stms$; $var.close(); $suff$;} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_NO_TRY2_SHADOW = "try($armres_x$) {$CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$ finally {$finstms_x$;}";
    private static final String PTR_ENC_IN_NO_TRY_FIN = "try($armres$) {final $CV $var = $init; $stms$; $var.close(); $suff$;} catch $catches$";
    private static final String PTR_ENC_IN_NO_TRY_FIN_SHADOW = "try($armres_x$) {final $CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$";
    private static final String PTR_ENC_IN_NO_TRY_EFIN = "try($armres$) {$stms$; $var.close(); $suff$;} catch $catches$";
    private static final String PTR_ENC_IN_NO_TRY_EFIN_SHADOW = "try($armres_x$) {$stms_x$; $var_x.close();} catch $catches_x$";
    private static final String PTR_ENC_IN_NO_TRY2_FIN = "try($armres$) {final $CV $var = $init; $stms$; $var.close(); $suff$;} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_NO_TRY2_FIN_SHADOW = "try($armres_x$) {$CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$ finally {$finstms_x$;}";
    private static final String PTR_ENC_IN_NO_TRY2_EFIN = "try($armres$) {$stms$; $var.close(); $suff$;} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_NO_TRY2_EFIN_SHADOW = "try($armres_x$) {$stms_x$; $var_x.close();} catch $catches_x$ finally {$finstms_x$;}";
    private static final String PTR_ENC_IN_TRY = "try($armres$) { $CV $var = $init; try { $stms$; } finally {$var.close();}} catch $catches$";
    private static final String PTR_ENC_IN_TRY_SHADOW = "try($armres_x$) { $CV_x $var_x = $init_x; try { $stms_x$; } finally {$var_x.close();}} catch $catches_x$";
    private static final String PTR_ENC_IN_TRY2 = "try($armres$) { $CV $var = $init; try { $stms$; } finally {$var.close();}} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_TRY2_SHADOW = "try($armres_x$) { $CV_x $var_x = $init_x; try { $stms_x$; } finally {$var_x.close();}} catch $catches_x$ finally {$finstms_x$;}";
    private static final String PTR_ENC_IN_TRY_FIN = "try($armres$) { final $CV $var = $init; try { $stms$; } finally {$var.close();}} catch $catches$";
    private static final String PTR_ENC_IN_TRY_FIN_SHADOW = "try($armres_x$) { final $CV_x $var_x = $init_x; try { $stms_x$; } finally {$var_x.close();}} catch $catches_x$";
    private static final String PTR_ENC_IN_TRY_EFIN = "try($armres$) {try { $stms$; } finally {$var.close();}} catch $catches$";
    private static final String PTR_ENC_IN_TRY_EFIN_SHADOW = "try($armres_x$) {try { $stms_x$; } finally {$var_x.close();}} catch $catches_x$";
    private static final String PTR_ENC_IN_TRY2_FIN = "try($armres$) { final $CV $var = $init; try { $stms$; } finally {$var.close();}} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_TRY2_FIN_SHADOW = "try($armres_x$) { final $CV_x $var_x = $init_x; try { $stms_x$; } finally {$var_x.close();}} catch $catches_x$ finally {$finstms_x$;}";
    private static final String PTR_ENC_IN_TRY2_EFIN = "try($armres$) {try { $stms$; } finally {$var.close();}} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_TRY2_EFIN_SHADOW = "try($armres_x$) {try { $stms_x$; } finally {$var_x.close();}} catch $catches_x$ finally {$finstms_x$;}";
    private static final String PTR_ENC_IN_TRY_NULL = "try($armres$) { $CV $var = null; try { $var = $init; $stms$; } finally {if ($var != null) $var.close();}} catch $catches$";
    private static final String PTR_ENC_IN_TRY_NULL_SHADOW = "try($armres_x$) { $CV_x $var_x = null; try { $var_x = $init_x; $stms_x$; } finally {if ($var_x != null) $var_x.close();}} catch $catches_x$";
    private static final String PTR_ENC_IN_TRY_NULL2 = "try($armres$) { $CV $var = null; try { $var = $init; $stms$; } finally {if ($var != null) $var.close();}} catch $catches$ finally {$finstms$;}";
    private static final String PTR_ENC_IN_TRY_NULL2_SHADOW = "try($armres_x$) { $CV_x $var_x = null; try { $var_x = $init_x; $stms_x$; } finally {if ($var_x != null) $var_x.close();}} catch $catches_x$ finally {$finstms_x$;}";
    static boolean checkAutoCloseable = true;
    private static final Collection<? extends TreePath> UNRESOLVABLE_MARKER = new ArrayList<TreePath>();

    public static List<ErrorDescription> hintCorrectCode(HintContext ctx) {
        return ConvertToARM.hintImpl(ctx, NestingKind.IN, "FIX_ChangeTryToARM");
    }

    public static List<ErrorDescription> hint11(HintContext ctx) {
        return ConvertToARM.hint1Impl(ctx, false, "TXT_ConvertToARM");
    }

    public static List<ErrorDescription> hint12(HintContext ctx) {
        return ConvertToARM.hint1Impl(ctx, true);
    }

    public static List<ErrorDescription> hint1Impl(HintContext ctx, boolean secondRule) {
        return ConvertToARM.hint1Impl(ctx, secondRule, "TXT_ConvertToARM");
    }

    public static List<ErrorDescription> hint1Impl(HintContext ctx, boolean secondRule, String fixKey) {
        if (!(MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath(), (String)PTR_ENC_OUT_NO_TRY_SHADOW) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath(), (String)PTR_ENC_OUT_NO_TRY_FIN_SHADOW) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath(), (String)PTR_ENC_OUT_NO_TRY_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_OUT_NO_TRY_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath(), (String)PTR_ENC_OUT_TRY_SHADOW) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath(), (String)PTR_ENC_OUT_TRY_FIN_SHADOW) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath(), (String)PTR_ENC_OUT_TRY_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_OUT_TRY_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath(), (String)PTR_ENC_OUT_TRY_NULL_SHADOW) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_NO_TRY_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)"try($armres_x$) {$CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$ finally {$finstms_x$;}") && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_NO_TRY_FIN_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_NO_TRY_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath().getParentPath(), (String)PTR_ENC_IN_NO_TRY_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)"try($armres_x$) {$CV_x $var_x = $init_x; $stms_x$; $var_x.close();} catch $catches_x$ finally {$finstms_x$;}") && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_NO_TRY2_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath().getParentPath(), (String)PTR_ENC_IN_NO_TRY2_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_TRY_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_TRY2_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_TRY_FIN_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_TRY_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath().getParentPath(), (String)PTR_ENC_IN_TRY_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_TRY2_FIN_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_TRY2_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath().getParentPath(), (String)PTR_ENC_IN_TRY2_EFIN_SHADOW) && ConvertToARM.isEffectivelyFinal(ctx) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_TRY_NULL_SHADOW) && ConvertToARM.insideARM(ctx) || MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath().getParentPath(), (String)PTR_ENC_IN_TRY_NULL2_SHADOW) && ConvertToARM.insideARM(ctx))) {
            if (!secondRule && MatcherUtilities.matches((HintContext)ctx, (TreePath)ctx.getPath(), (String)PTR_ENC_NONE_TRY_NULL2_SHADOW)) {
                return Collections.emptyList();
            }
            return ConvertToARM.hintImpl(ctx, NestingKind.NONE, fixKey);
        }
        return Collections.emptyList();
    }

    public static List<ErrorDescription> hint2(HintContext ctx) {
        return ConvertToARM.hintImpl(ctx, NestingKind.OUT, "FIX_MergeTryResources");
    }

    public static List<ErrorDescription> hint3(HintContext ctx) {
        if (ConvertToARM.insideARM(ctx)) {
            return ConvertToARM.hintImpl(ctx, NestingKind.IN, "FIX_MergeTryResources");
        }
        return Collections.emptyList();
    }

    private static List<ErrorDescription> hintImpl(HintContext ctx, NestingKind nestingKind, String key) {
        Parameters.notNull((CharSequence)"ctx", (Object)ctx);
        Map vars = ctx.getVariables();
        TreePath varVar = (TreePath)vars.get("$var");
        assert (varVar != null);
        CompilationInfo info = ctx.getInfo();
        Trees trees = info.getTrees();
        TypeMirror type = trees.getTypeMirror(varVar);
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>(1);
        if (type != null && type.getKind() == TypeKind.DECLARED) {
            Element element;
            TypeElement autoCloseable = info.getElements().getTypeElement(AUTO_CLOSEABLE);
            if (ConvertToARM.isSupportedSourceLevel(info.getFileObject(), JDK_17) && (!checkAutoCloseable || autoCloseable != null && info.getTypes().isSubtype(type, autoCloseable.asType())) && (element = trees.getElement(varVar)) != null && EnumSet.of(ElementKind.FIELD, ElementKind.PARAMETER, ElementKind.LOCAL_VARIABLE).contains((Object)element.getKind())) {
                LinkedList cleanUpStatements;
                Collection tail;
                Collection<? extends TreePath> usages;
                Map multiVars;
                Collection stms;
                TreePath typeVar = (TreePath)vars.get("$CV");
                VariableElement resElement = (VariableElement)element;
                if ((typeVar != null || ConvertToARM.isSupportedSourceLevel(info.getFileObject(), JDK_9) && resElement.getKind() != ElementKind.LOCAL_VARIABLE && info.getElementUtilities().isEffectivelyFinal(resElement)) && !(stms = (Collection)(multiVars = ctx.getMultiVariables()).get("$stms$")).isEmpty() && !ConvertToARM.isAssigned(resElement, stms, trees) && !ConvertToARM.hasNonCleanUpUsages(usages = ConvertToARM.findResourceUsages(resElement, tail = multiVars.containsKey("$suff$") ? (Collection)multiVars.get("$suff$") : (Collection)multiVars.get("$$2$"), trees), cleanUpStatements = new LinkedList()) && !ConvertToARM.splitVariablesClash(stms, tail, trees)) {
                    Iterator<? extends TreePath> paths;
                    TreePath path = varVar;
                    if (typeVar == null && (paths = ConvertToARM.findResourceUsages(resElement, stms, trees).iterator()).hasNext()) {
                        path = paths.next();
                    }
                    result.add(ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)path, (String)NbBundle.getMessage(ConvertToARM.class, (String)"TXT_ConvertToARM"), (Fix[])new Fix[]{new ConvertToARMFix(info, key, ctx.getPath(), nestingKind, varVar, (TreePath)vars.get("$init"), (Collection)multiVars.get("$armres$"), stms, (Collection)multiVars.get("$catches$"), (Collection)multiVars.get("$finstms$"), tail, cleanUpStatements).toEditorFix()}));
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    private static Collection<? extends TreePathHandle> wrap(CompilationInfo info, Collection<? extends TreePath> paths) {
        if (paths == null) {
            return null;
        }
        ArrayList<TreePathHandle> result = new ArrayList<TreePathHandle>(paths.size());
        for (TreePath treePath : paths) {
            result.add(TreePathHandle.create((TreePath)treePath, (CompilationInfo)info));
        }
        return result;
    }

    private static Collection<? extends TreePath> unwrap(CompilationInfo info, Collection<? extends TreePathHandle> paths) {
        if (paths == null) {
            return null;
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>(paths.size());
        for (TreePathHandle treePathHandle : paths) {
            TreePath tp = treePathHandle.resolve(info);
            if (tp == null) {
                LOG.log(Level.FINE, "Cannot resolve TreePathHandle: {0}", tp.toString());
                return UNRESOLVABLE_MARKER;
            }
            result.add(tp);
        }
        return result;
    }

    private static void rewriteCopyComments(WorkingCopy wc, Tree from, Tree to) {
        GeneratorUtilities gen = GeneratorUtilities.get((WorkingCopy)wc);
        gen.copyComments(from, to, true);
        gen.copyComments(from, to, false);
        wc.rewrite(from, to);
    }

    private static VariableTree removeFinal(WorkingCopy wc, VariableTree varTree) {
        ModifiersTree oldMods = varTree.getModifiers();
        if (oldMods != null && oldMods.getFlags().contains((Object)Modifier.FINAL)) {
            ModifiersTree newMods = wc.getTreeMaker().removeModifiersModifier(oldMods, Modifier.FINAL);
            ConvertToARM.rewriteCopyComments(wc, oldMods, newMods);
        }
        return varTree;
    }

    private static Collection<? extends Tree> removeFinal(WorkingCopy wc, Collection<? extends Tree> trees) {
        ArrayList<Tree> result = new ArrayList<Tree>(trees.size());
        for (Tree tree : trees) {
            result.add(tree.getKind() == Tree.Kind.VARIABLE ? ConvertToARM.removeFinal(wc, (VariableTree)tree) : tree);
        }
        return result;
    }

    private static VariableTree addInit(WorkingCopy wc, VariableTree var, ExpressionTree init) {
        ExpressionTree currentInit = var.getInitializer();
        if (currentInit.getKind() == Tree.Kind.NULL_LITERAL) {
            VariableTree newVar = wc.getTreeMaker().Variable(var.getModifiers(), (CharSequence)var.getName(), var.getType(), init);
            ConvertToARM.rewriteCopyComments(wc, var, newVar);
            return newVar;
        }
        return var;
    }

    private static TryTree findNestedARM(Collection<? extends StatementTree> stms, StatementTree var) {
        boolean state = var == null;
        for (StatementTree statementTree : stms) {
            if (statementTree == var) {
                state = true;
            }
            if (!state) continue;
            if (statementTree.getKind() == Tree.Kind.TRY) {
                TryTree tryTree = (TryTree)statementTree;
                if (tryTree.getResources() != null && !tryTree.getResources().isEmpty()) {
                    return tryTree;
                }
                Iterator<? extends StatementTree> blkStms = tryTree.getBlock().getStatements().iterator();
                if (blkStms.hasNext()) {
                    StatementTree bstm = blkStms.next();
                    if (bstm.getKind() == Tree.Kind.TRY) {
                        return (TryTree)bstm;
                    }
                    if (bstm.getKind() == Tree.Kind.EXPRESSION_STATEMENT && blkStms.hasNext() && (bstm = blkStms.next()).getKind() == Tree.Kind.TRY) {
                        return (TryTree)bstm;
                    }
                }
            }
            if (statementTree == var) continue;
            break;
        }
        return null;
    }

    private static TreePath findEnclosingARMPath(TreePath varPath) {
        TreePath path;
        if (varPath == null) {
            return null;
        }
        if (varPath.getLeaf().getKind() == Tree.Kind.VARIABLE) {
            TreePath path2 = ConvertToARM.findEnclosingTryPath(varPath);
            return path2 != null && ((TryTree)path2.getLeaf()).getResources() != null && !((TryTree)path2.getLeaf()).getResources().isEmpty() ? path2 : null;
        }
        for (path = varPath; path != null && !(path.getLeaf() instanceof StatementTree); path = path.getParentPath()) {
        }
        if ((path = ConvertToARM.findEnclosingTryPath(path)) != null && ((TryTree)path.getLeaf()).getResources() != null && !((TryTree)path.getLeaf()).getResources().isEmpty()) {
            return path;
        }
        return (path = ConvertToARM.findEnclosingTryPath(path)) != null && ((TryTree)path.getLeaf()).getResources() != null && !((TryTree)path.getLeaf()).getResources().isEmpty() ? path : null;
    }

    private static TreePath findEnclosingTryPath(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent == null || parent.getLeaf().getKind() != Tree.Kind.BLOCK) {
            return null;
        }
        if ((parent = parent.getParentPath()) == null || parent.getLeaf().getKind() != Tree.Kind.TRY) {
            return null;
        }
        return parent;
    }

    private static boolean isEffectivelyFinal(HintContext ctx) {
        TreePath var;
        if (ConvertToARM.isSupportedSourceLevel(ctx.getInfo().getFileObject(), JDK_9) && (var = (TreePath)ctx.getVariables().get("$var")) != null) {
            Element el = ctx.getInfo().getTrees().getElement(var);
            return el != null && EnumSet.of(ElementKind.FIELD, ElementKind.PARAMETER).contains((Object)el.getKind()) && ctx.getInfo().getElementUtilities().isEffectivelyFinal((VariableElement)el);
        }
        return false;
    }

    private static boolean insideARM(HintContext ctx) {
        return ConvertToARM.findEnclosingARMPath((TreePath)ctx.getVariables().get("$var")) != null;
    }

    private static Collection<VariableTree> findVariableDecls(List<? extends StatementTree> statements, Tree parent) {
        LinkedList<VariableTree> varDecls = new LinkedList<VariableTree>();
        for (StatementTree statementTree : statements) {
            if (statementTree.getKind() != Tree.Kind.VARIABLE) continue;
            varDecls.add((VariableTree)statementTree);
        }
        return varDecls;
    }

    private static Collection<VariableTree> findVarsUsages(Collection<VariableTree> vars, List<? extends StatementTree> stms, final CompilationUnitTree cu, final Trees trees) {
        final HashMap<Element, VariableTree> elms = new HashMap<Element, VariableTree>();
        for (VariableTree var : vars) {
            Element elm = trees.getElement(trees.getPath(cu, var));
            if (elm == null) continue;
            elms.put(elm, var);
        }
        final HashSet result = new HashSet();
        ErrorAwareTreeScanner<Void, Void> scanner = new ErrorAwareTreeScanner<Void, Void>(){

            public Void visitIdentifier(IdentifierTree node, Void p) {
                Element elm = trees.getElement(trees.getPath(cu, node));
                VariableTree var = (VariableTree)elms.get(elm);
                if (var != null) {
                    result.add(var);
                }
                return (Void)super.visitIdentifier(node, (Object)p);
            }
        };
        scanner.scan(stms, null);
        vars.retainAll(result);
        return vars;
    }

    private static Collection<? extends TreePath> findResourceUsages(final VariableElement resource, Collection<? extends TreePath> statements, final Trees trees) {
        final LinkedList usages = new LinkedList();
        if (statements != null) {
            ErrorAwareTreePathScanner<List<TreePath>, List<TreePath>> scanner = new ErrorAwareTreePathScanner<List<TreePath>, List<TreePath>>(){

                public List<TreePath> visitIdentifier(IdentifierTree node, List<TreePath> p) {
                    TreePath path = this.getCurrentPath();
                    Element element = trees.getElement(path);
                    if (element == resource) {
                        usages.add(path);
                    }
                    return (List)super.visitIdentifier(node, p);
                }
            };
            for (TreePath treePath : statements) {
                scanner.scan(treePath, usages);
            }
        }
        return usages;
    }

    private static boolean hasNonCleanUpUsages(Collection<? extends TreePath> usages, Collection<? super TreePath> cleanupStatements) {
        for (TreePath treePath : usages) {
            TreePath parentPath = treePath.getParentPath();
            Tree parent = parentPath.getLeaf();
            if (parent.getKind() != Tree.Kind.ASSIGNMENT) {
                return true;
            }
            AssignmentTree assign = (AssignmentTree)parent;
            if (assign.getVariable() != treePath.getLeaf()) {
                return true;
            }
            if (assign.getExpression().getKind() != Tree.Kind.NULL_LITERAL) {
                return true;
            }
            TreePath parentParent = parentPath.getParentPath();
            if (parentParent.getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                return true;
            }
            cleanupStatements.add(parentParent);
        }
        return false;
    }

    private static boolean isAssigned(final Element what, Iterable<? extends TreePath> where, final Trees trees) {
        ErrorAwareTreePathScanner<Boolean, Void> scanner = new ErrorAwareTreePathScanner<Boolean, Void>(){

            public Boolean visitAssignment(AssignmentTree node, Void p) {
                if (trees.getElement(new TreePath(this.getCurrentPath(), node.getVariable())) == what) {
                    return true;
                }
                return (Boolean)super.visitAssignment(node, (Object)p);
            }

            public Boolean reduce(Boolean r1, Boolean r2) {
                return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
            }
        };
        for (TreePath treePath : where) {
            if (scanner.scan(treePath, null) != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }

    private static boolean splitVariablesClash(Collection<? extends TreePath> statementsPaths, Collection<? extends TreePath> tail, Trees trees) {
        if (tail == null || tail.isEmpty()) {
            return false;
        }
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>(statementsPaths.size());
        for (TreePath treePath : statementsPaths) {
            statements.add((StatementTree)treePath.getLeaf());
        }
        final HashSet<VariableTree> usedAfterCloseVarDecls = new HashSet<VariableTree>(ConvertToARM.findVarsUsages(ConvertToARM.findVariableDecls(statements, statementsPaths.isEmpty() ? null : statementsPaths.iterator().next().getParentPath().getLeaf()), ConvertToARMFix.asList(tail), tail.iterator().next().getCompilationUnit(), trees));
        final HashSet<String> hashSet = new HashSet<String>();
        for (VariableTree vt : usedAfterCloseVarDecls) {
            hashSet.add(vt.getName().toString());
        }
        ErrorAwareTreeScanner<Boolean, Void> scanner = new ErrorAwareTreeScanner<Boolean, Void>(){

            public Boolean visitVariable(VariableTree node, Void p) {
                if (hashSet.contains(node.getName().toString()) && !usedAfterCloseVarDecls.contains(node)) {
                    return true;
                }
                return (Boolean)super.visitVariable(node, (Object)p);
            }

            public Boolean reduce(Boolean r1, Boolean r2) {
                return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
            }
        };
        return scanner.scan(statements, null) == Boolean.TRUE;
    }

    private static boolean isSupportedSourceLevel(FileObject file, SpecificationVersion ver) {
        if (file == null) {
            return false;
        }
        String sl = SourceLevelQuery.getSourceLevel((FileObject)file);
        if (sl == null) {
            return false;
        }
        return ver.compareTo((Object)new SpecificationVersion(sl)) <= 0;
    }

    private static enum NestingKind {
        NONE,
        IN,
        OUT;

    }

    private static final class ConvertToARMFix
    extends JavaFix {
        private final String bundleKey;
        private final NestingKind nestingKind;
        private final TreePathHandle initHandle;
        private final TreePathHandle varHandle;
        private final Collection<? extends TreePathHandle> armPathHandles;
        private final Collection<? extends TreePathHandle> statementsPathHandles;
        private final Collection<? extends TreePathHandle> catchesPathHandles;
        private final Collection<? extends TreePathHandle> finStatementsPathHandles;
        private final Collection<? extends TreePathHandle> tailHandle;
        private final Collection<? extends TreePathHandle> cleanUpStmsHandle;

        private ConvertToARMFix(CompilationInfo info, String bundleKey, TreePath owner, NestingKind nestignKind, TreePath var, TreePath init, Collection<? extends TreePath> armPaths, Collection<? extends TreePath> statements, Collection<? extends TreePath> catches, Collection<? extends TreePath> finStatementsPath, Collection<? extends TreePath> tail, Collection<? extends TreePath> cleanUpStms) {
            super(info, owner);
            this.bundleKey = bundleKey;
            this.nestingKind = nestignKind;
            this.varHandle = var != null ? TreePathHandle.create((TreePath)var, (CompilationInfo)info) : null;
            this.initHandle = init != null ? TreePathHandle.create((TreePath)init, (CompilationInfo)info) : null;
            this.armPathHandles = ConvertToARM.wrap(info, armPaths);
            this.statementsPathHandles = ConvertToARM.wrap(info, statements);
            this.catchesPathHandles = ConvertToARM.wrap(info, catches);
            this.finStatementsPathHandles = ConvertToARM.wrap(info, finStatementsPath);
            this.tailHandle = ConvertToARM.wrap(info, tail);
            this.cleanUpStmsHandle = ConvertToARM.wrap(info, cleanUpStms);
        }

        public String getText() {
            return NbBundle.getMessage(ConvertToARM.class, (String)this.bundleKey);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            TryTree oldTry;
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            TreePath init = this.initHandle != null ? this.initHandle.resolve((CompilationInfo)wc) : null;
            TreePath var = this.varHandle.resolve((CompilationInfo)wc);
            if (var == null) {
                LOG.log(Level.FINE, "Cannot resolve TreePathHandle: {0}", this.varHandle.toString());
                return;
            }
            Collection armPaths = ConvertToARM.unwrap((CompilationInfo)wc, this.armPathHandles);
            Collection statementsPaths = ConvertToARM.unwrap((CompilationInfo)wc, this.statementsPathHandles);
            Collection catchesPaths = ConvertToARM.unwrap((CompilationInfo)wc, this.catchesPathHandles);
            Collection finStatementsPath = ConvertToARM.unwrap((CompilationInfo)wc, this.finStatementsPathHandles);
            Collection tail = ConvertToARM.unwrap((CompilationInfo)wc, this.tailHandle);
            Collection cleanUpStms = ConvertToARM.unwrap((CompilationInfo)wc, this.cleanUpStmsHandle);
            TreeMaker tm = wc.getTreeMaker();
            GeneratorUtilities gen = GeneratorUtilities.get((WorkingCopy)wc);
            gen.importComments(tp.getLeaf(), wc.getCompilationUnit());
            HashSet<StatementTree> nonNeededStms = new HashSet<StatementTree>();
            for (TreePath stm : cleanUpStms) {
                BlockTree owner = (BlockTree)stm.getParentPath().getLeaf();
                if (owner == tp.getLeaf()) {
                    nonNeededStms.add((StatementTree)stm.getLeaf());
                    continue;
                }
                ConvertToARM.rewriteCopyComments(wc, owner, tm.removeBlockStatement(owner, (StatementTree)stm.getLeaf()));
            }
            if (this.nestingKind == NestingKind.NONE) {
                List statements = ConvertToARMFix.asList(statementsPaths);
                LinkedList<VariableTree> additionalVars = new LinkedList<VariableTree>();
                LinkedList<VariableTree> removedVars = new LinkedList<VariableTree>();
                if (tail != null && !tail.isEmpty()) {
                    Collection usedAfterCloseVarDecls = ConvertToARM.findVarsUsages(ConvertToARM.findVariableDecls(statements, statementsPaths.isEmpty() ? null : ((TreePath)statementsPaths.iterator().next()).getParentPath().getLeaf()), ConvertToARMFix.asList(tail), ((TreePath)tail.iterator().next()).getCompilationUnit(), wc.getTrees());
                    for (VariableTree vr : usedAfterCloseVarDecls) {
                        additionalVars.add(tm.Variable(vr.getModifiers(), (CharSequence)vr.getName(), vr.getType(), null));
                        if (vr.getInitializer() != null) {
                            ConvertToARM.rewriteCopyComments(wc, vr, tm.ExpressionStatement((ExpressionTree)tm.Assignment((ExpressionTree)tm.Identifier((CharSequence)vr.getName()), vr.getInitializer())));
                            continue;
                        }
                        removedVars.add(vr);
                    }
                }
                LinkedList filteredStatements = new LinkedList(statements);
                filteredStatements.removeAll(removedVars);
                BlockTree block = tm.Block(filteredStatements, false);
                Tree resTree = var.getLeaf().getKind() == Tree.Kind.VARIABLE ? ConvertToARM.addInit(wc, ConvertToARM.removeFinal(wc, (VariableTree)var.getLeaf()), (ExpressionTree)init.getLeaf()) : var.getLeaf();
                TryTree tryTree = tm.Try(Collections.singletonList(resTree), block, ConvertToARMFix.asList(catchesPaths), ConvertToARMFix.rewriteFinallyBlock(tm, finStatementsPath));
                StatementTree stat = null;
                if (tp.getLeaf().getKind() == Tree.Kind.TRY) {
                    stat = (StatementTree)tp.getLeaf();
                    tp = tp.getParentPath();
                } else if (var.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                    stat = (StatementTree)var.getLeaf();
                }
                ConvertToARM.rewriteCopyComments(wc, tp.getLeaf(), ConvertToARMFix.rewriteOwnerBlock(gen, tm, ((BlockTree)tp.getLeaf()).getStatements(), stat, additionalVars, tryTree, statements, nonNeededStms));
            } else if (this.nestingKind == NestingKind.OUT) {
                StatementTree stat = null;
                if (tp.getLeaf().getKind() == Tree.Kind.TRY) {
                    stat = (StatementTree)tp.getLeaf();
                    tp = tp.getParentPath();
                } else if (var.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                    stat = (StatementTree)var.getLeaf();
                }
                oldTry = ConvertToARM.findNestedARM(((BlockTree)tp.getLeaf()).getStatements(), stat);
                if (oldTry == null) {
                    return;
                }
                ArrayList<Tree> arm = new ArrayList<Tree>();
                Tree resTree = var.getLeaf().getKind() == Tree.Kind.VARIABLE ? ConvertToARM.addInit(wc, ConvertToARM.removeFinal(wc, (VariableTree)var.getLeaf()), (ExpressionTree)init.getLeaf()) : var.getLeaf();
                arm.add(resTree);
                arm.addAll(ConvertToARM.removeFinal(wc, ConvertToARMFix.asList(armPaths)));
                TryTree newTry = tm.Try(arm, oldTry.getBlock(), ConvertToARMFix.asList(catchesPaths), ConvertToARMFix.rewriteFinallyBlock(tm, finStatementsPath));
                ConvertToARM.rewriteCopyComments(wc, tp.getLeaf(), ConvertToARMFix.rewriteOwnerBlock(gen, tm, ((BlockTree)tp.getLeaf()).getStatements(), stat, Collections.emptyList(), newTry, ConvertToARMFix.asList(statementsPaths), nonNeededStms));
            } else if (this.nestingKind == NestingKind.IN) {
                TryTree newTry;
                TreePath oldTryPath = ConvertToARM.findEnclosingARMPath(var);
                if (oldTryPath == null) {
                    return;
                }
                TryTree rewriteTree = oldTry = (TryTree)oldTryPath.getLeaf();
                ArrayList<Tree> arm = new ArrayList<Tree>(ConvertToARM.removeFinal(wc, oldTry.getResources()));
                Tree resTree = var.getLeaf().getKind() == Tree.Kind.VARIABLE ? ConvertToARM.addInit(wc, ConvertToARM.removeFinal(wc, (VariableTree)var.getLeaf()), (ExpressionTree)init.getLeaf()) : var.getLeaf();
                arm.add(resTree);
                StatementTree newTree = newTry = tm.Try(arm, tm.Block(ConvertToARMFix.asList(statementsPaths), false), oldTry.getCatches(), oldTry.getFinallyBlock());
                if (tail != null && !tail.isEmpty()) {
                    TreePath parent = oldTryPath.getParentPath();
                    if (parent != null && parent.getLeaf().getKind() == Tree.Kind.BLOCK) {
                        BlockTree bt = (BlockTree)parent.getLeaf();
                        int index = bt.getStatements().indexOf(oldTry);
                        List stats = ConvertToARMFix.asList(tail);
                        for (int i = 0; i < stats.size(); ++i) {
                            bt = tm.insertBlockStatement(bt, index + 1 + i, (StatementTree)stats.get(i));
                        }
                        ConvertToARM.rewriteCopyComments(wc, parent.getLeaf(), bt);
                    } else {
                        ArrayList<TryTree> stats = new ArrayList<TryTree>();
                        stats.add(newTry);
                        stats.addAll(ConvertToARMFix.asList(statementsPaths));
                        newTree = tm.Block(stats, false);
                    }
                }
                ConvertToARM.rewriteCopyComments(wc, rewriteTree, newTree);
            }
        }

        private static <R extends Tree> List<? extends R> asList(Collection<? extends TreePath> data) {
            if (data == null) {
                return Collections.emptyList();
            }
            ArrayList<Tree> result = new ArrayList<Tree>(data.size());
            for (TreePath treePath : data) {
                result.add(treePath.getLeaf());
            }
            return result;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private static BlockTree rewriteOwnerBlock(GeneratorUtilities gen, TreeMaker tm, List<? extends StatementTree> originalStatements, StatementTree var, List<? extends VariableTree> preVarDecls, TryTree newTry, List<? extends StatementTree> oldStms, Set<? extends StatementTree> removeStms) {
            ArrayList<Object> statements = new ArrayList<Object>(originalStatements.size());
            int state = var != null ? 0 : 1;
            HashSet<? extends StatementTree> toRemove = new HashSet<StatementTree>(oldStms);
            Iterator<? extends StatementTree> iterator = originalStatements.iterator();
            while (true) {
                void var12_12;
                block12: {
                    TryTree tt;
                    if (!iterator.hasNext()) {
                        return tm.Block(statements, false);
                    }
                    StatementTree statementTree = iterator.next();
                    if (removeStms.contains(statementTree)) continue;
                    if (var == statementTree) {
                        statements.addAll(preVarDecls);
                        if (var.getKind() == Tree.Kind.TRY) {
                            gen.copyComments((Tree)statementTree, (Tree)newTry, true);
                            gen.copyComments((Tree)statementTree, (Tree)newTry, false);
                            if (statementTree.getKind() == Tree.Kind.TRY && (tt = (TryTree)statementTree).getFinallyBlock() != null) {
                                void var14_20;
                                BlockTree blockTree = newTry.getFinallyBlock();
                                if (blockTree == null) {
                                    TryTree tryTree = newTry;
                                }
                                gen.copyComments((Tree)tt.getFinallyBlock(), (Tree)var14_20, true);
                                gen.copyComments((Tree)tt.getFinallyBlock(), (Tree)var14_20, false);
                            }
                            TryTree tryTree = newTry;
                            state = 0;
                            break block12;
                        } else {
                            state = 1;
                            continue;
                        }
                    }
                    if (state == 1) {
                        state = toRemove.contains(statementTree) || statementTree.getKind() == Tree.Kind.TRY && ((TryTree)statementTree).getResources() != null && !((TryTree)statementTree).getResources().isEmpty() ? 2 : 0;
                        gen.copyComments((Tree)statementTree, (Tree)newTry, true);
                        gen.copyComments((Tree)statementTree, (Tree)newTry, false);
                        if (statementTree.getKind() == Tree.Kind.TRY && (tt = (TryTree)statementTree).getFinallyBlock() != null) {
                            void var14_23;
                            BlockTree blockTree = newTry.getFinallyBlock();
                            if (blockTree == null) {
                                TryTree tryTree = newTry;
                            }
                            gen.copyComments((Tree)tt.getFinallyBlock(), (Tree)var14_23, true);
                            gen.copyComments((Tree)tt.getFinallyBlock(), (Tree)var14_23, false);
                        }
                        TryTree tryTree = newTry;
                    } else if (state == 2) {
                        if (toRemove.contains(statementTree)) continue;
                        state = 0;
                        continue;
                    }
                }
                statements.add(var12_12);
            }
        }

        private static BlockTree rewriteFinallyBlock(TreeMaker tm, Collection<? extends TreePath> paths) {
            if (paths == null || paths.isEmpty()) {
                return null;
            }
            ArrayList<StatementTree> statements = new ArrayList<StatementTree>(paths.size());
            for (TreePath treePath : paths) {
                statements.add((StatementTree)treePath.getLeaf());
            }
            BlockTree result = tm.Block(statements, false);
            return result;
        }
    }
}

