/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.util.SourceLevelChecker;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupUISupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableSource;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableUISupport;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.UpdateType;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class EntityClassesPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(EntityClassesPanel.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JTextComponent packageComboBoxEditor;
    private PersistenceGenerator persistenceGen;
    private Project project;
    private String tableSourceName;
    private SelectedTables selectedTables;
    private final boolean puRequired;
    private final JMenuItem allToUpdateItem;
    private final JMenuItem allToRecreateItem;
    private JLabel classNamesLabel;
    private JScrollPane classNamesScrollPane;
    private JTable classNamesTable;
    private JCheckBox createPUCheckbox;
    private JLabel createPUWarningLabel;
    private JCheckBox generateFinderMethodsCheckBox;
    private JCheckBox generateJAXBCheckBox;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JCheckBox mappedSuperclassCheckBox;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JPanel spacerPanel;
    private JLabel specifyNamesLabel;
    private JButton tableActionsButton;
    private JPopupMenu tableActionsPopup;

    private EntityClassesPanel(boolean puRequired, boolean JAXBRequired) {
        this.puRequired = puRequired;
        this.initComponents();
        if (JAXBRequired) {
            this.generateJAXBCheckBox.setEnabled(false);
        }
        this.allToUpdateItem = this.tableActionsPopup.add(new AllToUpdateAction());
        this.allToRecreateItem = this.tableActionsPopup.add(new AllToRecreateAction());
        this.classNamesTable.getParent().setBackground(this.classNamesTable.getBackground());
        this.classNamesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.mappedSuperclassCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (EntityClassesPanel.this.mappedSuperclassCheckBox.isSelected()) {
                    EntityClassesPanel.this.generateFinderMethodsCheckBox.setEnabled(false);
                    EntityClassesPanel.this.generateFinderMethodsCheckBox.setSelected(false);
                } else {
                    EntityClassesPanel.this.generateFinderMethodsCheckBox.setEnabled(true);
                }
            }
        });
        this.packageComboBoxEditor = (JTextComponent)this.packageComboBox.getEditor().getEditorComponent();
        Document packageComboBoxDocument = this.packageComboBoxEditor.getDocument();
        packageComboBoxDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                EntityClassesPanel.this.packageChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EntityClassesPanel.this.packageChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EntityClassesPanel.this.packageChanged();
            }
        });
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    boolean isBeanValidationSupported() {
        if (this.project == null) {
            return false;
        }
        String notNullAnnotation = "javax.validation.constraints.NotNull";
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        if (groups == null || groups.length < 1) {
            return false;
        }
        SourceGroup firstGroup = groups[0];
        FileObject fo = firstGroup.getRootFolder();
        ClassPath compile = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
        if (compile == null) {
            return false;
        }
        return compile.findResource("javax.validation.constraints.NotNull".replace('.', '/') + ".class") != null;
    }

    public void initialize(PersistenceGenerator persistenceGen, Project project, FileObject targetFolder) {
        SourceGroup targetSourceGroup;
        this.persistenceGen = persistenceGen;
        this.project = project;
        this.projectTextField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        SourceGroup[] sourceGroups = SourceGroups.getJavaSourceGroups((Project)project);
        SourceGroupUISupport.connect(this.locationComboBox, sourceGroups);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.updatePackageComboBox();
        if (targetFolder != null && (targetSourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])sourceGroups, (FileObject)targetFolder)) != null) {
            this.locationComboBox.setSelectedItem(targetSourceGroup);
            String targetPackage = SourceGroups.getPackageForFolder((SourceGroup)targetSourceGroup, (FileObject)targetFolder);
            if (targetPackage != null) {
                this.packageComboBoxEditor.setText(targetPackage);
            }
        }
        Mnemonics.setLocalizedText((AbstractButton)this.generateFinderMethodsCheckBox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_GenerateNamedQueryAnnotations"));
        this.updatePersistenceUnitButton(true);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        SourceGroup firstGroup = groups[0];
        FileObject fo = firstGroup.getRootFolder();
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)fo);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement jc = controller.getElements().getTypeElement("javax.xml.bind.annotation.XmlTransient");
                    if (jc == null) {
                        EntityClassesPanel.this.generateJAXBCheckBox.setSelected(false);
                        EntityClassesPanel.this.generateJAXBCheckBox.setEnabled(false);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Fail to check if jaxb is supported");
        }
    }

    public void update(TableClosure tableClosure, String tableSourceName) {
        try {
            if (this.selectedTables == null) {
                this.selectedTables = new SelectedTables(this.persistenceGen, tableClosure, this.getLocationValue(), this.getPackageName());
                this.selectedTables.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent event) {
                        EntityClassesPanel.this.changeSupport.fireChange();
                    }
                });
            } else {
                this.selectedTables.setTableClosureAndTargetFolder(tableClosure, this.getLocationValue(), this.getPackageName());
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        TableUISupport.connectClassNames(this.classNamesTable, this.selectedTables);
        this.tableSourceName = tableSourceName;
        this.updateSetAllButtons();
    }

    public SelectedTables getSelectedTables() {
        return this.selectedTables;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackageName() {
        return this.packageComboBoxEditor.getText();
    }

    public boolean getGenerateMappedSuperclasses() {
        return this.mappedSuperclassCheckBox.isSelected();
    }

    public boolean getGenerateFinderMethods() {
        return this.generateFinderMethodsCheckBox.isSelected();
    }

    public boolean getGenerateJAXB() {
        return this.generateJAXBCheckBox.isSelected();
    }

    public boolean getGenerateValidationConstraints() {
        return this.isBeanValidationSupported();
    }

    public boolean getCreatePersistenceUnit() {
        return this.createPUCheckbox.isVisible() && this.createPUCheckbox.isSelected();
    }

    private void locationChanged() {
        this.updatePackageComboBox();
        this.updateSelectedTables();
        this.changeSupport.fireChange();
    }

    private void packageChanged() {
        this.updateSelectedTables();
        this.changeSupport.fireChange();
    }

    private void updatePackageComboBox() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel model = PackageView.createListView((SourceGroup)sourceGroup);
            if (model.getSelectedItem() != null && model.getSelectedItem().toString().startsWith("META-INF") && model.getSize() > 1) {
                model.setSelectedItem(model.getElementAt(1));
            }
            this.packageComboBox.setModel(model);
        }
    }

    private void updatePersistenceUnitButton(boolean initial) {
        String ver;
        Provider provider;
        String sourceLevel;
        String warning = " ";
        try {
            boolean canCreate;
            boolean showWarning = !ProviderUtil.persistenceExists(this.project, this.getLocationValue().getRootFolder());
            boolean isContainerManaged = Util.isContainerManaged(this.project);
            boolean bl = canCreate = isContainerManaged || ConnectionManager.getDefault().getConnections().length > 0;
            if (initial) {
                this.createPUCheckbox.setVisible(showWarning && canCreate);
                this.createPUCheckbox.setSelected(showWarning && canCreate);
                this.createPUCheckbox.setEnabled(!this.puRequired && canCreate);
            }
            if (showWarning && !this.createPUCheckbox.isSelected()) {
                warning = NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_NoPersistenceUnit");
            }
        }
        catch (InvalidPersistenceXmlException ipx) {
            this.createPUCheckbox.setVisible(false);
            warning = NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_InvalidPersistenceXml", (Object)ipx.getPath());
        }
        catch (RuntimeException ipx) {
            this.createPUCheckbox.setVisible(false);
            warning = NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_InvalidPersistenceXml", (Object)ipx.getMessage());
        }
        if (warning.trim().length() == 0 && this.getCreatePersistenceUnit() && (sourceLevel = SourceLevelChecker.getSourceLevel(this.project)) != null && sourceLevel.matches("1\\.[0-5]([^0-9].*)?") && (provider = Util.getPreferredProvider(this.project)) != null && (ver = ProviderUtil.getVersion(provider)) != null && !"1.0".equals(ver)) {
            warning = Util.isJPAVersionSupported(this.project, ver) ? NbBundle.getMessage(RelatedCMPWizard.class, (String)"ERR_WrongSourceLevel", (Object)sourceLevel) : NbBundle.getMessage(RelatedCMPWizard.class, (String)"ERR_UnsupportedJpaVersion", (Object)ver, (Object)Util.getJPAVersionSupported(this.project, ver));
        }
        if (warning.trim().length() > 0) {
            ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/persistence/ui/resources/warning.gif", (boolean)false);
            this.createPUWarningLabel.setIcon(icon);
            this.createPUWarningLabel.setText(warning);
            this.createPUWarningLabel.setToolTipText(warning);
        } else {
            this.createPUWarningLabel.setIcon(null);
            this.createPUWarningLabel.setText(" ");
            this.createPUWarningLabel.setToolTipText(null);
        }
    }

    private void updateSetAllButtons() {
        boolean update = false;
        boolean recreate = false;
        if (this.selectedTables != null) {
            for (Table table : this.selectedTables.getTables()) {
                if (this.selectedTables.getUpdateType(table).equals((Object)UpdateType.NEW)) continue;
                if (this.selectedTables.getUpdateType(table).equals((Object)UpdateType.UPDATE)) {
                    recreate = true;
                } else {
                    update = true;
                }
                if (!update || !recreate) continue;
                break;
            }
        }
        this.tableActionsButton.setEnabled(update || recreate);
        this.allToUpdateItem.setEnabled(update);
        this.allToRecreateItem.setEnabled(recreate);
    }

    private void updateSelectedTables() {
        if (this.selectedTables != null) {
            try {
                this.selectedTables.setTargetFolder(this.getLocationValue(), this.getPackageName());
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private void initComponents() {
        this.tableActionsPopup = new JPopupMenu();
        this.specifyNamesLabel = new JLabel();
        this.classNamesLabel = new JLabel();
        this.classNamesScrollPane = new JScrollPane();
        this.classNamesTable = new TableUISupport.ClassNamesTable();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.generateFinderMethodsCheckBox = new JCheckBox();
        this.mappedSuperclassCheckBox = new JCheckBox();
        this.spacerPanel = new JPanel();
        this.tableActionsButton = new JButton();
        this.createPUWarningLabel = new ShyLabel();
        this.createPUCheckbox = new JCheckBox();
        this.generateJAXBCheckBox = new JCheckBox();
        this.tableActionsPopup.setInvoker(this.tableActionsButton);
        this.setName(NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_EntityClasses"));
        Mnemonics.setLocalizedText((JLabel)this.specifyNamesLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_SpecifyEntityClassNames"));
        Mnemonics.setLocalizedText((JLabel)this.classNamesLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_ClassNames"));
        this.classNamesScrollPane.setMinimumSize(new Dimension(23, 80));
        this.classNamesScrollPane.setViewportView(this.classNamesTable);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityClassesPanel.this.locationComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        this.generateFinderMethodsCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateFinderMethodsCheckBox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_GenerateFinderMethods"));
        this.generateFinderMethodsCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        Mnemonics.setLocalizedText((AbstractButton)this.mappedSuperclassCheckBox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_GenerateMappedSuperclass"));
        this.mappedSuperclassCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.spacerPanel.setPreferredSize(new Dimension(377, 24));
        Mnemonics.setLocalizedText((AbstractButton)this.tableActionsButton, (String)"...");
        this.tableActionsButton.setMaximumSize(new Dimension(24, 24));
        this.tableActionsButton.setMinimumSize(new Dimension(24, 24));
        this.tableActionsButton.setPreferredSize(new Dimension(24, 24));
        this.tableActionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityClassesPanel.this.tableActionsButtonActionPerformed(evt);
            }
        });
        GroupLayout spacerPanelLayout = new GroupLayout(this.spacerPanel);
        this.spacerPanel.setLayout(spacerPanelLayout);
        spacerPanelLayout.setHorizontalGroup(spacerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, spacerPanelLayout.createSequentialGroup().addContainerGap(404, Short.MAX_VALUE).addComponent(this.tableActionsButton, -2, 24, -2)));
        spacerPanelLayout.setVerticalGroup(spacerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spacerPanelLayout.createSequentialGroup().addComponent(this.tableActionsButton, -2, 20, -2).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((JLabel)this.createPUWarningLabel, (String)"  ");
        this.createPUWarningLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createPUWarningLabel.setMaximumSize(new Dimension(1000, 29));
        this.createPUCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createPUCheckbox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_CreatePersistenceUnit"));
        this.createPUCheckbox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createPUCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EntityClassesPanel.this.createPUCheckboxItemStateChanged(evt);
            }
        });
        this.generateJAXBCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateJAXBCheckBox, (String)NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_GenerateJAXBAnnotations"));
        this.generateJAXBCheckBox.setToolTipText(NbBundle.getMessage(EntityClassesPanel.class, (String)"TXT_ToolTipJAXB"));
        this.generateJAXBCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classNamesLabel).addComponent(this.projectLabel).addComponent(this.locationLabel).addComponent(this.packageLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spacerPanel, -1, 458, Short.MAX_VALUE).addComponent(this.packageComboBox, 0, 428, Short.MAX_VALUE).addComponent(this.locationComboBox, 0, 428, Short.MAX_VALUE).addComponent(this.projectTextField, GroupLayout.Alignment.TRAILING, -1, 428, Short.MAX_VALUE).addComponent(this.classNamesScrollPane, -1, 428, Short.MAX_VALUE))).addComponent(this.createPUWarningLabel, -1, 540, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.specifyNamesLabel).addComponent(this.generateJAXBCheckBox).addComponent(this.generateFinderMethodsCheckBox).addComponent(this.createPUCheckbox).addComponent(this.mappedSuperclassCheckBox)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.specifyNamesLabel).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classNamesLabel).addComponent(this.classNamesScrollPane, -1, 80, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spacerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectTextField, -2, -1, -2).addComponent(this.projectLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationComboBox, -2, -1, -2).addComponent(this.locationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageComboBox, -2, -1, -2).addComponent(this.packageLabel)).addGap(21, 21, 21).addComponent(this.generateFinderMethodsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateJAXBCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mappedSuperclassCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createPUCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createPUWarningLabel, -2, 16, -2).addContainerGap()));
    }

    private void locationComboBoxActionPerformed(ActionEvent evt) {
        this.locationChanged();
    }

    private void createPUCheckboxItemStateChanged(ItemEvent evt) {
        if (!this.createPUCheckbox.isVisible() || this.createPUCheckbox.isSelected()) {
            // empty if block
        }
        this.updatePersistenceUnitButton(false);
    }

    private void tableActionsButtonActionPerformed(ActionEvent evt) {
        Component component = (Component)evt.getSource();
        Point loc = component.getLocationOnScreen();
        loc.y += component.getHeight() / 2;
        loc.x += component.getWidth() / 2;
        this.tableActionsPopup.setLocation(loc);
        this.tableActionsPopup.setVisible(true);
    }

    private class AllToRecreateAction
    extends AbstractAction {
        public AllToRecreateAction() {
            super(NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_RecreateAction"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Table table : EntityClassesPanel.this.selectedTables.getTables()) {
                if (!UpdateType.UPDATE.equals((Object)EntityClassesPanel.this.selectedTables.getUpdateType(table))) continue;
                EntityClassesPanel.this.selectedTables.setUpdateType(table, UpdateType.RECREATE);
            }
            TableUISupport.connectClassNames(EntityClassesPanel.this.classNamesTable, EntityClassesPanel.this.selectedTables);
            EntityClassesPanel.this.updateSetAllButtons();
        }
    }

    private class AllToUpdateAction
    extends AbstractAction {
        public AllToUpdateAction() {
            super(NbBundle.getMessage(EntityClassesPanel.class, (String)"LBL_UpdateAction"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Table table : EntityClassesPanel.this.selectedTables.getTables()) {
                if (!UpdateType.RECREATE.equals((Object)EntityClassesPanel.this.selectedTables.getUpdateType(table))) continue;
                EntityClassesPanel.this.selectedTables.setUpdateType(table, UpdateType.UPDATE);
            }
            TableUISupport.connectClassNames(EntityClassesPanel.this.classNamesTable, EntityClassesPanel.this.selectedTables);
            EntityClassesPanel.this.updateSetAllButtons();
        }
    }

    private static final class ShyLabel
    extends JLabel {
        private ShyLabel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = 0;
            return size;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            size.width = 0;
            return size;
        }
    }

    public static final class WizardPanel
    implements WizardDescriptor.Panel,
    WizardDescriptor.FinishablePanel,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private EntityClassesPanel component;
        private boolean componentInitialized;
        private WizardDescriptor wizardDescriptor;
        private Project project;
        private boolean puRequired;
        private boolean JAXBRequired;
        private boolean isFinishable;
        private List<Provider> providers;

        public WizardPanel() {
            this(false);
        }

        public WizardPanel(boolean persistenceUnitRequired, boolean JAXBRequired, boolean isFinishable) {
            this.puRequired = persistenceUnitRequired;
            this.JAXBRequired = JAXBRequired;
            this.isFinishable = isFinishable;
        }

        public WizardPanel(boolean persistenceUnitRequired, boolean JAXBRequired) {
            this(persistenceUnitRequired, JAXBRequired, true);
        }

        public WizardPanel(boolean persistenceUnitRequired) {
            this(persistenceUnitRequired, false, true);
        }

        public EntityClassesPanel getComponent() {
            if (this.component == null) {
                this.component = new EntityClassesPanel(this.puRequired, this.JAXBRequired);
                this.component.addChangeListener(this);
            }
            return this.component;
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public HelpCtx getHelp() {
            return new HelpCtx(EntityClassesPanel.class);
        }

        public void readSettings(Object settings) {
            TableSource.Type tableSourceType;
            this.wizardDescriptor = (WizardDescriptor)settings;
            RelatedCMPHelper helper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
            if (!this.componentInitialized) {
                this.componentInitialized = true;
                PersistenceGenerator persistenceGen = helper.getPersistenceGenerator();
                this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
                FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
                this.getComponent().initialize(persistenceGen, this.project, targetFolder);
            }
            TableSource tableSource = helper.getTableSource();
            String tableSourceName = null;
            if (tableSource != null && ((tableSourceType = tableSource.getType()) == TableSource.Type.DATA_SOURCE || tableSourceType == TableSource.Type.CONNECTION)) {
                tableSourceName = tableSource.getName();
            }
            this.getComponent().update(helper.getTableClosure(), tableSourceName);
        }

        public boolean isValid() {
            String problem;
            SelectedTables selectedTables;
            SourceGroup sourceGroup = this.getComponent().getLocationValue();
            if (sourceGroup == null) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_SelectSourceGroup"));
                return false;
            }
            String packageName = this.getComponent().getPackageName();
            if (packageName.trim().equals("")) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_CantUseDefaultPackage"));
                return false;
            }
            if (!JavaIdentifiers.isValidPackageName((String)packageName)) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_InvalidPackage"));
                return false;
            }
            if (!SourceGroups.isFolderWritable((SourceGroup)sourceGroup, (String)packageName)) {
                this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_JavaTargetChooser_UnwritablePackage"));
                return false;
            }
            ClassPath classPath = null;
            try {
                FileObject packageFO = SourceGroups.getFolderForPackage((SourceGroup)sourceGroup, (String)packageName, (boolean)false);
                if (packageFO == null) {
                    packageFO = sourceGroup.getRootFolder();
                }
                classPath = ClassPath.getClassPath((FileObject)packageFO, (String)"classpath/compile");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
            if (classPath != null) {
                if (classPath.findResource("javax/persistence/EntityManager.class") == null) {
                    if (this.providers == null) {
                        this.providers = PersistenceLibrarySupport.getProvidersFromLibraries();
                    }
                    if (this.providers.size() == 0) {
                        this.setErrorMessage(NbBundle.getMessage(EntityClassesPanel.class, (String)"ERR_NoJavaPersistenceAPI"));
                        return false;
                    }
                }
            } else {
                LOGGER.warning("Cannot get a classpath for package " + packageName + " in " + sourceGroup);
            }
            if ((selectedTables = this.getComponent().getSelectedTables()) != null && (problem = selectedTables.getFirstProblemDisplayName()) != null) {
                this.setErrorMessage(problem);
                return false;
            }
            this.setErrorMessage(" ");
            return true;
        }

        public void storeSettings(Object settings) {
            RelatedCMPHelper helper = RelatedCMPWizard.getHelper(this.wizardDescriptor);
            helper.setSelectedTables(this.getComponent().getSelectedTables());
            helper.setLocation(this.getComponent().getLocationValue());
            helper.setPackageName(this.getComponent().getPackageName());
            helper.setGenerateMappedSuperclasses(this.getComponent().getGenerateMappedSuperclasses());
            helper.setGenerateFinderMethods(this.getComponent().getGenerateFinderMethods());
            helper.setGenerateJAXBAnnotations(this.getComponent().getGenerateJAXB());
            helper.setGenerateValidationConstraints(this.getComponent().getGenerateValidationConstraints());
            helper.setCreatePU(this.getComponent().getCreatePersistenceUnit());
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.changeSupport.fireChange();
        }

        private void setErrorMessage(String errorMessage) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        }

        public boolean isFinishPanel() {
            return this.isFinishable;
        }
    }
}

