/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.IOException;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.service.connector.MsgBuffer;
import org.apache.tomcat.service.connector.MsgConnector;

public class Ajp13ConnectorResponse
extends ResponseImpl {
    public static final int MAX_SEND_SIZE = 8184;
    public static final byte JK_AJP13_SEND_BODY_CHUNK = 3;
    public static final byte JK_AJP13_SEND_HEADERS = 4;
    public static final byte JK_AJP13_END_RESPONSE = 5;
    public static final int SC_RESP_CONTENT_TYPE = 40961;
    public static final int SC_RESP_CONTENT_LANGUAGE = 40962;
    public static final int SC_RESP_CONTENT_LENGTH = 40963;
    public static final int SC_RESP_DATE = 40964;
    public static final int SC_RESP_LAST_MODIFIED = 40965;
    public static final int SC_RESP_LOCATION = 40966;
    public static final int SC_RESP_SET_COOKIE = 40967;
    public static final int SC_RESP_SET_COOKIE2 = 40968;
    public static final int SC_RESP_SERVLET_ENGINE = 40969;
    public static final int SC_RESP_STATUS = 40970;
    public static final int SC_RESP_WWW_AUTHENTICATE = 40971;
    MsgConnector con;
    private boolean finished = false;

    public void endHeaders() throws IOException {
        super.endHeaders();
        if (this.request.getProtocol() == null) {
            return;
        }
        if (this.request.getContext() != null) {
            this.setHeader("Servlet-Engine", this.request.getContext().getEngineHeader());
        }
        MsgBuffer msg = this.con.getMsgBuffer();
        msg.reset();
        msg.appendByte((byte)4);
        msg.appendInt(this.getStatus());
        msg.appendString("");
        this.headers.removeHeader("Status");
        this.headers.removeHeader("Servlet-Engine");
        int numHeaders = this.headers.size();
        msg.appendInt(numHeaders);
        int i = 0;
        while (i < numHeaders) {
            String headerName = this.headers.getHeaderName(i);
            int sc = this.headerNameToSc(headerName);
            if (-1 != sc) {
                msg.appendInt(sc);
            } else {
                msg.appendString(headerName);
            }
            msg.appendString(this.headers.getHeader(i));
            ++i;
        }
        msg.end();
        this.con.send(msg);
    }

    public void finish() throws IOException {
        if (!this.finished) {
            super.finish();
            this.finished = true;
            MsgBuffer msg = this.con.getMsgBuffer();
            msg.reset();
            msg.appendByte((byte)5);
            msg.appendByte((byte)1);
            msg.end();
            this.con.send(msg);
        }
    }

    protected int headerNameToSc(String name) {
        switch (name.charAt(0)) {
            case 'C': 
            case 'c': {
                if (name.equalsIgnoreCase("Content-Type")) {
                    return 40961;
                }
                if (name.equalsIgnoreCase("Content-Language")) {
                    return 40962;
                }
                if (!name.equalsIgnoreCase("Content-Length")) break;
                return 40963;
            }
            case 'D': 
            case 'd': {
                if (!name.equalsIgnoreCase("Date")) break;
                return 40964;
            }
            case 'L': 
            case 'l': {
                if (name.equalsIgnoreCase("Last-Modified")) {
                    return 40965;
                }
                if (!name.equalsIgnoreCase("Location")) break;
                return 40966;
            }
            case 'S': 
            case 's': {
                if (name.equalsIgnoreCase("Set-Cookie")) {
                    return 40967;
                }
                if (!name.equalsIgnoreCase("Set-Cookie2")) break;
                return 40968;
            }
            case 'W': 
            case 'w': {
                if (!name.equalsIgnoreCase("WWW-Autheticate")) break;
                return 40971;
            }
        }
        return -1;
    }

    public void recycle() {
        super.recycle();
        this.finished = false;
    }

    public void setConnector(MsgConnector con) {
        this.con = con;
    }

    public void doWrite(byte[] b, int off, int len) throws IOException {
        int sent = 0;
        while (sent < len) {
            int to_send = len - sent;
            to_send = to_send > 8184 ? 8184 : to_send;
            MsgBuffer buf = this.con.getMsgBuffer();
            buf.reset();
            buf.appendByte((byte)3);
            buf.appendBytes(b, off + sent, to_send);
            this.con.send(buf);
            sent += to_send;
        }
    }
}

