/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.tomcat.service.JNIEndpointConnector;
import org.apache.tomcat.service.StartupThread;
import org.apache.tomcat.service.connector.JNIConnectionHandler;
import org.apache.tomcat.util.StringManager;

public class JNIEndpoint {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    JNIConnectionHandler handler;
    boolean running = false;

    public void setConnectionHandler(JNIConnectionHandler handler) {
        this.handler = handler;
    }

    public JNIConnectionHandler getConnectionHandler() {
        return this.handler;
    }

    public synchronized void startEndpoint() {
        System.out.println("Running ...");
        this.running = true;
        this.notify();
    }

    public synchronized void stopEndpoint() {
        this.running = false;
        this.notify();
    }

    public int startup(String cmdLine, String stdout, String stderr) {
        try {
            if (null != stdout) {
                System.setOut(new PrintStream(new FileOutputStream(stdout)));
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (null != stderr) {
                System.setErr(new PrintStream(new FileOutputStream(stderr)));
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            JNIEndpointConnector.setEndpoint(this);
            StartupThread startup = new StartupThread(cmdLine, this);
            startup.start();
            System.out.println("Starting up StartupThread");
            JNIEndpoint jNIEndpoint = this;
            synchronized (jNIEndpoint) {
                this.wait(60000L);
            }
            System.out.println("End waiting");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.running) {
            System.out.println("Running fine ");
            return 1;
        }
        System.out.println("Error - why doesn't run ??");
        return 0;
    }

    public int service(long s, long l) {
        if (this.running) {
            try {
                JNIConnectionHandler handler = this.getConnectionHandler();
                handler.processConnection(s, l);
                return 1;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return 0;
    }

    public void shutdown() {
        System.out.println("JNI In shutdown");
    }
}

