/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.launch;

import java.util.prefs.Preferences;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbPreferences;

public final class ShellOptions {
    public static final SpecificationVersion MIN_SPEC_VERSION = new SpecificationVersion("1.6");
    private static final String PREF_PLATFORM = "launchPlatformId";
    private static final String PREF_OPEN_CONSOLE = "openConsoleOnLaunch";
    private static final String PREF_REUSE_CONSOLES = "reuseDeadConsoles";
    private static final String PREF_HISTORY_LINES = "historyLines";
    private Preferences prefs;

    private Preferences prefs() {
        if (this.prefs != null) {
            return this.prefs;
        }
        this.prefs = NbPreferences.forModule(ShellOptions.class);
        return this.prefs;
    }

    public int getHistoryLines() {
        return this.prefs().getInt(PREF_HISTORY_LINES, 50);
    }

    public void setHistoryLines(int val) {
        this.prefs().putInt(PREF_HISTORY_LINES, val);
    }

    public void setOpenConsole(boolean open) {
        this.prefs().putBoolean(PREF_OPEN_CONSOLE, open);
    }

    public void setReuseDeadConsoles(boolean reuse) {
        this.prefs().putBoolean(PREF_REUSE_CONSOLES, reuse);
    }

    public boolean isOpenConsole() {
        return this.prefs().getBoolean(PREF_OPEN_CONSOLE, false);
    }

    public boolean isReuseDeadConsoles() {
        return this.prefs().getBoolean(PREF_REUSE_CONSOLES, true);
    }

    public boolean isPlatformSet() {
        return this.prefs().get(PREF_PLATFORM, null) != null;
    }

    public void setSelectedPlatform(JavaPlatform p) {
        this.prefs().put(PREF_PLATFORM, p.getDisplayName());
    }

    public boolean setSelectedPlatform(String name) {
        JavaPlatform[] candidates = JavaPlatformManager.getDefault().getPlatforms(name, null);
        if (candidates != null && candidates.length == 1) {
            this.prefs().put(PREF_PLATFORM, name);
            return true;
        }
        return false;
    }

    public JavaPlatform getSelectedPlatform() {
        String platformId = this.prefs().get(PREF_PLATFORM, null);
        if (platformId == null) {
            return this.getDefaultPlatform();
        }
        JavaPlatform[] candidates = JavaPlatformManager.getDefault().getPlatforms(platformId, null);
        if (candidates == null || candidates.length == 0) {
            return this.getDefaultPlatform();
        }
        return candidates[0];
    }

    public JavaPlatform getDefaultPlatform() {
        JavaPlatform check = JavaPlatform.getDefault();
        if (check.getSpecification().getVersion().compareTo((Object)MIN_SPEC_VERSION) >= 0) {
            return check;
        }
        JavaPlatform[] candidates = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("J2SE", MIN_SPEC_VERSION));
        return candidates == null || candidates.length == 0 ? null : candidates[0];
    }

    public static ShellOptions get() {
        return new ShellOptions();
    }

    public boolean accepts(JavaPlatform p) {
        return p.getSpecification().getVersion().compareTo((Object)MIN_SPEC_VERSION) >= 0;
    }
}

