/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.launch;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.java.api.common.ui.PlatformFilter;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.jshell.launch.JShellOptionsController;
import org.netbeans.modules.jshell.launch.ShellOptions;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JShellOptionsPanel
extends JPanel
implements ActionListener,
ItemListener {
    private ShellOptions options;
    private JShellOptionsController ctrl;
    private JButton btnManage;
    private JComboBox<String> cbPlatform;
    private JCheckBox chAutoOpen;
    private JCheckBox chReuseConsoles;
    private JSpinner historyLines;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private boolean disableUpdates;

    public JShellOptionsPanel(JShellOptionsController ctrl) {
        this.ctrl = ctrl;
        this.options = ShellOptions.get();
        this.initComponents();
        ComboBoxModel platforms = PlatformUiSupport.createPlatformComboBoxModel(null, Collections.singletonList(new PlatformFilter(){

            public boolean accept(JavaPlatform platform) {
                return JShellOptionsPanel.this.options.accepts(platform);
            }
        }));
        this.cbPlatform.setModel(platforms);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbPlatform = new JComboBox();
        this.btnManage = new JButton();
        this.chAutoOpen = new JCheckBox();
        this.chReuseConsoles = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.historyLines = new JSpinner();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(JShellOptionsPanel.class, (String)"JShellOptionsPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnManage, (String)NbBundle.getMessage(JShellOptionsPanel.class, (String)"JShellOptionsPanel.btnManage.text"));
        this.btnManage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JShellOptionsPanel.this.btnManageActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.chAutoOpen, (String)NbBundle.getMessage(JShellOptionsPanel.class, (String)"JShellOptionsPanel.chAutoOpen.text"));
        this.chReuseConsoles.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chReuseConsoles, (String)NbBundle.getMessage(JShellOptionsPanel.class, (String)"JShellOptionsPanel.chReuseConsoles.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(JShellOptionsPanel.class, (String)"JShellOptionsPanel.jLabel2.text"));
        this.historyLines.setModel(new SpinnerNumberModel((Number)50, Integer.valueOf(0), null, (Number)1));
        this.historyLines.setName("");
        this.historyLines.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JShellOptionsPanel.this.historyLinesStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPlatform, 0, 225, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.btnManage)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.chReuseConsoles).addComponent(this.chAutoOpen).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.historyLines))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbPlatform, -2, -1, -2).addComponent(this.btnManage)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chAutoOpen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chReuseConsoles).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.historyLines, -2, -1, -2)).addContainerGap(167, Short.MAX_VALUE)));
    }

    private void btnManageActionPerformed(ActionEvent evt) {
        JavaPlatform old = this.getSelectedPlatformObject();
        PlatformsCustomizer.showCustomizer(null);
        if (old == null && this.cbPlatform.getSelectedItem() == null && this.cbPlatform.getItemCount() > 0) {
            this.disableUpdates = true;
            this.setSelectedItem(this.options.getSelectedPlatform());
            if (this.cbPlatform.getSelectedItem() == null) {
                this.cbPlatform.setSelectedIndex(0);
            }
            this.disableUpdates = false;
        }
    }

    private void historyLinesStateChanged(ChangeEvent evt) {
        this.changed();
    }

    public boolean isChanged() {
        if (this.chReuseConsoles.isSelected() != this.options.isReuseDeadConsoles()) {
            return true;
        }
        if (this.chAutoOpen.isSelected() != this.options.isOpenConsole()) {
            return true;
        }
        if (this.getSelectedPlatformObject() != this.options.getSelectedPlatform()) {
            return true;
        }
        Object val = this.historyLines.getModel().getValue();
        if (!(val instanceof Integer)) {
            return true;
        }
        return ((Integer)val).intValue() != this.options.getHistoryLines();
    }

    private void setSelectedItem(JavaPlatform p) {
        if (p == null) {
            this.cbPlatform.setSelectedItem(null);
            return;
        }
        for (int i = 0; i < this.cbPlatform.getItemCount(); ++i) {
            String o = this.cbPlatform.getItemAt(i);
            JavaPlatform item = PlatformUiSupport.getPlatform((Object)o);
            if (!p.equals(item)) continue;
            this.cbPlatform.setSelectedIndex(i);
            return;
        }
        this.cbPlatform.setSelectedItem(null);
    }

    public void load() {
        this.disableUpdates = true;
        this.chReuseConsoles.setSelected(this.options.isReuseDeadConsoles());
        this.chAutoOpen.setSelected(this.options.isOpenConsole());
        this.setSelectedItem(this.options.getSelectedPlatform());
        this.historyLines.getModel().setValue(this.options.getHistoryLines());
        this.disableUpdates = false;
    }

    public void store() {
        Object val;
        if (this.chReuseConsoles.isSelected() != this.options.isReuseDeadConsoles()) {
            this.options.setReuseDeadConsoles(this.chReuseConsoles.isSelected());
        }
        if (this.chAutoOpen.isSelected() != this.options.isOpenConsole()) {
            this.options.setOpenConsole(this.chAutoOpen.isSelected());
        }
        if (this.getSelectedPlatformObject() != this.options.getSelectedPlatform()) {
            this.options.setSelectedPlatform(this.getSelectedPlatform());
        }
        if ((val = this.historyLines.getModel().getValue()) instanceof Integer && ((Integer)val).intValue() != this.options.getHistoryLines()) {
            this.options.setHistoryLines((Integer)val);
        }
    }

    private JavaPlatform getSelectedPlatformObject() {
        Object key = this.cbPlatform.getSelectedItem();
        return key == null ? null : PlatformUiSupport.getPlatform((Object)key);
    }

    private String getSelectedPlatform() {
        Object o = this.cbPlatform.getSelectedItem();
        return o == null ? null : o.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.changed();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.changed();
    }

    private void changed() {
        if (!this.disableUpdates) {
            this.ctrl.changed();
        }
    }

    public boolean valid() {
        if (this.cbPlatform.getSelectedItem() == null) {
            return this.options.getDefaultPlatform() == null;
        }
        return true;
    }
}

