/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.shaderc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.util.shaderc.ShadercSPVCBindingInfo;
import org.lwjgl.util.shaderc.ShadercSPVCCombinedImageSampler;
import org.lwjgl.util.shaderc.ShadercSPVCMSLResourceBinding;
import org.lwjgl.util.shaderc.ShadercSPVCResourceLocationInfo;
import org.lwjgl.util.shaderc.ShadercSPVCResourceTypeInfo;
import org.lwjgl.util.shaderc.ShadercSPVCWorkgroupSize;

public class ShadercSpvc {
    public static final int shaderc_spvc_decoration_specid = 0;
    public static final int shaderc_spvc_decoration_block = 1;
    public static final int shaderc_spvc_decoration_rowmajor = 2;
    public static final int shaderc_spvc_decoration_colmajor = 3;
    public static final int shaderc_spvc_decoration_arraystride = 4;
    public static final int shaderc_spvc_decoration_matrixstride = 5;
    public static final int shaderc_spvc_decoration_builtin = 6;
    public static final int shaderc_spvc_decoration_noperspective = 7;
    public static final int shaderc_spvc_decoration_flat = 8;
    public static final int shaderc_spvc_decoration_centroid = 9;
    public static final int shaderc_spvc_decoration_restrict = 10;
    public static final int shaderc_spvc_decoration_aliased = 11;
    public static final int shaderc_spvc_decoration_nonwritable = 12;
    public static final int shaderc_spvc_decoration_nonreadable = 13;
    public static final int shaderc_spvc_decoration_uniform = 14;
    public static final int shaderc_spvc_decoration_location = 15;
    public static final int shaderc_spvc_decoration_component = 16;
    public static final int shaderc_spvc_decoration_index = 17;
    public static final int shaderc_spvc_decoration_binding = 18;
    public static final int shaderc_spvc_decoration_descriptorset = 19;
    public static final int shaderc_spvc_decoration_offset = 20;
    public static final int shaderc_spvc_decoration_nocontraction = 21;
    public static final int shaderc_spvc_msl_platform_ios = 0;
    public static final int shaderc_spvc_msl_platform_macos = 1;
    public static final int shaderc_spvc_status_success = 0;
    public static final int shaderc_spvc_status_compilation_error = 1;
    public static final int shaderc_spvc_status_internal_error = 2;
    public static final int shaderc_spvc_status_validation_error = 3;
    public static final int shaderc_spvc_status_transformation_error = 4;
    public static final int shaderc_spvc_status_configuration_error = 5;
    public static final int shaderc_spvc_status_uninitialized_compiler_error = 6;
    public static final int shaderc_spvc_status_missing_context_error = 7;
    public static final int shaderc_spvc_status_invalid_out_param = 8;
    public static final int shaderc_spvc_execution_model_vertex = 0;
    public static final int shaderc_spvc_execution_model_fragment = 1;
    public static final int shaderc_spvc_execution_model_glcompute = 2;
    public static final int shaderc_spvc_execution_model_invalid = 3;
    public static final int shaderc_spvc_binding_type_uniform_buffer = 0;
    public static final int shaderc_spvc_binding_type_storage_buffer = 1;
    public static final int shaderc_spvc_binding_type_readonly_storage_buffer = 2;
    public static final int shaderc_spvc_binding_type_sampler = 3;
    public static final int shaderc_spvc_binding_type_sampled_texture = 4;
    public static final int shaderc_spvc_binding_type_storage_texture = 5;
    public static final int shaderc_spvc_texture_view_dimension_undefined = 0;
    public static final int shaderc_spvc_texture_view_dimension_e1D = 1;
    public static final int shaderc_spvc_texture_view_dimension_e2D = 2;
    public static final int shaderc_spvc_texture_view_dimension_e2D_array = 3;
    public static final int shaderc_spvc_texture_view_dimension_cube = 4;
    public static final int shaderc_spvc_texture_view_dimension_cube_array = 5;
    public static final int shaderc_spvc_texture_view_dimension_e3D = 6;
    public static final int shaderc_spvc_shaderc_spvc_texture_format_type_float = 0;
    public static final int shaderc_spvc_shaderc_spvc_texture_format_type_sint = 1;
    public static final int shaderc_spvc_shaderc_spvc_texture_format_type_uint = 2;
    public static final int shaderc_spvc_shaderc_spvc_texture_format_type_other = 3;
    public static final int shaderc_spvc_shaderc_spvc_shader_resource_uniform_buffers = 0;
    public static final int shaderc_spvc_shaderc_spvc_shader_resource_separate_images = 1;
    public static final int shaderc_spvc_shaderc_spvc_shader_resource_separate_samplers = 2;
    public static final int shaderc_spvc_shaderc_spvc_shader_resource_storage_buffers = 3;
    private static final SharedLibrary SHADERC = Library.loadNative(ShadercSpvc.class, (String)"org.lwjgl.shaderc", (String)((String)Configuration.SHADERC_SPVC_LIBRARY_NAME.get((Object)Platform.mapLibraryNameBundled((String)"shaderc_spvc"))), (boolean)true);

    protected ShadercSpvc() {
        throw new UnsupportedOperationException();
    }

    public static SharedLibrary getLibrary() {
        return SHADERC;
    }

    @NativeType(value="shaderc_spvc_context_t")
    public static long shaderc_spvc_context_create() {
        long __functionAddress = Functions.context_create;
        return JNI.invokeP((long)__functionAddress);
    }

    public static void shaderc_spvc_context_destroy(@NativeType(value="shaderc_spvc_context_t") long context) {
        long __functionAddress = Functions.context_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        JNI.invokePV((long)context, (long)__functionAddress);
    }

    public static long nshaderc_spvc_context_get_messages(long context) {
        long __functionAddress = Functions.context_get_messages;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePP((long)context, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String shaderc_spvc_context_get_messages(@NativeType(value="shaderc_spvc_context_t const") long context) {
        long __result = ShadercSpvc.nshaderc_spvc_context_get_messages(context);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static void shaderc_spvc_context_set_use_spvc_parser(@NativeType(value="shaderc_spvc_context_t") long context, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.context_set_use_spvc_parser;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        JNI.invokePV((long)context, (boolean)b, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_compile_options_t")
    public static long shaderc_spvc_compile_options_create() {
        long __functionAddress = Functions.compile_options_create;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_compile_options_t")
    public static long shaderc_spvc_compile_options_clone(@NativeType(value="shaderc_spvc_compile_options_t const") long options) {
        long __functionAddress = Functions.compile_options_clone;
        return JNI.invokePP((long)options, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_destroy(@NativeType(value="shaderc_spvc_compile_options_t") long options) {
        long __functionAddress = Functions.compile_options_destroy;
        JNI.invokePV((long)options, (long)__functionAddress);
    }

    public static void nshaderc_spvc_compile_options_set_entry_point(long options, long entry_point) {
        long __functionAddress = Functions.compile_options_set_entry_point;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePPV((long)options, (long)entry_point, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_entry_point(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="char const *") ByteBuffer entry_point) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)entry_point);
        }
        ShadercSpvc.nshaderc_spvc_compile_options_set_entry_point(options, MemoryUtil.memAddress((ByteBuffer)entry_point));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shaderc_spvc_compile_options_set_entry_point(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="char const *") CharSequence entry_point) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(entry_point, true);
            long entry_pointEncoded = stack.getPointerAddress();
            ShadercSpvc.nshaderc_spvc_compile_options_set_entry_point(options, entry_pointEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void shaderc_spvc_compile_options_set_remove_unused_variables(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_remove_unused_variables;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_robust_buffer_access_pass(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_robust_buffer_access_pass;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_emit_line_directives(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_emit_line_directives;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_source_env(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="shaderc_target_env") int env, @NativeType(value="shaderc_env_version") int version) {
        long __functionAddress = Functions.compile_options_set_source_env;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)env, (int)version, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_target_env(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="shaderc_target_env") int env, @NativeType(value="shaderc_env_version") int version) {
        long __functionAddress = Functions.compile_options_set_target_env;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)env, (int)version, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_vulkan_semantics(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_vulkan_semantics;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_separate_shader_objects(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_separate_shader_objects;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_flatten_ubo(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_flatten_ubo;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_glsl_language_version(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="uint32_t") int version) {
        long __functionAddress = Functions.compile_options_set_glsl_language_version;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)version, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_flatten_multidimensional_arrays(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_flatten_multidimensional_arrays;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_es(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_es;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_glsl_emit_push_constant_as_ubo(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_glsl_emit_push_constant_as_ubo;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_msl_language_version(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="uint32_t") int version) {
        long __functionAddress = Functions.compile_options_set_msl_language_version;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)version, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_msl_swizzle_texture_samples(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_msl_swizzle_texture_samples;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_msl_platform(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="shaderc_spvc_msl_platform") int platform) {
        long __functionAddress = Functions.compile_options_set_msl_platform;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)platform, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_msl_pad_fragment_output(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_msl_pad_fragment_output;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_msl_capture(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_msl_capture;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_msl_domain_lower_left(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_msl_domain_lower_left;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_msl_argument_buffers(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_msl_argument_buffers;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void nshaderc_spvc_compile_options_set_msl_discrete_descriptor_sets(long options, long descriptors, long num_descriptors) {
        long __functionAddress = Functions.compile_options_set_msl_discrete_descriptor_sets;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePPPV((long)options, (long)descriptors, (long)num_descriptors, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_msl_discrete_descriptor_sets(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="uint32_t const *") IntBuffer descriptors) {
        ShadercSpvc.nshaderc_spvc_compile_options_set_msl_discrete_descriptor_sets(options, MemoryUtil.memAddress((IntBuffer)descriptors), descriptors.remaining());
    }

    public static void shaderc_spvc_compile_options_set_msl_enable_point_size_builtin(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_msl_enable_point_size_builtin;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_msl_buffer_size_buffer_index(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="uint32_t") int index) {
        long __functionAddress = Functions.compile_options_set_msl_buffer_size_buffer_index;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)index, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_hlsl_shader_model(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="uint32_t") int model) {
        long __functionAddress = Functions.compile_options_set_hlsl_shader_model;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (int)model, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_hlsl_point_size_compat(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_hlsl_point_size_compat;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_hlsl_point_coord_compat(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_hlsl_point_coord_compat;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_fixup_clipspace(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_fixup_clipspace;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_flip_vert_y(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_flip_vert_y;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_validate(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_validate;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static void shaderc_spvc_compile_options_set_optimize(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="bool") boolean b) {
        long __functionAddress = Functions.compile_options_set_optimize;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        JNI.invokePV((long)options, (boolean)b, (long)__functionAddress);
    }

    public static long nshaderc_spvc_compile_options_set_for_fuzzing(long options, long data, long size) {
        long __functionAddress = Functions.compile_options_set_for_fuzzing;
        if (Checks.CHECKS) {
            Checks.check((long)options);
        }
        return JNI.invokePPPP((long)options, (long)data, (long)size, (long)__functionAddress);
    }

    @NativeType(value="size_t")
    public static long shaderc_spvc_compile_options_set_for_fuzzing(@NativeType(value="shaderc_spvc_compile_options_t") long options, @NativeType(value="uint8_t const *") ByteBuffer data) {
        return ShadercSpvc.nshaderc_spvc_compile_options_set_for_fuzzing(options, MemoryUtil.memAddress((ByteBuffer)data), data.remaining());
    }

    public static int nshaderc_spvc_initialize_for_glsl(long context, long source, long source_len, long options) {
        long __functionAddress = Functions.initialize_for_glsl;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.check((long)options);
        }
        return JNI.invokePPPPI((long)context, (long)source, (long)source_len, (long)options, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_initialize_for_glsl(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="uint32_t const *") IntBuffer source, @NativeType(value="shaderc_spvc_compile_options_t") long options) {
        return ShadercSpvc.nshaderc_spvc_initialize_for_glsl(context, MemoryUtil.memAddress((IntBuffer)source), source.remaining(), options);
    }

    public static int nshaderc_spvc_initialize_for_hlsl(long context, long source, long source_len, long options) {
        long __functionAddress = Functions.initialize_for_hlsl;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.check((long)options);
        }
        return JNI.invokePPPPI((long)context, (long)source, (long)source_len, (long)options, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_initialize_for_hlsl(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="uint32_t const *") IntBuffer source, @NativeType(value="shaderc_spvc_compile_options_t") long options) {
        return ShadercSpvc.nshaderc_spvc_initialize_for_hlsl(context, MemoryUtil.memAddress((IntBuffer)source), source.remaining(), options);
    }

    public static int nshaderc_spvc_initialize_for_msl(long context, long source, long source_len, long options) {
        long __functionAddress = Functions.initialize_for_msl;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.check((long)options);
        }
        return JNI.invokePPPPI((long)context, (long)source, (long)source_len, (long)options, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_initialize_for_msl(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="uint32_t const *") IntBuffer source, @NativeType(value="shaderc_spvc_compile_options_t") long options) {
        return ShadercSpvc.nshaderc_spvc_initialize_for_msl(context, MemoryUtil.memAddress((IntBuffer)source), source.remaining(), options);
    }

    public static int nshaderc_spvc_initialize_for_vulkan(long context, long source, long source_len, long options) {
        long __functionAddress = Functions.initialize_for_vulkan;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.check((long)options);
        }
        return JNI.invokePPPPI((long)context, (long)source, (long)source_len, (long)options, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_initialize_for_vulkan(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="uint32_t const *") IntBuffer source, @NativeType(value="shaderc_spvc_compile_options_t") long options) {
        return ShadercSpvc.nshaderc_spvc_initialize_for_vulkan(context, MemoryUtil.memAddress((IntBuffer)source), source.remaining(), options);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_compile_shader(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="shaderc_spvc_compilation_result_t") long result) {
        long __functionAddress = Functions.compile_shader;
        if (Checks.CHECKS) {
            Checks.check((long)context);
            Checks.check((long)result);
        }
        return JNI.invokePPI((long)context, (long)result, (long)__functionAddress);
    }

    public static int nshaderc_spvc_get_decoration(long context, int id, int decoration, long value) {
        long __functionAddress = Functions.get_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePPI((long)context, (int)id, (int)decoration, (long)value, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_get_decoration(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="uint32_t") int id, @NativeType(value="shaderc_spvc_decoration") int decoration, @NativeType(value="uint32_t *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, (int)1);
        }
        return ShadercSpvc.nshaderc_spvc_get_decoration(context, id, decoration, MemoryUtil.memAddress((IntBuffer)value));
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_unset_decoration(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="uint32_t") int id, @NativeType(value="shaderc_spvc_decoration") int decoration) {
        long __functionAddress = Functions.unset_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePI((long)context, (int)id, (int)decoration, (long)__functionAddress);
    }

    public static void nshaderc_spvc_set_name(long context, int id, long name) {
        long __functionAddress = Functions.set_name;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        JNI.invokePPV((long)context, (int)id, (long)name, (long)__functionAddress);
    }

    public static void shaderc_spvc_set_name(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="uint32_t") int id, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        ShadercSpvc.nshaderc_spvc_set_name(context, id, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shaderc_spvc_set_name(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="uint32_t") int id, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            ShadercSpvc.nshaderc_spvc_set_name(context, id, nameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void shaderc_spvc_build_combined_image_samplers(@NativeType(value="shaderc_spvc_context_t const") long context) {
        long __functionAddress = Functions.build_combined_image_samplers;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        JNI.invokePV((long)context, (long)__functionAddress);
    }

    public static void nshaderc_spvc_get_combined_image_samplers(long context, long samplers, long num_samplers) {
        long __functionAddress = Functions.get_combined_image_samplers;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        JNI.invokePPPV((long)context, (long)samplers, (long)num_samplers, (long)__functionAddress);
    }

    public static void shaderc_spvc_get_combined_image_samplers(@NativeType(value="shaderc_spvc_context_t const") long context, @Nullable @NativeType(value="shaderc_spvc_combined_image_sampler *") ShadercSPVCCombinedImageSampler samplers, @NativeType(value="size_t *") PointerBuffer num_samplers) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)num_samplers, (int)1);
        }
        ShadercSpvc.nshaderc_spvc_get_combined_image_samplers(context, MemoryUtil.memAddressSafe((Pointer)samplers), MemoryUtil.memAddress((CustomBuffer)num_samplers));
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_set_decoration(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="uint32_t") int id, @NativeType(value="shaderc_spvc_decoration") int decoration, @NativeType(value="uint32_t") int argument) {
        long __functionAddress = Functions.set_decoration;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePI((long)context, (int)id, (int)decoration, (int)argument, (long)__functionAddress);
    }

    public static native int nshaderc_spvc_add_msl_resource_binding(long var0, long var2, long var4);

    public static int nshaderc_spvc_add_msl_resource_binding(long context, long binding) {
        long __functionAddress = Functions.add_msl_resource_binding;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return ShadercSpvc.nshaderc_spvc_add_msl_resource_binding(context, binding, __functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_add_msl_resource_binding(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="shaderc_spvc_msl_resource_binding const") ShadercSPVCMSLResourceBinding binding) {
        return ShadercSpvc.nshaderc_spvc_add_msl_resource_binding(context, binding.address());
    }

    public static int nshaderc_spvc_get_workgroup_size(long context, long function_name, int execution_model, long workgroup_size) {
        long __functionAddress = Functions.get_workgroup_size;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePPPI((long)context, (long)function_name, (int)execution_model, (long)workgroup_size, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_get_workgroup_size(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="char const *") ByteBuffer function_name, @NativeType(value="shaderc_spvc_execution_model") int execution_model, @NativeType(value="shaderc_spvc_workgroup_size *") ShadercSPVCWorkgroupSize.Buffer workgroup_size) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)function_name);
            Checks.check((CustomBuffer)workgroup_size, (int)1);
        }
        return ShadercSpvc.nshaderc_spvc_get_workgroup_size(context, MemoryUtil.memAddress((ByteBuffer)function_name), execution_model, workgroup_size.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_get_workgroup_size(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="char const *") CharSequence function_name, @NativeType(value="shaderc_spvc_execution_model") int execution_model, @NativeType(value="shaderc_spvc_workgroup_size *") ShadercSPVCWorkgroupSize.Buffer workgroup_size) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)workgroup_size, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(function_name, true);
            long function_nameEncoded = stack.getPointerAddress();
            int n = ShadercSpvc.nshaderc_spvc_get_workgroup_size(context, function_nameEncoded, execution_model, workgroup_size.address());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nshaderc_spvc_needs_buffer_size_buffer(long context, long b) {
        long __functionAddress = Functions.needs_buffer_size_buffer;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePPI((long)context, (long)b, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_needs_buffer_size_buffer(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="bool *") ByteBuffer b) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)b, (int)1);
        }
        return ShadercSpvc.nshaderc_spvc_needs_buffer_size_buffer(context, MemoryUtil.memAddress((ByteBuffer)b));
    }

    public static int nshaderc_spvc_get_execution_model(long context, long execution_model) {
        long __functionAddress = Functions.get_execution_model;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePPI((long)context, (long)execution_model, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_get_execution_model(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="shaderc_spvc_execution_model *") IntBuffer execution_model) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)execution_model, (int)1);
        }
        return ShadercSpvc.nshaderc_spvc_get_execution_model(context, MemoryUtil.memAddress((IntBuffer)execution_model));
    }

    public static int nshaderc_spvc_get_push_constant_buffer_count(long context, long count) {
        long __functionAddress = Functions.get_push_constant_buffer_count;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePPI((long)context, (long)count, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_get_push_constant_buffer_count(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="size_t *") PointerBuffer count) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)count, (int)1);
        }
        return ShadercSpvc.nshaderc_spvc_get_push_constant_buffer_count(context, MemoryUtil.memAddress((CustomBuffer)count));
    }

    public static int nshaderc_spvc_get_binding_info(long context, int resource, int binding_type, long bindings, long binding_count) {
        long __functionAddress = Functions.get_binding_info;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePPPI((long)context, (int)resource, (int)binding_type, (long)bindings, (long)binding_count, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_get_binding_info(@NativeType(value="shaderc_spvc_context_t const") long context, @NativeType(value="shaderc_spvc_shader_resource") int resource, @NativeType(value="shaderc_spvc_binding_type") int binding_type, @Nullable @NativeType(value="shaderc_spvc_binding_info *") ShadercSPVCBindingInfo.Buffer bindings, @NativeType(value="size_t *") PointerBuffer binding_count) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)binding_count, (int)1);
            Checks.checkSafe((CustomBuffer)bindings, (long)binding_count.get(binding_count.position()));
        }
        return ShadercSpvc.nshaderc_spvc_get_binding_info(context, resource, binding_type, MemoryUtil.memAddressSafe((Pointer)bindings), MemoryUtil.memAddress((CustomBuffer)binding_count));
    }

    public static int nshaderc_spvc_get_input_stage_location_info(long context, long locations, long location_count) {
        long __functionAddress = Functions.get_input_stage_location_info;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePPPI((long)context, (long)locations, (long)location_count, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_get_input_stage_location_info(@NativeType(value="shaderc_spvc_context_t const") long context, @Nullable @NativeType(value="shaderc_spvc_resource_location_info *") ShadercSPVCResourceLocationInfo.Buffer locations, @NativeType(value="size_t *") PointerBuffer location_count) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)location_count, (int)1);
            Checks.checkSafe((CustomBuffer)locations, (long)location_count.get(location_count.position()));
        }
        return ShadercSpvc.nshaderc_spvc_get_input_stage_location_info(context, MemoryUtil.memAddressSafe((Pointer)locations), MemoryUtil.memAddress((CustomBuffer)location_count));
    }

    public static int nshaderc_spvc_get_output_stage_location_info(long context, long locations, long location_count) {
        long __functionAddress = Functions.get_output_stage_location_info;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePPPI((long)context, (long)locations, (long)location_count, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_get_output_stage_location_info(@NativeType(value="shaderc_spvc_context_t const") long context, @Nullable @NativeType(value="shaderc_spvc_resource_location_info *") ShadercSPVCResourceLocationInfo.Buffer locations, @NativeType(value="size_t *") PointerBuffer location_count) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)location_count, (int)1);
            Checks.checkSafe((CustomBuffer)locations, (long)location_count.get(location_count.position()));
        }
        return ShadercSpvc.nshaderc_spvc_get_output_stage_location_info(context, MemoryUtil.memAddressSafe((Pointer)locations), MemoryUtil.memAddress((CustomBuffer)location_count));
    }

    public static int nshaderc_spvc_get_output_stage_type_info(long context, long types, long type_count) {
        long __functionAddress = Functions.get_output_stage_type_info;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePPPI((long)context, (long)types, (long)type_count, (long)__functionAddress);
    }

    @NativeType(value="shaderc_spvc_status")
    public static int shaderc_spvc_get_output_stage_type_info(@NativeType(value="shaderc_spvc_context_t const") long context, @Nullable @NativeType(value="shaderc_spvc_resource_type_info *") ShadercSPVCResourceTypeInfo.Buffer types, @NativeType(value="size_t *") PointerBuffer type_count) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)type_count, (int)1);
            Checks.checkSafe((CustomBuffer)types, (long)type_count.get(type_count.position()));
        }
        return ShadercSpvc.nshaderc_spvc_get_output_stage_type_info(context, MemoryUtil.memAddressSafe((Pointer)types), MemoryUtil.memAddress((CustomBuffer)type_count));
    }

    @NativeType(value="shaderc_spvc_compilation_result_t")
    public static long shaderc_spvc_result_create() {
        long __functionAddress = Functions.result_create;
        return JNI.invokeP((long)__functionAddress);
    }

    public static void shaderc_spvc_result_destroy(@NativeType(value="shaderc_spvc_compilation_result_t") long result) {
        long __functionAddress = Functions.result_destroy;
        if (Checks.CHECKS) {
            Checks.check((long)result);
        }
        JNI.invokePV((long)result, (long)__functionAddress);
    }

    public static long nshaderc_spvc_result_get_string_output(long result) {
        long __functionAddress = Functions.result_get_string_output;
        if (Checks.CHECKS) {
            Checks.check((long)result);
        }
        return JNI.invokePP((long)result, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String shaderc_spvc_result_get_string_output(@NativeType(value="shaderc_spvc_compilation_result_t const") long result) {
        long __result = ShadercSpvc.nshaderc_spvc_result_get_string_output(result);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nshaderc_spvc_result_get_binary_output(long result) {
        long __functionAddress = Functions.result_get_binary_output;
        if (Checks.CHECKS) {
            Checks.check((long)result);
        }
        return JNI.invokePP((long)result, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public static IntBuffer shaderc_spvc_result_get_binary_output(@NativeType(value="shaderc_spvc_compilation_result_t const") long result) {
        long __result = ShadercSpvc.nshaderc_spvc_result_get_binary_output(result);
        return MemoryUtil.memIntBufferSafe((long)__result, (int)ShadercSpvc.shaderc_spvc_result_get_binary_length(result));
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public static IntBuffer shaderc_spvc_result_get_binary_output(@NativeType(value="shaderc_spvc_compilation_result_t const") long result, long length) {
        long __result = ShadercSpvc.nshaderc_spvc_result_get_binary_output(result);
        return MemoryUtil.memIntBufferSafe((long)__result, (int)((int)length));
    }

    @NativeType(value="uint32_t")
    public static int shaderc_spvc_result_get_binary_length(@NativeType(value="shaderc_spvc_compilation_result_t const") long result) {
        long __functionAddress = Functions.result_get_binary_length;
        if (Checks.CHECKS) {
            Checks.check((long)result);
        }
        return JNI.invokePI((long)result, (long)__functionAddress);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return SHADERC;
    }

    public static final class Functions {
        public static final long context_create = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_context_create");
        public static final long context_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_context_destroy");
        public static final long context_get_messages = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_context_get_messages");
        public static final long context_set_use_spvc_parser = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_context_set_use_spvc_parser");
        public static final long compile_options_create = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_create");
        public static final long compile_options_clone = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_clone");
        public static final long compile_options_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_destroy");
        public static final long compile_options_set_entry_point = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_entry_point");
        public static final long compile_options_set_remove_unused_variables = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_remove_unused_variables");
        public static final long compile_options_set_robust_buffer_access_pass = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_robust_buffer_access_pass");
        public static final long compile_options_set_emit_line_directives = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_emit_line_directives");
        public static final long compile_options_set_source_env = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_source_env");
        public static final long compile_options_set_target_env = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_target_env");
        public static final long compile_options_set_vulkan_semantics = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_vulkan_semantics");
        public static final long compile_options_set_separate_shader_objects = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_separate_shader_objects");
        public static final long compile_options_set_flatten_ubo = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_flatten_ubo");
        public static final long compile_options_set_glsl_language_version = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_glsl_language_version");
        public static final long compile_options_set_flatten_multidimensional_arrays = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_flatten_multidimensional_arrays");
        public static final long compile_options_set_es = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_es");
        public static final long compile_options_set_glsl_emit_push_constant_as_ubo = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_glsl_emit_push_constant_as_ubo");
        public static final long compile_options_set_msl_language_version = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_msl_language_version");
        public static final long compile_options_set_msl_swizzle_texture_samples = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_msl_swizzle_texture_samples");
        public static final long compile_options_set_msl_platform = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_msl_platform");
        public static final long compile_options_set_msl_pad_fragment_output = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_msl_pad_fragment_output");
        public static final long compile_options_set_msl_capture = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_msl_capture");
        public static final long compile_options_set_msl_domain_lower_left = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_msl_domain_lower_left");
        public static final long compile_options_set_msl_argument_buffers = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_msl_argument_buffers");
        public static final long compile_options_set_msl_discrete_descriptor_sets = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_msl_discrete_descriptor_sets");
        public static final long compile_options_set_msl_enable_point_size_builtin = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_msl_enable_point_size_builtin");
        public static final long compile_options_set_msl_buffer_size_buffer_index = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_msl_buffer_size_buffer_index");
        public static final long compile_options_set_hlsl_shader_model = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_hlsl_shader_model");
        public static final long compile_options_set_hlsl_point_size_compat = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_hlsl_point_size_compat");
        public static final long compile_options_set_hlsl_point_coord_compat = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_hlsl_point_coord_compat");
        public static final long compile_options_set_fixup_clipspace = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_fixup_clipspace");
        public static final long compile_options_set_flip_vert_y = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_flip_vert_y");
        public static final long compile_options_set_validate = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_validate");
        public static final long compile_options_set_optimize = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_optimize");
        public static final long compile_options_set_for_fuzzing = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_options_set_for_fuzzing");
        public static final long initialize_for_glsl = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_initialize_for_glsl");
        public static final long initialize_for_hlsl = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_initialize_for_hlsl");
        public static final long initialize_for_msl = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_initialize_for_msl");
        public static final long initialize_for_vulkan = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_initialize_for_vulkan");
        public static final long compile_shader = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_compile_shader");
        public static final long get_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_get_decoration");
        public static final long unset_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_unset_decoration");
        public static final long set_name = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_set_name");
        public static final long build_combined_image_samplers = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_build_combined_image_samplers");
        public static final long get_combined_image_samplers = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_get_combined_image_samplers");
        public static final long set_decoration = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_set_decoration");
        public static final long add_msl_resource_binding = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_add_msl_resource_binding");
        public static final long get_workgroup_size = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_get_workgroup_size");
        public static final long needs_buffer_size_buffer = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_needs_buffer_size_buffer");
        public static final long get_execution_model = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_get_execution_model");
        public static final long get_push_constant_buffer_count = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_get_push_constant_buffer_count");
        public static final long get_binding_info = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_get_binding_info");
        public static final long get_input_stage_location_info = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_get_input_stage_location_info");
        public static final long get_output_stage_location_info = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_get_output_stage_location_info");
        public static final long get_output_stage_type_info = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_get_output_stage_type_info");
        public static final long result_create = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_result_create");
        public static final long result_destroy = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_result_destroy");
        public static final long result_get_string_output = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_result_get_string_output");
        public static final long result_get_binary_output = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_result_get_binary_output");
        public static final long result_get_binary_length = APIUtil.apiGetFunctionAddress((FunctionProvider)ShadercSpvc.access$000(), (String)"shaderc_spvc_result_get_binary_length");

        private Functions() {
        }
    }
}

