/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_TEXTURE_DESC
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDRESSMODE;
    public static final int FILTERMODE;
    public static final int FLAGS;
    public static final int MAXANISOTROPY;
    public static final int MIPMAPFILTERMODE;
    public static final int MIPMAPLEVELBIAS;
    public static final int MINMIPMAPLEVELCLAMP;
    public static final int MAXMIPMAPLEVELCLAMP;
    public static final int BORDERCOLOR;
    public static final int RESERVED;

    public CUDA_TEXTURE_DESC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_TEXTURE_DESC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUaddress_mode[3]")
    public IntBuffer addressMode() {
        return CUDA_TEXTURE_DESC.naddressMode(this.address());
    }

    @NativeType(value="CUaddress_mode")
    public int addressMode(int index) {
        return CUDA_TEXTURE_DESC.naddressMode(this.address(), index);
    }

    @NativeType(value="CUfilter_mode")
    public int filterMode() {
        return CUDA_TEXTURE_DESC.nfilterMode(this.address());
    }

    @NativeType(value="unsigned int")
    public int flags() {
        return CUDA_TEXTURE_DESC.nflags(this.address());
    }

    @NativeType(value="unsigned int")
    public int maxAnisotropy() {
        return CUDA_TEXTURE_DESC.nmaxAnisotropy(this.address());
    }

    @NativeType(value="CUfilter_mode")
    public int mipmapFilterMode() {
        return CUDA_TEXTURE_DESC.nmipmapFilterMode(this.address());
    }

    public float mipmapLevelBias() {
        return CUDA_TEXTURE_DESC.nmipmapLevelBias(this.address());
    }

    public float minMipmapLevelClamp() {
        return CUDA_TEXTURE_DESC.nminMipmapLevelClamp(this.address());
    }

    public float maxMipmapLevelClamp() {
        return CUDA_TEXTURE_DESC.nmaxMipmapLevelClamp(this.address());
    }

    @NativeType(value="float[4]")
    public FloatBuffer borderColor() {
        return CUDA_TEXTURE_DESC.nborderColor(this.address());
    }

    public float borderColor(int index) {
        return CUDA_TEXTURE_DESC.nborderColor(this.address(), index);
    }

    @NativeType(value="int[12]")
    public IntBuffer reserved() {
        return CUDA_TEXTURE_DESC.nreserved(this.address());
    }

    public int reserved(int index) {
        return CUDA_TEXTURE_DESC.nreserved(this.address(), index);
    }

    public CUDA_TEXTURE_DESC addressMode(@NativeType(value="CUaddress_mode[3]") IntBuffer value) {
        CUDA_TEXTURE_DESC.naddressMode(this.address(), value);
        return this;
    }

    public CUDA_TEXTURE_DESC addressMode(int index, @NativeType(value="CUaddress_mode") int value) {
        CUDA_TEXTURE_DESC.naddressMode(this.address(), index, value);
        return this;
    }

    public CUDA_TEXTURE_DESC filterMode(@NativeType(value="CUfilter_mode") int value) {
        CUDA_TEXTURE_DESC.nfilterMode(this.address(), value);
        return this;
    }

    public CUDA_TEXTURE_DESC flags(@NativeType(value="unsigned int") int value) {
        CUDA_TEXTURE_DESC.nflags(this.address(), value);
        return this;
    }

    public CUDA_TEXTURE_DESC maxAnisotropy(@NativeType(value="unsigned int") int value) {
        CUDA_TEXTURE_DESC.nmaxAnisotropy(this.address(), value);
        return this;
    }

    public CUDA_TEXTURE_DESC mipmapFilterMode(@NativeType(value="CUfilter_mode") int value) {
        CUDA_TEXTURE_DESC.nmipmapFilterMode(this.address(), value);
        return this;
    }

    public CUDA_TEXTURE_DESC mipmapLevelBias(float value) {
        CUDA_TEXTURE_DESC.nmipmapLevelBias(this.address(), value);
        return this;
    }

    public CUDA_TEXTURE_DESC minMipmapLevelClamp(float value) {
        CUDA_TEXTURE_DESC.nminMipmapLevelClamp(this.address(), value);
        return this;
    }

    public CUDA_TEXTURE_DESC maxMipmapLevelClamp(float value) {
        CUDA_TEXTURE_DESC.nmaxMipmapLevelClamp(this.address(), value);
        return this;
    }

    public CUDA_TEXTURE_DESC borderColor(@NativeType(value="float[4]") FloatBuffer value) {
        CUDA_TEXTURE_DESC.nborderColor(this.address(), value);
        return this;
    }

    public CUDA_TEXTURE_DESC borderColor(int index, float value) {
        CUDA_TEXTURE_DESC.nborderColor(this.address(), index, value);
        return this;
    }

    public CUDA_TEXTURE_DESC reserved(@NativeType(value="int[12]") IntBuffer value) {
        CUDA_TEXTURE_DESC.nreserved(this.address(), value);
        return this;
    }

    public CUDA_TEXTURE_DESC reserved(int index, int value) {
        CUDA_TEXTURE_DESC.nreserved(this.address(), index, value);
        return this;
    }

    public CUDA_TEXTURE_DESC set(IntBuffer addressMode, int filterMode, int flags, int maxAnisotropy, int mipmapFilterMode, float mipmapLevelBias, float minMipmapLevelClamp, float maxMipmapLevelClamp, FloatBuffer borderColor, IntBuffer reserved) {
        this.addressMode(addressMode);
        this.filterMode(filterMode);
        this.flags(flags);
        this.maxAnisotropy(maxAnisotropy);
        this.mipmapFilterMode(mipmapFilterMode);
        this.mipmapLevelBias(mipmapLevelBias);
        this.minMipmapLevelClamp(minMipmapLevelClamp);
        this.maxMipmapLevelClamp(maxMipmapLevelClamp);
        this.borderColor(borderColor);
        this.reserved(reserved);
        return this;
    }

    public CUDA_TEXTURE_DESC set(CUDA_TEXTURE_DESC src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_TEXTURE_DESC malloc() {
        return (CUDA_TEXTURE_DESC)CUDA_TEXTURE_DESC.wrap(CUDA_TEXTURE_DESC.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUDA_TEXTURE_DESC calloc() {
        return (CUDA_TEXTURE_DESC)CUDA_TEXTURE_DESC.wrap(CUDA_TEXTURE_DESC.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUDA_TEXTURE_DESC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUDA_TEXTURE_DESC)CUDA_TEXTURE_DESC.wrap(CUDA_TEXTURE_DESC.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUDA_TEXTURE_DESC create(long address) {
        return (CUDA_TEXTURE_DESC)CUDA_TEXTURE_DESC.wrap(CUDA_TEXTURE_DESC.class, (long)address);
    }

    @Nullable
    public static CUDA_TEXTURE_DESC createSafe(long address) {
        return address == 0L ? null : (CUDA_TEXTURE_DESC)CUDA_TEXTURE_DESC.wrap(CUDA_TEXTURE_DESC.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUDA_TEXTURE_DESC.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUDA_TEXTURE_DESC.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUDA_TEXTURE_DESC.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_TEXTURE_DESC.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUDA_TEXTURE_DESC.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUDA_TEXTURE_DESC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUDA_TEXTURE_DESC.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CUDA_TEXTURE_DESC mallocStack() {
        return CUDA_TEXTURE_DESC.mallocStack(MemoryStack.stackGet());
    }

    public static CUDA_TEXTURE_DESC callocStack() {
        return CUDA_TEXTURE_DESC.callocStack(MemoryStack.stackGet());
    }

    public static CUDA_TEXTURE_DESC mallocStack(MemoryStack stack) {
        return (CUDA_TEXTURE_DESC)CUDA_TEXTURE_DESC.wrap(CUDA_TEXTURE_DESC.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUDA_TEXTURE_DESC callocStack(MemoryStack stack) {
        return (CUDA_TEXTURE_DESC)CUDA_TEXTURE_DESC.wrap(CUDA_TEXTURE_DESC.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CUDA_TEXTURE_DESC.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CUDA_TEXTURE_DESC.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_TEXTURE_DESC.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_TEXTURE_DESC.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static IntBuffer naddressMode(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)ADDRESSMODE), (int)3);
    }

    public static int naddressMode(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)ADDRESSMODE + Checks.check((int)index, (int)3) * 4L);
    }

    public static int nfilterMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)FILTERMODE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nmaxAnisotropy(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXANISOTROPY);
    }

    public static int nmipmapFilterMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIPMAPFILTERMODE);
    }

    public static float nmipmapLevelBias(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MIPMAPLEVELBIAS);
    }

    public static float nminMipmapLevelClamp(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MINMIPMAPLEVELCLAMP);
    }

    public static float nmaxMipmapLevelClamp(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXMIPMAPLEVELCLAMP);
    }

    public static FloatBuffer nborderColor(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)BORDERCOLOR), (int)4);
    }

    public static float nborderColor(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)BORDERCOLOR + Checks.check((int)index, (int)4) * 4L);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)RESERVED), (int)12);
    }

    public static int nreserved(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)RESERVED + Checks.check((int)index, (int)12) * 4L);
    }

    public static void naddressMode(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)ADDRESSMODE), (long)(value.remaining() * 4));
    }

    public static void naddressMode(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)ADDRESSMODE + Checks.check((int)index, (int)3) * 4L, value);
    }

    public static void nfilterMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FILTERMODE, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nmaxAnisotropy(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXANISOTROPY, value);
    }

    public static void nmipmapFilterMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIPMAPFILTERMODE, value);
    }

    public static void nmipmapLevelBias(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MIPMAPLEVELBIAS, value);
    }

    public static void nminMipmapLevelClamp(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MINMIPMAPLEVELCLAMP, value);
    }

    public static void nmaxMipmapLevelClamp(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MAXMIPMAPLEVELCLAMP, value);
    }

    public static void nborderColor(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)BORDERCOLOR), (long)(value.remaining() * 4));
    }

    public static void nborderColor(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)BORDERCOLOR + Checks.check((int)index, (int)4) * 4L, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)12);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)RESERVED), (long)(value.remaining() * 4));
    }

    public static void nreserved(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)RESERVED + Checks.check((int)index, (int)12) * 4L, value);
    }

    static {
        Struct.Layout layout = CUDA_TEXTURE_DESC.__struct((Struct.Member[])new Struct.Member[]{CUDA_TEXTURE_DESC.__array((int)4, (int)3), CUDA_TEXTURE_DESC.__member((int)4), CUDA_TEXTURE_DESC.__member((int)4), CUDA_TEXTURE_DESC.__member((int)4), CUDA_TEXTURE_DESC.__member((int)4), CUDA_TEXTURE_DESC.__member((int)4), CUDA_TEXTURE_DESC.__member((int)4), CUDA_TEXTURE_DESC.__member((int)4), CUDA_TEXTURE_DESC.__array((int)4, (int)4), CUDA_TEXTURE_DESC.__array((int)4, (int)12)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ADDRESSMODE = layout.offsetof(0);
        FILTERMODE = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        MAXANISOTROPY = layout.offsetof(3);
        MIPMAPFILTERMODE = layout.offsetof(4);
        MIPMAPLEVELBIAS = layout.offsetof(5);
        MINMIPMAPLEVELCLAMP = layout.offsetof(6);
        MAXMIPMAPLEVELCLAMP = layout.offsetof(7);
        BORDERCOLOR = layout.offsetof(8);
        RESERVED = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<CUDA_TEXTURE_DESC, Buffer>
    implements NativeResource {
        private static final CUDA_TEXTURE_DESC ELEMENT_FACTORY = CUDA_TEXTURE_DESC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUDA_TEXTURE_DESC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUaddress_mode[3]")
        public IntBuffer addressMode() {
            return CUDA_TEXTURE_DESC.naddressMode(this.address());
        }

        @NativeType(value="CUaddress_mode")
        public int addressMode(int index) {
            return CUDA_TEXTURE_DESC.naddressMode(this.address(), index);
        }

        @NativeType(value="CUfilter_mode")
        public int filterMode() {
            return CUDA_TEXTURE_DESC.nfilterMode(this.address());
        }

        @NativeType(value="unsigned int")
        public int flags() {
            return CUDA_TEXTURE_DESC.nflags(this.address());
        }

        @NativeType(value="unsigned int")
        public int maxAnisotropy() {
            return CUDA_TEXTURE_DESC.nmaxAnisotropy(this.address());
        }

        @NativeType(value="CUfilter_mode")
        public int mipmapFilterMode() {
            return CUDA_TEXTURE_DESC.nmipmapFilterMode(this.address());
        }

        public float mipmapLevelBias() {
            return CUDA_TEXTURE_DESC.nmipmapLevelBias(this.address());
        }

        public float minMipmapLevelClamp() {
            return CUDA_TEXTURE_DESC.nminMipmapLevelClamp(this.address());
        }

        public float maxMipmapLevelClamp() {
            return CUDA_TEXTURE_DESC.nmaxMipmapLevelClamp(this.address());
        }

        @NativeType(value="float[4]")
        public FloatBuffer borderColor() {
            return CUDA_TEXTURE_DESC.nborderColor(this.address());
        }

        public float borderColor(int index) {
            return CUDA_TEXTURE_DESC.nborderColor(this.address(), index);
        }

        @NativeType(value="int[12]")
        public IntBuffer reserved() {
            return CUDA_TEXTURE_DESC.nreserved(this.address());
        }

        public int reserved(int index) {
            return CUDA_TEXTURE_DESC.nreserved(this.address(), index);
        }

        public Buffer addressMode(@NativeType(value="CUaddress_mode[3]") IntBuffer value) {
            CUDA_TEXTURE_DESC.naddressMode(this.address(), value);
            return this;
        }

        public Buffer addressMode(int index, @NativeType(value="CUaddress_mode") int value) {
            CUDA_TEXTURE_DESC.naddressMode(this.address(), index, value);
            return this;
        }

        public Buffer filterMode(@NativeType(value="CUfilter_mode") int value) {
            CUDA_TEXTURE_DESC.nfilterMode(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="unsigned int") int value) {
            CUDA_TEXTURE_DESC.nflags(this.address(), value);
            return this;
        }

        public Buffer maxAnisotropy(@NativeType(value="unsigned int") int value) {
            CUDA_TEXTURE_DESC.nmaxAnisotropy(this.address(), value);
            return this;
        }

        public Buffer mipmapFilterMode(@NativeType(value="CUfilter_mode") int value) {
            CUDA_TEXTURE_DESC.nmipmapFilterMode(this.address(), value);
            return this;
        }

        public Buffer mipmapLevelBias(float value) {
            CUDA_TEXTURE_DESC.nmipmapLevelBias(this.address(), value);
            return this;
        }

        public Buffer minMipmapLevelClamp(float value) {
            CUDA_TEXTURE_DESC.nminMipmapLevelClamp(this.address(), value);
            return this;
        }

        public Buffer maxMipmapLevelClamp(float value) {
            CUDA_TEXTURE_DESC.nmaxMipmapLevelClamp(this.address(), value);
            return this;
        }

        public Buffer borderColor(@NativeType(value="float[4]") FloatBuffer value) {
            CUDA_TEXTURE_DESC.nborderColor(this.address(), value);
            return this;
        }

        public Buffer borderColor(int index, float value) {
            CUDA_TEXTURE_DESC.nborderColor(this.address(), index, value);
            return this;
        }

        public Buffer reserved(@NativeType(value="int[12]") IntBuffer value) {
            CUDA_TEXTURE_DESC.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, int value) {
            CUDA_TEXTURE_DESC.nreserved(this.address(), index, value);
            return this;
        }
    }
}

