/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU65;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CU70
extends CU65 {
    public static final long CU_STREAM_LEGACY = 1L;
    public static final long CU_STREAM_PER_THREAD = 2L;

    protected CU70() {
        throw new UnsupportedOperationException();
    }

    public static int ncuDevicePrimaryCtxRetain(long pctx, int dev) {
        long __functionAddress = Functions.DevicePrimaryCtxRetain;
        return JNI.callPI((long)pctx, (int)dev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDevicePrimaryCtxRetain(@NativeType(value="CUcontext *") PointerBuffer pctx, @NativeType(value="CUdevice") int dev) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pctx, (int)1);
        }
        return CU70.ncuDevicePrimaryCtxRetain(MemoryUtil.memAddress((CustomBuffer)pctx), dev);
    }

    @NativeType(value="CUresult")
    public static int cuDevicePrimaryCtxRelease(@NativeType(value="CUdevice") int dev) {
        long __functionAddress = Functions.DevicePrimaryCtxRelease;
        return JNI.callI((int)dev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDevicePrimaryCtxSetFlags(@NativeType(value="CUdevice") int dev, @NativeType(value="unsigned int") int flags) {
        long __functionAddress = Functions.DevicePrimaryCtxSetFlags;
        return JNI.callI((int)dev, (int)flags, (long)__functionAddress);
    }

    public static int ncuDevicePrimaryCtxGetState(int dev, long flags, long active) {
        long __functionAddress = Functions.DevicePrimaryCtxGetState;
        return JNI.callPPI((int)dev, (long)flags, (long)active, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDevicePrimaryCtxGetState(@NativeType(value="CUdevice") int dev, @NativeType(value="unsigned int *") IntBuffer flags, @NativeType(value="int *") IntBuffer active) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)flags, (int)1);
            Checks.check((Buffer)active, (int)1);
        }
        return CU70.ncuDevicePrimaryCtxGetState(dev, MemoryUtil.memAddress((IntBuffer)flags), MemoryUtil.memAddress((IntBuffer)active));
    }

    @NativeType(value="CUresult")
    public static int cuDevicePrimaryCtxReset(@NativeType(value="CUdevice") int dev) {
        long __functionAddress = Functions.DevicePrimaryCtxReset;
        return JNI.callI((int)dev, (long)__functionAddress);
    }

    public static int ncuCtxGetFlags(long flags) {
        long __functionAddress = Functions.CtxGetFlags;
        return JNI.callPI((long)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuCtxGetFlags(@NativeType(value="unsigned int *") IntBuffer flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)flags, (int)1);
        }
        return CU70.ncuCtxGetFlags(MemoryUtil.memAddress((IntBuffer)flags));
    }

    public static int ncuPointerGetAttributes(int numAttributes, long attributes, long data, long ptr) {
        long __functionAddress = Functions.PointerGetAttributes;
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        return JNI.callPPPI((int)numAttributes, (long)attributes, (long)data, (long)ptr, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuPointerGetAttributes(@NativeType(value="CUpointer_attribute *") IntBuffer attributes, @NativeType(value="void **") PointerBuffer data, @NativeType(value="CUdeviceptr") long ptr) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)data, (int)attributes.remaining());
        }
        return CU70.ncuPointerGetAttributes(attributes.remaining(), MemoryUtil.memAddress((IntBuffer)attributes), MemoryUtil.memAddress((CustomBuffer)data), ptr);
    }

    public static final class Functions {
        public static final long DevicePrimaryCtxRetain = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDevicePrimaryCtxRetain");
        public static final long DevicePrimaryCtxRelease = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDevicePrimaryCtxRelease");
        public static final long DevicePrimaryCtxSetFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDevicePrimaryCtxSetFlags");
        public static final long DevicePrimaryCtxGetState = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDevicePrimaryCtxGetState");
        public static final long DevicePrimaryCtxReset = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDevicePrimaryCtxReset");
        public static final long CtxGetFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuCtxGetFlags");
        public static final long PointerGetAttributes = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuPointerGetAttributes");

        private Functions() {
        }
    }
}

