/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorImageInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLER;
    public static final int IMAGEVIEW;
    public static final int IMAGELAYOUT;

    public VkDescriptorImageInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDescriptorImageInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkSampler")
    public long sampler() {
        return VkDescriptorImageInfo.nsampler(this.address());
    }

    @NativeType(value="VkImageView")
    public long imageView() {
        return VkDescriptorImageInfo.nimageView(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int imageLayout() {
        return VkDescriptorImageInfo.nimageLayout(this.address());
    }

    public VkDescriptorImageInfo sampler(@NativeType(value="VkSampler") long value) {
        VkDescriptorImageInfo.nsampler(this.address(), value);
        return this;
    }

    public VkDescriptorImageInfo imageView(@NativeType(value="VkImageView") long value) {
        VkDescriptorImageInfo.nimageView(this.address(), value);
        return this;
    }

    public VkDescriptorImageInfo imageLayout(@NativeType(value="VkImageLayout") int value) {
        VkDescriptorImageInfo.nimageLayout(this.address(), value);
        return this;
    }

    public VkDescriptorImageInfo set(long sampler, long imageView, int imageLayout) {
        this.sampler(sampler);
        this.imageView(imageView);
        this.imageLayout(imageLayout);
        return this;
    }

    public VkDescriptorImageInfo set(VkDescriptorImageInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDescriptorImageInfo malloc() {
        return (VkDescriptorImageInfo)VkDescriptorImageInfo.wrap(VkDescriptorImageInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDescriptorImageInfo calloc() {
        return (VkDescriptorImageInfo)VkDescriptorImageInfo.wrap(VkDescriptorImageInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDescriptorImageInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDescriptorImageInfo)VkDescriptorImageInfo.wrap(VkDescriptorImageInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDescriptorImageInfo create(long address) {
        return (VkDescriptorImageInfo)VkDescriptorImageInfo.wrap(VkDescriptorImageInfo.class, (long)address);
    }

    @Nullable
    public static VkDescriptorImageInfo createSafe(long address) {
        return address == 0L ? null : (VkDescriptorImageInfo)VkDescriptorImageInfo.wrap(VkDescriptorImageInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDescriptorImageInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDescriptorImageInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDescriptorImageInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorImageInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDescriptorImageInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDescriptorImageInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDescriptorImageInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDescriptorImageInfo mallocStack() {
        return VkDescriptorImageInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorImageInfo callocStack() {
        return VkDescriptorImageInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorImageInfo mallocStack(MemoryStack stack) {
        return (VkDescriptorImageInfo)VkDescriptorImageInfo.wrap(VkDescriptorImageInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorImageInfo callocStack(MemoryStack stack) {
        return (VkDescriptorImageInfo)VkDescriptorImageInfo.wrap(VkDescriptorImageInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorImageInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorImageInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDescriptorImageInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDescriptorImageInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nsampler(long struct) {
        return UNSAFE.getLong(null, struct + (long)SAMPLER);
    }

    public static long nimageView(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGEVIEW);
    }

    public static int nimageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGELAYOUT);
    }

    public static void nsampler(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SAMPLER, value);
    }

    public static void nimageView(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)IMAGEVIEW, value);
    }

    public static void nimageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGELAYOUT, value);
    }

    static {
        Struct.Layout layout = VkDescriptorImageInfo.__struct((Struct.Member[])new Struct.Member[]{VkDescriptorImageInfo.__member((int)8), VkDescriptorImageInfo.__member((int)8), VkDescriptorImageInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLER = layout.offsetof(0);
        IMAGEVIEW = layout.offsetof(1);
        IMAGELAYOUT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorImageInfo, Buffer>
    implements NativeResource {
        private static final VkDescriptorImageInfo ELEMENT_FACTORY = VkDescriptorImageInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDescriptorImageInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkSampler")
        public long sampler() {
            return VkDescriptorImageInfo.nsampler(this.address());
        }

        @NativeType(value="VkImageView")
        public long imageView() {
            return VkDescriptorImageInfo.nimageView(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int imageLayout() {
            return VkDescriptorImageInfo.nimageLayout(this.address());
        }

        public Buffer sampler(@NativeType(value="VkSampler") long value) {
            VkDescriptorImageInfo.nsampler(this.address(), value);
            return this;
        }

        public Buffer imageView(@NativeType(value="VkImageView") long value) {
            VkDescriptorImageInfo.nimageView(this.address(), value);
            return this;
        }

        public Buffer imageLayout(@NativeType(value="VkImageLayout") int value) {
            VkDescriptorImageInfo.nimageLayout(this.address(), value);
            return this;
        }
    }
}

