/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SIZE;
    public static final int USAGE;
    public static final int SHARINGMODE;
    public static final int QUEUEFAMILYINDEXCOUNT;
    public static final int PQUEUEFAMILYINDICES;

    public VkBufferCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBufferCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkBufferCreateFlags")
    public int flags() {
        return VkBufferCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkBufferCreateInfo.nsize(this.address());
    }

    @NativeType(value="VkBufferUsageFlags")
    public int usage() {
        return VkBufferCreateInfo.nusage(this.address());
    }

    @NativeType(value="VkSharingMode")
    public int sharingMode() {
        return VkBufferCreateInfo.nsharingMode(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndexCount() {
        return VkBufferCreateInfo.nqueueFamilyIndexCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pQueueFamilyIndices() {
        return VkBufferCreateInfo.npQueueFamilyIndices(this.address());
    }

    public VkBufferCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBufferCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkBufferCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo flags(@NativeType(value="VkBufferCreateFlags") int value) {
        VkBufferCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo size(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCreateInfo.nsize(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo usage(@NativeType(value="VkBufferUsageFlags") int value) {
        VkBufferCreateInfo.nusage(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo sharingMode(@NativeType(value="VkSharingMode") int value) {
        VkBufferCreateInfo.nsharingMode(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo pQueueFamilyIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkBufferCreateInfo.npQueueFamilyIndices(this.address(), value);
        return this;
    }

    public VkBufferCreateInfo set(int sType, long pNext, int flags, long size, int usage, int sharingMode, @Nullable IntBuffer pQueueFamilyIndices) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.size(size);
        this.usage(usage);
        this.sharingMode(sharingMode);
        this.pQueueFamilyIndices(pQueueFamilyIndices);
        return this;
    }

    public VkBufferCreateInfo set(VkBufferCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferCreateInfo malloc() {
        return (VkBufferCreateInfo)VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBufferCreateInfo calloc() {
        return (VkBufferCreateInfo)VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBufferCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBufferCreateInfo)VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBufferCreateInfo create(long address) {
        return (VkBufferCreateInfo)VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkBufferCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkBufferCreateInfo)VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBufferCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBufferCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBufferCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBufferCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBufferCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBufferCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBufferCreateInfo mallocStack() {
        return VkBufferCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkBufferCreateInfo callocStack() {
        return VkBufferCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkBufferCreateInfo mallocStack(MemoryStack stack) {
        return (VkBufferCreateInfo)VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferCreateInfo callocStack(MemoryStack stack) {
        return (VkBufferCreateInfo)VkBufferCreateInfo.wrap(VkBufferCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBufferCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBufferCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static int nusage(long struct) {
        return UNSAFE.getInt(null, struct + (long)USAGE);
    }

    public static int nsharingMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHARINGMODE);
    }

    public static int nqueueFamilyIndexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEFAMILYINDEXCOUNT);
    }

    @Nullable
    public static IntBuffer npQueueFamilyIndices(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PQUEUEFAMILYINDICES)), (int)VkBufferCreateInfo.nqueueFamilyIndexCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    public static void nusage(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)USAGE, value);
    }

    public static void nsharingMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHARINGMODE, value);
    }

    public static void nqueueFamilyIndexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUEFAMILYINDEXCOUNT, value);
    }

    public static void npQueueFamilyIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PQUEUEFAMILYINDICES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkBufferCreateInfo.nqueueFamilyIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkBufferCreateInfo.nqueueFamilyIndexCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PQUEUEFAMILYINDICES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkBufferCreateInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkBufferCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkBufferCreateInfo.__member((int)4), VkBufferCreateInfo.__member((int)POINTER_SIZE), VkBufferCreateInfo.__member((int)4), VkBufferCreateInfo.__member((int)8), VkBufferCreateInfo.__member((int)4), VkBufferCreateInfo.__member((int)4), VkBufferCreateInfo.__member((int)4), VkBufferCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SIZE = layout.offsetof(3);
        USAGE = layout.offsetof(4);
        SHARINGMODE = layout.offsetof(5);
        QUEUEFAMILYINDEXCOUNT = layout.offsetof(6);
        PQUEUEFAMILYINDICES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkBufferCreateInfo, Buffer>
    implements NativeResource {
        private static final VkBufferCreateInfo ELEMENT_FACTORY = VkBufferCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBufferCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkBufferCreateFlags")
        public int flags() {
            return VkBufferCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkBufferCreateInfo.nsize(this.address());
        }

        @NativeType(value="VkBufferUsageFlags")
        public int usage() {
            return VkBufferCreateInfo.nusage(this.address());
        }

        @NativeType(value="VkSharingMode")
        public int sharingMode() {
            return VkBufferCreateInfo.nsharingMode(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndexCount() {
            return VkBufferCreateInfo.nqueueFamilyIndexCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pQueueFamilyIndices() {
            return VkBufferCreateInfo.npQueueFamilyIndices(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkBufferCreateFlags") int value) {
            VkBufferCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCreateInfo.nsize(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="VkBufferUsageFlags") int value) {
            VkBufferCreateInfo.nusage(this.address(), value);
            return this;
        }

        public Buffer sharingMode(@NativeType(value="VkSharingMode") int value) {
            VkBufferCreateInfo.nsharingMode(this.address(), value);
            return this;
        }

        public Buffer pQueueFamilyIndices(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkBufferCreateInfo.npQueueFamilyIndices(this.address(), value);
            return this;
        }
    }
}

