/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.util.Map;
import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkDevice;

public class AMDDisplayNativeHdr {
    public static final int VK_AMD_DISPLAY_NATIVE_HDR_SPEC_VERSION = 1;
    public static final String VK_AMD_DISPLAY_NATIVE_HDR_EXTENSION_NAME = "VK_AMD_display_native_hdr";
    public static final int VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD = 1000213000;
    public static final int VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD = 1000213001;
    public static final int VK_COLOR_SPACE_DISPLAY_NATIVE_AMD = 1000213000;

    protected AMDDisplayNativeHdr() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsDevice(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_AMD_DISPLAY_NATIVE_HDR_EXTENSION_NAME) && VK.checkExtension(VK_AMD_DISPLAY_NATIVE_HDR_EXTENSION_NAME, VK.isSupported(provider, "vkSetLocalDimmingAMD", caps));
    }

    public static void vkSetLocalDimmingAMD(VkDevice device, @NativeType(value="VkSwapchainKHR") long swapChain, @NativeType(value="VkBool32") boolean localDimmingEnable) {
        long __functionAddress = device.getCapabilities().vkSetLocalDimmingAMD;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJV((long)device.address(), (long)swapChain, (int)(localDimmingEnable ? 1 : 0), (long)__functionAddress);
    }
}

