/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXSourceLocation
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR_DATA;
    public static final int INT_DATA;

    public CXSourceLocation(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXSourceLocation.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *[2]")
    public PointerBuffer ptr_data() {
        return CXSourceLocation.nptr_data(this.address());
    }

    @NativeType(value="void const *")
    public long ptr_data(int index) {
        return CXSourceLocation.nptr_data(this.address(), index);
    }

    @NativeType(value="unsigned")
    public int int_data() {
        return CXSourceLocation.nint_data(this.address());
    }

    public static CXSourceLocation malloc() {
        return (CXSourceLocation)CXSourceLocation.wrap(CXSourceLocation.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXSourceLocation calloc() {
        return (CXSourceLocation)CXSourceLocation.wrap(CXSourceLocation.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXSourceLocation create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXSourceLocation)CXSourceLocation.wrap(CXSourceLocation.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXSourceLocation create(long address) {
        return (CXSourceLocation)CXSourceLocation.wrap(CXSourceLocation.class, (long)address);
    }

    @Nullable
    public static CXSourceLocation createSafe(long address) {
        return address == 0L ? null : (CXSourceLocation)CXSourceLocation.wrap(CXSourceLocation.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXSourceLocation.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXSourceLocation.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXSourceLocation.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXSourceLocation.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXSourceLocation.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXSourceLocation.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXSourceLocation.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXSourceLocation mallocStack() {
        return CXSourceLocation.mallocStack(MemoryStack.stackGet());
    }

    public static CXSourceLocation callocStack() {
        return CXSourceLocation.callocStack(MemoryStack.stackGet());
    }

    public static CXSourceLocation mallocStack(MemoryStack stack) {
        return (CXSourceLocation)CXSourceLocation.wrap(CXSourceLocation.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXSourceLocation callocStack(MemoryStack stack) {
        return (CXSourceLocation)CXSourceLocation.wrap(CXSourceLocation.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXSourceLocation.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXSourceLocation.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXSourceLocation.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXSourceLocation.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static PointerBuffer nptr_data(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)PTR_DATA), (int)2);
    }

    public static long nptr_data(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PTR_DATA + Checks.check((int)index, (int)2) * (long)POINTER_SIZE));
    }

    public static int nint_data(long struct) {
        return UNSAFE.getInt(null, struct + (long)INT_DATA);
    }

    static {
        Struct.Layout layout = CXSourceLocation.__struct((Struct.Member[])new Struct.Member[]{CXSourceLocation.__array((int)POINTER_SIZE, (int)2), CXSourceLocation.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR_DATA = layout.offsetof(0);
        INT_DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXSourceLocation, Buffer>
    implements NativeResource {
        private static final CXSourceLocation ELEMENT_FACTORY = CXSourceLocation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXSourceLocation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *[2]")
        public PointerBuffer ptr_data() {
            return CXSourceLocation.nptr_data(this.address());
        }

        @NativeType(value="void const *")
        public long ptr_data(int index) {
            return CXSourceLocation.nptr_data(this.address(), index);
        }

        @NativeType(value="unsigned")
        public int int_data() {
            return CXSourceLocation.nint_data(this.address());
        }
    }
}

