/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXCursorAndRangeVisit;
import org.lwjgl.llvm.CXCursorAndRangeVisitI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXCursorAndRangeVisitor
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONTEXT;
    public static final int VISIT;

    public CXCursorAndRangeVisitor(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXCursorAndRangeVisitor.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)")
    public CXCursorAndRangeVisit visit() {
        return CXCursorAndRangeVisitor.nvisit(this.address());
    }

    public CXCursorAndRangeVisitor visit(@NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)") CXCursorAndRangeVisitI value) {
        CXCursorAndRangeVisitor.nvisit(this.address(), value);
        return this;
    }

    public CXCursorAndRangeVisitor set(CXCursorAndRangeVisitor src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CXCursorAndRangeVisitor malloc() {
        return (CXCursorAndRangeVisitor)CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXCursorAndRangeVisitor calloc() {
        return (CXCursorAndRangeVisitor)CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXCursorAndRangeVisitor create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXCursorAndRangeVisitor)CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXCursorAndRangeVisitor create(long address) {
        return (CXCursorAndRangeVisitor)CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, (long)address);
    }

    @Nullable
    public static CXCursorAndRangeVisitor createSafe(long address) {
        return address == 0L ? null : (CXCursorAndRangeVisitor)CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXCursorAndRangeVisitor.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXCursorAndRangeVisitor.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXCursorAndRangeVisitor.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXCursorAndRangeVisitor.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXCursorAndRangeVisitor.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXCursorAndRangeVisitor.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXCursorAndRangeVisitor.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXCursorAndRangeVisitor mallocStack() {
        return CXCursorAndRangeVisitor.mallocStack(MemoryStack.stackGet());
    }

    public static CXCursorAndRangeVisitor callocStack() {
        return CXCursorAndRangeVisitor.callocStack(MemoryStack.stackGet());
    }

    public static CXCursorAndRangeVisitor mallocStack(MemoryStack stack) {
        return (CXCursorAndRangeVisitor)CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXCursorAndRangeVisitor callocStack(MemoryStack stack) {
        return (CXCursorAndRangeVisitor)CXCursorAndRangeVisitor.wrap(CXCursorAndRangeVisitor.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXCursorAndRangeVisitor.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXCursorAndRangeVisitor.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXCursorAndRangeVisitor.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXCursorAndRangeVisitor.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static CXCursorAndRangeVisit nvisit(long struct) {
        return CXCursorAndRangeVisit.create(MemoryUtil.memGetAddress((long)(struct + (long)CONTEXT)));
    }

    public static void nvisit(long struct, CXCursorAndRangeVisitI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VISIT), (long)CXCursorAndRangeVisit.DELEGATE);
        MemoryUtil.memPutAddress((long)(struct + (long)CONTEXT), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CONTEXT)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)VISIT)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            CXCursorAndRangeVisitor.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = CXCursorAndRangeVisitor.__struct((Struct.Member[])new Struct.Member[]{CXCursorAndRangeVisitor.__member((int)POINTER_SIZE), CXCursorAndRangeVisitor.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONTEXT = layout.offsetof(0);
        VISIT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXCursorAndRangeVisitor, Buffer>
    implements NativeResource {
        private static final CXCursorAndRangeVisitor ELEMENT_FACTORY = CXCursorAndRangeVisitor.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXCursorAndRangeVisitor getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)")
        public CXCursorAndRangeVisit visit() {
            return CXCursorAndRangeVisitor.nvisit(this.address());
        }

        public Buffer visit(@NativeType(value="enum CXVisitorResult (*) (void *, CXCursor, CXSourceRange)") CXCursorAndRangeVisitI value) {
            CXCursorAndRangeVisitor.nvisit(this.address(), value);
            return this;
        }
    }
}

