/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_Bounds")
public class MeshoptBounds
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CENTER;
    public static final int RADIUS;
    public static final int CONE_APEX;
    public static final int CONE_AXIS;
    public static final int CONE_CUTOFF;
    public static final int CONE_AXIS_S8;
    public static final int CONE_CUTOFF_S8;

    public MeshoptBounds(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeshoptBounds.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[3]")
    public FloatBuffer center() {
        return MeshoptBounds.ncenter(this.address());
    }

    public float center(int index) {
        return MeshoptBounds.ncenter(this.address(), index);
    }

    public float radius() {
        return MeshoptBounds.nradius(this.address());
    }

    @NativeType(value="float[3]")
    public FloatBuffer cone_apex() {
        return MeshoptBounds.ncone_apex(this.address());
    }

    public float cone_apex(int index) {
        return MeshoptBounds.ncone_apex(this.address(), index);
    }

    @NativeType(value="float[3]")
    public FloatBuffer cone_axis() {
        return MeshoptBounds.ncone_axis(this.address());
    }

    public float cone_axis(int index) {
        return MeshoptBounds.ncone_axis(this.address(), index);
    }

    public float cone_cutoff() {
        return MeshoptBounds.ncone_cutoff(this.address());
    }

    @NativeType(value="char[3]")
    public ByteBuffer cone_axis_s8() {
        return MeshoptBounds.ncone_axis_s8(this.address());
    }

    @NativeType(value="char")
    public byte cone_axis_s8(int index) {
        return MeshoptBounds.ncone_axis_s8(this.address(), index);
    }

    @NativeType(value="char")
    public byte cone_cutoff_s8() {
        return MeshoptBounds.ncone_cutoff_s8(this.address());
    }

    public static MeshoptBounds malloc() {
        return (MeshoptBounds)MeshoptBounds.wrap(MeshoptBounds.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static MeshoptBounds calloc() {
        return (MeshoptBounds)MeshoptBounds.wrap(MeshoptBounds.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static MeshoptBounds create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (MeshoptBounds)MeshoptBounds.wrap(MeshoptBounds.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static MeshoptBounds create(long address) {
        return (MeshoptBounds)MeshoptBounds.wrap(MeshoptBounds.class, (long)address);
    }

    @Nullable
    public static MeshoptBounds createSafe(long address) {
        return address == 0L ? null : (MeshoptBounds)MeshoptBounds.wrap(MeshoptBounds.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)MeshoptBounds.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)MeshoptBounds.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)MeshoptBounds.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptBounds.__create((int)capacity, (int)SIZEOF);
        return (Buffer)MeshoptBounds.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)MeshoptBounds.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)MeshoptBounds.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static MeshoptBounds mallocStack() {
        return MeshoptBounds.mallocStack(MemoryStack.stackGet());
    }

    public static MeshoptBounds callocStack() {
        return MeshoptBounds.callocStack(MemoryStack.stackGet());
    }

    public static MeshoptBounds mallocStack(MemoryStack stack) {
        return (MeshoptBounds)MeshoptBounds.wrap(MeshoptBounds.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeshoptBounds callocStack(MemoryStack stack) {
        return (MeshoptBounds)MeshoptBounds.wrap(MeshoptBounds.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MeshoptBounds.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MeshoptBounds.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeshoptBounds.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeshoptBounds.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static FloatBuffer ncenter(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)CENTER), (int)3);
    }

    public static float ncenter(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)CENTER + Checks.check((int)index, (int)3) * 4L);
    }

    public static float nradius(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RADIUS);
    }

    public static FloatBuffer ncone_apex(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)CONE_APEX), (int)3);
    }

    public static float ncone_apex(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)CONE_APEX + Checks.check((int)index, (int)3) * 4L);
    }

    public static FloatBuffer ncone_axis(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)CONE_AXIS), (int)3);
    }

    public static float ncone_axis(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)CONE_AXIS + Checks.check((int)index, (int)3) * 4L);
    }

    public static float ncone_cutoff(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CONE_CUTOFF);
    }

    public static ByteBuffer ncone_axis_s8(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)CONE_AXIS_S8), (int)3);
    }

    public static byte ncone_axis_s8(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)CONE_AXIS_S8 + Checks.check((int)index, (int)3) * 1L);
    }

    public static byte ncone_cutoff_s8(long struct) {
        return UNSAFE.getByte(null, struct + (long)CONE_CUTOFF_S8);
    }

    static {
        Struct.Layout layout = MeshoptBounds.__struct((Struct.Member[])new Struct.Member[]{MeshoptBounds.__array((int)4, (int)3), MeshoptBounds.__member((int)4), MeshoptBounds.__array((int)4, (int)3), MeshoptBounds.__array((int)4, (int)3), MeshoptBounds.__member((int)4), MeshoptBounds.__array((int)1, (int)3), MeshoptBounds.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CENTER = layout.offsetof(0);
        RADIUS = layout.offsetof(1);
        CONE_APEX = layout.offsetof(2);
        CONE_AXIS = layout.offsetof(3);
        CONE_CUTOFF = layout.offsetof(4);
        CONE_AXIS_S8 = layout.offsetof(5);
        CONE_CUTOFF_S8 = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<MeshoptBounds, Buffer>
    implements NativeResource {
        private static final MeshoptBounds ELEMENT_FACTORY = MeshoptBounds.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MeshoptBounds getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[3]")
        public FloatBuffer center() {
            return MeshoptBounds.ncenter(this.address());
        }

        public float center(int index) {
            return MeshoptBounds.ncenter(this.address(), index);
        }

        public float radius() {
            return MeshoptBounds.nradius(this.address());
        }

        @NativeType(value="float[3]")
        public FloatBuffer cone_apex() {
            return MeshoptBounds.ncone_apex(this.address());
        }

        public float cone_apex(int index) {
            return MeshoptBounds.ncone_apex(this.address(), index);
        }

        @NativeType(value="float[3]")
        public FloatBuffer cone_axis() {
            return MeshoptBounds.ncone_axis(this.address());
        }

        public float cone_axis(int index) {
            return MeshoptBounds.ncone_axis(this.address(), index);
        }

        public float cone_cutoff() {
            return MeshoptBounds.ncone_cutoff(this.address());
        }

        @NativeType(value="char[3]")
        public ByteBuffer cone_axis_s8() {
            return MeshoptBounds.ncone_axis_s8(this.address());
        }

        @NativeType(value="char")
        public byte cone_axis_s8(int index) {
            return MeshoptBounds.ncone_axis_s8(this.address(), index);
        }

        @NativeType(value="char")
        public byte cone_cutoff_s8() {
            return MeshoptBounds.ncone_cutoff_s8(this.address());
        }
    }
}

