/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct par_octasphere_mesh")
public class ParOctasphereMesh
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSITIONS;
    public static final int NORMALS;
    public static final int TEXCOORDS;
    public static final int INDICES;
    public static final int NUM_INDICES;
    public static final int NUM_VERTICES;

    public ParOctasphereMesh(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ParOctasphereMesh.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer positions(int capacity) {
        return ParOctasphereMesh.npositions(this.address(), capacity);
    }

    @Nullable
    @NativeType(value="float *")
    public FloatBuffer normals(int capacity) {
        return ParOctasphereMesh.nnormals(this.address(), capacity);
    }

    @Nullable
    @NativeType(value="float *")
    public FloatBuffer texcoords(int capacity) {
        return ParOctasphereMesh.ntexcoords(this.address(), capacity);
    }

    @NativeType(value="uint16_t *")
    public ShortBuffer indices(int capacity) {
        return ParOctasphereMesh.nindices(this.address(), capacity);
    }

    @NativeType(value="uint32_t")
    public int num_indices() {
        return ParOctasphereMesh.nnum_indices(this.address());
    }

    @NativeType(value="uint32_t")
    public int num_vertices() {
        return ParOctasphereMesh.nnum_vertices(this.address());
    }

    public ParOctasphereMesh positions(@NativeType(value="float *") FloatBuffer value) {
        ParOctasphereMesh.npositions(this.address(), value);
        return this;
    }

    public ParOctasphereMesh normals(@Nullable @NativeType(value="float *") FloatBuffer value) {
        ParOctasphereMesh.nnormals(this.address(), value);
        return this;
    }

    public ParOctasphereMesh texcoords(@Nullable @NativeType(value="float *") FloatBuffer value) {
        ParOctasphereMesh.ntexcoords(this.address(), value);
        return this;
    }

    public ParOctasphereMesh indices(@NativeType(value="uint16_t *") ShortBuffer value) {
        ParOctasphereMesh.nindices(this.address(), value);
        return this;
    }

    public ParOctasphereMesh set(FloatBuffer positions, @Nullable FloatBuffer normals, @Nullable FloatBuffer texcoords, ShortBuffer indices) {
        this.positions(positions);
        this.normals(normals);
        this.texcoords(texcoords);
        this.indices(indices);
        return this;
    }

    public ParOctasphereMesh set(ParOctasphereMesh src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ParOctasphereMesh malloc() {
        return (ParOctasphereMesh)ParOctasphereMesh.wrap(ParOctasphereMesh.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static ParOctasphereMesh calloc() {
        return (ParOctasphereMesh)ParOctasphereMesh.wrap(ParOctasphereMesh.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static ParOctasphereMesh create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (ParOctasphereMesh)ParOctasphereMesh.wrap(ParOctasphereMesh.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static ParOctasphereMesh create(long address) {
        return (ParOctasphereMesh)ParOctasphereMesh.wrap(ParOctasphereMesh.class, (long)address);
    }

    @Nullable
    public static ParOctasphereMesh createSafe(long address) {
        return address == 0L ? null : (ParOctasphereMesh)ParOctasphereMesh.wrap(ParOctasphereMesh.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)ParOctasphereMesh.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)ParOctasphereMesh.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)ParOctasphereMesh.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ParOctasphereMesh.__create((int)capacity, (int)SIZEOF);
        return (Buffer)ParOctasphereMesh.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ParOctasphereMesh.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ParOctasphereMesh.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ParOctasphereMesh mallocStack() {
        return ParOctasphereMesh.mallocStack(MemoryStack.stackGet());
    }

    public static ParOctasphereMesh callocStack() {
        return ParOctasphereMesh.callocStack(MemoryStack.stackGet());
    }

    public static ParOctasphereMesh mallocStack(MemoryStack stack) {
        return (ParOctasphereMesh)ParOctasphereMesh.wrap(ParOctasphereMesh.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ParOctasphereMesh callocStack(MemoryStack stack) {
        return (ParOctasphereMesh)ParOctasphereMesh.wrap(ParOctasphereMesh.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ParOctasphereMesh.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ParOctasphereMesh.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)ParOctasphereMesh.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)ParOctasphereMesh.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static FloatBuffer npositions(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)POSITIONS)), (int)capacity);
    }

    @Nullable
    public static FloatBuffer nnormals(long struct, int capacity) {
        return MemoryUtil.memFloatBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)NORMALS)), (int)capacity);
    }

    @Nullable
    public static FloatBuffer ntexcoords(long struct, int capacity) {
        return MemoryUtil.memFloatBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)TEXCOORDS)), (int)capacity);
    }

    public static ShortBuffer nindices(long struct, int capacity) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)INDICES)), (int)capacity);
    }

    public static int nnum_indices(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_INDICES);
    }

    public static int nnum_vertices(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_VERTICES);
    }

    public static void npositions(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)POSITIONS), (long)MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nnormals(long struct, @Nullable FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NORMALS), (long)MemoryUtil.memAddressSafe((FloatBuffer)value));
    }

    public static void ntexcoords(long struct, @Nullable FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TEXCOORDS), (long)MemoryUtil.memAddressSafe((FloatBuffer)value));
    }

    public static void nindices(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INDICES), (long)MemoryUtil.memAddress((ShortBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)POSITIONS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)INDICES)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            ParOctasphereMesh.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = ParOctasphereMesh.__struct((Struct.Member[])new Struct.Member[]{ParOctasphereMesh.__member((int)POINTER_SIZE), ParOctasphereMesh.__member((int)POINTER_SIZE), ParOctasphereMesh.__member((int)POINTER_SIZE), ParOctasphereMesh.__member((int)POINTER_SIZE), ParOctasphereMesh.__member((int)4), ParOctasphereMesh.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSITIONS = layout.offsetof(0);
        NORMALS = layout.offsetof(1);
        TEXCOORDS = layout.offsetof(2);
        INDICES = layout.offsetof(3);
        NUM_INDICES = layout.offsetof(4);
        NUM_VERTICES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<ParOctasphereMesh, Buffer>
    implements NativeResource {
        private static final ParOctasphereMesh ELEMENT_FACTORY = ParOctasphereMesh.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ParOctasphereMesh getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float *")
        public FloatBuffer positions(int capacity) {
            return ParOctasphereMesh.npositions(this.address(), capacity);
        }

        @Nullable
        @NativeType(value="float *")
        public FloatBuffer normals(int capacity) {
            return ParOctasphereMesh.nnormals(this.address(), capacity);
        }

        @Nullable
        @NativeType(value="float *")
        public FloatBuffer texcoords(int capacity) {
            return ParOctasphereMesh.ntexcoords(this.address(), capacity);
        }

        @NativeType(value="uint16_t *")
        public ShortBuffer indices(int capacity) {
            return ParOctasphereMesh.nindices(this.address(), capacity);
        }

        @NativeType(value="uint32_t")
        public int num_indices() {
            return ParOctasphereMesh.nnum_indices(this.address());
        }

        @NativeType(value="uint32_t")
        public int num_vertices() {
            return ParOctasphereMesh.nnum_vertices(this.address());
        }

        public Buffer positions(@NativeType(value="float *") FloatBuffer value) {
            ParOctasphereMesh.npositions(this.address(), value);
            return this;
        }

        public Buffer normals(@Nullable @NativeType(value="float *") FloatBuffer value) {
            ParOctasphereMesh.nnormals(this.address(), value);
            return this;
        }

        public Buffer texcoords(@Nullable @NativeType(value="float *") FloatBuffer value) {
            ParOctasphereMesh.ntexcoords(this.address(), value);
            return this;
        }

        public Buffer indices(@NativeType(value="uint16_t *") ShortBuffer value) {
            ParOctasphereMesh.nindices(this.address(), value);
            return this;
        }
    }
}

