/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import net.i2p.data.DataHelper;

class NTCP2Options {
    private final float _sendMin;
    private final float _sendMax;
    private final float _recvMin;
    private final float _recvMax;
    private final int _sendDummy;
    private final int _recvDummy;
    private final int _sendDelay;
    private final int _recvDelay;

    public NTCP2Options(float sendMin, float sendMax, float recvMin, float recvMax, int sendDummy, int recvDummy, int sendDelay, int recvDelay) {
        this._sendMin = sendMin;
        this._sendMax = sendMax;
        this._recvMin = recvMin;
        this._recvMax = recvMax;
        this._sendDummy = sendDummy;
        this._recvDummy = recvDummy;
        this._sendDelay = sendDelay;
        this._recvDelay = recvDelay;
    }

    public float getSendMin() {
        return this._sendMin;
    }

    public float getSendMax() {
        return this._sendMax;
    }

    public float getRecvMin() {
        return this._recvMin;
    }

    public float getRecvMax() {
        return this._recvMax;
    }

    public int getSendDummy() {
        return this._sendDummy;
    }

    public int getRecvDummy() {
        return this._recvDummy;
    }

    public int getSendDelay() {
        return this._sendDelay;
    }

    public int getRecvDelay() {
        return this._recvDelay;
    }

    public NTCP2Options merge(NTCP2Options his) {
        float xrMax;
        float xrMin;
        float xsMax;
        float xsMin = Math.max(this._sendMin, his.getRecvMin());
        if (xsMin > (xsMax = Math.min(this._sendMax, his.getRecvMax()))) {
            xsMin = xsMax;
        }
        if ((xrMin = Math.max(this._recvMin, his.getSendMin())) > (xrMax = Math.min(this._recvMax, his.getSendMax()))) {
            xrMin = xrMax;
        }
        int xsDummy = Math.min(this._sendDummy, his.getRecvDummy());
        int xrDummy = Math.min(this._recvDummy, his.getSendDummy());
        int xsDelay = Math.min(this._sendDelay, his.getRecvDelay());
        int xrDelay = Math.min(this._recvDelay, his.getSendDelay());
        return new NTCP2Options(xsMin, xsMax, xrMin, xrMax, xsDummy, xrDummy, xsDelay, xrDelay);
    }

    public static NTCP2Options fromByteArray(byte[] options) {
        if (options.length < 12) {
            return null;
        }
        float tmin = (float)(options[0] & 0xFF) / 16.0f;
        float tmax = (float)(options[1] & 0xFF) / 16.0f;
        float rmin = (float)(options[2] & 0xFF) / 16.0f;
        float rmax = (float)(options[3] & 0xFF) / 16.0f;
        int tdummy = (int)DataHelper.fromLong(options, 4, 2);
        int rdummy = (int)DataHelper.fromLong(options, 6, 2);
        int tdelay = (int)DataHelper.fromLong(options, 8, 2);
        int rdelay = (int)DataHelper.fromLong(options, 10, 2);
        return new NTCP2Options(tmin, tmax, rmin, rmax, tdummy, rdummy, tdelay, rdelay);
    }

    public String toString() {
        return "Padding options: send min/max %: (" + this._sendMin * 100.0f + ", " + this._sendMax * 100.0f + ") recv min/max %: (" + this._recvMin * 100.0f + ", " + this._recvMax * 100.0f + ") dummy send/recv B/s: (" + this._sendDummy + ", " + this._recvDummy + ") delay send/recv ms: (" + this._sendDelay + ", " + this._recvDelay + ')';
    }
}

