/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir;

import java.util.ArrayList;
import java.util.List;

public class Util {
    public static List<String> listDesc(String desc) {
        ArrayList<String> list = new ArrayList<String>(5);
        char[] chars = desc.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    list.add(Character.toString(chars[i]));
                    ++i;
                    break;
                }
                case '[': {
                    int count = 1;
                    while (chars[i + count] == '[') {
                        ++count;
                    }
                    if (chars[i + count] == 'L') {
                        ++count;
                        while (chars[i + count] != ';') {
                            ++count;
                        }
                    }
                    list.add(new String(chars, i, ++count));
                    i += count + 1;
                    break;
                }
                case 'L': {
                    int count = 1;
                    while (chars[i + count] != ';') {
                        ++count;
                    }
                    list.add(new String(chars, i, ++count));
                    i += count + 1;
                }
            }
        }
        return list;
    }

    public static void appendString(StringBuffer buf, String s) {
        buf.append('\"');
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\n') {
                buf.append("\\n");
            } else if (c == '\r') {
                buf.append("\\r");
            } else if (c == '\\') {
                buf.append("\\\\");
            } else if (c == '\"') {
                buf.append("\\\"");
            } else if (c < ' ' || c > '\u007f') {
                buf.append("\\u");
                if (c < '\u0010') {
                    buf.append("000");
                } else if (c < '\u0100') {
                    buf.append("00");
                } else if (c < '\u1000') {
                    buf.append('0');
                }
                buf.append(Integer.toString(c, 16));
            } else {
                buf.append(c);
            }
            ++i;
        }
        buf.append('\"');
    }

    public static String toShortClassName(String desc) {
        switch (desc.charAt(0)) {
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case 'V': {
                return "void";
            }
            case 'L': {
                int i = desc.lastIndexOf(47);
                return desc.substring(i < 0 ? 1 : i + 1, desc.length() - 1);
            }
            case '[': {
                int d = 1;
                while (d < desc.length()) {
                    if (desc.charAt(d) != '[') break;
                    ++d;
                }
                int i = desc.lastIndexOf(47);
                StringBuilder sb = new StringBuilder().append(desc.substring(i < 0 ? d : i + 1, desc.length() - 1));
                int t = 0;
                while (t < d) {
                    sb.append("[]");
                    ++t;
                }
                return sb.toString();
            }
        }
        throw new UnsupportedOperationException();
    }
}

