/* This file is generated by venus-protocol git-2564dba1. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_PIPELINE_CACHE_H
#define VN_PROTOCOL_DRIVER_PIPELINE_CACHE_H

#include "vn_device.h"
#include "vn_protocol_driver_structs.h"

/* struct VkPipelineCacheCreateInfo chain */

static inline size_t
vn_sizeof_VkPipelineCacheCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPipelineCacheCreateInfo_self(const VkPipelineCacheCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_size_t(&val->initialDataSize);
    if (val->pInitialData) {
        size += vn_sizeof_array_size(val->initialDataSize);
        size += vn_sizeof_blob_array(val->pInitialData, val->initialDataSize);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkPipelineCacheCreateInfo(const VkPipelineCacheCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPipelineCacheCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPipelineCacheCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPipelineCacheCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPipelineCacheCreateInfo_self(struct vn_cs_encoder *enc, const VkPipelineCacheCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_size_t(enc, &val->initialDataSize);
    if (val->pInitialData) {
        vn_encode_array_size(enc, val->initialDataSize);
        vn_encode_blob_array(enc, val->pInitialData, val->initialDataSize);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkPipelineCacheCreateInfo(struct vn_cs_encoder *enc, const VkPipelineCacheCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO });
    vn_encode_VkPipelineCacheCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPipelineCacheCreateInfo_self(enc, val);
}

static inline size_t vn_sizeof_vkCreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreatePipelineCache_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkPipelineCacheCreateInfo(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pPipelineCache);
    if (pPipelineCache)
        cmd_size += vn_sizeof_VkPipelineCache(pPipelineCache);

    return cmd_size;
}

static inline void vn_encode_vkCreatePipelineCache(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreatePipelineCache_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkPipelineCacheCreateInfo(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pPipelineCache))
        vn_encode_VkPipelineCache(enc, pPipelineCache);
}

static inline size_t vn_sizeof_vkCreatePipelineCache_reply(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreatePipelineCache_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pPipelineCache);
    if (pPipelineCache)
        cmd_size += vn_sizeof_VkPipelineCache(pPipelineCache);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreatePipelineCache_reply(struct vn_cs_decoder *dec, VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreatePipelineCache_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkPipelineCache(dec, pPipelineCache);
    } else {
        pPipelineCache = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyPipelineCache_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkPipelineCache(&pipelineCache);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyPipelineCache(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyPipelineCache_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkPipelineCache(enc, &pipelineCache);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyPipelineCache_reply(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyPipelineCache_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip pipelineCache */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyPipelineCache_reply(struct vn_cs_decoder *dec, VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyPipelineCache_EXT);

    /* skip device */
    /* skip pipelineCache */
    /* skip pAllocator */
}

static inline size_t vn_sizeof_vkGetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPipelineCacheData_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkPipelineCache(&pipelineCache);
    cmd_size += vn_sizeof_simple_pointer(pDataSize);
    if (pDataSize)
        cmd_size += vn_sizeof_size_t(pDataSize);
    cmd_size += vn_sizeof_simple_pointer(pData); /* out */

    return cmd_size;
}

static inline void vn_encode_vkGetPipelineCacheData(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPipelineCacheData_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkPipelineCache(enc, &pipelineCache);
    if (vn_encode_simple_pointer(enc, pDataSize))
        vn_encode_size_t(enc, pDataSize);
    vn_encode_array_size(enc, pData ? *pDataSize : 0); /* out */
}

static inline size_t vn_sizeof_vkGetPipelineCacheData_reply(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPipelineCacheData_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pipelineCache */
    cmd_size += vn_sizeof_simple_pointer(pDataSize);
    if (pDataSize)
        cmd_size += vn_sizeof_size_t(pDataSize);
    if (pData) {
        cmd_size += vn_sizeof_array_size(*pDataSize);
        cmd_size += vn_sizeof_blob_array(pData, *pDataSize);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkGetPipelineCacheData_reply(struct vn_cs_decoder *dec, VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPipelineCacheData_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pipelineCache */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_size_t(dec, pDataSize);
    } else {
        pDataSize = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, *pDataSize);
        vn_decode_blob_array(dec, pData, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        pData = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkMergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkMergePipelineCaches_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkPipelineCache(&dstCache);
    cmd_size += vn_sizeof_uint32_t(&srcCacheCount);
    if (pSrcCaches) {
        cmd_size += vn_sizeof_array_size(srcCacheCount);
        for (uint32_t i = 0; i < srcCacheCount; i++)
            cmd_size += vn_sizeof_VkPipelineCache(&pSrcCaches[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkMergePipelineCaches(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkMergePipelineCaches_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkPipelineCache(enc, &dstCache);
    vn_encode_uint32_t(enc, &srcCacheCount);
    if (pSrcCaches) {
        vn_encode_array_size(enc, srcCacheCount);
        for (uint32_t i = 0; i < srcCacheCount; i++)
            vn_encode_VkPipelineCache(enc, &pSrcCaches[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkMergePipelineCaches_reply(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkMergePipelineCaches_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip dstCache */
    /* skip srcCacheCount */
    /* skip pSrcCaches */

    return cmd_size;
}

static inline VkResult vn_decode_vkMergePipelineCaches_reply(struct vn_cs_decoder *dec, VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkMergePipelineCaches_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip dstCache */
    /* skip srcCacheCount */
    /* skip pSrcCaches */

    return ret;
}

static inline void vn_submit_vkCreatePipelineCache(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreatePipelineCache(device, pCreateInfo, pAllocator, pPipelineCache);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCreatePipelineCache(&submit->command, cmd_flags, device, pCreateInfo, pAllocator, pPipelineCache);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreatePipelineCache_reply(device, pCreateInfo, pAllocator, pPipelineCache) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkDestroyPipelineCache(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyPipelineCache(device, pipelineCache, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkDestroyPipelineCache(&submit->command, cmd_flags, device, pipelineCache, pAllocator);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyPipelineCache_reply(device, pipelineCache, pAllocator) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkGetPipelineCacheData(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPipelineCacheData(device, pipelineCache, pDataSize, pData);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkGetPipelineCacheData(&submit->command, cmd_flags, device, pipelineCache, pDataSize, pData);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPipelineCacheData_reply(device, pipelineCache, pDataSize, pData) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkMergePipelineCaches(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkMergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkMergePipelineCaches(&submit->command, cmd_flags, device, dstCache, srcCacheCount, pSrcCaches);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkMergePipelineCaches_reply(device, dstCache, srcCacheCount, pSrcCaches) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline VkResult vn_call_vkCreatePipelineCache(struct vn_instance *vn_instance, VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCreatePipelineCache(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCreateInfo, pAllocator, pPipelineCache, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkCreatePipelineCache_reply(&submit.reply, device, pCreateInfo, pAllocator, pPipelineCache);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreatePipelineCache(struct vn_instance *vn_instance, VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCreatePipelineCache(vn_instance, 0, device, pCreateInfo, pAllocator, pPipelineCache, &submit);
}

static inline void vn_call_vkDestroyPipelineCache(struct vn_instance *vn_instance, VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyPipelineCache(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pipelineCache, pAllocator, &submit);
    if (submit.reply_bo) {
        vn_decode_vkDestroyPipelineCache_reply(&submit.reply, device, pipelineCache, pAllocator);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkDestroyPipelineCache(struct vn_instance *vn_instance, VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyPipelineCache(vn_instance, 0, device, pipelineCache, pAllocator, &submit);
}

static inline VkResult vn_call_vkGetPipelineCacheData(struct vn_instance *vn_instance, VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPipelineCacheData(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pipelineCache, pDataSize, pData, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkGetPipelineCacheData_reply(&submit.reply, device, pipelineCache, pDataSize, pData);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkGetPipelineCacheData(struct vn_instance *vn_instance, VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPipelineCacheData(vn_instance, 0, device, pipelineCache, pDataSize, pData, &submit);
}

static inline VkResult vn_call_vkMergePipelineCaches(struct vn_instance *vn_instance, VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkMergePipelineCaches(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, dstCache, srcCacheCount, pSrcCaches, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkMergePipelineCaches_reply(&submit.reply, device, dstCache, srcCacheCount, pSrcCaches);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkMergePipelineCaches(struct vn_instance *vn_instance, VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkMergePipelineCaches(vn_instance, 0, device, dstCache, srcCacheCount, pSrcCaches, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_PIPELINE_CACHE_H */
