/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Date;

public class Interval {
    public final Date start;
    public final Date end;

    public Interval(Date start, Date end) {
        if (start == null) {
            throw new IllegalArgumentException("Start date is null.");
        }
        if (end == null) {
            throw new IllegalArgumentException("End date is null.");
        }
        if (end.before(start)) {
            throw new IllegalArgumentException("End date is before start date.");
        }
        this.start = start;
        this.end = end;
    }

    public boolean equals(Object object) {
        try {
            Interval other = (Interval)object;
            return other.start.equals(this.start) && other.end.equals(this.end);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean after(Interval other) {
        return this.start.after(other.end);
    }

    public boolean before(Interval other) {
        return this.end.before(other.start);
    }
}

