/*
 * Decompiled with CFR 0.152.
 */
package tr.view.overview;

import au.com.thinkingrock.tr.resource.Icons;
import au.com.thinkingrock.tr.resource.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.Locale;
import javax.swing.SwingUtilities;
import org.apache.batik.swing.JSVGCanvas;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import tr.util.Observable;
import tr.util.Observer;
import tr.util.Utils;
import tr.view.Window;
import tr.view.overview.Overview;
import tr.view.overview.spi.OverviewSVGProvider;

public final class OverviewTopComponent
extends Window {
    private static final long serialVersionUID = 1L;
    public static final String PREFERRED_ID = "OverviewTopComponent";
    private static OverviewTopComponent instance;
    private final Lookup.Result<OverviewSVGProvider> lookup = Lookup.getDefault().lookupResult(OverviewSVGProvider.class);
    private final Overview overview;
    private final JSVGCanvas canvas;
    private Observer observer;

    private OverviewTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(OverviewTopComponent.class, (String)"CTL_OverviewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(OverviewTopComponent.class, (String)"HINT_OverviewTopComponent"));
        this.setIcon(Icons.Overview.getImage());
        this.overview = new Overview();
        this.canvas = this.overview.getSVGCanvas();
        this.add((Component)this.canvas, "Center");
        this.canvas.setURI(this.getURL().toExternalForm());
        this.canvas.setSize(1, 1);
    }

    private URL getURL() {
        String language = Locale.getDefault().getLanguage();
        String country = Locale.getDefault().getCountry();
        OverviewSVGProvider generalLanguageProvider = null;
        for (OverviewSVGProvider provider : this.lookup.allInstances()) {
            if (!Utils.equal((Object)provider.getLanguage(), (Object)language)) continue;
            if (Utils.equal((Object)provider.getCountry(), (Object)country)) {
                return provider.getURL();
            }
            if (provider.getCountry() != null) continue;
            generalLanguageProvider = provider;
        }
        if (generalLanguageProvider != null) {
            return generalLanguageProvider.getURL();
        }
        return Resource.getOverviewURL();
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
    }

    private void addListeners() {
        this.observer = new Observer(){

            public void update(Observable observable, final Object screen) {
                if (screen instanceof Overview.Screen) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            OverviewTopComponent.this.switchScreen((Overview.Screen)((Object)screen));
                        }
                    });
                }
            }
        };
        this.overview.addObserver(this.observer);
    }

    private void removeListeners() {
        this.overview.removeObserver(this.observer);
    }

    private void switchScreen(Overview.Screen screen) {
        screen.action.actionPerformed(null);
    }

    public static synchronized OverviewTopComponent getDefault() {
        if (instance == null) {
            instance = new OverviewTopComponent();
        }
        return instance;
    }

    public static synchronized OverviewTopComponent findInstance() {
        return OverviewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentActivated() {
        this.refresh();
    }

    public void componentOpened() {
        this.refresh();
    }

    public void refresh() {
        this.canvas.setSize(1, 1);
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.overview");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

