/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.javascript;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Mode;
import processing.app.Sketch;
import processing.app.syntax.PdeKeywords;
import processing.core.PApplet;
import processing.mode.javascript.JavaScriptBuild;
import processing.mode.javascript.JavaScriptEditor;

public class JavaScriptMode
extends Mode {
    public Editor createEditor(Base base, String path, int[] location) {
        return new JavaScriptEditor(base, path, location, this);
    }

    public JavaScriptMode(Base base, File folder) {
        super(base, folder);
        try {
            this.loadKeywords();
        }
        catch (IOException e) {
            Base.showError("Problem loading keywords", "Could not load keywords.txt, please re-install Processing.", e);
        }
    }

    protected void loadKeywords() throws IOException {
        File file = new File(this.folder, "keywords.txt");
        BufferedReader reader = PApplet.createReader((File)file);
        this.tokenMarker = new PdeKeywords();
        this.keywordToReference = new HashMap();
        String line = null;
        while ((line = reader.readLine()) != null) {
            String htmlFilename;
            String[] pieces = PApplet.trim((String[])PApplet.split((String)line, (char)'\t'));
            if (pieces.length < 2) continue;
            String keyword = pieces[0];
            String coloring = pieces[1];
            if (coloring.length() > 0) {
                this.tokenMarker.addColoring(keyword, coloring);
            }
            if (pieces.length != 3 || (htmlFilename = pieces[2]).length() <= 0) continue;
            this.keywordToReference.put(keyword, htmlFilename);
        }
    }

    public String getTitle() {
        return "JavaScript";
    }

    public File[] getExampleCategoryFolders() {
        return new File[0];
    }

    public String getDefaultExtension() {
        return "pde";
    }

    public String[] getExtensions() {
        return new String[]{"pde", "pjs"};
    }

    public String[] getIgnorable() {
        return new String[]{"applet_js"};
    }

    public boolean handleExport(Sketch sketch) throws IOException {
        JavaScriptBuild build = new JavaScriptBuild(sketch);
        return build.export();
    }
}

