/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import processing.app.Base;
import processing.app.syntax.SyntaxStyle;
import processing.core.PApplet;

public class Settings {
    HashMap<String, String> defaults;
    HashMap<String, String> table = new HashMap();
    File file;

    public Settings(File file) throws IOException {
        this.file = file;
        this.load();
        this.setColor("run.window.bgcolor", SystemColor.control);
        this.defaults = (HashMap)this.table.clone();
    }

    public void load() {
        String[] lines;
        for (String line : lines = PApplet.loadStrings((File)this.file)) {
            int equals;
            if (line.length() == 0 || line.charAt(0) == '#' || (equals = line.indexOf(61)) == -1) continue;
            String key = line.substring(0, equals).trim();
            String value = line.substring(equals + 1).trim();
            this.table.put(key, value);
        }
        String platformExt = "." + Base.getPlatformName();
        int platformExtLength = platformExt.length();
        for (String key : this.table.keySet()) {
            if (!key.endsWith(platformExt)) continue;
            String actualKey = key.substring(0, key.length() - platformExtLength);
            String value = this.get(key);
            this.table.put(actualKey, value);
        }
    }

    public String get(String attribute) {
        return this.table.get(attribute);
    }

    public String getDefault(String attribute) {
        return this.defaults.get(attribute);
    }

    public void set(String attribute, String value) {
        this.table.put(attribute, value);
    }

    public boolean getBoolean(String attribute) {
        String value = this.get(attribute);
        if (value == null) {
            System.err.println("Boolean not found: " + attribute);
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public void setBoolean(String attribute, boolean value) {
        this.set(attribute, value ? "true" : "false");
    }

    public int getInteger(String attribute) {
        String value = this.get(attribute);
        if (value == null) {
            System.err.println("Integer not found: " + attribute);
            return 0;
        }
        return Integer.parseInt(value);
    }

    public void setInteger(String key, int value) {
        this.set(key, String.valueOf(value));
    }

    public Color getColor(String attribute) {
        Color parsed = null;
        String s = this.get(attribute);
        if (s != null && s.indexOf("#") == 0) {
            try {
                int v = Integer.parseInt(s.substring(1), 16);
                parsed = new Color(v);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return parsed;
    }

    public void setColor(String attr, Color what) {
        this.set(attr, "#" + PApplet.hex((int)(what.getRGB() & 0xFFFFFF), (int)6));
    }

    public Font getFont(String attr) {
        String[] pieces;
        boolean replace = false;
        String value = this.get(attr);
        if (value == null) {
            value = this.getDefault(attr);
            replace = true;
        }
        if ((pieces = PApplet.split((String)value, (char)',')).length != 3) {
            value = this.getDefault(attr);
            pieces = PApplet.split((String)value, (char)',');
            replace = true;
        }
        String name = pieces[0];
        int style = 0;
        if (pieces[1].indexOf("bold") != -1) {
            style |= 1;
        }
        if (pieces[1].indexOf("italic") != -1) {
            style |= 2;
        }
        int size = PApplet.parseInt((String)pieces[2], (int)12);
        Font font = new Font(name, style, size);
        if (replace) {
            this.set(attr, value);
        }
        return font;
    }

    public SyntaxStyle getStyle(String what) {
        String str = this.get("editor." + what + ".style");
        StringTokenizer st = new StringTokenizer(str, ",");
        String s = st.nextToken();
        if (s.indexOf("#") == 0) {
            s = s.substring(1);
        }
        Color color = new Color(Integer.parseInt(s, 16));
        s = st.nextToken();
        boolean bold = s.indexOf("bold") != -1;
        boolean italic = s.indexOf("italic") != -1;
        return new SyntaxStyle(color, italic, bold);
    }
}

