"""Generated message classes for container version v1.

Builds and manages container-based applications, powered by the open source
Kubernetes technology.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'container'


class AcceleratorConfig(_messages.Message):
  r"""AcceleratorConfig represents a Hardware Accelerator request.

  Fields:
    acceleratorCount: The number of the accelerator cards exposed to an
      instance.
    acceleratorType: The accelerator type resource name. List of supported
      accelerators [here](https://cloud.google.com/compute/docs/gpus)
    gpuPartitionSize: Size of partitions to create on the GPU. Valid values
      are described in the NVIDIA [mig user
      guide](https://docs.nvidia.com/datacenter/tesla/mig-user-
      guide/#partitioning).
  """

  acceleratorCount = _messages.IntegerField(1)
  acceleratorType = _messages.StringField(2)
  gpuPartitionSize = _messages.StringField(3)


class AddonsConfig(_messages.Message):
  r"""Configuration for the addons that can be automatically spun up in the
  cluster, enabling additional functionality.

  Fields:
    cloudRunConfig: Configuration for the Cloud Run addon, which allows the
      user to use a managed Knative service.
    configConnectorConfig: Configuration for the ConfigConnector add-on, a
      Kubernetes extension to manage hosted GCP services through the
      Kubernetes API
    dnsCacheConfig: Configuration for NodeLocalDNS, a dns cache running on
      cluster nodes
    gcePersistentDiskCsiDriverConfig: Configuration for the Compute Engine
      Persistent Disk CSI driver.
    gcpFilestoreCsiDriverConfig: Configuration for the GCP Filestore CSI
      driver.
    horizontalPodAutoscaling: Configuration for the horizontal pod autoscaling
      feature, which increases or decreases the number of replica pods a
      replication controller has based on the resource usage of the existing
      pods.
    httpLoadBalancing: Configuration for the HTTP (L7) load balancing
      controller addon, which makes it easy to set up HTTP load balancers for
      services in a cluster.
    kubernetesDashboard: Configuration for the Kubernetes Dashboard. This
      addon is deprecated, and will be disabled in 1.15. It is recommended to
      use the Cloud Console to manage and monitor your Kubernetes clusters,
      workloads and applications. For more information, see:
      https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
    networkPolicyConfig: Configuration for NetworkPolicy. This only tracks
      whether the addon is enabled or not on the Master, it does not track
      whether network policy is enabled for the nodes.
  """

  cloudRunConfig = _messages.MessageField('CloudRunConfig', 1)
  configConnectorConfig = _messages.MessageField('ConfigConnectorConfig', 2)
  dnsCacheConfig = _messages.MessageField('DnsCacheConfig', 3)
  gcePersistentDiskCsiDriverConfig = _messages.MessageField('GcePersistentDiskCsiDriverConfig', 4)
  gcpFilestoreCsiDriverConfig = _messages.MessageField('GcpFilestoreCsiDriverConfig', 5)
  horizontalPodAutoscaling = _messages.MessageField('HorizontalPodAutoscaling', 6)
  httpLoadBalancing = _messages.MessageField('HttpLoadBalancing', 7)
  kubernetesDashboard = _messages.MessageField('KubernetesDashboard', 8)
  networkPolicyConfig = _messages.MessageField('NetworkPolicyConfig', 9)


class AuthenticatorGroupsConfig(_messages.Message):
  r"""Configuration for returning group information from authenticators.

  Fields:
    enabled: Whether this cluster should return group membership lookups
      during authentication using a group of security groups.
    securityGroup: The name of the security group-of-groups to be used. Only
      relevant if enabled = true.
  """

  enabled = _messages.BooleanField(1)
  securityGroup = _messages.StringField(2)


class AutoUpgradeOptions(_messages.Message):
  r"""AutoUpgradeOptions defines the set of options for the user to control
  how the Auto Upgrades will proceed.

  Fields:
    autoUpgradeStartTime: [Output only] This field is set when upgrades are
      about to commence with the approximate start time for the upgrades, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    description: [Output only] This field is set when upgrades are about to
      commence with the description of the upgrade.
  """

  autoUpgradeStartTime = _messages.StringField(1)
  description = _messages.StringField(2)


class Autopilot(_messages.Message):
  r"""Autopilot is the configuration for Autopilot settings on the cluster.

  Fields:
    enabled: Enable Autopilot
  """

  enabled = _messages.BooleanField(1)


class AutoprovisioningNodePoolDefaults(_messages.Message):
  r"""AutoprovisioningNodePoolDefaults contains defaults for a node pool
  created by NAP.

  Fields:
    bootDiskKmsKey: The Customer Managed Encryption Key used to encrypt the
      boot disk attached to each node in the node pool. This should be of the
      form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]
      /cryptoKeys/[KEY_NAME]. For more information about protecting resources
      with Cloud KMS Keys please see:
      https://cloud.google.com/compute/docs/disks/customer-managed-encryption
    diskSizeGb: Size of the disk attached to each node, specified in GB. The
      smallest allowed disk size is 10GB. If unspecified, the default disk
      size is 100GB.
    diskType: Type of the disk attached to each node (e.g. 'pd-standard', 'pd-
      ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-
      standard'
    imageType: The image type to use for NAP created node.
    management: Specifies the node management options for NAP created node-
      pools.
    minCpuPlatform: Minimum CPU platform to be used for NAP created node
      pools. The instance may be scheduled on the specified or newer CPU
      platform. Applicable values are the friendly names of CPU platforms,
      such as minCpuPlatform: Intel Haswell or minCpuPlatform: Intel Sandy
      Bridge. For more information, read [how to specify min CPU
      platform](https://cloud.google.com/compute/docs/instances/specify-min-
      cpu-platform) To unset the min cpu platform field pass "automatic" as
      field value.
    oauthScopes: Scopes that are used by NAP when creating node pools.
    serviceAccount: The Google Cloud Platform Service Account to be used by
      the node VMs.
    shieldedInstanceConfig: Shielded Instance options.
    upgradeSettings: Specifies the upgrade settings for NAP created node pools
  """

  bootDiskKmsKey = _messages.StringField(1)
  diskSizeGb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  diskType = _messages.StringField(3)
  imageType = _messages.StringField(4)
  management = _messages.MessageField('NodeManagement', 5)
  minCpuPlatform = _messages.StringField(6)
  oauthScopes = _messages.StringField(7, repeated=True)
  serviceAccount = _messages.StringField(8)
  shieldedInstanceConfig = _messages.MessageField('ShieldedInstanceConfig', 9)
  upgradeSettings = _messages.MessageField('UpgradeSettings', 10)


class BigQueryDestination(_messages.Message):
  r"""Parameters for using BigQuery as the destination of resource usage
  export.

  Fields:
    datasetId: The ID of a BigQuery Dataset.
  """

  datasetId = _messages.StringField(1)


class BinaryAuthorization(_messages.Message):
  r"""Configuration for Binary Authorization.

  Fields:
    enabled: Enable Binary Authorization for this cluster. If enabled, all
      container images will be validated by Binary Authorization.
  """

  enabled = _messages.BooleanField(1)


class CancelOperationRequest(_messages.Message):
  r"""CancelOperationRequest cancels a single operation.

  Fields:
    name: The name (project, location, operation id) of the operation to
      cancel. Specified in the format `projects/*/locations/*/operations/*`.
    operationId: Deprecated. The server-assigned `name` of the operation. This
      field has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the operation resides. This field has been deprecated and replaced by
      the name field.
  """

  name = _messages.StringField(1)
  operationId = _messages.StringField(2)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class CidrBlock(_messages.Message):
  r"""CidrBlock contains an optional name and one CIDR block.

  Fields:
    cidrBlock: cidr_block must be specified in CIDR notation.
    displayName: display_name is an optional field for users to identify CIDR
      blocks.
  """

  cidrBlock = _messages.StringField(1)
  displayName = _messages.StringField(2)


class ClientCertificateConfig(_messages.Message):
  r"""Configuration for client certificates on the cluster.

  Fields:
    issueClientCertificate: Issue a client certificate.
  """

  issueClientCertificate = _messages.BooleanField(1)


class CloudRunConfig(_messages.Message):
  r"""Configuration options for the Cloud Run feature.

  Enums:
    LoadBalancerTypeValueValuesEnum: Which load balancer type is installed for
      Cloud Run.

  Fields:
    disabled: Whether Cloud Run addon is enabled for this cluster.
    loadBalancerType: Which load balancer type is installed for Cloud Run.
  """

  class LoadBalancerTypeValueValuesEnum(_messages.Enum):
    r"""Which load balancer type is installed for Cloud Run.

    Values:
      LOAD_BALANCER_TYPE_UNSPECIFIED: Load balancer type for Cloud Run is
        unspecified.
      LOAD_BALANCER_TYPE_EXTERNAL: Install external load balancer for Cloud
        Run.
      LOAD_BALANCER_TYPE_INTERNAL: Install internal load balancer for Cloud
        Run.
    """
    LOAD_BALANCER_TYPE_UNSPECIFIED = 0
    LOAD_BALANCER_TYPE_EXTERNAL = 1
    LOAD_BALANCER_TYPE_INTERNAL = 2

  disabled = _messages.BooleanField(1)
  loadBalancerType = _messages.EnumField('LoadBalancerTypeValueValuesEnum', 2)


class Cluster(_messages.Message):
  r"""A Google Kubernetes Engine cluster.

  Enums:
    StatusValueValuesEnum: [Output only] The current status of this cluster.

  Messages:
    ResourceLabelsValue: The resource labels for the cluster to use to
      annotate any related Google Compute Engine resources.

  Fields:
    addonsConfig: Configurations for the various addons available to run in
      the cluster.
    authenticatorGroupsConfig: Configuration controlling RBAC group membership
      information.
    autopilot: Autopilot configuration for the cluster.
    autoscaling: Cluster-level autoscaling configuration.
    binaryAuthorization: Configuration for Binary Authorization.
    clusterIpv4Cidr: The IP address range of the container pods in this
      cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-
      Domain_Routing) notation (e.g. `10.96.0.0/14`). Leave blank to have one
      automatically chosen or specify a `/14` block in `10.0.0.0/8`.
    conditions: Which conditions caused the current cluster state.
    confidentialNodes: Configuration of Confidential Nodes
    createTime: [Output only] The time the cluster was created, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    currentMasterVersion: [Output only] The current software version of the
      master endpoint.
    currentNodeCount: [Output only] The number of nodes currently in the
      cluster. Deprecated. Call Kubernetes API directly to retrieve node
      information.
    currentNodeVersion: [Output only] Deprecated, use
      [NodePools.version](https://cloud.google.com/kubernetes-
      engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
      instead. The current version of the node software components. If they
      are currently at multiple versions because they're in the process of
      being upgraded, this reflects the minimum version of all nodes.
    databaseEncryption: Configuration of etcd encryption.
    defaultMaxPodsConstraint: The default constraint on the maximum number of
      pods that can be run simultaneously on a node in the node pool of this
      cluster. Only honored if cluster created with IP Alias support.
    description: An optional description of this cluster.
    enableKubernetesAlpha: Kubernetes alpha features are enabled on this
      cluster. This includes alpha API groups (e.g. v1alpha1) and features
      that may not be production ready in the kubernetes version of the master
      and nodes. The cluster has no SLA for uptime and master/node upgrades
      are disabled. Alpha enabled clusters are automatically deleted thirty
      days after creation.
    enableTpu: Enable the ability to use Cloud TPUs in this cluster.
    endpoint: [Output only] The IP address of this cluster's master endpoint.
      The endpoint can be accessed from the internet at
      `https://username:password@endpoint/`. See the `masterAuth` property of
      this resource for username and password information.
    expireTime: [Output only] The time the cluster will be automatically
      deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    id: Output only. Unique id for the cluster.
    initialClusterVersion: The initial Kubernetes version for this cluster.
      Valid versions are those found in validMasterVersions returned by
      getServerConfig. The version can be upgraded over time; such upgrades
      are reflected in currentMasterVersion and currentNodeVersion. Users may
      specify either explicit versions offered by Kubernetes Engine or version
      aliases, which have the following behavior: - "latest": picks the
      highest valid Kubernetes version - "1.X": picks the highest valid
      patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid
      gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit
      Kubernetes version - "","-": picks the default Kubernetes version
    initialNodeCount: The number of nodes to create in this cluster. You must
      ensure that your Compute Engine [resource
      quota](https://cloud.google.com/compute/quotas) is sufficient for this
      number of instances. You must also have available firewall and routes
      quota. For requests, this field should only be used in lieu of a
      "node_pool" object, since this configuration (along with the
      "node_config") will be used to create a "NodePool" object with an auto-
      generated name. Do not use this and a node_pool at the same time. This
      field is deprecated, use node_pool.initial_node_count instead.
    instanceGroupUrls: Deprecated. Use node_pools.instance_group_urls.
    ipAllocationPolicy: Configuration for cluster IP allocation.
    labelFingerprint: The fingerprint of the set of labels for this cluster.
    legacyAbac: Configuration for the legacy ABAC authorization mode.
    location: [Output only] The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/regions-zones/regions-
      zones#available) or
      [region](https://cloud.google.com/compute/docs/regions-zones/regions-
      zones#available) in which the cluster resides.
    locations: The list of Google Compute Engine
      [zones](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster's nodes should be located. This field provides a default
      value if [NodePool.Locations](https://cloud.google.com/kubernetes-engine
      /docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.F
      IELDS.locations) are not specified during node pool creation. Warning:
      changing cluster locations will update the
      [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/ref
      erence/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.loc
      ations) of all node pools and will result in nodes being added and/or
      removed.
    loggingConfig: Logging configuration for the cluster.
    loggingService: The logging service the cluster should use to write logs.
      Currently available options: * `logging.googleapis.com/kubernetes` - The
      Cloud Logging service with a Kubernetes-native resource model *
      `logging.googleapis.com` - The legacy Cloud Logging service (no longer
      available as of GKE 1.15). * `none` - no logs will be exported from the
      cluster. If left as an empty string,`logging.googleapis.com/kubernetes`
      will be used for GKE 1.14+ or `logging.googleapis.com` for earlier
      versions.
    maintenancePolicy: Configure the maintenance policy for this cluster.
    masterAuth: The authentication information for accessing the master
      endpoint. If unspecified, the defaults are used: For clusters before
      v1.12, if master_auth is unspecified, `username` will be set to "admin",
      a random password will be generated, and a client certificate will be
      issued.
    masterAuthorizedNetworksConfig: The configuration options for master
      authorized networks feature.
    meshCertificates: Configuration for issuance of mTLS keys and certificates
      to Kubernetes pods.
    monitoringConfig: Monitoring configuration for the cluster.
    monitoringService: The monitoring service the cluster should use to write
      metrics. Currently available options: *
      "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring service
      with a Kubernetes-native resource model * `monitoring.googleapis.com` -
      The legacy Cloud Monitoring service (no longer available as of GKE
      1.15). * `none` - No metrics will be exported from the cluster. If left
      as an empty string,`monitoring.googleapis.com/kubernetes` will be used
      for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
    name: The name of this cluster. The name must be unique within this
      project and location (e.g. zone or region), and can be up to 40
      characters with the following restrictions: * Lowercase letters,
      numbers, and hyphens only. * Must start with a letter. * Must end with a
      number or a letter.
    network: The name of the Google Compute Engine
      [network](https://cloud.google.com/compute/docs/networks-and-
      firewalls#networks) to which the cluster is connected. If left
      unspecified, the `default` network will be used.
    networkConfig: Configuration for cluster networking.
    networkPolicy: Configuration options for the NetworkPolicy feature.
    nodeConfig: Parameters used in creating the cluster's nodes. For requests,
      this field should only be used in lieu of a "node_pool" object, since
      this configuration (along with the "initial_node_count") will be used to
      create a "NodePool" object with an auto-generated name. Do not use this
      and a node_pool at the same time. For responses, this field will be
      populated with the node configuration of the first node pool. (For
      configuration of each node pool, see `node_pool.config`) If unspecified,
      the defaults are used. This field is deprecated, use node_pool.config
      instead.
    nodeIpv4CidrSize: [Output only] The size of the address space on each node
      for hosting containers. This is provisioned from within the
      `container_ipv4_cidr` range. This field will only be set when cluster is
      in route-based network mode.
    nodePools: The node pools associated with this cluster. This field should
      not be set if "node_config" or "initial_node_count" are specified.
    notificationConfig: Notification configuration of the cluster.
    privateClusterConfig: Configuration for private cluster.
    releaseChannel: Release channel configuration.
    resourceLabels: The resource labels for the cluster to use to annotate any
      related Google Compute Engine resources.
    resourceUsageExportConfig: Configuration for exporting resource usages.
      Resource usage export is disabled when this config is unspecified.
    selfLink: [Output only] Server-defined URL for the resource.
    servicesIpv4Cidr: [Output only] The IP address range of the Kubernetes
      services in this cluster, in
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `1.2.3.4/29`). Service addresses are typically put in the
      last `/16` from the container CIDR.
    shieldedNodes: Shielded Nodes configuration.
    status: [Output only] The current status of this cluster.
    statusMessage: [Output only] Deprecated. Use conditions instead.
      Additional information about the current status of this cluster, if
      available.
    subnetwork: The name of the Google Compute Engine
      [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
      the cluster is connected.
    tpuIpv4CidrBlock: [Output only] The IP address range of the Cloud TPUs in
      this cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-
      Domain_Routing) notation (e.g. `1.2.3.4/29`).
    verticalPodAutoscaling: Cluster-level Vertical Pod Autoscaling
      configuration.
    workloadIdentityConfig: Configuration for the use of Kubernetes Service
      Accounts in GCP IAM policies.
    zone: [Output only] The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field is deprecated, use location instead.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output only] The current status of this cluster.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the cluster is being
        created.
      RUNNING: The RUNNING state indicates the cluster has been created and is
        fully usable.
      RECONCILING: The RECONCILING state indicates that some work is actively
        being done on the cluster, such as upgrading the master or node
        software. Details can be found in the `statusMessage` field.
      STOPPING: The STOPPING state indicates the cluster is being deleted.
      ERROR: The ERROR state indicates the cluster is unusable. It will be
        automatically deleted. Details can be found in the `statusMessage`
        field.
      DEGRADED: The DEGRADED state indicates the cluster requires user action
        to restore full functionality. Details can be found in the
        `statusMessage` field.
    """
    STATUS_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RECONCILING = 3
    STOPPING = 4
    ERROR = 5
    DEGRADED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceLabelsValue(_messages.Message):
    r"""The resource labels for the cluster to use to annotate any related
    Google Compute Engine resources.

    Messages:
      AdditionalProperty: An additional property for a ResourceLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ResourceLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  addonsConfig = _messages.MessageField('AddonsConfig', 1)
  authenticatorGroupsConfig = _messages.MessageField('AuthenticatorGroupsConfig', 2)
  autopilot = _messages.MessageField('Autopilot', 3)
  autoscaling = _messages.MessageField('ClusterAutoscaling', 4)
  binaryAuthorization = _messages.MessageField('BinaryAuthorization', 5)
  clusterIpv4Cidr = _messages.StringField(6)
  conditions = _messages.MessageField('StatusCondition', 7, repeated=True)
  confidentialNodes = _messages.MessageField('ConfidentialNodes', 8)
  createTime = _messages.StringField(9)
  currentMasterVersion = _messages.StringField(10)
  currentNodeCount = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  currentNodeVersion = _messages.StringField(12)
  databaseEncryption = _messages.MessageField('DatabaseEncryption', 13)
  defaultMaxPodsConstraint = _messages.MessageField('MaxPodsConstraint', 14)
  description = _messages.StringField(15)
  enableKubernetesAlpha = _messages.BooleanField(16)
  enableTpu = _messages.BooleanField(17)
  endpoint = _messages.StringField(18)
  expireTime = _messages.StringField(19)
  id = _messages.StringField(20)
  initialClusterVersion = _messages.StringField(21)
  initialNodeCount = _messages.IntegerField(22, variant=_messages.Variant.INT32)
  instanceGroupUrls = _messages.StringField(23, repeated=True)
  ipAllocationPolicy = _messages.MessageField('IPAllocationPolicy', 24)
  labelFingerprint = _messages.StringField(25)
  legacyAbac = _messages.MessageField('LegacyAbac', 26)
  location = _messages.StringField(27)
  locations = _messages.StringField(28, repeated=True)
  loggingConfig = _messages.MessageField('LoggingConfig', 29)
  loggingService = _messages.StringField(30)
  maintenancePolicy = _messages.MessageField('MaintenancePolicy', 31)
  masterAuth = _messages.MessageField('MasterAuth', 32)
  masterAuthorizedNetworksConfig = _messages.MessageField('MasterAuthorizedNetworksConfig', 33)
  meshCertificates = _messages.MessageField('MeshCertificates', 34)
  monitoringConfig = _messages.MessageField('MonitoringConfig', 35)
  monitoringService = _messages.StringField(36)
  name = _messages.StringField(37)
  network = _messages.StringField(38)
  networkConfig = _messages.MessageField('NetworkConfig', 39)
  networkPolicy = _messages.MessageField('NetworkPolicy', 40)
  nodeConfig = _messages.MessageField('NodeConfig', 41)
  nodeIpv4CidrSize = _messages.IntegerField(42, variant=_messages.Variant.INT32)
  nodePools = _messages.MessageField('NodePool', 43, repeated=True)
  notificationConfig = _messages.MessageField('NotificationConfig', 44)
  privateClusterConfig = _messages.MessageField('PrivateClusterConfig', 45)
  releaseChannel = _messages.MessageField('ReleaseChannel', 46)
  resourceLabels = _messages.MessageField('ResourceLabelsValue', 47)
  resourceUsageExportConfig = _messages.MessageField('ResourceUsageExportConfig', 48)
  selfLink = _messages.StringField(49)
  servicesIpv4Cidr = _messages.StringField(50)
  shieldedNodes = _messages.MessageField('ShieldedNodes', 51)
  status = _messages.EnumField('StatusValueValuesEnum', 52)
  statusMessage = _messages.StringField(53)
  subnetwork = _messages.StringField(54)
  tpuIpv4CidrBlock = _messages.StringField(55)
  verticalPodAutoscaling = _messages.MessageField('VerticalPodAutoscaling', 56)
  workloadIdentityConfig = _messages.MessageField('WorkloadIdentityConfig', 57)
  zone = _messages.StringField(58)


class ClusterAutoscaling(_messages.Message):
  r"""ClusterAutoscaling contains global, per-cluster information required by
  Cluster Autoscaler to automatically adjust the size of the cluster and
  create/delete node pools based on the current needs.

  Enums:
    AutoscalingProfileValueValuesEnum: Defines autoscaling behaviour.

  Fields:
    autoprovisioningLocations: The list of Google Compute Engine
      [zones](https://cloud.google.com/compute/docs/zones#available) in which
      the NodePool's nodes can be created by NAP.
    autoprovisioningNodePoolDefaults: AutoprovisioningNodePoolDefaults
      contains defaults for a node pool created by NAP.
    autoscalingProfile: Defines autoscaling behaviour.
    enableNodeAutoprovisioning: Enables automatic node pool creation and
      deletion.
    resourceLimits: Contains global constraints regarding minimum and maximum
      amount of resources in the cluster.
  """

  class AutoscalingProfileValueValuesEnum(_messages.Enum):
    r"""Defines autoscaling behaviour.

    Values:
      PROFILE_UNSPECIFIED: No change to autoscaling configuration.
      OPTIMIZE_UTILIZATION: Prioritize optimizing utilization of resources.
      BALANCED: Use default (balanced) autoscaling configuration.
    """
    PROFILE_UNSPECIFIED = 0
    OPTIMIZE_UTILIZATION = 1
    BALANCED = 2

  autoprovisioningLocations = _messages.StringField(1, repeated=True)
  autoprovisioningNodePoolDefaults = _messages.MessageField('AutoprovisioningNodePoolDefaults', 2)
  autoscalingProfile = _messages.EnumField('AutoscalingProfileValueValuesEnum', 3)
  enableNodeAutoprovisioning = _messages.BooleanField(4)
  resourceLimits = _messages.MessageField('ResourceLimit', 5, repeated=True)


class ClusterUpdate(_messages.Message):
  r"""ClusterUpdate describes an update to the cluster. Exactly one update can
  be applied to a cluster with each request, so at most one field can be
  provided.

  Enums:
    DesiredDatapathProviderValueValuesEnum: The desired datapath provider for
      the cluster.
    DesiredPrivateIpv6GoogleAccessValueValuesEnum: The desired state of IPv6
      connectivity to Google Services.

  Fields:
    desiredAddonsConfig: Configurations for the various addons available to
      run in the cluster.
    desiredAuthenticatorGroupsConfig: The desired authenticator groups config
      for the cluster.
    desiredAutopilot: The desired Autopilot configuration for the cluster.
    desiredBinaryAuthorization: The desired configuration options for the
      Binary Authorization feature.
    desiredClusterAutoscaling: Cluster-level autoscaling configuration.
    desiredDatabaseEncryption: Configuration of etcd encryption.
    desiredDatapathProvider: The desired datapath provider for the cluster.
    desiredDefaultSnatStatus: The desired status of whether to disable default
      sNAT for this cluster.
    desiredImage: The desired name of the image to use for this node. This is
      used to create clusters using a custom image. NOTE: Set the
      "desired_node_pool" field as well.
    desiredImageProject: The project containing the desired image to use for
      this node. This is used to create clusters using a custom image. NOTE:
      Set the "desired_node_pool" field as well.
    desiredImageType: The desired image type for the node pool. NOTE: Set the
      "desired_node_pool" field as well.
    desiredIntraNodeVisibilityConfig: The desired config of Intra-node
      visibility.
    desiredL4ilbSubsettingConfig: The desired L4 Internal Load Balancer
      Subsetting configuration.
    desiredLocations: The desired list of Google Compute Engine
      [zones](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster's nodes should be located. This list must always include the
      cluster's primary zone. Warning: changing cluster locations will update
      the locations of all node pools and will result in nodes being added
      and/or removed.
    desiredLoggingConfig: The desired logging configuration.
    desiredLoggingService: The logging service the cluster should use to write
      logs. Currently available options: * `logging.googleapis.com/kubernetes`
      - The Cloud Logging service with a Kubernetes-native resource model *
      `logging.googleapis.com` - The legacy Cloud Logging service (no longer
      available as of GKE 1.15). * `none` - no logs will be exported from the
      cluster. If left as an empty string,`logging.googleapis.com/kubernetes`
      will be used for GKE 1.14+ or `logging.googleapis.com` for earlier
      versions.
    desiredMasterAuthorizedNetworksConfig: The desired configuration options
      for master authorized networks feature.
    desiredMasterVersion: The Kubernetes version to change the master to.
      Users may specify either explicit versions offered by Kubernetes Engine
      or version aliases, which have the following behavior: - "latest": picks
      the highest valid Kubernetes version - "1.X": picks the highest valid
      patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid
      gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit
      Kubernetes version - "-": picks the default Kubernetes version
    desiredMeshCertificates: Configuration for issuance of mTLS keys and
      certificates to Kubernetes pods.
    desiredMonitoringConfig: The desired monitoring configuration.
    desiredMonitoringService: The monitoring service the cluster should use to
      write metrics. Currently available options: *
      "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring service
      with a Kubernetes-native resource model * `monitoring.googleapis.com` -
      The legacy Cloud Monitoring service (no longer available as of GKE
      1.15). * `none` - No metrics will be exported from the cluster. If left
      as an empty string,`monitoring.googleapis.com/kubernetes` will be used
      for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
    desiredNodePoolAutoscaling: Autoscaler configuration for the node pool
      specified in desired_node_pool_id. If there is only one pool in the
      cluster and desired_node_pool_id is not provided then the change applies
      to that single node pool.
    desiredNodePoolId: The node pool to be upgraded. This field is mandatory
      if "desired_node_version", "desired_image_family" or
      "desired_node_pool_autoscaling" is specified and there is more than one
      node pool on the cluster.
    desiredNodeVersion: The Kubernetes version to change the nodes to
      (typically an upgrade). Users may specify either explicit versions
      offered by Kubernetes Engine or version aliases, which have the
      following behavior: - "latest": picks the highest valid Kubernetes
      version - "1.X": picks the highest valid patch+gke.N patch in the 1.X
      version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y
      version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "-":
      picks the Kubernetes master version
    desiredNotificationConfig: The desired notification configuration.
    desiredPrivateClusterConfig: The desired private cluster configuration.
    desiredPrivateIpv6GoogleAccess: The desired state of IPv6 connectivity to
      Google Services.
    desiredReleaseChannel: The desired release channel configuration.
    desiredResourceUsageExportConfig: The desired configuration for exporting
      resource usage.
    desiredShieldedNodes: Configuration for Shielded Nodes.
    desiredVerticalPodAutoscaling: Cluster-level Vertical Pod Autoscaling
      configuration.
    desiredWorkloadIdentityConfig: Configuration for Workload Identity.
  """

  class DesiredDatapathProviderValueValuesEnum(_messages.Enum):
    r"""The desired datapath provider for the cluster.

    Values:
      DATAPATH_PROVIDER_UNSPECIFIED: Default value.
      LEGACY_DATAPATH: Use the IPTables implementation based on kube-proxy.
      ADVANCED_DATAPATH: Use the eBPF based GKE Dataplane V2 with additional
        features. See the [GKE Dataplane V2
        documentation](https://cloud.google.com/kubernetes-engine/docs/how-
        to/dataplane-v2) for more.
    """
    DATAPATH_PROVIDER_UNSPECIFIED = 0
    LEGACY_DATAPATH = 1
    ADVANCED_DATAPATH = 2

  class DesiredPrivateIpv6GoogleAccessValueValuesEnum(_messages.Enum):
    r"""The desired state of IPv6 connectivity to Google Services.

    Values:
      PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED: Default value. Same as DISABLED
      PRIVATE_IPV6_GOOGLE_ACCESS_DISABLED: No private access to or from Google
        Services
      PRIVATE_IPV6_GOOGLE_ACCESS_TO_GOOGLE: Enables private IPv6 access to
        Google Services from GKE
      PRIVATE_IPV6_GOOGLE_ACCESS_BIDIRECTIONAL: Enables priate IPv6 access to
        and from Google Services
    """
    PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED = 0
    PRIVATE_IPV6_GOOGLE_ACCESS_DISABLED = 1
    PRIVATE_IPV6_GOOGLE_ACCESS_TO_GOOGLE = 2
    PRIVATE_IPV6_GOOGLE_ACCESS_BIDIRECTIONAL = 3

  desiredAddonsConfig = _messages.MessageField('AddonsConfig', 1)
  desiredAuthenticatorGroupsConfig = _messages.MessageField('AuthenticatorGroupsConfig', 2)
  desiredAutopilot = _messages.MessageField('Autopilot', 3)
  desiredBinaryAuthorization = _messages.MessageField('BinaryAuthorization', 4)
  desiredClusterAutoscaling = _messages.MessageField('ClusterAutoscaling', 5)
  desiredDatabaseEncryption = _messages.MessageField('DatabaseEncryption', 6)
  desiredDatapathProvider = _messages.EnumField('DesiredDatapathProviderValueValuesEnum', 7)
  desiredDefaultSnatStatus = _messages.MessageField('DefaultSnatStatus', 8)
  desiredImage = _messages.StringField(9)
  desiredImageProject = _messages.StringField(10)
  desiredImageType = _messages.StringField(11)
  desiredIntraNodeVisibilityConfig = _messages.MessageField('IntraNodeVisibilityConfig', 12)
  desiredL4ilbSubsettingConfig = _messages.MessageField('ILBSubsettingConfig', 13)
  desiredLocations = _messages.StringField(14, repeated=True)
  desiredLoggingConfig = _messages.MessageField('LoggingConfig', 15)
  desiredLoggingService = _messages.StringField(16)
  desiredMasterAuthorizedNetworksConfig = _messages.MessageField('MasterAuthorizedNetworksConfig', 17)
  desiredMasterVersion = _messages.StringField(18)
  desiredMeshCertificates = _messages.MessageField('MeshCertificates', 19)
  desiredMonitoringConfig = _messages.MessageField('MonitoringConfig', 20)
  desiredMonitoringService = _messages.StringField(21)
  desiredNodePoolAutoscaling = _messages.MessageField('NodePoolAutoscaling', 22)
  desiredNodePoolId = _messages.StringField(23)
  desiredNodeVersion = _messages.StringField(24)
  desiredNotificationConfig = _messages.MessageField('NotificationConfig', 25)
  desiredPrivateClusterConfig = _messages.MessageField('PrivateClusterConfig', 26)
  desiredPrivateIpv6GoogleAccess = _messages.EnumField('DesiredPrivateIpv6GoogleAccessValueValuesEnum', 27)
  desiredReleaseChannel = _messages.MessageField('ReleaseChannel', 28)
  desiredResourceUsageExportConfig = _messages.MessageField('ResourceUsageExportConfig', 29)
  desiredShieldedNodes = _messages.MessageField('ShieldedNodes', 30)
  desiredVerticalPodAutoscaling = _messages.MessageField('VerticalPodAutoscaling', 31)
  desiredWorkloadIdentityConfig = _messages.MessageField('WorkloadIdentityConfig', 32)


class CompleteIPRotationRequest(_messages.Message):
  r"""CompleteIPRotationRequest moves the cluster master back into single-IP
  mode.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster id) of the cluster to complete
      IP rotation. Specified in the format
      `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class ConfidentialNodes(_messages.Message):
  r"""ConfidentialNodes is configuration for the confidential nodes feature,
  which makes nodes run on confidential VMs.

  Fields:
    enabled: Whether Confidential Nodes feature is enabled for all nodes in
      this cluster.
  """

  enabled = _messages.BooleanField(1)


class ConfigConnectorConfig(_messages.Message):
  r"""Configuration options for the Config Connector add-on.

  Fields:
    enabled: Whether Cloud Connector is enabled for this cluster.
  """

  enabled = _messages.BooleanField(1)


class ConsumptionMeteringConfig(_messages.Message):
  r"""Parameters for controlling consumption metering.

  Fields:
    enabled: Whether to enable consumption metering for this cluster. If
      enabled, a second BigQuery table will be created to hold resource
      consumption records.
  """

  enabled = _messages.BooleanField(1)


class ContainerProjectsAggregatedUsableSubnetworksListRequest(_messages.Message):
  r"""A ContainerProjectsAggregatedUsableSubnetworksListRequest object.

  Fields:
    filter: Filtering currently only supports equality on the networkProjectId
      and must be in the form: "networkProjectId=[PROJECTID]", where
      `networkProjectId` is the project which owns the listed subnetworks.
      This defaults to the parent project ID.
    pageSize: The max number of results per page that should be returned. If
      the number of available results is larger than `page_size`, a
      `next_page_token` is returned which can be used to get the next page of
      results in subsequent requests. Acceptable values are 0 to 500,
      inclusive. (Default: 500)
    pageToken: Specifies a page token to use. Set this to the nextPageToken
      returned by previous list requests to get the next page of results.
    parent: The parent project where subnetworks are usable. Specified in the
      format `projects/*`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ContainerProjectsLocationsClustersDeleteRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to delete. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to delete.
      Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsLocationsClustersGetJwksRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersGetJwksRequest object.

  Fields:
    parent: The cluster (project, location, cluster id) to get keys for.
      Specified in the format `projects/*/locations/*/clusters/*`.
  """

  parent = _messages.StringField(1, required=True)


class ContainerProjectsLocationsClustersGetRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to retrieve. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to retrieve.
      Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsLocationsClustersListRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersListRequest object.

  Fields:
    parent: The parent (project and location) where the clusters will be
      listed. Specified in the format `projects/*/locations/*`. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides, or "-" for all zones. This field has been
      deprecated and replaced by the parent field.
  """

  parent = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2)
  zone = _messages.StringField(3)


class ContainerProjectsLocationsClustersNodePoolsDeleteRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersNodePoolsDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to delete. Specified in the format
      `projects/*/locations/*/clusters/*/nodePools/*`.
    nodePoolId: Deprecated. The name of the node pool to delete. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  nodePoolId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class ContainerProjectsLocationsClustersNodePoolsGetRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersNodePoolsGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to get. Specified in the format
      `projects/*/locations/*/clusters/*/nodePools/*`.
    nodePoolId: Deprecated. The name of the node pool. This field has been
      deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  nodePoolId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class ContainerProjectsLocationsClustersNodePoolsListRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersNodePoolsListRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the parent field.
    parent: The parent (project, location, cluster id) where the node pools
      will be listed. Specified in the format
      `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      parent field.
  """

  clusterId = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsLocationsClustersWellKnownGetOpenidConfigurationRequest(_messages.Message):
  r"""A
  ContainerProjectsLocationsClustersWellKnownGetOpenidConfigurationRequest
  object.

  Fields:
    parent: The cluster (project, location, cluster id) to get the discovery
      document for. Specified in the format
      `projects/*/locations/*/clusters/*`.
  """

  parent = _messages.StringField(1, required=True)


class ContainerProjectsLocationsGetServerConfigRequest(_messages.Message):
  r"""A ContainerProjectsLocationsGetServerConfigRequest object.

  Fields:
    name: The name (project and location) of the server config to get,
      specified in the format `projects/*/locations/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) to return
      operations for. This field has been deprecated and replaced by the name
      field.
  """

  name = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2)
  zone = _messages.StringField(3)


class ContainerProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ContainerProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name (project, location, operation id) of the operation to get.
      Specified in the format `projects/*/locations/*/operations/*`.
    operationId: Deprecated. The server-assigned `name` of the operation. This
      field has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  name = _messages.StringField(1, required=True)
  operationId = _messages.StringField(2)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ContainerProjectsLocationsOperationsListRequest object.

  Fields:
    parent: The parent (project and location) where the operations will be
      listed. Specified in the format `projects/*/locations/*`. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) to return
      operations for, or `-` for all zones. This field has been deprecated and
      replaced by the parent field.
  """

  parent = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2)
  zone = _messages.StringField(3)


class ContainerProjectsZonesClustersDeleteRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to delete. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to delete.
      Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesClustersGetRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to retrieve. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to retrieve.
      Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesClustersListRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersListRequest object.

  Fields:
    parent: The parent (project and location) where the clusters will be
      listed. Specified in the format `projects/*/locations/*`. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides, or "-" for all zones. This field has been
      deprecated and replaced by the parent field.
  """

  parent = _messages.StringField(1)
  projectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ContainerProjectsZonesClustersNodePoolsDeleteRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersNodePoolsDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to delete. Specified in the format
      `projects/*/locations/*/clusters/*/nodePools/*`.
    nodePoolId: Deprecated. The name of the node pool to delete. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  nodePoolId = _messages.StringField(3, required=True)
  projectId = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ContainerProjectsZonesClustersNodePoolsGetRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersNodePoolsGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to get. Specified in the format
      `projects/*/locations/*/clusters/*/nodePools/*`.
    nodePoolId: Deprecated. The name of the node pool. This field has been
      deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  nodePoolId = _messages.StringField(3, required=True)
  projectId = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ContainerProjectsZonesClustersNodePoolsListRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersNodePoolsListRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the parent field.
    parent: The parent (project, location, cluster id) where the node pools
      will be listed. Specified in the format
      `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      parent field.
  """

  clusterId = _messages.StringField(1, required=True)
  parent = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesGetServerconfigRequest(_messages.Message):
  r"""A ContainerProjectsZonesGetServerconfigRequest object.

  Fields:
    name: The name (project and location) of the server config to get,
      specified in the format `projects/*/locations/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) to return
      operations for. This field has been deprecated and replaced by the name
      field.
  """

  name = _messages.StringField(1)
  projectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ContainerProjectsZonesOperationsGetRequest(_messages.Message):
  r"""A ContainerProjectsZonesOperationsGetRequest object.

  Fields:
    name: The name (project, location, operation id) of the operation to get.
      Specified in the format `projects/*/locations/*/operations/*`.
    operationId: Deprecated. The server-assigned `name` of the operation. This
      field has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  name = _messages.StringField(1)
  operationId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesOperationsListRequest(_messages.Message):
  r"""A ContainerProjectsZonesOperationsListRequest object.

  Fields:
    parent: The parent (project and location) where the operations will be
      listed. Specified in the format `projects/*/locations/*`. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) to return
      operations for, or `-` for all zones. This field has been deprecated and
      replaced by the parent field.
  """

  parent = _messages.StringField(1)
  projectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class CreateClusterRequest(_messages.Message):
  r"""CreateClusterRequest creates a cluster.

  Fields:
    cluster: Required. A [cluster
      resource](https://cloud.google.com/container-
      engine/reference/rest/v1/projects.locations.clusters)
    parent: The parent (project and location) where the cluster will be
      created. Specified in the format `projects/*/locations/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      parent field.
  """

  cluster = _messages.MessageField('Cluster', 1)
  parent = _messages.StringField(2)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class CreateNodePoolRequest(_messages.Message):
  r"""CreateNodePoolRequest creates a node pool for a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the parent field.
    nodePool: Required. The node pool to create.
    parent: The parent (project, location, cluster id) where the node pool
      will be created. Specified in the format
      `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      parent field.
  """

  clusterId = _messages.StringField(1)
  nodePool = _messages.MessageField('NodePool', 2)
  parent = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class CustomImageConfig(_messages.Message):
  r"""CustomImageConfig contains the information r

  Fields:
    image: The name of the image to use for this node.
    imageFamily: The name of the image family to use for this node.
    imageProject: The project containing the image to use for this node.
  """

  image = _messages.StringField(1)
  imageFamily = _messages.StringField(2)
  imageProject = _messages.StringField(3)


class DailyMaintenanceWindow(_messages.Message):
  r"""Time window specified for daily maintenance operations.

  Fields:
    duration: [Output only] Duration of the time window, automatically chosen
      to be smallest possible in the given scenario. Duration will be in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "PTnHnMnS".
    startTime: Time within the maintenance window to start the maintenance
      operations. Time format should be in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "HH:MM", where HH
      : [00-23] and MM : [00-59] GMT.
  """

  duration = _messages.StringField(1)
  startTime = _messages.StringField(2)


class DatabaseEncryption(_messages.Message):
  r"""Configuration of etcd encryption.

  Enums:
    StateValueValuesEnum: Denotes the state of etcd encryption.

  Fields:
    keyName: Name of CloudKMS key to use for the encryption of secrets in
      etcd. Ex. projects/my-project/locations/global/keyRings/my-
      ring/cryptoKeys/my-key
    state: Denotes the state of etcd encryption.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Denotes the state of etcd encryption.

    Values:
      UNKNOWN: Should never be set
      ENCRYPTED: Secrets in etcd are encrypted.
      DECRYPTED: Secrets in etcd are stored in plain text (at etcd level) -
        this is unrelated to Compute Engine level full disk encryption.
    """
    UNKNOWN = 0
    ENCRYPTED = 1
    DECRYPTED = 2

  keyName = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class DefaultSnatStatus(_messages.Message):
  r"""DefaultSnatStatus contains the desired state of whether default sNAT
  should be disabled on the cluster.

  Fields:
    disabled: Disables cluster default sNAT rules.
  """

  disabled = _messages.BooleanField(1)


class DnsCacheConfig(_messages.Message):
  r"""Configuration for NodeLocal DNSCache

  Fields:
    enabled: Whether NodeLocal DNSCache is enabled for this cluster.
  """

  enabled = _messages.BooleanField(1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class GcePersistentDiskCsiDriverConfig(_messages.Message):
  r"""Configuration for the Compute Engine PD CSI driver.

  Fields:
    enabled: Whether the Compute Engine PD CSI driver is enabled for this
      cluster.
  """

  enabled = _messages.BooleanField(1)


class GcpFilestoreCsiDriverConfig(_messages.Message):
  r"""Configuration for the GCP Filestore CSI driver.

  Fields:
    enabled: Whether the GCP Filestore CSI driver is enabled for this cluster.
  """

  enabled = _messages.BooleanField(1)


class GetJSONWebKeysResponse(_messages.Message):
  r"""GetJSONWebKeysResponse is a valid JSON Web Key Set as specififed in rfc
  7517

  Fields:
    cacheHeader: OnePlatform automatically extracts this field and uses it to
      set the HTTP Cache-Control header.
    keys: The public component of the keys used by the cluster to sign token
      requests.
  """

  cacheHeader = _messages.MessageField('HttpCacheControlResponseHeader', 1)
  keys = _messages.MessageField('Jwk', 2, repeated=True)


class GetOpenIDConfigResponse(_messages.Message):
  r"""GetOpenIDConfigResponse is an OIDC discovery document for the cluster.
  See the OpenID Connect Discovery 1.0 specification for details.

  Fields:
    cacheHeader: OnePlatform automatically extracts this field and uses it to
      set the HTTP Cache-Control header.
    claims_supported: Supported claims.
    grant_types: Supported grant types.
    id_token_signing_alg_values_supported: supported ID Token signing
      Algorithms.
    issuer: OIDC Issuer.
    jwks_uri: JSON Web Key uri.
    response_types_supported: Supported response types.
    subject_types_supported: Supported subject types.
  """

  cacheHeader = _messages.MessageField('HttpCacheControlResponseHeader', 1)
  claims_supported = _messages.StringField(2, repeated=True)
  grant_types = _messages.StringField(3, repeated=True)
  id_token_signing_alg_values_supported = _messages.StringField(4, repeated=True)
  issuer = _messages.StringField(5)
  jwks_uri = _messages.StringField(6)
  response_types_supported = _messages.StringField(7, repeated=True)
  subject_types_supported = _messages.StringField(8, repeated=True)


class HorizontalPodAutoscaling(_messages.Message):
  r"""Configuration options for the horizontal pod autoscaling feature, which
  increases or decreases the number of replica pods a replication controller
  has based on the resource usage of the existing pods.

  Fields:
    disabled: Whether the Horizontal Pod Autoscaling feature is enabled in the
      cluster. When enabled, it ensures that metrics are collected into
      Stackdriver Monitoring.
  """

  disabled = _messages.BooleanField(1)


class HttpCacheControlResponseHeader(_messages.Message):
  r"""RFC-2616: cache control support

  Fields:
    age: 14.6 response cache age, in seconds since the response is generated
    directive: 14.9 request and response directives
    expires: 14.21 response cache expires, in RFC 1123 date format
  """

  age = _messages.IntegerField(1)
  directive = _messages.StringField(2)
  expires = _messages.StringField(3)


class HttpLoadBalancing(_messages.Message):
  r"""Configuration options for the HTTP (L7) load balancing controller addon,
  which makes it easy to set up HTTP load balancers for services in a cluster.

  Fields:
    disabled: Whether the HTTP Load Balancing controller is enabled in the
      cluster. When enabled, it runs a small pod in the cluster that manages
      the load balancers.
  """

  disabled = _messages.BooleanField(1)


class ILBSubsettingConfig(_messages.Message):
  r"""ILBSubsettingConfig contains the desired config of L4 Internal
  LoadBalancer subsetting on this cluster.

  Fields:
    enabled: Enables l4 ILB subsetting for this cluster.
  """

  enabled = _messages.BooleanField(1)


class IPAllocationPolicy(_messages.Message):
  r"""Configuration for controlling how IPs are allocated in the cluster.

  Fields:
    clusterIpv4Cidr: This field is deprecated, use cluster_ipv4_cidr_block.
    clusterIpv4CidrBlock: The IP address range for the cluster pod IPs. If
      this field is set, then `cluster.cluster_ipv4_cidr` must be left blank.
      This field is only applicable when `use_ip_aliases` is true. Set to
      blank to have a range chosen with the default size. Set to /netmask
      (e.g. `/14`) to have a range chosen with a specific netmask. Set to a
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
      `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific
      range to use.
    clusterSecondaryRangeName: The name of the secondary range to be used for
      the cluster CIDR block. The secondary range will be used for pod IP
      addresses. This must be an existing secondary range associated with the
      cluster subnetwork. This field is only applicable with use_ip_aliases is
      true and create_subnetwork is false.
    createSubnetwork: Whether a new subnetwork will be created automatically
      for the cluster. This field is only applicable when `use_ip_aliases` is
      true.
    nodeIpv4Cidr: This field is deprecated, use node_ipv4_cidr_block.
    nodeIpv4CidrBlock: The IP address range of the instance IPs in this
      cluster. This is applicable only if `create_subnetwork` is true. Set to
      blank to have a range chosen with the default size. Set to /netmask
      (e.g. `/14`) to have a range chosen with a specific netmask. Set to a
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
      `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific
      range to use.
    servicesIpv4Cidr: This field is deprecated, use services_ipv4_cidr_block.
    servicesIpv4CidrBlock: The IP address range of the services IPs in this
      cluster. If blank, a range will be automatically chosen with the default
      size. This field is only applicable when `use_ip_aliases` is true. Set
      to blank to have a range chosen with the default size. Set to /netmask
      (e.g. `/14`) to have a range chosen with a specific netmask. Set to a
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
      `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific
      range to use.
    servicesSecondaryRangeName: The name of the secondary range to be used as
      for the services CIDR block. The secondary range will be used for
      service ClusterIPs. This must be an existing secondary range associated
      with the cluster subnetwork. This field is only applicable with
      use_ip_aliases is true and create_subnetwork is false.
    subnetworkName: A custom subnetwork name to be used if `create_subnetwork`
      is true. If this field is empty, then an automatic name will be chosen
      for the new subnetwork.
    tpuIpv4CidrBlock: The IP address range of the Cloud TPUs in this cluster.
      If unspecified, a range will be automatically chosen with the default
      size. This field is only applicable when `use_ip_aliases` is true. If
      unspecified, the range will use the default size. Set to /netmask (e.g.
      `/14`) to have a range chosen with a specific netmask. Set to a
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
      `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific
      range to use.
    useIpAliases: Whether alias IPs will be used for pod IPs in the cluster.
      This is used in conjunction with use_routes. It cannot be true if
      use_routes is true. If both use_ip_aliases and use_routes are false,
      then the server picks the default IP allocation mode
    useRoutes: Whether routes will be used for pod IPs in the cluster. This is
      used in conjunction with use_ip_aliases. It cannot be true if
      use_ip_aliases is true. If both use_ip_aliases and use_routes are false,
      then the server picks the default IP allocation mode
  """

  clusterIpv4Cidr = _messages.StringField(1)
  clusterIpv4CidrBlock = _messages.StringField(2)
  clusterSecondaryRangeName = _messages.StringField(3)
  createSubnetwork = _messages.BooleanField(4)
  nodeIpv4Cidr = _messages.StringField(5)
  nodeIpv4CidrBlock = _messages.StringField(6)
  servicesIpv4Cidr = _messages.StringField(7)
  servicesIpv4CidrBlock = _messages.StringField(8)
  servicesSecondaryRangeName = _messages.StringField(9)
  subnetworkName = _messages.StringField(10)
  tpuIpv4CidrBlock = _messages.StringField(11)
  useIpAliases = _messages.BooleanField(12)
  useRoutes = _messages.BooleanField(13)


class IntraNodeVisibilityConfig(_messages.Message):
  r"""IntraNodeVisibilityConfig contains the desired config of the intra-node
  visibility on this cluster.

  Fields:
    enabled: Enables intra node visibility for this cluster.
  """

  enabled = _messages.BooleanField(1)


class Jwk(_messages.Message):
  r"""Jwk is a JSON Web Key as specified in RFC 7517

  Fields:
    alg: Algorithm.
    crv: Used for ECDSA keys.
    e: Used for RSA keys.
    kid: Key ID.
    kty: Key Type.
    n: Used for RSA keys.
    use: Permitted uses for the public keys.
    x: Used for ECDSA keys.
    y: Used for ECDSA keys.
  """

  alg = _messages.StringField(1)
  crv = _messages.StringField(2)
  e = _messages.StringField(3)
  kid = _messages.StringField(4)
  kty = _messages.StringField(5)
  n = _messages.StringField(6)
  use = _messages.StringField(7)
  x = _messages.StringField(8)
  y = _messages.StringField(9)


class KubernetesDashboard(_messages.Message):
  r"""Configuration for the Kubernetes Dashboard.

  Fields:
    disabled: Whether the Kubernetes Dashboard is enabled for this cluster.
  """

  disabled = _messages.BooleanField(1)


class LegacyAbac(_messages.Message):
  r"""Configuration for the legacy Attribute Based Access Control
  authorization mode.

  Fields:
    enabled: Whether the ABAC authorizer is enabled for this cluster. When
      enabled, identities in the system, including service accounts, nodes,
      and controllers, will have statically granted permissions beyond those
      provided by the RBAC configuration or IAM.
  """

  enabled = _messages.BooleanField(1)


class LinuxNodeConfig(_messages.Message):
  r"""Parameters that can be configured on Linux nodes.

  Messages:
    SysctlsValue: The Linux kernel parameters to be applied to the nodes and
      all pods running on the nodes. The following parameters are supported.
      net.core.netdev_max_backlog net.core.rmem_max net.core.wmem_default
      net.core.wmem_max net.core.optmem_max net.core.somaxconn
      net.ipv4.tcp_rmem net.ipv4.tcp_wmem net.ipv4.tcp_tw_reuse

  Fields:
    sysctls: The Linux kernel parameters to be applied to the nodes and all
      pods running on the nodes. The following parameters are supported.
      net.core.netdev_max_backlog net.core.rmem_max net.core.wmem_default
      net.core.wmem_max net.core.optmem_max net.core.somaxconn
      net.ipv4.tcp_rmem net.ipv4.tcp_wmem net.ipv4.tcp_tw_reuse
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SysctlsValue(_messages.Message):
    r"""The Linux kernel parameters to be applied to the nodes and all pods
    running on the nodes. The following parameters are supported.
    net.core.netdev_max_backlog net.core.rmem_max net.core.wmem_default
    net.core.wmem_max net.core.optmem_max net.core.somaxconn net.ipv4.tcp_rmem
    net.ipv4.tcp_wmem net.ipv4.tcp_tw_reuse

    Messages:
      AdditionalProperty: An additional property for a SysctlsValue object.

    Fields:
      additionalProperties: Additional properties of type SysctlsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SysctlsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  sysctls = _messages.MessageField('SysctlsValue', 1)


class ListClustersResponse(_messages.Message):
  r"""ListClustersResponse is the result of ListClustersRequest.

  Fields:
    clusters: A list of clusters in the project in the specified zone, or
      across all ones.
    missingZones: If any zones are listed here, the list of clusters returned
      may be missing those zones.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  missingZones = _messages.StringField(2, repeated=True)


class ListNodePoolsResponse(_messages.Message):
  r"""ListNodePoolsResponse is the result of ListNodePoolsRequest.

  Fields:
    nodePools: A list of node pools for a cluster.
  """

  nodePools = _messages.MessageField('NodePool', 1, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""ListOperationsResponse is the result of ListOperationsRequest.

  Fields:
    missingZones: If any zones are listed here, the list of operations
      returned may be missing the operations from those zones.
    operations: A list of operations in the project in the specified zone.
  """

  missingZones = _messages.StringField(1, repeated=True)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListUsableSubnetworksResponse(_messages.Message):
  r"""ListUsableSubnetworksResponse is the response of
  ListUsableSubnetworksRequest.

  Fields:
    nextPageToken: This token allows you to get the next page of results for
      list requests. If the number of results is larger than `page_size`, use
      the `next_page_token` as a value for the query parameter `page_token` in
      the next request. The value will become empty when there are no more
      pages.
    subnetworks: A list of usable subnetworks in the specified network
      project.
  """

  nextPageToken = _messages.StringField(1)
  subnetworks = _messages.MessageField('UsableSubnetwork', 2, repeated=True)


class LoggingComponentConfig(_messages.Message):
  r"""LoggingComponentConfig is cluster logging component configuration.

  Enums:
    EnableComponentsValueListEntryValuesEnum:

  Fields:
    enableComponents: Select components to collect logs. An empty set would
      disable all logging.
  """

  class EnableComponentsValueListEntryValuesEnum(_messages.Enum):
    r"""EnableComponentsValueListEntryValuesEnum enum type.

    Values:
      COMPONENT_UNSPECIFIED: Default value. This shouldn't be used.
      SYSTEM_COMPONENTS: system components
      WORKLOADS: workloads
      APISERVER: kube-apiserver
      SCHEDULER: kube-scheduler
      CONTROLLER_MANAGER: kube-controller-manager
      ADDON_MANAGER: kube-addon-manager
    """
    COMPONENT_UNSPECIFIED = 0
    SYSTEM_COMPONENTS = 1
    WORKLOADS = 2
    APISERVER = 3
    SCHEDULER = 4
    CONTROLLER_MANAGER = 5
    ADDON_MANAGER = 6

  enableComponents = _messages.EnumField('EnableComponentsValueListEntryValuesEnum', 1, repeated=True)


class LoggingConfig(_messages.Message):
  r"""LoggingConfig is cluster logging configuration.

  Fields:
    componentConfig: Logging components configuration
  """

  componentConfig = _messages.MessageField('LoggingComponentConfig', 1)


class MaintenancePolicy(_messages.Message):
  r"""MaintenancePolicy defines the maintenance policy to be used for the
  cluster.

  Fields:
    resourceVersion: A hash identifying the version of this policy, so that
      updates to fields of the policy won't accidentally undo intermediate
      changes (and so that users of the API unaware of some fields won't
      accidentally remove other fields). Make a `get()` request to the cluster
      to get the current resource version and include it with requests to set
      the policy.
    window: Specifies the maintenance window in which maintenance may be
      performed.
  """

  resourceVersion = _messages.StringField(1)
  window = _messages.MessageField('MaintenanceWindow', 2)


class MaintenanceWindow(_messages.Message):
  r"""MaintenanceWindow defines the maintenance window to be used for the
  cluster.

  Messages:
    MaintenanceExclusionsValue: Exceptions to maintenance window. Non-
      emergency maintenance should not occur in these windows.

  Fields:
    dailyMaintenanceWindow: DailyMaintenanceWindow specifies a daily
      maintenance operation window.
    maintenanceExclusions: Exceptions to maintenance window. Non-emergency
      maintenance should not occur in these windows.
    recurringWindow: RecurringWindow specifies some number of recurring time
      periods for maintenance to occur. The time windows may be overlapping.
      If no maintenance windows are set, maintenance can occur at any time.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MaintenanceExclusionsValue(_messages.Message):
    r"""Exceptions to maintenance window. Non-emergency maintenance should not
    occur in these windows.

    Messages:
      AdditionalProperty: An additional property for a
        MaintenanceExclusionsValue object.

    Fields:
      additionalProperties: Additional properties of type
        MaintenanceExclusionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MaintenanceExclusionsValue object.

      Fields:
        key: Name of the additional property.
        value: A TimeWindow attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TimeWindow', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  dailyMaintenanceWindow = _messages.MessageField('DailyMaintenanceWindow', 1)
  maintenanceExclusions = _messages.MessageField('MaintenanceExclusionsValue', 2)
  recurringWindow = _messages.MessageField('RecurringTimeWindow', 3)


class MasterAuth(_messages.Message):
  r"""The authentication information for accessing the master endpoint.
  Authentication can be done using HTTP basic auth or using client
  certificates.

  Fields:
    clientCertificate: [Output only] Base64-encoded public certificate used by
      clients to authenticate to the cluster endpoint.
    clientCertificateConfig: Configuration for client certificate
      authentication on the cluster. For clusters before v1.12, if no
      configuration is specified, a client certificate is issued.
    clientKey: [Output only] Base64-encoded private key used by clients to
      authenticate to the cluster endpoint.
    clusterCaCertificate: [Output only] Base64-encoded public certificate that
      is the root of trust for the cluster.
    password: The password to use for HTTP basic authentication to the master
      endpoint. Because the master endpoint is open to the Internet, you
      should create a strong password. If a password is provided for cluster
      creation, username must be non-empty. Warning: basic authentication is
      deprecated, and will be removed in GKE control plane versions 1.19 and
      newer. For a list of recommended authentication methods, see:
      https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-
      authentication
    username: The username to use for HTTP basic authentication to the master
      endpoint. For clusters v1.6.0 and later, basic authentication can be
      disabled by leaving username unspecified (or setting it to the empty
      string). Warning: basic authentication is deprecated, and will be
      removed in GKE control plane versions 1.19 and newer. For a list of
      recommended authentication methods, see:
      https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-
      authentication
  """

  clientCertificate = _messages.StringField(1)
  clientCertificateConfig = _messages.MessageField('ClientCertificateConfig', 2)
  clientKey = _messages.StringField(3)
  clusterCaCertificate = _messages.StringField(4)
  password = _messages.StringField(5)
  username = _messages.StringField(6)


class MasterAuthorizedNetworksConfig(_messages.Message):
  r"""Configuration options for the master authorized networks feature.
  Enabled master authorized networks will disallow all external traffic to
  access Kubernetes master through HTTPS except traffic from the given CIDR
  blocks, Google Compute Engine Public IPs and Google Prod IPs.

  Fields:
    cidrBlocks: cidr_blocks define up to 50 external networks that could
      access Kubernetes master through HTTPS.
    enabled: Whether or not master authorized networks is enabled.
  """

  cidrBlocks = _messages.MessageField('CidrBlock', 1, repeated=True)
  enabled = _messages.BooleanField(2)


class MaxPodsConstraint(_messages.Message):
  r"""Constraints applied to pods.

  Fields:
    maxPodsPerNode: Constraint enforced on the max num of pods per node.
  """

  maxPodsPerNode = _messages.IntegerField(1)


class MeshCertificates(_messages.Message):
  r"""Configuration for issuance of mTLS keys and certificates to Kubernetes
  pods.

  Fields:
    enableCertificates: enable_certificates controls issuance of workload mTLS
      certificates. If set, the GKE Workload Identity Certificates controller
      and node agent will be deployed in the cluster, which can then be
      configured by creating a WorkloadCertificateConfig Custom Resource.
      Requires Workload Identity (workload_pool must be non-empty).
  """

  enableCertificates = _messages.BooleanField(1)


class Metric(_messages.Message):
  r"""Progress metric is (string, int|float|string) pair.

  Fields:
    doubleValue: For metrics with floating point value.
    intValue: For metrics with integer value.
    name: Required. Metric name, e.g., "nodes total", "percent done".
    stringValue: For metrics with custom values (ratios, visual progress,
      etc.).
  """

  doubleValue = _messages.FloatField(1)
  intValue = _messages.IntegerField(2)
  name = _messages.StringField(3)
  stringValue = _messages.StringField(4)


class MonitoringComponentConfig(_messages.Message):
  r"""MonitoringComponentConfig is cluster monitoring component configuration.

  Enums:
    EnableComponentsValueListEntryValuesEnum:

  Fields:
    enableComponents: Select components to collect metrics. An empty set would
      disable all monitoring.
  """

  class EnableComponentsValueListEntryValuesEnum(_messages.Enum):
    r"""EnableComponentsValueListEntryValuesEnum enum type.

    Values:
      COMPONENT_UNSPECIFIED: Default value. This shouldn't be used.
      SYSTEM_COMPONENTS: system components
      WORKLOADS: workloads
      APISERVER: kube-apiserver
      SCHEDULER: kube-scheduler
      CONTROLLER_MANAGER: kube-controller-manager
    """
    COMPONENT_UNSPECIFIED = 0
    SYSTEM_COMPONENTS = 1
    WORKLOADS = 2
    APISERVER = 3
    SCHEDULER = 4
    CONTROLLER_MANAGER = 5

  enableComponents = _messages.EnumField('EnableComponentsValueListEntryValuesEnum', 1, repeated=True)


class MonitoringConfig(_messages.Message):
  r"""MonitoringConfig is cluster monitoring configuration.

  Fields:
    componentConfig: Monitoring components configuration
  """

  componentConfig = _messages.MessageField('MonitoringComponentConfig', 1)


class NetworkConfig(_messages.Message):
  r"""NetworkConfig reports the relative names of network & subnetwork.

  Enums:
    DatapathProviderValueValuesEnum: The desired datapath provider for this
      cluster. By default, uses the IPTables-based kube-proxy implementation.
    PrivateIpv6GoogleAccessValueValuesEnum: The desired state of IPv6
      connectivity to Google Services. By default, no private IPv6 access to
      or from Google Services (all access will be via IPv4)

  Fields:
    datapathProvider: The desired datapath provider for this cluster. By
      default, uses the IPTables-based kube-proxy implementation.
    defaultSnatStatus: Whether the cluster disables default in-node sNAT
      rules. In-node sNAT rules will be disabled when default_snat_status is
      disabled. When disabled is set to false, default IP masquerade rules
      will be applied to the nodes to prevent sNAT on cluster internal
      traffic.
    enableIntraNodeVisibility: Whether Intra-node visibility is enabled for
      this cluster. This makes same node pod to pod traffic visible for VPC
      network.
    enableL4ilbSubsetting: Whether L4ILB Subsetting is enabled for this
      cluster.
    network: Output only. The relative name of the Google Compute Engine
      network(https://cloud.google.com/compute/docs/networks-and-
      firewalls#networks) to which the cluster is connected. Example:
      projects/my-project/global/networks/my-network
    privateIpv6GoogleAccess: The desired state of IPv6 connectivity to Google
      Services. By default, no private IPv6 access to or from Google Services
      (all access will be via IPv4)
    subnetwork: Output only. The relative name of the Google Compute Engine
      [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
      cluster is connected. Example: projects/my-project/regions/us-
      central1/subnetworks/my-subnet
  """

  class DatapathProviderValueValuesEnum(_messages.Enum):
    r"""The desired datapath provider for this cluster. By default, uses the
    IPTables-based kube-proxy implementation.

    Values:
      DATAPATH_PROVIDER_UNSPECIFIED: Default value.
      LEGACY_DATAPATH: Use the IPTables implementation based on kube-proxy.
      ADVANCED_DATAPATH: Use the eBPF based GKE Dataplane V2 with additional
        features. See the [GKE Dataplane V2
        documentation](https://cloud.google.com/kubernetes-engine/docs/how-
        to/dataplane-v2) for more.
    """
    DATAPATH_PROVIDER_UNSPECIFIED = 0
    LEGACY_DATAPATH = 1
    ADVANCED_DATAPATH = 2

  class PrivateIpv6GoogleAccessValueValuesEnum(_messages.Enum):
    r"""The desired state of IPv6 connectivity to Google Services. By default,
    no private IPv6 access to or from Google Services (all access will be via
    IPv4)

    Values:
      PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED: Default value. Same as DISABLED
      PRIVATE_IPV6_GOOGLE_ACCESS_DISABLED: No private access to or from Google
        Services
      PRIVATE_IPV6_GOOGLE_ACCESS_TO_GOOGLE: Enables private IPv6 access to
        Google Services from GKE
      PRIVATE_IPV6_GOOGLE_ACCESS_BIDIRECTIONAL: Enables priate IPv6 access to
        and from Google Services
    """
    PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED = 0
    PRIVATE_IPV6_GOOGLE_ACCESS_DISABLED = 1
    PRIVATE_IPV6_GOOGLE_ACCESS_TO_GOOGLE = 2
    PRIVATE_IPV6_GOOGLE_ACCESS_BIDIRECTIONAL = 3

  datapathProvider = _messages.EnumField('DatapathProviderValueValuesEnum', 1)
  defaultSnatStatus = _messages.MessageField('DefaultSnatStatus', 2)
  enableIntraNodeVisibility = _messages.BooleanField(3)
  enableL4ilbSubsetting = _messages.BooleanField(4)
  network = _messages.StringField(5)
  privateIpv6GoogleAccess = _messages.EnumField('PrivateIpv6GoogleAccessValueValuesEnum', 6)
  subnetwork = _messages.StringField(7)


class NetworkPolicy(_messages.Message):
  r"""Configuration options for the NetworkPolicy feature.
  https://kubernetes.io/docs/concepts/services-networking/networkpolicies/

  Enums:
    ProviderValueValuesEnum: The selected network policy provider.

  Fields:
    enabled: Whether network policy is enabled on the cluster.
    provider: The selected network policy provider.
  """

  class ProviderValueValuesEnum(_messages.Enum):
    r"""The selected network policy provider.

    Values:
      PROVIDER_UNSPECIFIED: Not set
      CALICO: Tigera (Calico Felix).
    """
    PROVIDER_UNSPECIFIED = 0
    CALICO = 1

  enabled = _messages.BooleanField(1)
  provider = _messages.EnumField('ProviderValueValuesEnum', 2)


class NetworkPolicyConfig(_messages.Message):
  r"""Configuration for NetworkPolicy. This only tracks whether the addon is
  enabled or not on the Master, it does not track whether network policy is
  enabled for the nodes.

  Fields:
    disabled: Whether NetworkPolicy is enabled for this cluster.
  """

  disabled = _messages.BooleanField(1)


class NodeConfig(_messages.Message):
  r"""Parameters that describe the nodes in a cluster.

  Messages:
    LabelsValue: The map of Kubernetes labels (key/value pairs) to be applied
      to each node. These will added in addition to any default label(s) that
      Kubernetes may apply to the node. In case of conflict in label keys, the
      applied set may differ depending on the Kubernetes version -- it's best
      to assume the behavior is undefined and conflicts should be avoided. For
      more information, including usage and the valid values, see:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/labels/
    MetadataValue: The metadata key/value pairs assigned to instances in the
      cluster. Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less
      than 128 bytes in length. These are reflected as part of a URL in the
      metadata server. Additionally, to avoid ambiguity, keys must not
      conflict with any other metadata keys for the project or be one of the
      reserved keys: - "cluster-location" - "cluster-name" - "cluster-uid" -
      "configure-sh" - "containerd-configure-sh" - "enable-os-login" - "gci-
      ensure-gke-docker" - "gci-metrics-enabled" - "gci-update-strategy" -
      "instance-template" - "kube-env" - "startup-script" - "user-data" -
      "disable-address-manager" - "windows-startup-script-ps1" - "common-psm1"
      - "k8s-node-setup-psm1" - "install-ssh-psm1" - "user-profile-psm1"
      Values are free-form strings, and only have meaning as interpreted by
      the image running in the instance. The only restriction placed on them
      is that each value's size must be less than or equal to 32 KB. The total
      size of all keys and values must be less than 512 KB.

  Fields:
    accelerators: A list of hardware accelerators to be attached to each node.
      See https://cloud.google.com/compute/docs/gpus for more information
      about support for GPUs.
    bootDiskKmsKey:  The Customer Managed Encryption Key used to encrypt the
      boot disk attached to each node in the node pool. This should be of the
      form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]
      /cryptoKeys/[KEY_NAME]. For more information about protecting resources
      with Cloud KMS Keys please see:
      https://cloud.google.com/compute/docs/disks/customer-managed-encryption
    diskSizeGb: Size of the disk attached to each node, specified in GB. The
      smallest allowed disk size is 10GB. If unspecified, the default disk
      size is 100GB.
    diskType: Type of the disk attached to each node (e.g. 'pd-standard', 'pd-
      ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-
      standard'
    gvnic: Enable or disable gvnic in the node pool.
    imageType: The image type to use for this node. Note that for a given
      image type, the latest version of it will be used.
    kubeletConfig: Node kubelet configs.
    labels: The map of Kubernetes labels (key/value pairs) to be applied to
      each node. These will added in addition to any default label(s) that
      Kubernetes may apply to the node. In case of conflict in label keys, the
      applied set may differ depending on the Kubernetes version -- it's best
      to assume the behavior is undefined and conflicts should be avoided. For
      more information, including usage and the valid values, see:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/labels/
    linuxNodeConfig: Parameters that can be configured on Linux nodes.
    localSsdCount: The number of local SSD disks to be attached to the node.
      The limit for this value is dependent upon the maximum number of disks
      available on a machine per zone. See:
      https://cloud.google.com/compute/docs/disks/local-ssd for more
      information.
    machineType: The name of a Google Compute Engine [machine
      type](https://cloud.google.com/compute/docs/machine-types) If
      unspecified, the default machine type is `e2-medium`.
    metadata: The metadata key/value pairs assigned to instances in the
      cluster. Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less
      than 128 bytes in length. These are reflected as part of a URL in the
      metadata server. Additionally, to avoid ambiguity, keys must not
      conflict with any other metadata keys for the project or be one of the
      reserved keys: - "cluster-location" - "cluster-name" - "cluster-uid" -
      "configure-sh" - "containerd-configure-sh" - "enable-os-login" - "gci-
      ensure-gke-docker" - "gci-metrics-enabled" - "gci-update-strategy" -
      "instance-template" - "kube-env" - "startup-script" - "user-data" -
      "disable-address-manager" - "windows-startup-script-ps1" - "common-psm1"
      - "k8s-node-setup-psm1" - "install-ssh-psm1" - "user-profile-psm1"
      Values are free-form strings, and only have meaning as interpreted by
      the image running in the instance. The only restriction placed on them
      is that each value's size must be less than or equal to 32 KB. The total
      size of all keys and values must be less than 512 KB.
    minCpuPlatform: Minimum CPU platform to be used by this instance. The
      instance may be scheduled on the specified or newer CPU platform.
      Applicable values are the friendly names of CPU platforms, such as
      `minCpuPlatform: "Intel Haswell"` or `minCpuPlatform: "Intel Sandy
      Bridge"`. For more information, read [how to specify min CPU
      platform](https://cloud.google.com/compute/docs/instances/specify-min-
      cpu-platform)
    nodeGroup: Setting this field will assign instances of this pool to run on
      the specified node group. This is useful for running workloads on [sole
      tenant nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-
      nodes).
    nodeImageConfig: The node image configuration to use for this node pool.
      Note that this is only applicable for node pools using
      image_type=CUSTOM.
    oauthScopes: The set of Google API scopes to be made available on all of
      the node VMs under the "default" service account. The following scopes
      are recommended, but not required, and by default are not included: *
      `https://www.googleapis.com/auth/compute` is required for mounting
      persistent storage on your nodes. *
      `https://www.googleapis.com/auth/devstorage.read_only` is required for
      communicating with **gcr.io** (the [Google Container
      Registry](https://cloud.google.com/container-registry/)). If
      unspecified, no scopes are added, unless Cloud Logging or Cloud
      Monitoring are enabled, in which case their required scopes will be
      added.
    preemptible: Whether the nodes are created as preemptible VM instances.
      See: https://cloud.google.com/compute/docs/instances/preemptible for
      more information about preemptible VM instances.
    reservationAffinity: The optional reservation affinity. Setting this field
      will apply the specified [Zonal Compute
      Reservation](https://cloud.google.com/compute/docs/instances/reserving-
      zonal-resources) to this node pool.
    sandboxConfig: Sandbox configuration for this node.
    serviceAccount: The Google Cloud Platform Service Account to be used by
      the node VMs. Specify the email address of the Service Account;
      otherwise, if no Service Account is specified, the "default" service
      account is used.
    shieldedInstanceConfig: Shielded Instance options.
    tags: The list of instance tags applied to all nodes. Tags are used to
      identify valid sources or targets for network firewalls and are
      specified by the client during cluster or node pool creation. Each tag
      within the list must comply with RFC1035.
    taints: List of kubernetes taints to be applied to each node. For more
      information, including usage and the valid values, see:
      https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
    workloadMetadataConfig: The workload metadata configuration for this node.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The map of Kubernetes labels (key/value pairs) to be applied to each
    node. These will added in addition to any default label(s) that Kubernetes
    may apply to the node. In case of conflict in label keys, the applied set
    may differ depending on the Kubernetes version -- it's best to assume the
    behavior is undefined and conflicts should be avoided. For more
    information, including usage and the valid values, see:
    https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""The metadata key/value pairs assigned to instances in the cluster.
    Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128
    bytes in length. These are reflected as part of a URL in the metadata
    server. Additionally, to avoid ambiguity, keys must not conflict with any
    other metadata keys for the project or be one of the reserved keys: -
    "cluster-location" - "cluster-name" - "cluster-uid" - "configure-sh" -
    "containerd-configure-sh" - "enable-os-login" - "gci-ensure-gke-docker" -
    "gci-metrics-enabled" - "gci-update-strategy" - "instance-template" -
    "kube-env" - "startup-script" - "user-data" - "disable-address-manager" -
    "windows-startup-script-ps1" - "common-psm1" - "k8s-node-setup-psm1" -
    "install-ssh-psm1" - "user-profile-psm1" Values are free-form strings, and
    only have meaning as interpreted by the image running in the instance. The
    only restriction placed on them is that each value's size must be less
    than or equal to 32 KB. The total size of all keys and values must be less
    than 512 KB.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Additional properties of type MetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accelerators = _messages.MessageField('AcceleratorConfig', 1, repeated=True)
  bootDiskKmsKey = _messages.StringField(2)
  diskSizeGb = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  diskType = _messages.StringField(4)
  gvnic = _messages.MessageField('VirtualNIC', 5)
  imageType = _messages.StringField(6)
  kubeletConfig = _messages.MessageField('NodeKubeletConfig', 7)
  labels = _messages.MessageField('LabelsValue', 8)
  linuxNodeConfig = _messages.MessageField('LinuxNodeConfig', 9)
  localSsdCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  machineType = _messages.StringField(11)
  metadata = _messages.MessageField('MetadataValue', 12)
  minCpuPlatform = _messages.StringField(13)
  nodeGroup = _messages.StringField(14)
  nodeImageConfig = _messages.MessageField('CustomImageConfig', 15)
  oauthScopes = _messages.StringField(16, repeated=True)
  preemptible = _messages.BooleanField(17)
  reservationAffinity = _messages.MessageField('ReservationAffinity', 18)
  sandboxConfig = _messages.MessageField('SandboxConfig', 19)
  serviceAccount = _messages.StringField(20)
  shieldedInstanceConfig = _messages.MessageField('ShieldedInstanceConfig', 21)
  tags = _messages.StringField(22, repeated=True)
  taints = _messages.MessageField('NodeTaint', 23, repeated=True)
  workloadMetadataConfig = _messages.MessageField('WorkloadMetadataConfig', 24)


class NodeKubeletConfig(_messages.Message):
  r"""Node kubelet configs.

  Fields:
    cpuCfsQuota: Enable CPU CFS quota enforcement for containers that specify
      CPU limits. This option is enabled by default which makes kubelet use
      CFS quota (https://www.kernel.org/doc/Documentation/scheduler/sched-
      bwc.txt) to enforce container CPU limits. Otherwise, CPU limits will not
      be enforced at all. Disable this option to mitigate CPU throttling
      problems while still having your pods to be in Guaranteed QoS class by
      specifying the CPU limits. The default value is 'true' if unspecified.
    cpuCfsQuotaPeriod: Set the CPU CFS quota period value 'cpu.cfs_period_us'.
      The string must be a sequence of decimal numbers, each with optional
      fraction and a unit suffix, such as "300ms". Valid time units are "ns",
      "us" (or "\xb5s"), "ms", "s", "m", "h". The value must be a positive
      duration.
    cpuManagerPolicy: Control the CPU management policy on the node. See
      https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-
      policies/ The following values are allowed. - "none": the default, which
      represents the existing scheduling behavior. - "static": allows pods
      with certain resource characteristics to be granted increased CPU
      affinity and exclusivity on the node. The default value is 'none' if
      unspecified.
  """

  cpuCfsQuota = _messages.BooleanField(1)
  cpuCfsQuotaPeriod = _messages.StringField(2)
  cpuManagerPolicy = _messages.StringField(3)


class NodeManagement(_messages.Message):
  r"""NodeManagement defines the set of node management services turned on for
  the node pool.

  Fields:
    autoRepair: A flag that specifies whether the node auto-repair is enabled
      for the node pool. If enabled, the nodes in this node pool will be
      monitored and, if they fail health checks too many times, an automatic
      repair action will be triggered.
    autoUpgrade: A flag that specifies whether node auto-upgrade is enabled
      for the node pool. If enabled, node auto-upgrade helps keep the nodes in
      your node pool up to date with the latest release version of Kubernetes.
    upgradeOptions: Specifies the Auto Upgrade knobs for the node pool.
  """

  autoRepair = _messages.BooleanField(1)
  autoUpgrade = _messages.BooleanField(2)
  upgradeOptions = _messages.MessageField('AutoUpgradeOptions', 3)


class NodeNetworkConfig(_messages.Message):
  r"""Parameters for node pool-level network config.

  Fields:
    createPodRange: Input only. Whether to create a new range for pod IPs in
      this node pool. Defaults are provided for `pod_range` and
      `pod_ipv4_cidr_block` if they are not specified. If neither
      `create_pod_range` or `pod_range` are specified, the cluster-level
      default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is used. Only
      applicable if `ip_allocation_policy.use_ip_aliases` is true. This field
      cannot be changed after the node pool has been created.
    podIpv4CidrBlock: The IP address range for pod IPs in this node pool. Only
      applicable if `create_pod_range` is true. Set to blank to have a range
      chosen with the default size. Set to /netmask (e.g. `/14`) to have a
      range chosen with a specific netmask. Set to a
      [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) to pick a specific range to use. Only
      applicable if `ip_allocation_policy.use_ip_aliases` is true. This field
      cannot be changed after the node pool has been created.
    podRange: The ID of the secondary range for pod IPs. If `create_pod_range`
      is true, this ID is used for the new range. If `create_pod_range` is
      false, uses an existing secondary range with this ID. Only applicable if
      `ip_allocation_policy.use_ip_aliases` is true. This field cannot be
      changed after the node pool has been created.
  """

  createPodRange = _messages.BooleanField(1)
  podIpv4CidrBlock = _messages.StringField(2)
  podRange = _messages.StringField(3)


class NodePool(_messages.Message):
  r"""NodePool contains the name and configuration for a cluster's node pool.
  Node pools are a set of nodes (i.e. VM's), with a common configuration and
  specification, under the control of the cluster master. They may have a set
  of Kubernetes labels applied to them, which may be used to reference them
  during pod scheduling. They may also be resized up or down, to accommodate
  the workload.

  Enums:
    StatusValueValuesEnum: [Output only] The status of the nodes in this pool
      instance.

  Fields:
    autoscaling: Autoscaler configuration for this NodePool. Autoscaler is
      enabled only if a valid configuration is present.
    conditions: Which conditions caused the current node pool state.
    config: The node configuration of the pool.
    initialNodeCount: The initial node count for the pool. You must ensure
      that your Compute Engine [resource
      quota](https://cloud.google.com/compute/quotas) is sufficient for this
      number of instances. You must also have available firewall and routes
      quota.
    instanceGroupUrls: [Output only] The resource URLs of the [managed
      instance groups](https://cloud.google.com/compute/docs/instance-
      groups/creating-groups-of-managed-instances) associated with this node
      pool.
    locations: The list of Google Compute Engine
      [zones](https://cloud.google.com/compute/docs/zones#available) in which
      the NodePool's nodes should be located. If this value is unspecified
      during node pool creation, the
      [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/refe
      rence/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
      value will be used, instead. Warning: changing node pool locations will
      result in nodes being added and/or removed.
    management: NodeManagement configuration for this NodePool.
    maxPodsConstraint: The constraint on the maximum number of pods that can
      be run simultaneously on a node in the node pool.
    name: The name of the node pool.
    networkConfig: Networking configuration for this NodePool. If specified,
      it overrides the cluster-level defaults.
    podIpv4CidrSize: [Output only] The pod CIDR block size per node in this
      node pool.
    selfLink: [Output only] Server-defined URL for the resource.
    status: [Output only] The status of the nodes in this pool instance.
    statusMessage: [Output only] Deprecated. Use conditions instead.
      Additional information about the current status of this node pool
      instance, if available.
    upgradeSettings: Upgrade settings control disruption and speed of the
      upgrade.
    version: The version of the Kubernetes of this node.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output only] The status of the nodes in this pool instance.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the node pool is being
        created.
      RUNNING: The RUNNING state indicates the node pool has been created and
        is fully usable.
      RUNNING_WITH_ERROR: The RUNNING_WITH_ERROR state indicates the node pool
        has been created and is partially usable. Some error state has
        occurred and some functionality may be impaired. Customer may need to
        reissue a request or trigger a new update.
      RECONCILING: The RECONCILING state indicates that some work is actively
        being done on the node pool, such as upgrading node software. Details
        can be found in the `statusMessage` field.
      STOPPING: The STOPPING state indicates the node pool is being deleted.
      ERROR: The ERROR state indicates the node pool may be unusable. Details
        can be found in the `statusMessage` field.
    """
    STATUS_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RUNNING_WITH_ERROR = 3
    RECONCILING = 4
    STOPPING = 5
    ERROR = 6

  autoscaling = _messages.MessageField('NodePoolAutoscaling', 1)
  conditions = _messages.MessageField('StatusCondition', 2, repeated=True)
  config = _messages.MessageField('NodeConfig', 3)
  initialNodeCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  instanceGroupUrls = _messages.StringField(5, repeated=True)
  locations = _messages.StringField(6, repeated=True)
  management = _messages.MessageField('NodeManagement', 7)
  maxPodsConstraint = _messages.MessageField('MaxPodsConstraint', 8)
  name = _messages.StringField(9)
  networkConfig = _messages.MessageField('NodeNetworkConfig', 10)
  podIpv4CidrSize = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  selfLink = _messages.StringField(12)
  status = _messages.EnumField('StatusValueValuesEnum', 13)
  statusMessage = _messages.StringField(14)
  upgradeSettings = _messages.MessageField('UpgradeSettings', 15)
  version = _messages.StringField(16)


class NodePoolAutoscaling(_messages.Message):
  r"""NodePoolAutoscaling contains information required by cluster autoscaler
  to adjust the size of the node pool to the current cluster usage.

  Fields:
    autoprovisioned: Can this node pool be deleted automatically.
    enabled: Is autoscaling enabled for this node pool.
    maxNodeCount: Maximum number of nodes for one location in the NodePool.
      Must be >= min_node_count. There has to be enough quota to scale up the
      cluster.
    minNodeCount: Minimum number of nodes for one location in the NodePool.
      Must be >= 1 and <= max_node_count.
  """

  autoprovisioned = _messages.BooleanField(1)
  enabled = _messages.BooleanField(2)
  maxNodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class NodeTaint(_messages.Message):
  r"""Kubernetes taint is comprised of three fields: key, value, and effect.
  Effect can only be one of three types: NoSchedule, PreferNoSchedule or
  NoExecute. See
  [here](https://kubernetes.io/docs/concepts/configuration/taint-and-
  toleration) for more information, including usage and the valid values.

  Enums:
    EffectValueValuesEnum: Effect for taint.

  Fields:
    effect: Effect for taint.
    key: Key for taint.
    value: Value for taint.
  """

  class EffectValueValuesEnum(_messages.Enum):
    r"""Effect for taint.

    Values:
      EFFECT_UNSPECIFIED: Not set
      NO_SCHEDULE: NoSchedule
      PREFER_NO_SCHEDULE: PreferNoSchedule
      NO_EXECUTE: NoExecute
    """
    EFFECT_UNSPECIFIED = 0
    NO_SCHEDULE = 1
    PREFER_NO_SCHEDULE = 2
    NO_EXECUTE = 3

  effect = _messages.EnumField('EffectValueValuesEnum', 1)
  key = _messages.StringField(2)
  value = _messages.StringField(3)


class NotificationConfig(_messages.Message):
  r"""NotificationConfig is the configuration of notifications.

  Fields:
    pubsub: Notification config for Pub/Sub.
  """

  pubsub = _messages.MessageField('PubSub', 1)


class Operation(_messages.Message):
  r"""This operation resource represents operations that may have happened or
  are happening on the cluster. All fields are output only.

  Enums:
    OperationTypeValueValuesEnum: The operation type.
    StatusValueValuesEnum: The current status of the operation.

  Fields:
    clusterConditions: Which conditions caused the current cluster state.
      Deprecated. Use field error instead.
    detail: Detailed operation progress, if available.
    endTime: [Output only] The time the operation completed, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    error: The error result of the operation in case of failure.
    location: [Output only] The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/regions-zones/regions-
      zones#available) or
      [region](https://cloud.google.com/compute/docs/regions-zones/regions-
      zones#available) in which the cluster resides.
    name: The server-assigned ID for the operation.
    nodepoolConditions: Which conditions caused the current node pool state.
      Deprecated. Use field error instead.
    operationType: The operation type.
    progress: Output only. [Output only] Progress information for an
      operation.
    selfLink: Server-defined URL for the resource.
    startTime: [Output only] The time the operation started, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    status: The current status of the operation.
    statusMessage: Output only. If an error has occurred, a textual
      description of the error. Deprecated. Use the field error instead.
    targetLink: Server-defined URL for the target of the operation.
    zone: The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the operation is taking place. This field is deprecated, use location
      instead.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The operation type.

    Values:
      TYPE_UNSPECIFIED: Not set.
      CREATE_CLUSTER: Cluster create.
      DELETE_CLUSTER: Cluster delete.
      UPGRADE_MASTER: A master upgrade.
      UPGRADE_NODES: A node upgrade.
      REPAIR_CLUSTER: Cluster repair.
      UPDATE_CLUSTER: Cluster update.
      CREATE_NODE_POOL: Node pool create.
      DELETE_NODE_POOL: Node pool delete.
      SET_NODE_POOL_MANAGEMENT: Set node pool management.
      AUTO_REPAIR_NODES: Automatic node pool repair.
      AUTO_UPGRADE_NODES: Automatic node upgrade.
      SET_LABELS: Set labels.
      SET_MASTER_AUTH: Set/generate master auth materials
      SET_NODE_POOL_SIZE: Set node pool size.
      SET_NETWORK_POLICY: Updates network policy for a cluster.
      SET_MAINTENANCE_POLICY: Set the maintenance policy.
    """
    TYPE_UNSPECIFIED = 0
    CREATE_CLUSTER = 1
    DELETE_CLUSTER = 2
    UPGRADE_MASTER = 3
    UPGRADE_NODES = 4
    REPAIR_CLUSTER = 5
    UPDATE_CLUSTER = 6
    CREATE_NODE_POOL = 7
    DELETE_NODE_POOL = 8
    SET_NODE_POOL_MANAGEMENT = 9
    AUTO_REPAIR_NODES = 10
    AUTO_UPGRADE_NODES = 11
    SET_LABELS = 12
    SET_MASTER_AUTH = 13
    SET_NODE_POOL_SIZE = 14
    SET_NETWORK_POLICY = 15
    SET_MAINTENANCE_POLICY = 16

  class StatusValueValuesEnum(_messages.Enum):
    r"""The current status of the operation.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PENDING: The operation has been created.
      RUNNING: The operation is currently running.
      DONE: The operation is done, either cancelled or completed.
      ABORTING: The operation is aborting.
    """
    STATUS_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3
    ABORTING = 4

  clusterConditions = _messages.MessageField('StatusCondition', 1, repeated=True)
  detail = _messages.StringField(2)
  endTime = _messages.StringField(3)
  error = _messages.MessageField('Status', 4)
  location = _messages.StringField(5)
  name = _messages.StringField(6)
  nodepoolConditions = _messages.MessageField('StatusCondition', 7, repeated=True)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 8)
  progress = _messages.MessageField('OperationProgress', 9)
  selfLink = _messages.StringField(10)
  startTime = _messages.StringField(11)
  status = _messages.EnumField('StatusValueValuesEnum', 12)
  statusMessage = _messages.StringField(13)
  targetLink = _messages.StringField(14)
  zone = _messages.StringField(15)


class OperationProgress(_messages.Message):
  r"""Information about operation (or operation stage) progress.

  Enums:
    StatusValueValuesEnum: Status of an operation stage. Unset for single-
      stage operations.

  Fields:
    metrics: Progress metric bundle, for example: metrics: [{name: "nodes
      done", int_value: 15}, {name: "nodes total", int_value: 32}] or metrics:
      [{name: "progress", double_value: 0.56}, {name: "progress scale",
      double_value: 1.0}]
    name: A non-parameterized string describing an operation stage. Unset for
      single-stage operations.
    stages: Substages of an operation or a stage.
    status: Status of an operation stage. Unset for single-stage operations.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Status of an operation stage. Unset for single-stage operations.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PENDING: The operation has been created.
      RUNNING: The operation is currently running.
      DONE: The operation is done, either cancelled or completed.
      ABORTING: The operation is aborting.
    """
    STATUS_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3
    ABORTING = 4

  metrics = _messages.MessageField('Metric', 1, repeated=True)
  name = _messages.StringField(2)
  stages = _messages.MessageField('OperationProgress', 3, repeated=True)
  status = _messages.EnumField('StatusValueValuesEnum', 4)


class PrivateClusterConfig(_messages.Message):
  r"""Configuration options for private clusters.

  Fields:
    enablePrivateEndpoint: Whether the master's internal IP address is used as
      the cluster endpoint.
    enablePrivateNodes: Whether nodes have internal IP addresses only. If
      enabled, all nodes are given only RFC 1918 private addresses and
      communicate with the master via private networking.
    masterGlobalAccessConfig: Controls master global access settings.
    masterIpv4CidrBlock: The IP range in CIDR notation to use for the hosted
      master network. This range will be used for assigning internal IP
      addresses to the master or set of masters, as well as the ILB VIP. This
      range must not overlap with any other ranges in use within the cluster's
      network.
    peeringName: Output only. The peering name in the customer VPC used by
      this cluster.
    privateEndpoint: Output only. The internal IP address of this cluster's
      master endpoint.
    publicEndpoint: Output only. The external IP address of this cluster's
      master endpoint.
  """

  enablePrivateEndpoint = _messages.BooleanField(1)
  enablePrivateNodes = _messages.BooleanField(2)
  masterGlobalAccessConfig = _messages.MessageField('PrivateClusterMasterGlobalAccessConfig', 3)
  masterIpv4CidrBlock = _messages.StringField(4)
  peeringName = _messages.StringField(5)
  privateEndpoint = _messages.StringField(6)
  publicEndpoint = _messages.StringField(7)


class PrivateClusterMasterGlobalAccessConfig(_messages.Message):
  r"""Configuration for controlling master global access settings.

  Fields:
    enabled: Whenever master is accessible globally or not.
  """

  enabled = _messages.BooleanField(1)


class PubSub(_messages.Message):
  r"""Pub/Sub specific notification config.

  Fields:
    enabled: Enable notifications for Pub/Sub.
    topic: The desired Pub/Sub topic to which notifications will be sent by
      GKE. Format is `projects/{project}/topics/{topic}`.
  """

  enabled = _messages.BooleanField(1)
  topic = _messages.StringField(2)


class RecurringTimeWindow(_messages.Message):
  r"""Represents an arbitrary window of time that recurs.

  Fields:
    recurrence: An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3)
      for how this window reccurs. They go on for the span of time between the
      start and end time. For example, to have something repeat every weekday,
      you'd use: `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR` To repeat some window
      daily (equivalent to the DailyMaintenanceWindow): `FREQ=DAILY` For the
      first weekend of every month: `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU` This
      specifies how frequently the window starts. Eg, if you wanted to have a
      9-5 UTC-4 window every weekday, you'd use something like: ``` start time
      = 2019-01-01T09:00:00-0400 end time = 2019-01-01T17:00:00-0400
      recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR ``` Windows can span
      multiple days. Eg, to make the window encompass every weekend from
      midnight Saturday till the last minute of Sunday UTC: ``` start time =
      2019-01-05T00:00:00Z end time = 2019-01-07T23:59:00Z recurrence =
      FREQ=WEEKLY;BYDAY=SA ``` Note the start and end time's specific dates
      are largely arbitrary except to specify duration of the window and when
      it first starts. The FREQ values of HOURLY, MINUTELY, and SECONDLY are
      not supported.
    window: The window of the first recurrence.
  """

  recurrence = _messages.StringField(1)
  window = _messages.MessageField('TimeWindow', 2)


class ReleaseChannel(_messages.Message):
  r"""ReleaseChannel indicates which release channel a cluster is subscribed
  to. Release channels are arranged in order of risk. When a cluster is
  subscribed to a release channel, Google maintains both the master version
  and the node version. Node auto-upgrade defaults to true and cannot be
  disabled.

  Enums:
    ChannelValueValuesEnum: channel specifies which release channel the
      cluster is subscribed to.

  Fields:
    channel: channel specifies which release channel the cluster is subscribed
      to.
  """

  class ChannelValueValuesEnum(_messages.Enum):
    r"""channel specifies which release channel the cluster is subscribed to.

    Values:
      UNSPECIFIED: No channel specified.
      RAPID: RAPID channel is offered on an early access basis for customers
        who want to test new releases. WARNING: Versions available in the
        RAPID Channel may be subject to unresolved issues with no known
        workaround and are not subject to any SLAs.
      REGULAR: Clusters subscribed to REGULAR receive versions that are
        considered GA quality. REGULAR is intended for production users who
        want to take advantage of new features.
      STABLE: Clusters subscribed to STABLE receive versions that are known to
        be stable and reliable in production.
    """
    UNSPECIFIED = 0
    RAPID = 1
    REGULAR = 2
    STABLE = 3

  channel = _messages.EnumField('ChannelValueValuesEnum', 1)


class ReleaseChannelConfig(_messages.Message):
  r"""ReleaseChannelConfig exposes configuration for a release channel.

  Enums:
    ChannelValueValuesEnum: The release channel this configuration applies to.

  Fields:
    channel: The release channel this configuration applies to.
    defaultVersion: The default version for newly created clusters on the
      channel.
    validVersions: List of valid versions for the channel.
  """

  class ChannelValueValuesEnum(_messages.Enum):
    r"""The release channel this configuration applies to.

    Values:
      UNSPECIFIED: No channel specified.
      RAPID: RAPID channel is offered on an early access basis for customers
        who want to test new releases. WARNING: Versions available in the
        RAPID Channel may be subject to unresolved issues with no known
        workaround and are not subject to any SLAs.
      REGULAR: Clusters subscribed to REGULAR receive versions that are
        considered GA quality. REGULAR is intended for production users who
        want to take advantage of new features.
      STABLE: Clusters subscribed to STABLE receive versions that are known to
        be stable and reliable in production.
    """
    UNSPECIFIED = 0
    RAPID = 1
    REGULAR = 2
    STABLE = 3

  channel = _messages.EnumField('ChannelValueValuesEnum', 1)
  defaultVersion = _messages.StringField(2)
  validVersions = _messages.StringField(3, repeated=True)


class ReservationAffinity(_messages.Message):
  r"""[ReservationAffinity](https://cloud.google.com/compute/docs/instances/re
  serving-zonal-resources) is the configuration of desired reservation which
  instances could take capacity from.

  Enums:
    ConsumeReservationTypeValueValuesEnum: Corresponds to the type of
      reservation consumption.

  Fields:
    consumeReservationType: Corresponds to the type of reservation
      consumption.
    key: Corresponds to the label key of a reservation resource. To target a
      SPECIFIC_RESERVATION by name, specify "googleapis.com/reservation-name"
      as the key and specify the name of your reservation as its value.
    values: Corresponds to the label value(s) of reservation resource(s).
  """

  class ConsumeReservationTypeValueValuesEnum(_messages.Enum):
    r"""Corresponds to the type of reservation consumption.

    Values:
      UNSPECIFIED: Default value. This should not be used.
      NO_RESERVATION: Do not consume from any reserved capacity.
      ANY_RESERVATION: Consume any reservation available.
      SPECIFIC_RESERVATION: Must consume from a specific reservation. Must
        specify key value fields for specifying the reservations.
    """
    UNSPECIFIED = 0
    NO_RESERVATION = 1
    ANY_RESERVATION = 2
    SPECIFIC_RESERVATION = 3

  consumeReservationType = _messages.EnumField('ConsumeReservationTypeValueValuesEnum', 1)
  key = _messages.StringField(2)
  values = _messages.StringField(3, repeated=True)


class ResourceLimit(_messages.Message):
  r"""Contains information about amount of some resource in the cluster. For
  memory, value should be in GB.

  Fields:
    maximum: Maximum amount of the resource in the cluster.
    minimum: Minimum amount of the resource in the cluster.
    resourceType: Resource name "cpu", "memory" or gpu-specific string.
  """

  maximum = _messages.IntegerField(1)
  minimum = _messages.IntegerField(2)
  resourceType = _messages.StringField(3)


class ResourceUsageExportConfig(_messages.Message):
  r"""Configuration for exporting cluster resource usages.

  Fields:
    bigqueryDestination: Configuration to use BigQuery as usage export
      destination.
    consumptionMeteringConfig: Configuration to enable resource consumption
      metering.
    enableNetworkEgressMetering: Whether to enable network egress metering for
      this cluster. If enabled, a daemonset will be created in the cluster to
      meter network egress traffic.
  """

  bigqueryDestination = _messages.MessageField('BigQueryDestination', 1)
  consumptionMeteringConfig = _messages.MessageField('ConsumptionMeteringConfig', 2)
  enableNetworkEgressMetering = _messages.BooleanField(3)


class RollbackNodePoolUpgradeRequest(_messages.Message):
  r"""RollbackNodePoolUpgradeRequest rollbacks the previously Aborted or
  Failed NodePool upgrade. This will be an no-op if the last upgrade
  successfully completed.

  Fields:
    clusterId: Deprecated. The name of the cluster to rollback. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node poll
      to rollback upgrade. Specified in the format
      `projects/*/locations/*/clusters/*/nodePools/*`.
    nodePoolId: Deprecated. The name of the node pool to rollback. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  nodePoolId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SandboxConfig(_messages.Message):
  r"""SandboxConfig contains configurations of the sandbox to use for the
  node.

  Enums:
    TypeValueValuesEnum: Type of the sandbox to use for the node.

  Fields:
    type: Type of the sandbox to use for the node.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Type of the sandbox to use for the node.

    Values:
      UNSPECIFIED: Default value. This should not be used.
      GVISOR: Run sandbox using gvisor.
    """
    UNSPECIFIED = 0
    GVISOR = 1

  type = _messages.EnumField('TypeValueValuesEnum', 1)


class ServerConfig(_messages.Message):
  r"""Kubernetes Engine service configuration.

  Fields:
    channels: List of release channel configurations.
    defaultClusterVersion: Version of Kubernetes the service deploys by
      default.
    defaultImageType: Default image type.
    validImageTypes: List of valid image types.
    validMasterVersions: List of valid master versions, in descending order.
    validNodeVersions: List of valid node upgrade target versions, in
      descending order.
  """

  channels = _messages.MessageField('ReleaseChannelConfig', 1, repeated=True)
  defaultClusterVersion = _messages.StringField(2)
  defaultImageType = _messages.StringField(3)
  validImageTypes = _messages.StringField(4, repeated=True)
  validMasterVersions = _messages.StringField(5, repeated=True)
  validNodeVersions = _messages.StringField(6, repeated=True)


class SetAddonsConfigRequest(_messages.Message):
  r"""SetAddonsConfigRequest sets the addons associated with the cluster.

  Fields:
    addonsConfig: Required. The desired configurations for the various addons
      available to run in the cluster.
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to set addons.
      Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  addonsConfig = _messages.MessageField('AddonsConfig', 1)
  clusterId = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetLabelsRequest(_messages.Message):
  r"""SetLabelsRequest sets the Google Cloud Platform labels on a Google
  Container Engine cluster, which will in turn set them for Google Compute
  Engine resources used by that cluster

  Messages:
    ResourceLabelsValue: Required. The labels to set for that cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    labelFingerprint: Required. The fingerprint of the previous set of labels
      for this resource, used to detect conflicts. The fingerprint is
      initially generated by Kubernetes Engine and changes after every request
      to modify or update labels. You must always provide an up-to-date
      fingerprint hash when updating or changing labels. Make a `get()`
      request to the resource to get the latest fingerprint.
    name: The name (project, location, cluster id) of the cluster to set
      labels. Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    resourceLabels: Required. The labels to set for that cluster.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceLabelsValue(_messages.Message):
    r"""Required. The labels to set for that cluster.

    Messages:
      AdditionalProperty: An additional property for a ResourceLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ResourceLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterId = _messages.StringField(1)
  labelFingerprint = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  resourceLabels = _messages.MessageField('ResourceLabelsValue', 5)
  zone = _messages.StringField(6)


class SetLegacyAbacRequest(_messages.Message):
  r"""SetLegacyAbacRequest enables or disables the ABAC authorization
  mechanism for a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to update. This field has
      been deprecated and replaced by the name field.
    enabled: Required. Whether ABAC authorization will be enabled in the
      cluster.
    name: The name (project, location, cluster id) of the cluster to set
      legacy abac. Specified in the format
      `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  enabled = _messages.BooleanField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetLocationsRequest(_messages.Message):
  r"""SetLocationsRequest sets the locations of the cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    locations: Required. The desired list of Google Compute Engine
      [zones](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster's nodes should be located. Changing the locations a cluster
      is in will result in nodes being either created or removed from the
      cluster, depending on whether locations are being added or removed. This
      list must always include the cluster's primary zone.
    name: The name (project, location, cluster) of the cluster to set
      locations. Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  locations = _messages.StringField(2, repeated=True)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetLoggingServiceRequest(_messages.Message):
  r"""SetLoggingServiceRequest sets the logging service of a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    loggingService: Required. The logging service the cluster should use to
      write logs. Currently available options: *
      `logging.googleapis.com/kubernetes` - The Cloud Logging service with a
      Kubernetes-native resource model * `logging.googleapis.com` - The legacy
      Cloud Logging service (no longer available as of GKE 1.15). * `none` -
      no logs will be exported from the cluster. If left as an empty
      string,`logging.googleapis.com/kubernetes` will be used for GKE 1.14+ or
      `logging.googleapis.com` for earlier versions.
    name: The name (project, location, cluster) of the cluster to set logging.
      Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  loggingService = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetMaintenancePolicyRequest(_messages.Message):
  r"""SetMaintenancePolicyRequest sets the maintenance policy for a cluster.

  Fields:
    clusterId: Required. The name of the cluster to update.
    maintenancePolicy: Required. The maintenance policy to be set for the
      cluster. An empty field clears the existing maintenance policy.
    name: The name (project, location, cluster id) of the cluster to set
      maintenance policy. Specified in the format
      `projects/*/locations/*/clusters/*`.
    projectId: Required. The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: Required. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides.
  """

  clusterId = _messages.StringField(1)
  maintenancePolicy = _messages.MessageField('MaintenancePolicy', 2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetMasterAuthRequest(_messages.Message):
  r"""SetMasterAuthRequest updates the admin password of a cluster.

  Enums:
    ActionValueValuesEnum: Required. The exact form of action to be taken on
      the master auth.

  Fields:
    action: Required. The exact form of action to be taken on the master auth.
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to set auth.
      Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    update: Required. A description of the update.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""Required. The exact form of action to be taken on the master auth.

    Values:
      UNKNOWN: Operation is unknown and will error out.
      SET_PASSWORD: Set the password to a user generated value.
      GENERATE_PASSWORD: Generate a new password and set it to that.
      SET_USERNAME: Set the username. If an empty username is provided, basic
        authentication is disabled for the cluster. If a non-empty username is
        provided, basic authentication is enabled, with either a provided
        password or a generated one.
    """
    UNKNOWN = 0
    SET_PASSWORD = 1
    GENERATE_PASSWORD = 2
    SET_USERNAME = 3

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  clusterId = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  update = _messages.MessageField('MasterAuth', 5)
  zone = _messages.StringField(6)


class SetMonitoringServiceRequest(_messages.Message):
  r"""SetMonitoringServiceRequest sets the monitoring service of a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    monitoringService: Required. The monitoring service the cluster should use
      to write metrics. Currently available options: *
      "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring service
      with a Kubernetes-native resource model * `monitoring.googleapis.com` -
      The legacy Cloud Monitoring service (no longer available as of GKE
      1.15). * `none` - No metrics will be exported from the cluster. If left
      as an empty string,`monitoring.googleapis.com/kubernetes` will be used
      for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
    name: The name (project, location, cluster) of the cluster to set
      monitoring. Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  monitoringService = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetNetworkPolicyRequest(_messages.Message):
  r"""SetNetworkPolicyRequest enables/disables network policy for a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster id) of the cluster to set
      networking policy. Specified in the format
      `projects/*/locations/*/clusters/*`.
    networkPolicy: Required. Configuration options for the NetworkPolicy
      feature.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  networkPolicy = _messages.MessageField('NetworkPolicy', 3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetNodePoolAutoscalingRequest(_messages.Message):
  r"""SetNodePoolAutoscalingRequest sets the autoscaler settings of a node
  pool.

  Fields:
    autoscaling: Required. Autoscaling configuration for the node pool.
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool) of the node pool to
      set autoscaler settings. Specified in the format
      `projects/*/locations/*/clusters/*/nodePools/*`.
    nodePoolId: Deprecated. The name of the node pool to upgrade. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  autoscaling = _messages.MessageField('NodePoolAutoscaling', 1)
  clusterId = _messages.StringField(2)
  name = _messages.StringField(3)
  nodePoolId = _messages.StringField(4)
  projectId = _messages.StringField(5)
  zone = _messages.StringField(6)


class SetNodePoolManagementRequest(_messages.Message):
  r"""SetNodePoolManagementRequest sets the node management properties of a
  node pool.

  Fields:
    clusterId: Deprecated. The name of the cluster to update. This field has
      been deprecated and replaced by the name field.
    management: Required. NodeManagement configuration for the node pool.
    name: The name (project, location, cluster, node pool id) of the node pool
      to set management properties. Specified in the format
      `projects/*/locations/*/clusters/*/nodePools/*`.
    nodePoolId: Deprecated. The name of the node pool to update. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  management = _messages.MessageField('NodeManagement', 2)
  name = _messages.StringField(3)
  nodePoolId = _messages.StringField(4)
  projectId = _messages.StringField(5)
  zone = _messages.StringField(6)


class SetNodePoolSizeRequest(_messages.Message):
  r"""SetNodePoolSizeRequest sets the size of a node pool.

  Fields:
    clusterId: Deprecated. The name of the cluster to update. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to set size. Specified in the format
      `projects/*/locations/*/clusters/*/nodePools/*`.
    nodeCount: Required. The desired node count for the pool.
    nodePoolId: Deprecated. The name of the node pool to update. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  nodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  nodePoolId = _messages.StringField(4)
  projectId = _messages.StringField(5)
  zone = _messages.StringField(6)


class ShieldedInstanceConfig(_messages.Message):
  r"""A set of Shielded Instance options.

  Fields:
    enableIntegrityMonitoring: Defines whether the instance has integrity
      monitoring enabled. Enables monitoring and attestation of the boot
      integrity of the instance. The attestation is performed against the
      integrity policy baseline. This baseline is initially derived from the
      implicitly trusted boot image when the instance is created.
    enableSecureBoot: Defines whether the instance has Secure Boot enabled.
      Secure Boot helps ensure that the system only runs authentic software by
      verifying the digital signature of all boot components, and halting the
      boot process if signature verification fails.
  """

  enableIntegrityMonitoring = _messages.BooleanField(1)
  enableSecureBoot = _messages.BooleanField(2)


class ShieldedNodes(_messages.Message):
  r"""Configuration of Shielded Nodes feature.

  Fields:
    enabled: Whether Shielded Nodes features are enabled on all nodes in this
      cluster.
  """

  enabled = _messages.BooleanField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StartIPRotationRequest(_messages.Message):
  r"""StartIPRotationRequest creates a new IP for the cluster and then
  performs a node upgrade on each node pool to point to the new IP.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster id) of the cluster to start IP
      rotation. Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    rotateCredentials: Whether to rotate credentials during IP rotation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3)
  rotateCredentials = _messages.BooleanField(4)
  zone = _messages.StringField(5)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StatusCondition(_messages.Message):
  r"""StatusCondition describes why a cluster or a node pool has a certain
  status (e.g., ERROR or DEGRADED).

  Enums:
    CanonicalCodeValueValuesEnum: Canonical code of the condition.
    CodeValueValuesEnum: Machine-friendly representation of the condition
      Deprecated. Use canonical_code instead.

  Fields:
    canonicalCode: Canonical code of the condition.
    code: Machine-friendly representation of the condition Deprecated. Use
      canonical_code instead.
    message: Human-friendly representation of the condition
  """

  class CanonicalCodeValueValuesEnum(_messages.Enum):
    r"""Canonical code of the condition.

    Values:
      OK: Not an error; returned on success HTTP Mapping: 200 OK
      CANCELLED: The operation was cancelled, typically by the caller. HTTP
        Mapping: 499 Client Closed Request
      UNKNOWN: Unknown error. For example, this error may be returned when a
        `Status` value received from another address space belongs to an error
        space that is not known in this address space. Also errors raised by
        APIs that do not return enough error information may be converted to
        this error. HTTP Mapping: 500 Internal Server Error
      INVALID_ARGUMENT: The client specified an invalid argument. Note that
        this differs from `FAILED_PRECONDITION`. `INVALID_ARGUMENT` indicates
        arguments that are problematic regardless of the state of the system
        (e.g., a malformed file name). HTTP Mapping: 400 Bad Request
      DEADLINE_EXCEEDED: The deadline expired before the operation could
        complete. For operations that change the state of the system, this
        error may be returned even if the operation has completed
        successfully. For example, a successful response from a server could
        have been delayed long enough for the deadline to expire. HTTP
        Mapping: 504 Gateway Timeout
      NOT_FOUND: Some requested entity (e.g., file or directory) was not
        found. Note to server developers: if a request is denied for an entire
        class of users, such as gradual feature rollout or undocumented
        allowlist, `NOT_FOUND` may be used. If a request is denied for some
        users within a class of users, such as user-based access control,
        `PERMISSION_DENIED` must be used. HTTP Mapping: 404 Not Found
      ALREADY_EXISTS: The entity that a client attempted to create (e.g., file
        or directory) already exists. HTTP Mapping: 409 Conflict
      PERMISSION_DENIED: The caller does not have permission to execute the
        specified operation. `PERMISSION_DENIED` must not be used for
        rejections caused by exhausting some resource (use
        `RESOURCE_EXHAUSTED` instead for those errors). `PERMISSION_DENIED`
        must not be used if the caller can not be identified (use
        `UNAUTHENTICATED` instead for those errors). This error code does not
        imply the request is valid or the requested entity exists or satisfies
        other pre-conditions. HTTP Mapping: 403 Forbidden
      UNAUTHENTICATED: The request does not have valid authentication
        credentials for the operation. HTTP Mapping: 401 Unauthorized
      RESOURCE_EXHAUSTED: Some resource has been exhausted, perhaps a per-user
        quota, or perhaps the entire file system is out of space. HTTP
        Mapping: 429 Too Many Requests
      FAILED_PRECONDITION: The operation was rejected because the system is
        not in a state required for the operation's execution. For example,
        the directory to be deleted is non-empty, an rmdir operation is
        applied to a non-directory, etc. Service implementors can use the
        following guidelines to decide between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`: (a) Use `UNAVAILABLE` if the client can
        retry just the failing call. (b) Use `ABORTED` if the client should
        retry at a higher level. For example, when a client-specified test-
        and-set fails, indicating the client should restart a read-modify-
        write sequence. (c) Use `FAILED_PRECONDITION` if the client should not
        retry until the system state has been explicitly fixed. For example,
        if an "rmdir" fails because the directory is non-empty,
        `FAILED_PRECONDITION` should be returned since the client should not
        retry unless the files are deleted from the directory. HTTP Mapping:
        400 Bad Request
      ABORTED: The operation was aborted, typically due to a concurrency issue
        such as a sequencer check failure or transaction abort. See the
        guidelines above for deciding between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 409 Conflict
      OUT_OF_RANGE: The operation was attempted past the valid range. E.g.,
        seeking or reading past end-of-file. Unlike `INVALID_ARGUMENT`, this
        error indicates a problem that may be fixed if the system state
        changes. For example, a 32-bit file system will generate
        `INVALID_ARGUMENT` if asked to read at an offset that is not in the
        range [0,2^32-1], but it will generate `OUT_OF_RANGE` if asked to read
        from an offset past the current file size. There is a fair bit of
        overlap between `FAILED_PRECONDITION` and `OUT_OF_RANGE`. We recommend
        using `OUT_OF_RANGE` (the more specific error) when it applies so that
        callers who are iterating through a space can easily look for an
        `OUT_OF_RANGE` error to detect when they are done. HTTP Mapping: 400
        Bad Request
      UNIMPLEMENTED: The operation is not implemented or is not
        supported/enabled in this service. HTTP Mapping: 501 Not Implemented
      INTERNAL: Internal errors. This means that some invariants expected by
        the underlying system have been broken. This error code is reserved
        for serious errors. HTTP Mapping: 500 Internal Server Error
      UNAVAILABLE: The service is currently unavailable. This is most likely a
        transient condition, which can be corrected by retrying with a
        backoff. Note that it is not always safe to retry non-idempotent
        operations. See the guidelines above for deciding between
        `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 503
        Service Unavailable
      DATA_LOSS: Unrecoverable data loss or corruption. HTTP Mapping: 500
        Internal Server Error
    """
    OK = 0
    CANCELLED = 1
    UNKNOWN = 2
    INVALID_ARGUMENT = 3
    DEADLINE_EXCEEDED = 4
    NOT_FOUND = 5
    ALREADY_EXISTS = 6
    PERMISSION_DENIED = 7
    UNAUTHENTICATED = 8
    RESOURCE_EXHAUSTED = 9
    FAILED_PRECONDITION = 10
    ABORTED = 11
    OUT_OF_RANGE = 12
    UNIMPLEMENTED = 13
    INTERNAL = 14
    UNAVAILABLE = 15
    DATA_LOSS = 16

  class CodeValueValuesEnum(_messages.Enum):
    r"""Machine-friendly representation of the condition Deprecated. Use
    canonical_code instead.

    Values:
      UNKNOWN: UNKNOWN indicates a generic condition.
      GCE_STOCKOUT: GCE_STOCKOUT indicates that Google Compute Engine
        resources are temporarily unavailable.
      GKE_SERVICE_ACCOUNT_DELETED: GKE_SERVICE_ACCOUNT_DELETED indicates that
        the user deleted their robot service account.
      GCE_QUOTA_EXCEEDED: Google Compute Engine quota was exceeded.
      SET_BY_OPERATOR: Cluster state was manually changed by an SRE due to a
        system logic error.
      CLOUD_KMS_KEY_ERROR: Unable to perform an encrypt operation against the
        CloudKMS key used for etcd level encryption.
      CA_EXPIRING: Cluster CA is expiring soon.
    """
    UNKNOWN = 0
    GCE_STOCKOUT = 1
    GKE_SERVICE_ACCOUNT_DELETED = 2
    GCE_QUOTA_EXCEEDED = 3
    SET_BY_OPERATOR = 4
    CLOUD_KMS_KEY_ERROR = 5
    CA_EXPIRING = 6

  canonicalCode = _messages.EnumField('CanonicalCodeValueValuesEnum', 1)
  code = _messages.EnumField('CodeValueValuesEnum', 2)
  message = _messages.StringField(3)


class TimeWindow(_messages.Message):
  r"""Represents an arbitrary window of time.

  Fields:
    endTime: The time that the window ends. The end time should take place
      after the start time.
    startTime: The time that the window first starts.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class UpdateClusterRequest(_messages.Message):
  r"""UpdateClusterRequest updates the settings of a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to update.
      Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    update: Required. A description of the update.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3)
  update = _messages.MessageField('ClusterUpdate', 4)
  zone = _messages.StringField(5)


class UpdateMasterRequest(_messages.Message):
  r"""UpdateMasterRequest updates the master of the cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    masterVersion: Required. The Kubernetes version to change the master to.
      Users may specify either explicit versions offered by Kubernetes Engine
      or version aliases, which have the following behavior: - "latest": picks
      the highest valid Kubernetes version - "1.X": picks the highest valid
      patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid
      gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit
      Kubernetes version - "-": picks the default Kubernetes version
    name: The name (project, location, cluster) of the cluster to update.
      Specified in the format `projects/*/locations/*/clusters/*`.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  masterVersion = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class UpdateNodePoolRequest(_messages.Message):
  r"""UpdateNodePoolRequests update a node pool's image and/or version.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    gvnic: Enable or disable gvnic on the node pool.
    image: The desired name of the image name to use for this node. This is
      used to create clusters using a custom image.
    imageProject: The project containing the desired image to use for this
      node pool. This is used to create clusters using a custom image.
    imageType: Required. The desired image type for the node pool.
    kubeletConfig: Node kubelet configs.
    linuxNodeConfig: Parameters that can be configured on Linux nodes.
    locations: The desired list of Google Compute Engine
      [zones](https://cloud.google.com/compute/docs/zones#available) in which
      the node pool's nodes should be located. Changing the locations for a
      node pool will result in nodes being either created or removed from the
      node pool, depending on whether locations are being added or removed.
    name: The name (project, location, cluster, node pool) of the node pool to
      update. Specified in the format
      `projects/*/locations/*/clusters/*/nodePools/*`.
    nodePoolId: Deprecated. The name of the node pool to upgrade. This field
      has been deprecated and replaced by the name field.
    nodeVersion: Required. The Kubernetes version to change the nodes to
      (typically an upgrade). Users may specify either explicit versions
      offered by Kubernetes Engine or version aliases, which have the
      following behavior: - "latest": picks the highest valid Kubernetes
      version - "1.X": picks the highest valid patch+gke.N patch in the 1.X
      version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y
      version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "-":
      picks the Kubernetes master version
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    upgradeSettings: Upgrade settings control disruption and speed of the
      upgrade.
    workloadMetadataConfig: The desired workload metadata config for the node
      pool.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](https://cloud.google.com/compute/docs/zones#available) in which
      the cluster resides. This field has been deprecated and replaced by the
      name field.
  """

  clusterId = _messages.StringField(1)
  gvnic = _messages.MessageField('VirtualNIC', 2)
  image = _messages.StringField(3)
  imageProject = _messages.StringField(4)
  imageType = _messages.StringField(5)
  kubeletConfig = _messages.MessageField('NodeKubeletConfig', 6)
  linuxNodeConfig = _messages.MessageField('LinuxNodeConfig', 7)
  locations = _messages.StringField(8, repeated=True)
  name = _messages.StringField(9)
  nodePoolId = _messages.StringField(10)
  nodeVersion = _messages.StringField(11)
  projectId = _messages.StringField(12)
  upgradeSettings = _messages.MessageField('UpgradeSettings', 13)
  workloadMetadataConfig = _messages.MessageField('WorkloadMetadataConfig', 14)
  zone = _messages.StringField(15)


class UpgradeAvailableEvent(_messages.Message):
  r"""UpgradeAvailableEvent is a notification sent to customers when a new
  available version is released.

  Enums:
    ResourceTypeValueValuesEnum: The resource type of the release version.

  Fields:
    releaseChannel: The release channel of the version. If empty, it means a
      non-channel release.
    resource: Optional relative path to the resource. For example, the
      relative path of the node pool.
    resourceType: The resource type of the release version.
    version: The release version available for upgrade.
  """

  class ResourceTypeValueValuesEnum(_messages.Enum):
    r"""The resource type of the release version.

    Values:
      UPGRADE_RESOURCE_TYPE_UNSPECIFIED: Default value. This shouldn't be
        used.
      MASTER: Master / control plane
      NODE_POOL: Node pool
    """
    UPGRADE_RESOURCE_TYPE_UNSPECIFIED = 0
    MASTER = 1
    NODE_POOL = 2

  releaseChannel = _messages.MessageField('ReleaseChannel', 1)
  resource = _messages.StringField(2)
  resourceType = _messages.EnumField('ResourceTypeValueValuesEnum', 3)
  version = _messages.StringField(4)


class UpgradeEvent(_messages.Message):
  r"""UpgradeEvent is a notification sent to customers by the cluster server
  when a resource is upgrading.

  Enums:
    ResourceTypeValueValuesEnum: The resource type that is upgrading.

  Fields:
    currentVersion: The current version before the upgrade.
    operation: The operation associated with this upgrade.
    operationStartTime: The time when the operation was started.
    resource: Optional relative path to the resource. For example in node pool
      upgrades, the relative path of the node pool.
    resourceType: The resource type that is upgrading.
    targetVersion: The target version for the upgrade.
  """

  class ResourceTypeValueValuesEnum(_messages.Enum):
    r"""The resource type that is upgrading.

    Values:
      UPGRADE_RESOURCE_TYPE_UNSPECIFIED: Default value. This shouldn't be
        used.
      MASTER: Master / control plane
      NODE_POOL: Node pool
    """
    UPGRADE_RESOURCE_TYPE_UNSPECIFIED = 0
    MASTER = 1
    NODE_POOL = 2

  currentVersion = _messages.StringField(1)
  operation = _messages.StringField(2)
  operationStartTime = _messages.StringField(3)
  resource = _messages.StringField(4)
  resourceType = _messages.EnumField('ResourceTypeValueValuesEnum', 5)
  targetVersion = _messages.StringField(6)


class UpgradeSettings(_messages.Message):
  r"""These upgrade settings control the level of parallelism and the level of
  disruption caused by an upgrade. maxUnavailable controls the number of nodes
  that can be simultaneously unavailable. maxSurge controls the number of
  additional nodes that can be added to the node pool temporarily for the time
  of the upgrade to increase the number of available nodes. (maxUnavailable +
  maxSurge) determines the level of parallelism (how many nodes are being
  upgraded at the same time). Note: upgrades inevitably introduce some
  disruption since workloads need to be moved from old nodes to new, upgraded
  ones. Even if maxUnavailable=0, this holds true. (Disruption stays within
  the limits of PodDisruptionBudget, if it is configured.) Consider a
  hypothetical node pool with 5 nodes having maxSurge=2, maxUnavailable=1.
  This means the upgrade process upgrades 3 nodes simultaneously. It creates 2
  additional (upgraded) nodes, then it brings down 3 old (not yet upgraded)
  nodes at the same time. This ensures that there are always at least 4 nodes
  available.

  Fields:
    maxSurge: The maximum number of nodes that can be created beyond the
      current size of the node pool during the upgrade process.
    maxUnavailable: The maximum number of nodes that can be simultaneously
      unavailable during the upgrade process. A node is considered available
      if its status is Ready.
  """

  maxSurge = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxUnavailable = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class UsableSubnetwork(_messages.Message):
  r"""UsableSubnetwork resource returns the subnetwork name, its associated
  network and the primary CIDR range.

  Fields:
    ipCidrRange: The range of internal addresses that are owned by this
      subnetwork.
    network: Network Name. Example: projects/my-project/global/networks/my-
      network
    secondaryIpRanges: Secondary IP ranges.
    statusMessage: A human readable status message representing the reasons
      for cases where the caller cannot use the secondary ranges under the
      subnet. For example if the secondary_ip_ranges is empty due to a
      permission issue, an insufficient permission message will be given by
      status_message.
    subnetwork: Subnetwork Name. Example: projects/my-project/regions/us-
      central1/subnetworks/my-subnet
  """

  ipCidrRange = _messages.StringField(1)
  network = _messages.StringField(2)
  secondaryIpRanges = _messages.MessageField('UsableSubnetworkSecondaryRange', 3, repeated=True)
  statusMessage = _messages.StringField(4)
  subnetwork = _messages.StringField(5)


class UsableSubnetworkSecondaryRange(_messages.Message):
  r"""Secondary IP range of a usable subnetwork.

  Enums:
    StatusValueValuesEnum: This field is to determine the status of the
      secondary range programmably.

  Fields:
    ipCidrRange: The range of IP addresses belonging to this subnetwork
      secondary range.
    rangeName: The name associated with this subnetwork secondary range, used
      when adding an alias IP range to a VM instance.
    status: This field is to determine the status of the secondary range
      programmably.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""This field is to determine the status of the secondary range
    programmably.

    Values:
      UNKNOWN: UNKNOWN is the zero value of the Status enum. It's not a valid
        status.
      UNUSED: UNUSED denotes that this range is unclaimed by any cluster.
      IN_USE_SERVICE: IN_USE_SERVICE denotes that this range is claimed by a
        cluster for services. It cannot be used for other clusters.
      IN_USE_SHAREABLE_POD: IN_USE_SHAREABLE_POD denotes this range was
        created by the network admin and is currently claimed by a cluster for
        pods. It can only be used by other clusters as a pod range.
      IN_USE_MANAGED_POD: IN_USE_MANAGED_POD denotes this range was created by
        GKE and is claimed for pods. It cannot be used for other clusters.
    """
    UNKNOWN = 0
    UNUSED = 1
    IN_USE_SERVICE = 2
    IN_USE_SHAREABLE_POD = 3
    IN_USE_MANAGED_POD = 4

  ipCidrRange = _messages.StringField(1)
  rangeName = _messages.StringField(2)
  status = _messages.EnumField('StatusValueValuesEnum', 3)


class VerticalPodAutoscaling(_messages.Message):
  r"""VerticalPodAutoscaling contains global, per-cluster information required
  by Vertical Pod Autoscaler to automatically adjust the resources of pods
  controlled by it.

  Fields:
    enabled: Enables vertical pod autoscaling.
  """

  enabled = _messages.BooleanField(1)


class VirtualNIC(_messages.Message):
  r"""Configuration of gVNIC feature.

  Fields:
    enabled: Whether gVNIC features are enabled in the node pool.
  """

  enabled = _messages.BooleanField(1)


class WorkloadIdentityConfig(_messages.Message):
  r"""Configuration for the use of Kubernetes Service Accounts in GCP IAM
  policies.

  Fields:
    workloadPool: The workload pool to attach all Kubernetes service accounts
      to.
  """

  workloadPool = _messages.StringField(1)


class WorkloadMetadataConfig(_messages.Message):
  r"""WorkloadMetadataConfig defines the metadata configuration to expose to
  workloads on the node pool.

  Enums:
    ModeValueValuesEnum: Mode is the configuration for how to expose metadata
      to workloads running on the node pool.

  Fields:
    mode: Mode is the configuration for how to expose metadata to workloads
      running on the node pool.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Mode is the configuration for how to expose metadata to workloads
    running on the node pool.

    Values:
      MODE_UNSPECIFIED: Not set.
      GCE_METADATA: Expose all Compute Engine metadata to pods.
      GKE_METADATA: Run the GKE Metadata Server on this node. The GKE Metadata
        Server exposes a metadata API to workloads that is compatible with the
        V1 Compute Metadata APIs exposed by the Compute Engine and App Engine
        Metadata Servers. This feature can only be enabled if Workload
        Identity is enabled at the cluster level.
    """
    MODE_UNSPECIFIED = 0
    GCE_METADATA = 1
    GKE_METADATA = 2

  mode = _messages.EnumField('ModeValueValuesEnum', 1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
