(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/flock#flock
    (lambda (_raw674_ _op675_)
      (let ((_fd677_ (if (std/os/fd#fd? _raw674_)
                         (std/os/fd#fd-e _raw674_)
                         _raw674_))
            (_op678_ (fxior _op675_ std/os/flock#LOCK_NB)))
        (let _lp680_ ()
          (let ((_r684_ (std/os/flock#_flock _fd677_ _op678_)))
            (if (not (let () (declare (not safe)) (##fxnegative? _r684_)))
                _r684_
                (let ((_errno687_
                       (let () (declare (not safe)) (##fx- _r684_))))
                  (if (or (eq? _errno687_ std/os/error#EAGAIN)
                          (eq? _errno687_ std/os/error#EWOULDBLOCK))
                      '#f
                      (if (eq? _errno687_ std/os/error#EINTR)
                          (_lp680_)
                          (std/os/error#raise-os-error
                           _errno687_
                           std/os/flock#flock
                           _raw674_
                           _op678_))))))))))
  (define std/os/flock#flock/block__%
    (lambda (_raw-or-fd653_ _op654_ _timeout655_)
      (letrec* ((_deadline657_
                 (if (not _timeout655_)
                     '#f
                     (if (time? _timeout655_)
                         (time->seconds _timeout655_)
                         (if (real? _timeout655_)
                             (+ (let ()
                                  (declare (not safe))
                                  (##current-time-point))
                                _timeout655_)
                             (error '"Bad argument; expected real, time or #f"
                                    _timeout655_))))))
        (let _lp659_ ()
          (if (std/os/flock#flock _raw-or-fd653_ _op654_)
              '#!void
              (begin
                (if _deadline657_
                    (if (< _deadline657_
                           (let ()
                             (declare (not safe))
                             (##current-time-point)))
                        '#!void
                        (std/error#raise-timeout
                         'flock
                         '"Deadline for flock operation exceeded"
                         _raw-or-fd653_
                         _op654_))
                    '#!void)
                (thread-sleep! (random-real))
                (_lp659_)))))))
  (define std/os/flock#flock/block__0
    (lambda (_raw-or-fd665_ _op666_)
      (let ((_timeout668_ '#f))
        (std/os/flock#flock/block__% _raw-or-fd665_ _op666_ _timeout668_))))
  (define std/os/flock#flock/block
    (lambda _g4330_
      (let ((_g4329_ (let () (declare (not safe)) (##length _g4330_))))
        (cond ((let () (declare (not safe)) (##fx= _g4329_ 2))
               (apply std/os/flock#flock/block__0 _g4330_))
              ((let () (declare (not safe)) (##fx= _g4329_ 3))
               (apply std/os/flock#flock/block__% _g4330_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/flock#flock/block
                _g4330_))))))
  (define std/os/flock#open-input-file/lock__%__%
    (lambda (__606609_ _op603611_ _flags604613_ _path615_ _timeout616_)
      (let* ((_op618_ (if (eq? _op603611_ absent-value)
                          std/os/flock#LOCK_SH
                          _op603611_))
             (_flags620_
              (if (eq? _flags604613_ absent-value)
                  std/os/fcntl#O_RDONLY
                  _flags604613_)))
        (std/os/flock#open-file/lock__%__%
         '#f
         'in
         _flags620_
         '0
         _path615_
         _op618_
         _timeout616_))))
  (define std/os/flock#open-input-file/lock__%__0
    (lambda (__606625_ _op603626_ _flags604627_ _path628_)
      (let ((_timeout630_ '#f))
        (std/os/flock#open-input-file/lock__%__%
         __606625_
         _op603626_
         _flags604627_
         _path628_
         _timeout630_))))
  (define std/os/flock#open-input-file/lock__%
    (lambda _g4332_
      (let ((_g4331_ (let () (declare (not safe)) (##length _g4332_))))
        (cond ((let () (declare (not safe)) (##fx= _g4331_ 4))
               (apply std/os/flock#open-input-file/lock__%__0 _g4332_))
              ((let () (declare (not safe)) (##fx= _g4331_ 5))
               (apply std/os/flock#open-input-file/lock__%__% _g4332_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/flock#open-input-file/lock__%
                _g4332_))))))
  (define std/os/flock#open-input-file/lock__@
    (lambda (_keys602641_ . _args643_)
      (apply std/os/flock#open-input-file/lock__%
             _keys602641_
             (table-ref _keys602641_ 'op: absent-value)
             (table-ref _keys602641_ 'flags: absent-value)
             _args643_)))
  (define std/os/flock#open-input-file/lock
    (lambda _args605649_
      (apply keyword-dispatch
             '#(flags: #f op: #f)
             std/os/flock#open-input-file/lock__@
             _args605649_)))
  (define std/os/flock#open-output-file/lock__%__%
    (lambda (__549552_
             _op545554_
             _flags546556_
             _mode547558_
             _path560_
             _timeout561_)
      (let* ((_op563_ (if (eq? _op545554_ absent-value)
                          std/os/flock#LOCK_EX
                          _op545554_))
             (_flags565_
              (if (eq? _flags546556_ absent-value)
                  (fxior std/os/fcntl#O_WRONLY std/os/fcntl#O_CREAT)
                  _flags546556_))
             (_mode567_
              (if (eq? _mode547558_ absent-value)
                  std/os/fdio#S_IRWXU
                  _mode547558_)))
        (std/os/flock#open-file/lock__%__%
         '#f
         'out
         _flags565_
         _mode567_
         _path560_
         _op563_
         _timeout561_))))
  (define std/os/flock#open-output-file/lock__%__0
    (lambda (__549572_ _op545573_ _flags546574_ _mode547575_ _path576_)
      (let ((_timeout578_ '#f))
        (std/os/flock#open-output-file/lock__%__%
         __549572_
         _op545573_
         _flags546574_
         _mode547575_
         _path576_
         _timeout578_))))
  (define std/os/flock#open-output-file/lock__%
    (lambda _g4334_
      (let ((_g4333_ (let () (declare (not safe)) (##length _g4334_))))
        (cond ((let () (declare (not safe)) (##fx= _g4333_ 5))
               (apply std/os/flock#open-output-file/lock__%__0 _g4334_))
              ((let () (declare (not safe)) (##fx= _g4333_ 6))
               (apply std/os/flock#open-output-file/lock__%__% _g4334_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/flock#open-output-file/lock__%
                _g4334_))))))
  (define std/os/flock#open-output-file/lock__@
    (lambda (_keys544590_ . _args592_)
      (apply std/os/flock#open-output-file/lock__%
             _keys544590_
             (table-ref _keys544590_ 'op: absent-value)
             (table-ref _keys544590_ 'flags: absent-value)
             (table-ref _keys544590_ 'mode: absent-value)
             _args592_)))
  (define std/os/flock#open-output-file/lock
    (lambda _args548598_
      (apply keyword-dispatch
             '#(#f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                mode:
                #f
                flags:
                #f
                #f
                #f
                #f
                #f
                #f
                op:
                #f)
             std/os/flock#open-output-file/lock__@
             _args548598_)))
  (define std/os/flock#open-file/lock__%__%
    (lambda (__474477_
             _dir470479_
             _flags471481_
             _mode472483_
             _path485_
             _op486_
             _timeout487_)
      (let* ((_dir489_
              (if (eq? _dir470479_ absent-value)
                  (error '"Missing required keyword argument" 'direction:)
                  _dir470479_))
             (_flags491_
              (if (eq? _flags471481_ absent-value)
                  (error '"Missing required keyword argument" 'flags:)
                  _flags471481_))
             (_mode493_
              (if (eq? _mode472483_ absent-value)
                  (error '"Missing required keyword argument" 'mode:)
                  _mode472483_))
             (_fd495_ (std/os/flock#open/lock__%__%
                       '#f
                       _flags491_
                       _mode493_
                       _path485_
                       _op486_
                       _timeout487_))
             (_port497_ (std/os/fd#fdopen-port _fd495_ _dir489_ _path485_))
             (_close-it499_ (macro-port-close _port497_))
             (_unlocked?501_ '#f))
        (letrec ((_close504_
                  (lambda (_port506_ . _args507_)
                    (if _unlocked?501_
                        '#!void
                        (begin
                          (std/os/flock#flock _fd495_ std/os/flock#LOCK_UN)
                          (set! _unlocked?501_ '#t)))
                    (apply _close-it499_ _port506_ _args507_))))
          (macro-port-close-set! _port497_ _close504_)
          _port497_))))
  (define std/os/flock#open-file/lock__%__0
    (lambda (__474512_
             _dir470513_
             _flags471514_
             _mode472515_
             _path516_
             _op517_)
      (let ((_timeout519_ '#f))
        (std/os/flock#open-file/lock__%__%
         __474512_
         _dir470513_
         _flags471514_
         _mode472515_
         _path516_
         _op517_
         _timeout519_))))
  (define std/os/flock#open-file/lock__%
    (lambda _g4336_
      (let ((_g4335_ (let () (declare (not safe)) (##length _g4336_))))
        (cond ((let () (declare (not safe)) (##fx= _g4335_ 6))
               (apply std/os/flock#open-file/lock__%__0 _g4336_))
              ((let () (declare (not safe)) (##fx= _g4335_ 7))
               (apply std/os/flock#open-file/lock__%__% _g4336_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/flock#open-file/lock__%
                _g4336_))))))
  (define std/os/flock#open-file/lock__@
    (lambda (_keys469532_ . _args534_)
      (apply std/os/flock#open-file/lock__%
             _keys469532_
             (table-ref _keys469532_ 'direction: absent-value)
             (table-ref _keys469532_ 'flags: absent-value)
             (table-ref _keys469532_ 'mode: absent-value)
             _args534_)))
  (define std/os/flock#open-file/lock
    (lambda _args473540_
      (apply keyword-dispatch
             '#(#f
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                mode:
                #f
                flags:
                #f
                #f
                #f
                #f
                #f
                #f
                #f
                direction:)
             std/os/flock#open-file/lock__@
             _args473540_)))
  (define std/os/flock#open/lock__%__%
    (lambda (__404407_
             _flags401409_
             _mode402411_
             _path413_
             _op414_
             _timeout415_)
      (let* ((_flags417_
              (if (eq? _flags401409_ absent-value)
                  (error '"Missing required keyword argument" 'flags:)
                  _flags401409_))
             (_mode419_
              (if (eq? _mode402411_ absent-value)
                  (error '"Missing required keyword argument" 'mode:)
                  _mode402411_))
             (_flags421_ _flags417_)
             (_fd426_ (let ((_r423_ (std/os/fdio#_open
                                     _path413_
                                     _flags421_
                                     _mode419_)))
                        (if (not (let ()
                                   (declare (not safe))
                                   (##fxnegative? _r423_)))
                            _r423_
                            (std/os/error#raise-os-error
                             (let () (declare (not safe)) (##fx- _r423_))
                             std/os/fdio#open
                             _path413_
                             _flags421_
                             _mode419_)))))
        (std/os/fcntl#fd-set-nonblock/closeonexec _fd426_)
        (with-exception-catcher
         (lambda (_g428430_)
           (if '#t
               (let ((_e433_ _g428430_))
                 (std/os/fdio#_close _fd426_)
                 (raise _e433_))
               (raise _g428430_)))
         (lambda ()
           (std/os/flock#flock/block__% _fd426_ _op414_ _timeout415_)))
        _fd426_)))
  (define std/os/flock#open/lock__%__0
    (lambda (__404439_ _flags401440_ _mode402441_ _path442_ _op443_)
      (let ((_timeout445_ '#f))
        (std/os/flock#open/lock__%__%
         __404439_
         _flags401440_
         _mode402441_
         _path442_
         _op443_
         _timeout445_))))
  (define std/os/flock#open/lock__%
    (lambda _g4338_
      (let ((_g4337_ (let () (declare (not safe)) (##length _g4338_))))
        (cond ((let () (declare (not safe)) (##fx= _g4337_ 5))
               (apply std/os/flock#open/lock__%__0 _g4338_))
              ((let () (declare (not safe)) (##fx= _g4337_ 6))
               (apply std/os/flock#open/lock__%__% _g4338_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/flock#open/lock__%
                _g4338_))))))
  (define std/os/flock#open/lock__@
    (lambda (_keys400457_ . _args459_)
      (apply std/os/flock#open/lock__%
             _keys400457_
             (table-ref _keys400457_ 'flags: absent-value)
             (table-ref _keys400457_ 'mode: absent-value)
             _args459_)))
  (define std/os/flock#open/lock
    (lambda _args403465_
      (apply keyword-dispatch
             '#(flags: mode: #f)
             std/os/flock#open/lock__@
             _args403465_)))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (define-macro (define-with-errno symbol ffi-symbol args)
    `(define (,symbol ,@args)
       (declare (not interrupts-enabled))
       (let ((r (,ffi-symbol ,@args)))
         (if (##fx< r 0) (##fx- (##c-code "___RESULT = ___FIX (errno);")) r))))
  (define-macro (define-c-struct
                 struct
                 #!optional
                 (members '())
                 release-function)
    (let* ((struct-str (symbol->string struct))
           (struct-ptr (string->symbol (string-append struct-str "*")))
           (shallow-ptr
            (string->symbol (string-append struct-str "-shallow-ptr*")))
           (borrowed-ptr
            (string->symbol (string-append struct-str "-borrowed-ptr*")))
           (string-types
            '(char-string
              nonull-char-string
              UTF-8-string
              nonnull-UTF-8-string
              UTF-16-string
              nonnull-UTF16-string))
           (string-compat-required?
            (let loop ((m members))
              (cond ((null? m) #f)
                    ((member (cdr (car m)) string-types) #t)
                    (else (loop (cdr m))))))
           (string-setter-body
            (lambda (member-name)
              (let ((m (string-append "___arg1->" member-name)))
                (string-append
                 "if("
                 m
                 " == NULL)"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "else if (strcmp("
                 m
                 ", ___arg2) != 0) {"
                 "\n"
                 "free("
                 m
                 ");"
                 "\n"
                 m
                 "= strdup(___arg2);"
                 "\n"
                 "}"
                 "\n"
                 "___return;"
                 "\n"))))
           (default-free-body
            (and string-compat-required?
                 (string-append
                  "___SCMOBJ "
                  struct-str
                  "_ffi_free (void *ptr) {"
                  "\n"
                  "struct "
                  struct-str
                  " *obj = (struct "
                  struct-str
                  "*) ptr;"
                  "\n"
                  (apply string-append
                         (map (lambda (m)
                                (cond ((memq (cdr m) string-types)
                                       (let ((mem-name
                                              (symbol->string (car m))))
                                         (string-append
                                          "if(obj->"
                                          mem-name
                                          ") "
                                          "free(obj->"
                                          mem-name
                                          ");"
                                          "\n")))
                                      (else "")))
                              members))
                  "free(obj);"
                  "\n"
                  "return ___FIX (___NO_ERR);"
                  "\n"
                  "}")))
           (release-function
            (or release-function
                (if string-compat-required?
                    (string-append struct-str "_ffi_free")
                    "ffi_free")))
           (string-compat-types
            (if string-compat-required?
                `((c-declare ,default-free-body)
                  (c-define-type
                   ,shallow-ptr
                   (pointer ,struct (,struct-ptr) "ffi_free")))
                '())))
      `(begin
         (c-define-type ,struct (struct ,struct-str))
         (c-define-type
          ,struct-ptr
          (pointer ,struct (,struct-ptr) ,release-function))
         (c-define-type ,borrowed-ptr (pointer ,struct (,struct-ptr)))
         ,@string-compat-types
         (define ,(string->symbol (string-append struct-str "-ptr?"))
           (lambda (obj)
             (and (foreign? obj) (equal? (foreign-tags obj) '(,struct-ptr)))))
         ,@(apply append
                  (map (lambda (m)
                         (let* ((member-name (symbol->string (car m)))
                                (member-type (cdr m))
                                (getter-name
                                 (string-append struct-str "-" member-name))
                                (setter-body
                                 (cond ((member member-type string-types)
                                        (string-setter-body member-name))
                                       (else
                                        (string-append
                                         "___arg1->"
                                         member-name
                                         " = ___arg2;"
                                         "\n"
                                         "___return;"
                                         "\n")))))
                           `((define ,(string->symbol getter-name)
                               (c-lambda
                                (,struct-ptr)
                                ,member-type
                                ,(string-append
                                  "___return(___arg1->"
                                  member-name
                                  ");")))
                             (define ,(string->symbol
                                       (string-append getter-name "-set!"))
                               (c-lambda
                                (,struct-ptr ,member-type)
                                void
                                ,setter-body)))))
                       members))
         (define ,(string->symbol (string-append "malloc-" struct-str))
           (c-lambda
            ()
            ,struct-ptr
            ,(string-append
              "struct "
              struct-str
              "* var = (struct "
              struct-str
              " *) malloc(sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(var, 0, sizeof(struct "
              struct-str
              "));"
              "___return(var);")))
         (define ,(string->symbol (string-append "ptr->" struct-str))
           (c-lambda (,struct-ptr) ,struct "___return(*___arg1);"))
         (define ,(string->symbol
                   (string-append "malloc-" struct-str "-array"))
           (c-lambda
            (unsigned-int32)
            ,(if string-compat-required? shallow-ptr struct-ptr)
            ,(string-append
              "struct "
              struct-str
              " *arr_var=(struct "
              struct-str
              " *) malloc(___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "if (arr_var == NULL)"
              "\n"
              "    ___return (NULL);"
              "\n"
              "memset(arr_var, 0, ___arg1*sizeof(struct "
              struct-str
              "));"
              "\n"
              "___return(arr_var);")))
         (define ,(string->symbol (string-append struct-str "-array-ref"))
           (c-lambda
            (,struct-ptr unsigned-int32)
            ,borrowed-ptr
            "___return (___arg1 + ___arg2);"))
         (define ,(string->symbol (string-append struct-str "-array-set!"))
           (c-lambda
            (,struct-ptr unsigned-int32 ,struct-ptr)
            void
            "*(___arg1 + ___arg2) = *___arg3; ___return;")))))
  (c-declare "#include <stdlib.h>")
  (c-declare "#include <string.h>")
  (c-declare "#include <errno.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace ("std/os/flock#" LOCK_NB LOCK_UN LOCK_EX LOCK_SH _flock))
  (c-declare "#include <sys/file.h>")
  (define-const LOCK_SH)
  (define-const LOCK_EX)
  (define-const LOCK_UN)
  (define-const LOCK_NB)
  (namespace ("std/os/flock#" __flock))
  (define-c-lambda __flock (int int) int "flock")
  (define-with-errno _flock __flock (fd op))
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif"))
