(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/sasl#scram-context::t
    (make-struct-type
     'std/net/sasl#scram-context::t
     '#f
     '12
     'scram-context
     '((final: . #t))
     ':init!
     '(h hmac user pass nonce cfm sfm r s i p v)))
  (define std/net/sasl#scram-context?
    (make-struct-predicate std/net/sasl#scram-context::t))
  (define std/net/sasl#make-scram-context
    (lambda _$args769_
      (apply make-struct-instance std/net/sasl#scram-context::t _$args769_)))
  (define std/net/sasl#scram-context-h
    (make-struct-field-accessor std/net/sasl#scram-context::t '0))
  (define std/net/sasl#scram-context-hmac
    (make-struct-field-accessor std/net/sasl#scram-context::t '1))
  (define std/net/sasl#scram-context-user
    (make-struct-field-accessor std/net/sasl#scram-context::t '2))
  (define std/net/sasl#scram-context-pass
    (make-struct-field-accessor std/net/sasl#scram-context::t '3))
  (define std/net/sasl#scram-context-nonce
    (make-struct-field-accessor std/net/sasl#scram-context::t '4))
  (define std/net/sasl#scram-context-cfm
    (make-struct-field-accessor std/net/sasl#scram-context::t '5))
  (define std/net/sasl#scram-context-sfm
    (make-struct-field-accessor std/net/sasl#scram-context::t '6))
  (define std/net/sasl#scram-context-r
    (make-struct-field-accessor std/net/sasl#scram-context::t '7))
  (define std/net/sasl#scram-context-s
    (make-struct-field-accessor std/net/sasl#scram-context::t '8))
  (define std/net/sasl#scram-context-i
    (make-struct-field-accessor std/net/sasl#scram-context::t '9))
  (define std/net/sasl#scram-context-p
    (make-struct-field-accessor std/net/sasl#scram-context::t '10))
  (define std/net/sasl#scram-context-v
    (make-struct-field-accessor std/net/sasl#scram-context::t '11))
  (define std/net/sasl#scram-context-h-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '0))
  (define std/net/sasl#scram-context-hmac-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '1))
  (define std/net/sasl#scram-context-user-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '2))
  (define std/net/sasl#scram-context-pass-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '3))
  (define std/net/sasl#scram-context-nonce-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '4))
  (define std/net/sasl#scram-context-cfm-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '5))
  (define std/net/sasl#scram-context-sfm-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '6))
  (define std/net/sasl#scram-context-r-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '7))
  (define std/net/sasl#scram-context-s-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '8))
  (define std/net/sasl#scram-context-i-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '9))
  (define std/net/sasl#scram-context-p-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '10))
  (define std/net/sasl#scram-context-v-set!
    (make-struct-field-mutator std/net/sasl#scram-context::t '11))
  (define std/net/sasl#scram-context:::init!
    (lambda (_self763_ _h764_ _hmac765_ _user766_ _pass767_)
      (if (let ((__tmp4428
                 (let () (declare (not safe)) (##vector-length _self763_))))
            (declare (not safe))
            (##fx< '4 __tmp4428))
          (begin
            (let () (declare (not safe)) (##vector-set! _self763_ '1 _h764_))
            (let ()
              (declare (not safe))
              (##vector-set! _self763_ '2 _hmac765_))
            (let ()
              (declare (not safe))
              (##vector-set! _self763_ '3 _user766_))
            (let ()
              (declare (not safe))
              (##vector-set! _self763_ '4 _pass767_)))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self763_))))
  (bind-method!
   std/net/sasl#scram-context::t
   ':init!
   std/net/sasl#scram-context:::init!
   '#f)
  (define std/net/sasl#scram-sha-1-begin
    (lambda (_user636_ _pass637_)
      (let ((__obj4426 (make-object std/net/sasl#scram-context::t '12)))
        (if (let ((__tmp4429
                   (let () (declare (not safe)) (##vector-length __obj4426))))
              (declare (not safe))
              (##fx< '4 __tmp4429))
            (begin
              (let ()
                (declare (not safe))
                (##vector-set! __obj4426 '1 std/crypto/digest#sha1))
              (let ()
                (declare (not safe))
                (##vector-set! __obj4426 '2 std/crypto/hmac#hmac-sha1))
              (let ()
                (declare (not safe))
                (##vector-set! __obj4426 '3 _user636_))
              (let ()
                (declare (not safe))
                (##vector-set! __obj4426 '4 _pass637_)))
            (error '"struct-instance-init!: too many arguments for struct"
                   __obj4426))
        __obj4426)))
  (define std/net/sasl#scram-sha-256-begin
    (lambda (_user633_ _pass634_)
      (let ((__obj4427 (make-object std/net/sasl#scram-context::t '12)))
        (if (let ((__tmp4430
                   (let () (declare (not safe)) (##vector-length __obj4427))))
              (declare (not safe))
              (##fx< '4 __tmp4430))
            (begin
              (let ()
                (declare (not safe))
                (##vector-set! __obj4427 '1 std/crypto/digest#sha256))
              (let ()
                (declare (not safe))
                (##vector-set! __obj4427 '2 std/crypto/hmac#hmac-sha256))
              (let ()
                (declare (not safe))
                (##vector-set! __obj4427 '3 _user633_))
              (let ()
                (declare (not safe))
                (##vector-set! __obj4427 '4 _pass634_)))
            (error '"struct-instance-init!: too many arguments for struct"
                   __obj4427))
        __obj4427)))
  (define std/net/sasl#scram-client-first-message__%
    (lambda (_ctx608_ _nonce609_)
      (letrec ((_first-message611_
                (lambda (_cfm621_) (string-append '"n,," _cfm621_))))
        (let* ((_nonce616_
                (let ((_$e613_ _nonce609_))
                  (if _$e613_
                      _$e613_
                      (std/text/base64#u8vector->base64-string
                       (std/crypto/etc#random-bytes '16)))))
               (_cfm618_
                (string-append
                 '"n="
                 (##direct-structure-ref
                  _ctx608_
                  '3
                  std/net/sasl#scram-context::t
                  '#f)
                 '",r="
                 _nonce616_)))
          (##direct-structure-set!
           _ctx608_
           _cfm618_
           '6
           std/net/sasl#scram-context::t
           '#f)
          (##direct-structure-set!
           _ctx608_
           _nonce616_
           '5
           std/net/sasl#scram-context::t
           '#f)
          (_first-message611_ _cfm618_)))))
  (define std/net/sasl#scram-client-first-message__0
    (lambda (_ctx626_)
      (let ((_nonce628_ '#f))
        (std/net/sasl#scram-client-first-message__% _ctx626_ _nonce628_))))
  (define std/net/sasl#scram-client-first-message
    (lambda _g4432_
      (let ((_g4431_ (let () (declare (not safe)) (##length _g4432_))))
        (cond ((let () (declare (not safe)) (##fx= _g4431_ 1))
               (apply std/net/sasl#scram-client-first-message__0 _g4432_))
              ((let () (declare (not safe)) (##fx= _g4431_ 2))
               (apply std/net/sasl#scram-client-first-message__% _g4432_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/sasl#scram-client-first-message
                _g4432_))))))
  (define std/net/sasl#scram-client-first-server-message!
    (lambda (_ctx584_ _sfm585_)
      (let* ((_msg587_ (std/net/sasl#scram-parse-message _sfm585_))
             (_r592_ (let ((_$e589_ (assget '"r" _msg587_)))
                       (if _$e589_
                           _$e589_
                           (std/net/sasl#fail
                            '"Invalid server message; missing nonce"
                            _msg587_))))
             (_s597_ (std/text/base64#base64-string->u8vector
                      (let ((_$e594_ (assget '"s" _msg587_)))
                        (if _$e594_
                            _$e594_
                            (std/net/sasl#fail
                             '"Invalid server message; missing salt"
                             _msg587_)))))
             (_i602_ (string->number
                      (let ((_$e599_ (assget '"i" _msg587_)))
                        (if _$e599_
                            _$e599_
                            (std/net/sasl#fail
                             '"Invalid server message; missing iteration count"
                             _msg587_)))))
             (_nonce604_
              (##direct-structure-ref
               _ctx584_
               '5
               std/net/sasl#scram-context::t
               '#f)))
        (if (and (fx> (string-length _r592_) (string-length _nonce604_))
                 (string-prefix? _nonce604_ _r592_))
            '#!void
            (std/net/sasl#fail '"Invalid server nonce" _r592_ _nonce604_))
        (##direct-structure-set!
         _ctx584_
         _sfm585_
         '7
         std/net/sasl#scram-context::t
         '#f)
        (##direct-structure-set!
         _ctx584_
         _r592_
         '8
         std/net/sasl#scram-context::t
         '#f)
        (##direct-structure-set!
         _ctx584_
         _s597_
         '9
         std/net/sasl#scram-context::t
         '#f)
        (##direct-structure-set!
         _ctx584_
         _i602_
         '10
         std/net/sasl#scram-context::t
         '#f)
        '#!void)))
  (define std/net/sasl#scram-client-final-message
    (lambda (_ctx472_)
      (letrec ((_final-message474_
                (lambda (_csm581_ _p582_)
                  (string-append _csm581_ '",p=" _p582_))))
        (let* ((_ctx475490_ _ctx472_)
               (_E477494_
                (lambda () (error '"No clause matching" _ctx475490_)))
               (_K478530_
                (lambda (_i497_
                         _s498_
                         _r499_
                         _sfm500_
                         _cfm501_
                         _passwd502_
                         _user503_
                         _hmac504_
                         _h505_)
                  (let* ((_csm507_ (string-append '"c=biws,r=" _r499_))
                         (_salted-passwd509_
                          (std/net/sasl#scram-Hi
                           _hmac504_
                           _passwd502_
                           _s498_
                           _i497_))
                         (_client-key511_
                          (_hmac504_
                           _salted-passwd509_
                           (std/text/utf8#string->utf8__0 '"Client Key")))
                         (_stored-key513_ (_h505_ _client-key511_))
                         (_auth-message515_
                          (std/text/utf8#string->utf8__0
                           (string-append
                            _cfm501_
                            '","
                            _sfm500_
                            '","
                            _csm507_)))
                         (_client-sign517_
                          (_hmac504_ _stored-key513_ _auth-message515_))
                         (_client-proof519_
                          (std/net/sasl#bytes-xor
                           _client-key511_
                           _client-sign517_))
                         (_p521_ (std/text/base64#u8vector->base64-string
                                  _client-proof519_))
                         (_server-key523_
                          (_hmac504_
                           _salted-passwd509_
                           (std/text/utf8#string->utf8__0 '"Server Key")))
                         (_server-sign525_
                          (_hmac504_ _server-key523_ _auth-message515_))
                         (_v527_ (std/text/base64#u8vector->base64-string
                                  _server-sign525_)))
                    (##direct-structure-set!
                     _ctx472_
                     _p521_
                     '11
                     std/net/sasl#scram-context::t
                     '#f)
                    (##direct-structure-set!
                     _ctx472_
                     _v527_
                     '12
                     std/net/sasl#scram-context::t
                     '#f)
                    (_final-message474_ _csm507_ _p521_)))))
          (if (let ()
                (declare (not safe))
                (##structure-direct-instance-of?
                 _ctx475490_
                 'std/net/sasl#scram-context::t))
              (let* ((_e479533_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ctx475490_ '1)))
                     (_h536_ _e479533_)
                     (_e480538_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ctx475490_ '2)))
                     (_hmac541_ _e480538_)
                     (_e481543_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ctx475490_ '3)))
                     (_user546_ _e481543_)
                     (_e482548_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ctx475490_ '4)))
                     (_passwd551_ _e482548_)
                     (_e483553_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ctx475490_ '5)))
                     (_e484556_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ctx475490_ '6)))
                     (_cfm559_ _e484556_)
                     (_e485561_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ctx475490_ '7)))
                     (_sfm564_ _e485561_)
                     (_e486566_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ctx475490_ '8)))
                     (_r569_ _e486566_)
                     (_e487571_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ctx475490_ '9)))
                     (_s574_ _e487571_)
                     (_e488576_
                      (let ()
                        (declare (not safe))
                        (##vector-ref _ctx475490_ '10)))
                     (_i579_ _e488576_))
                (_K478530_
                 _i579_
                 _s574_
                 _r569_
                 _sfm564_
                 _cfm559_
                 _passwd551_
                 _user546_
                 _hmac541_
                 _h536_))
              (_E477494_))))))
  (define std/net/sasl#scram-client-final-server-message!
    (lambda (_ctx454_ _smsg455_)
      (let ((_msg457_ (std/net/sasl#scram-parse-message _smsg455_)))
        (let ((_$e460_ (assget '"e" _msg457_)))
          (if _$e460_
              ((lambda (_what463_)
                 (std/net/sasl#fail '"Authentication failed" _what463_))
               _$e460_)
              (let ((_$e465_ (assget '"v" _msg457_)))
                (if _$e465_
                    ((lambda (_v468_)
                       (let ((_verifier470_
                              (##direct-structure-ref
                               _ctx454_
                               '12
                               std/net/sasl#scram-context::t
                               '#f)))
                         (if (equal? _v468_ _verifier470_)
                             '#!void
                             (std/net/sasl#fail
                              '"Authentication failed; invalid server signature"
                              _v468_
                              _verifier470_))))
                     _$e465_)
                    (std/net/sasl#fail
                     '"Malformed server message; missing verifier or error"
                     _msg457_))))))))
  (define std/net/sasl#scram-Hi
    (lambda (_hmac433_ _passwd434_ _salt435_ _count436_)
      (let* ((_key438_ (std/text/utf8#string->utf8__0 _passwd434_))
             (_u1440_ (_hmac433_
                       _key438_
                       (u8vector-append _salt435_ '#u8(0 0 0 1)))))
        (let _lp443_ ((_i445_ '1) (_ui446_ _u1440_) (_hi447_ _u1440_))
          (if (fx< _i445_ _count436_)
              (let* ((_ui+1449_ (_hmac433_ _key438_ _ui446_))
                     (_hi+1451_ (std/net/sasl#bytes-xor _ui+1449_ _hi447_)))
                (_lp443_ (fx+ _i445_ '1) _ui+1449_ _hi+1451_))
              _hi447_)))))
  (define std/net/sasl#bytes-xor
    (lambda (_a421_ _b422_)
      (let ((_len424_ (u8vector-length _a421_))
            (_len-b425_ (u8vector-length _b422_)))
        (if (fx= _len424_ _len-b425_)
            (let ((_res427_ (make-u8vector _len424_)))
              (let _lp429_ ((_i431_ '0))
                (if (fx< _i431_ _len424_)
                    (begin
                      (let ((__tmp4433
                             (let ((__tmp4435
                                    (let ()
                                      (declare (not safe))
                                      (##u8vector-ref _a421_ _i431_)))
                                   (__tmp4434
                                    (let ()
                                      (declare (not safe))
                                      (##u8vector-ref _b422_ _i431_))))
                               (declare (not safe))
                               (##fxxor __tmp4435 __tmp4434))))
                        (declare (not safe))
                        (##u8vector-set! _res427_ _i431_ __tmp4433))
                      (_lp429_ (fx+ _i431_ '1)))
                    _res427_)))
            (error '"Cannot xor bytes; length mismatch" _a421_ _b422_)))))
  (define std/net/sasl#scram-parse-message
    (lambda (_msg405_)
      (with-exception-catcher
       (lambda (_g406408_)
         (if '#t
             (let ((_e411_ _g406408_))
               (std/net/sasl#fail '"Malformed message" _msg405_ _e411_))
             (raise _g406408_)))
       (lambda ()
         (map (lambda (_str414_)
                (let ((_$e416_ (string-index _str414_ '#\=)))
                  (if _$e416_
                      ((lambda (_ix419_)
                         (cons (substring _str414_ '0 _ix419_)
                               (substring
                                _str414_
                                (fx+ _ix419_ '1)
                                (string-length _str414_))))
                       _$e416_)
                      (cons '"str" '#f))))
              (string-split _msg405_ '#\,))))))
  (define std/net/sasl#fail
    (lambda (_what402_ . _irritants403_)
      (apply std/error#raise-io-error
             'sasl-authenticate
             _what402_
             _irritants403_))))
