/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfParamToken;
import org.zaproxy.zap.extension.api.ZapApiIgnore;

public class AntiCsrfParam
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(AntiCsrfParam.class);
    private static final String ANTI_CSRF_BASE_KEY = "anticsrf";
    private static final String ALL_TOKENS_KEY = "anticsrf.tokens.token";
    private static final String TOKEN_NAME_KEY = "name";
    private static final String TOKEN_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_TOKEN_KEY = "anticsrf.confirmRemoveToken";
    private static final String[] DEFAULT_TOKENS_NAMES = new String[]{"anticsrf", "CSRFToken", "__RequestVerificationToken", "csrfmiddlewaretoken", "authenticity_token", "OWASP_CSRFTOKEN", "anoncsrf", "csrf_token", "_csrf", "_csrfSecret"};
    private List<AntiCsrfParamToken> tokens = null;
    private List<String> enabledTokensNames = null;
    private boolean confirmRemoveToken = true;

    @Override
    protected void parse() {
        try {
            List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_TOKENS_KEY);
            this.tokens = new ArrayList<AntiCsrfParamToken>(fields.size());
            this.enabledTokensNames = new ArrayList<String>(fields.size());
            ArrayList<String> tempTokensNames = new ArrayList<String>(fields.size());
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(TOKEN_NAME_KEY, "");
                if ("".equals(name) || tempTokensNames.contains(name)) continue;
                boolean enabled = sub.getBoolean(TOKEN_ENABLED_KEY, true);
                this.tokens.add(new AntiCsrfParamToken(name, enabled));
                tempTokensNames.add(name);
                if (!enabled) continue;
                this.enabledTokensNames.add(name);
            }
        }
        catch (ConversionException e) {
            logger.error((Object)("Error while loading anti CSRF tokens: " + e.getMessage()), (Throwable)e);
            this.tokens = new ArrayList<AntiCsrfParamToken>(DEFAULT_TOKENS_NAMES.length);
            this.enabledTokensNames = new ArrayList<String>(DEFAULT_TOKENS_NAMES.length);
        }
        this.addMissingTokens();
        this.confirmRemoveToken = this.getBoolean(CONFIRM_REMOVE_TOKEN_KEY, true);
    }

    private void addMissingTokens() {
        List<String> defaultTokensNames = Arrays.asList(DEFAULT_TOKENS_NAMES);
        if (this.getTokensNames().containsAll(defaultTokensNames)) {
            return;
        }
        defaultTokensNames.forEach(token -> this.addToken((String)token));
        this.setTokens(this.tokens);
    }

    @ZapApiIgnore
    public List<AntiCsrfParamToken> getTokens() {
        return this.tokens;
    }

    @ZapApiIgnore
    public void setTokens(List<AntiCsrfParamToken> tokens) {
        this.tokens = new ArrayList<AntiCsrfParamToken>(tokens);
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_TOKENS_KEY);
        ArrayList<String> enabledTokens = new ArrayList<String>(tokens.size());
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "anticsrf.tokens.token(" + i + ").";
            AntiCsrfParamToken token = tokens.get(i);
            this.getConfig().setProperty(elementBaseKey + TOKEN_NAME_KEY, (Object)token.getName());
            this.getConfig().setProperty(elementBaseKey + TOKEN_ENABLED_KEY, (Object)token.isEnabled());
            if (!token.isEnabled()) continue;
            enabledTokens.add(token.getName());
        }
        enabledTokens.trimToSize();
        this.enabledTokensNames = enabledTokens;
    }

    public void addToken(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        if (this.tokens.stream().noneMatch(token -> name.equals(token.getName()))) {
            this.tokens.add(new AntiCsrfParamToken(name));
            this.enabledTokensNames.add(name);
        }
    }

    public void removeToken(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        Iterator<AntiCsrfParamToken> it = this.tokens.iterator();
        while (it.hasNext()) {
            AntiCsrfParamToken token = it.next();
            if (!name.equals(token.getName())) continue;
            it.remove();
            if (!token.isEnabled()) break;
            this.enabledTokensNames.remove(name);
            break;
        }
    }

    @ZapApiIgnore
    public List<String> getTokensNames() {
        return this.enabledTokensNames;
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveToken() {
        return this.confirmRemoveToken;
    }

    @ZapApiIgnore
    public void setConfirmRemoveToken(boolean confirmRemove) {
        this.confirmRemoveToken = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_TOKEN_KEY, (Object)this.confirmRemoveToken);
    }
}

