/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitBuffer;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class Jt600ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_W01 = new PatternBuilder().text("(").number("(d+),").text("W01,").number("(ddd)(dd.dddd),").expression("([EW]),").number("(dd)(dd.dddd),").expression("([NS]),").expression("([AV]),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").any().compile();
    private static final Pattern PATTERN_U01 = new PatternBuilder().text("(").number("(d+),").number("(Udd),").number("d+,").optional().number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("([TF]),").number("(d+.d+),([NS]),").number("(d+.d+),([EW]),").number("(d+.?d*),").number("(d+),").number("(d+),").number("(d+)%,").expression("([01]+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+)").number(",(xx)").optional().any().compile();

    public Jt600ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static double convertCoordinate(int raw) {
        int degrees = raw / 1000000;
        double minutes = (double)(raw % 1000000) / 10000.0;
        return (double)degrees + minutes / 60.0;
    }

    private void decodeStatus(Position position, ByteBuf buf) {
        short value = buf.readUnsignedByte();
        position.set("ignition", BitUtil.check(value, 0));
        position.set("door", BitUtil.check(value, 6));
        value = buf.readUnsignedByte();
        position.set("charge", BitUtil.check(value, 0));
        position.set("blocked", BitUtil.check(value, 1));
        if (BitUtil.check(value, 2)) {
            position.set("alarm", "sos");
        }
        if (BitUtil.check(value, 3) || BitUtil.check(value, 4)) {
            position.set("alarm", "gpsAntennaCut");
        }
        if (BitUtil.check(value, 4)) {
            position.set("alarm", "overspeed");
        }
        if (BitUtil.check(value = buf.readUnsignedByte(), 2)) {
            position.set("alarm", "fatigueDriving");
        }
        if (BitUtil.check(value, 3)) {
            position.set("alarm", "tow");
        }
        buf.readUnsignedByte();
    }

    static boolean isLongFormat(ByteBuf buf, int flagIndex) {
        return buf.getUnsignedByte(flagIndex) >> 4 == 7;
    }

    static void decodeBinaryLocation(ByteBuf buf, Position position) {
        DateBuilder dateBuilder = new DateBuilder().setDay(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setYear(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
        position.setTime(dateBuilder.getDate());
        double latitude = Jt600ProtocolDecoder.convertCoordinate(BcdUtil.readInteger(buf, 8));
        double longitude = Jt600ProtocolDecoder.convertCoordinate(BcdUtil.readInteger(buf, 9));
        byte flags = buf.readByte();
        position.setValid((flags & 1) == 1);
        if ((flags & 2) == 0) {
            latitude = -latitude;
        }
        position.setLatitude(latitude);
        if ((flags & 4) == 0) {
            longitude = -longitude;
        }
        position.setLongitude(longitude);
        position.setSpeed(BcdUtil.readInteger(buf, 2));
        position.setCourse((double)buf.readUnsignedByte() * 2.0);
    }

    private List<Position> decodeBinary(ByteBuf buf, Channel channel, SocketAddress remoteAddress) {
        LinkedList<Position> positions = new LinkedList<Position>();
        buf.readByte();
        boolean longFormat = Jt600ProtocolDecoder.isLongFormat(buf, buf.readerIndex());
        String id = String.valueOf(Long.parseLong(ByteBufUtil.hexDump((ByteBuf)buf.readSlice(5))));
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        short protocolVersion = 0;
        if (longFormat) {
            protocolVersion = buf.readUnsignedByte();
        }
        int version = BitUtil.from(buf.readUnsignedByte(), 4);
        buf.readUnsignedShort();
        while (buf.readableBytes() > 1) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            Jt600ProtocolDecoder.decodeBinaryLocation(buf, position);
            if (longFormat) {
                position.set("odometer", buf.readUnsignedInt() * 1000L);
                position.set("sat", buf.readUnsignedByte());
                buf.readUnsignedInt();
                int status = buf.readUnsignedShort();
                position.set("alarm", BitUtil.check(status, 1) ? "geofenceEnter" : null);
                position.set("alarm", BitUtil.check(status, 2) ? "geofenceExit" : null);
                position.set("alarm", BitUtil.check(status, 3) ? "powerCut" : null);
                position.set("alarm", BitUtil.check(status, 4) ? "vibration" : null);
                position.set("blocked", BitUtil.check(status, 7));
                position.set("alarm", BitUtil.check(status, 11) ? "lowBattery" : null);
                position.set("alarm", BitUtil.check(status, 14) ? "fault" : null);
                position.set("status", status);
                short battery = buf.readUnsignedByte();
                if (battery == 255) {
                    position.set("charge", true);
                } else {
                    position.set("batteryLevel", Integer.valueOf(battery));
                }
                CellTower cellTower = CellTower.fromCidLac(buf.readUnsignedShort(), buf.readUnsignedShort());
                cellTower.setSignalStrength(Integer.valueOf(buf.readUnsignedByte()));
                position.setNetwork(new Network(cellTower));
                if (protocolVersion == 23) {
                    buf.readUnsignedByte();
                    buf.skipBytes(3);
                    buf.skipBytes(buf.readableBytes() - 1);
                }
            } else if (version == 1) {
                position.set("sat", buf.readUnsignedByte());
                position.set("power", buf.readUnsignedByte());
                buf.readByte();
                position.setAltitude(buf.readUnsignedShort());
                int cid = buf.readUnsignedShort();
                int lac = buf.readUnsignedShort();
                short rssi = buf.readUnsignedByte();
                if (cid != 0 && lac != 0) {
                    CellTower cellTower = CellTower.fromCidLac(cid, lac);
                    cellTower.setSignalStrength(Integer.valueOf(rssi));
                    position.setNetwork(new Network(cellTower));
                } else {
                    position.set("rssi", Integer.valueOf(rssi));
                }
            } else if (version == 2) {
                int fuel = buf.readUnsignedByte() << 8;
                this.decodeStatus(position, buf);
                position.set("odometer", buf.readUnsignedInt() * 1000L);
                position.set("fuel", fuel += buf.readUnsignedByte());
            } else if (version == 3) {
                BitBuffer bitBuffer = new BitBuffer(buf);
                position.set("fuel1", bitBuffer.readUnsigned(12));
                position.set("fuel2", bitBuffer.readUnsigned(12));
                position.set("fuel3", bitBuffer.readUnsigned(12));
                position.set("odometer", bitBuffer.readUnsigned(20) * 1000);
                int status = bitBuffer.readUnsigned(24);
                position.set("ignition", BitUtil.check(status, 0));
                position.set("status", status);
            }
            positions.add(position);
        }
        buf.readUnsignedByte();
        return positions;
    }

    private Position decodeW01(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN_W01, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setLongitude(parser.nextCoordinate());
        position.setLatitude(parser.nextCoordinate());
        position.setValid(parser.next().equals("A"));
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.set("power", parser.nextDouble(0.0));
        position.set("gps", parser.nextInt(0));
        position.set("rssi", parser.nextInt(0));
        position.set("alertType", parser.nextInt(0));
        return position;
    }

    private Position decodeU01(String sentence, Channel channel, SocketAddress remoteAddress) {
        Parser parser = new Parser(PATTERN_U01, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        String type = parser.next();
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setValid(parser.next().equals("T"));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setSpeed(UnitsConverter.knotsFromMph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.set("sat", parser.nextInt(0));
        position.set("batteryLevel", parser.nextInt(0));
        position.set("status", parser.nextBinInt(0));
        CellTower cellTower = CellTower.fromCidLac(parser.nextInt(0), parser.nextInt(0));
        cellTower.setSignalStrength(parser.nextInt(0));
        position.setNetwork(new Network(cellTower));
        position.set("odometer", parser.nextLong(0L) * 1000L);
        position.set("index", parser.nextInt(0));
        if (channel != null) {
            if (type.equals("U01") || type.equals("U02") || type.equals("U03")) {
                channel.writeAndFlush((Object)new NetworkMessage("(S39)", remoteAddress));
            } else if (type.equals("U06")) {
                channel.writeAndFlush((Object)new NetworkMessage("(S20)", remoteAddress));
            }
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        char first = (char)buf.getByte(0);
        if (first == '$') {
            return this.decodeBinary(buf, channel, remoteAddress);
        }
        if (first == '(') {
            String sentence = buf.toString(StandardCharsets.US_ASCII);
            if (sentence.contains("W01")) {
                return this.decodeW01(sentence, channel, remoteAddress);
            }
            return this.decodeU01(sentence, channel, remoteAddress);
        }
        return null;
    }
}

