/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class FifotrackProtocolDecoder
extends BaseProtocolDecoder {
    private ByteBuf photo;
    private static final Pattern PATTERN = new PatternBuilder().text("$$").number("d+,").number("(d+),").number("x+,").expression("[^,]+,").number("(d+)?,").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("([AV]),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(d+),").number("d+,").number("(x+),").number("(x+)?,").number("(x+)?,").number("(d+)|").number("(d+)|").number("(x+)|").number("(x+),").number("([x|]+)").expression(",([^,]+)").expression(",([^*]*)").optional(2).any().compile();
    private static final Pattern PATTERN_PHOTO = new PatternBuilder().text("$$").number("d+,").number("(d+),").any().number(",(d+),").expression("([^*]+)").text("*").number("xx").compile();
    private static final Pattern PATTERN_PHOTO_DATA = new PatternBuilder().text("$$").number("d+,").number("(d+),").number("x+,").expression("[^,]+,").expression("([^,]+),").number("(d+),").number("(d+),").compile();
    private static final Pattern PATTERN_RESULT = new PatternBuilder().text("$$").number("d+,").number("(d+),").any().expression(",([A-Z]+)").text("*").number("xx").compile();

    public FifotrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void requestPhoto(Channel channel, SocketAddress socketAddress, String imei, String file) {
        if (channel != null) {
            String content = "1,D06," + file + "," + this.photo.writerIndex() + "," + Math.min(1024, this.photo.writableBytes());
            int length = 1 + imei.length() + 1 + content.length();
            Object response = String.format("##%02d,%s,%s*", length, imei, content);
            response = (String)response + Checksum.sum((String)response) + "\r\n";
            channel.writeAndFlush((Object)new NetworkMessage(response, socketAddress));
        }
    }

    private String decodeAlarm(Integer alarm) {
        if (alarm != null) {
            switch (alarm) {
                case 2: {
                    return "sos";
                }
                case 14: {
                    return "lowPower";
                }
                case 15: {
                    return "powerCut";
                }
                case 16: {
                    return "powerRestored";
                }
                case 17: {
                    return "lowBattery";
                }
                case 18: {
                    return "overspeed";
                }
                case 20: {
                    return "gpsAntennaCut";
                }
                case 21: {
                    return "vibration";
                }
                case 23: {
                    return "hardAcceleration";
                }
                case 24: {
                    return "hardBraking";
                }
                case 27: {
                    return "fatigueDriving";
                }
                case 30: 
                case 32: {
                    return "jamming";
                }
                case 33: {
                    return "geofenceExit";
                }
                case 34: {
                    return "geofenceEnter";
                }
                case 35: {
                    return "idle";
                }
                case 40: 
                case 41: {
                    return "temperature";
                }
            }
            return null;
        }
        return null;
    }

    private Object decodeLocation(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("alarm", this.decodeAlarm(parser.nextInt()));
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.setAltitude(parser.nextInt().intValue());
        position.set("odometer", parser.nextLong());
        long status = parser.nextHexLong();
        position.set("rssi", BitUtil.between(status, 3, 8));
        position.set("sat", BitUtil.from(status, 28));
        position.set("status", status);
        position.set("input", parser.nextHexInt());
        position.set("output", parser.nextHexInt());
        position.setNetwork(new Network(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextHexInt(), parser.nextHexInt().intValue())));
        String[] adc = parser.next().split("\\|");
        for (int i = 0; i < adc.length; ++i) {
            position.set("adc" + (i + 1), Integer.parseInt(adc[i], 16));
        }
        if (parser.hasNext()) {
            position.set("driverUniqueId", String.valueOf(parser.nextHexInt()));
        }
        if (parser.hasNext()) {
            String[] sensors = parser.next().split("\\|");
            for (int i = 0; i < sensors.length; ++i) {
                position.set("io" + (i + 1), sensors[i]);
            }
        }
        return position;
    }

    private Object decodeResult(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_RESULT, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("result", parser.next());
        return position;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int typeIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)44) + 1;
        typeIndex = buf.indexOf(typeIndex, buf.writerIndex(), (byte)44) + 1;
        String type = buf.toString(typeIndex = buf.indexOf(typeIndex, buf.writerIndex(), (byte)44) + 1, 3, StandardCharsets.US_ASCII);
        if (type.startsWith("B")) {
            return this.decodeResult(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII));
        }
        if (type.equals("D05")) {
            String sentence = buf.toString(StandardCharsets.US_ASCII);
            Parser parser = new Parser(PATTERN_PHOTO, sentence);
            if (!parser.matches()) return null;
            String imei = parser.next();
            int length = parser.nextInt();
            String photoId = parser.next();
            this.photo = Unpooled.buffer((int)length);
            this.requestPhoto(channel, remoteAddress, imei, photoId);
            return null;
        } else {
            if (!type.equals("D06")) return this.decodeLocation(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII));
            if (this.photo == null) {
                return null;
            }
            int dataIndex = buf.indexOf(typeIndex + 4, buf.writerIndex(), (byte)44) + 1;
            dataIndex = buf.indexOf(dataIndex, buf.writerIndex(), (byte)44) + 1;
            dataIndex = buf.indexOf(dataIndex, buf.writerIndex(), (byte)44) + 1;
            String sentence = buf.toString(buf.readerIndex(), dataIndex, StandardCharsets.US_ASCII);
            Parser parser = new Parser(PATTERN_PHOTO_DATA, sentence);
            if (!parser.matches()) return null;
            String imei = parser.next();
            String photoId = parser.next();
            parser.nextInt();
            parser.nextInt();
            buf.readerIndex(dataIndex);
            buf.readBytes(this.photo, buf.readableBytes() - 3);
            if (this.photo.isWritable()) {
                this.requestPhoto(channel, remoteAddress, imei, photoId);
                return null;
            } else {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(this.getDeviceSession(channel, remoteAddress, imei).getDeviceId());
                this.getLastLocation(position, null);
                position.set("image", Context.getMediaManager().writeFile(imei, this.photo, "jpg"));
                this.photo.release();
                this.photo = null;
                return position;
            }
        }
    }
}

