/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notification;

import org.apache.velocity.VelocityContext;
import org.traccar.Context;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.FullMessage;
import org.traccar.notification.TextTemplateFormatter;
import org.traccar.reports.ReportUtils;

public final class NotificationFormatter {
    private NotificationFormatter() {
    }

    public static VelocityContext prepareContext(long userId, Event event, Position position) {
        String driverUniqueId;
        User user = Context.getPermissionsManager().getUser(userId);
        Device device = Context.getIdentityManager().getById(event.getDeviceId());
        VelocityContext velocityContext = TextTemplateFormatter.prepareContext(user);
        velocityContext.put("device", (Object)device);
        velocityContext.put("event", (Object)event);
        if (position != null) {
            velocityContext.put("position", (Object)position);
            velocityContext.put("speedUnit", (Object)ReportUtils.getSpeedUnit(userId));
            velocityContext.put("distanceUnit", (Object)ReportUtils.getDistanceUnit(userId));
            velocityContext.put("volumeUnit", (Object)ReportUtils.getVolumeUnit(userId));
        }
        if (event.getGeofenceId() != 0L) {
            velocityContext.put("geofence", Context.getGeofenceManager().getById(event.getGeofenceId()));
        }
        if (event.getMaintenanceId() != 0L) {
            velocityContext.put("maintenance", Context.getMaintenancesManager().getById(event.getMaintenanceId()));
        }
        if ((driverUniqueId = event.getString("driverUniqueId")) != null) {
            velocityContext.put("driver", (Object)Context.getDriversManager().getDriverByUniqueId(driverUniqueId));
        }
        return velocityContext;
    }

    public static FullMessage formatFullMessage(long userId, Event event, Position position) {
        VelocityContext velocityContext = NotificationFormatter.prepareContext(userId, event, position);
        return TextTemplateFormatter.formatFullMessage(velocityContext, event.getType());
    }

    public static String formatShortMessage(long userId, Event event, Position position) {
        VelocityContext velocityContext = NotificationFormatter.prepareContext(userId, event, position);
        return TextTemplateFormatter.formatShortMessage(velocityContext, event.getType());
    }
}

