/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.nonblocking;

import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.nonblocking.AcceptorCallable;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerTCPNonBlockingTransportHandler
extends TransportHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int port;
    private ServerSocket serverSocket;
    private Socket clientSocket;
    private AcceptorCallable callable;
    private FutureTask<Socket> task;
    private Thread thread;

    public ServerTCPNonBlockingTransportHandler(long timeout, int port) {
        super(timeout, ConnectionEndType.SERVER);
        this.port = port;
    }

    @Override
    public void closeConnection() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        if (this.clientSocket != null) {
            this.clientSocket.close();
        }
    }

    @Override
    public void initialize() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        this.callable = new AcceptorCallable(this.serverSocket);
        this.task = new FutureTask<Socket>(this.callable);
        this.thread = new Thread(this.task);
        this.thread.start();
        this.recheck();
    }

    public void recheck() throws IOException {
        if (this.task != null) {
            if (this.task.isDone()) {
                try {
                    this.clientSocket = this.task.get();
                    this.clientSocket.setSoTimeout(1);
                    this.setStreams(new PushbackInputStream(this.clientSocket.getInputStream()), this.clientSocket.getOutputStream());
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOGGER.warn("Could not retrieve clientSocket");
                    LOGGER.debug((Object)ex);
                }
            } else {
                LOGGER.debug("TransportHandler not yet connected");
            }
        } else {
            throw new IOException("Transporthandler is not initalized!");
        }
    }

    public void recheck(long timeout) throws IOException {
        try {
            if (this.task != null) {
                this.clientSocket = this.task.get(timeout, TimeUnit.MILLISECONDS);
                if (this.clientSocket != null) {
                    this.setStreams(new PushbackInputStream(this.clientSocket.getInputStream()), this.clientSocket.getOutputStream());
                }
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOGGER.warn("Could not retrieve clientSocket");
            LOGGER.debug((Object)ex);
        }
    }

    @Override
    public boolean isClosed() throws IOException {
        if (this.isInitialized()) {
            if (this.clientSocket != null && this.clientSocket.isClosed()) {
                if (this.serverSocket.isClosed()) {
                    return true;
                }
                if (this.clientSocket == null && this.serverSocket.isClosed()) {
                    return true;
                }
            }
            return false;
        }
        throw new IOException("Transporthandler is not initalized!");
    }

    @Override
    public void closeClientConnection() throws IOException {
        if (this.clientSocket != null && !this.clientSocket.isClosed()) {
            this.clientSocket.close();
        }
    }

    public int getPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return this.port;
    }
}

