/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemBufferedChCiphersAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlElements(value={@XmlElement(type=CipherSuite.class, name="suite")})
    private List<CipherSuite> removeCiphers = new ArrayList<CipherSuite>();

    public RemBufferedChCiphersAction() {
    }

    public RemBufferedChCiphersAction(String alias) {
        this.connectionAlias = alias;
    }

    public RemBufferedChCiphersAction(List<CipherSuite> removeCiphers) {
        this.removeCiphers = removeCiphers;
    }

    public RemBufferedChCiphersAction(CipherSuite ... removeCiphers) {
        this(new ArrayList<CipherSuite>(Arrays.asList(removeCiphers)));
    }

    public RemBufferedChCiphersAction(String alias, List<CipherSuite> removeCiphers) {
        super(alias);
        this.removeCiphers = removeCiphers;
    }

    public RemBufferedChCiphersAction(String alias, CipherSuite ... removeCiphers) {
        super(alias);
        this.removeCiphers = new ArrayList<CipherSuite>(Arrays.asList(removeCiphers));
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext ctx = state.getTlsContext(this.connectionAlias);
        ClientHelloMessage ch = (ClientHelloMessage)ctx.getMessageBuffer().getFirst();
        this.removeCiphers(ctx, ch);
        this.setExecuted(true);
    }

    private void removeCiphers(TlsContext ctx, ClientHelloMessage ch) {
        String msg_name = ch.toCompactString();
        if (ch.getCipherSuites() == null) {
            LOGGER.debug("No cipher suites found in " + msg_name + ". Nothing to do.");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Original cipher suites in " + msg_name + ":\n" + this.summarizeCiphers(ch));
        }
        byte[] ciphersBytes = (byte[])ch.getCipherSuites().getValue();
        List<CipherSuite> ciphers = CipherSuite.getCiphersuites(ciphersBytes);
        int origCiphersLength = ciphersBytes.length;
        ByteArrayOutputStream newCiphersBytes = new ByteArrayOutputStream();
        for (CipherSuite cs : ciphers) {
            LOGGER.debug("cipher.name, cipher.val = " + cs.name() + ", " + cs.getValue());
            if (this.removeCiphers.contains((Object)cs)) continue;
            try {
                newCiphersBytes.write(cs.getByteValue());
            }
            catch (IOException ex) {
                throw new WorkflowExecutionException("Could not write CipherSuite value to byte[]", ex);
            }
        }
        ch.setCipherSuites(newCiphersBytes.toByteArray());
        int newSuitesLength = ((byte[])ch.getCipherSuites().getValue()).length;
        int diffSuitesLength = origCiphersLength - newSuitesLength;
        int newMsgLength = (Integer)ch.getLength().getValue() - diffSuitesLength;
        ch.setLength(newMsgLength);
        ch.setCipherSuiteLength(newSuitesLength);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Modified cipher suites in " + msg_name + ":\n" + this.summarizeCiphers(ch));
        }
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }

    public List<CipherSuite> getRemoveCiphers() {
        return this.removeCiphers;
    }

    public void setRemoveCiphers(List<CipherSuite> removeCiphers) {
        this.removeCiphers = removeCiphers;
    }

    public void setRemoveCiphers(CipherSuite ... removeCiphers) {
        this.removeCiphers = new ArrayList<CipherSuite>(Arrays.asList(removeCiphers));
    }

    public String summarizeCiphers(ClientHelloMessage ch) {
        StringBuilder sb = new StringBuilder();
        sb.append("cipher suite bytes length: ").append(((byte[])ch.getCipherSuites().getValue()).length);
        sb.append("\ncipher suite bytes:");
        sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])ch.getCipherSuites().getValue())));
        sb.append("\nreadable cipher suite list:\n");
        for (CipherSuite cs : CipherSuite.getCiphersuites((byte[])ch.getCipherSuites().getValue())) {
            sb.append(cs.name()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void normalize() {
        super.normalize();
        this.initEmptyLists();
    }

    @Override
    public void normalize(TlsAction defaultAction) {
        super.normalize(defaultAction);
        this.initEmptyLists();
    }

    @Override
    public void filter() {
        super.filter();
        this.stripEmptyLists();
    }

    @Override
    public void filter(TlsAction defaultAction) {
        super.filter(defaultAction);
        this.stripEmptyLists();
    }

    private void stripEmptyLists() {
        if (this.removeCiphers == null || this.removeCiphers.isEmpty()) {
            this.removeCiphers = null;
        }
    }

    private void initEmptyLists() {
        if (this.removeCiphers == null) {
            this.removeCiphers = new ArrayList<CipherSuite>();
        }
        if (this.removeCiphers == null) {
            this.removeCiphers = new ArrayList<CipherSuite>();
        }
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 19 * hash + Objects.hashCode(this.removeCiphers);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemBufferedChCiphersAction other = (RemBufferedChCiphersAction)obj;
        if (!Objects.equals(this.removeCiphers, other.removeCiphers)) {
            return false;
        }
        return super.equals(obj);
    }
}

