/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CachedInfoExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.cachedinfo.CachedObject;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.CachedObjectPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.CachedObjectSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class CachedInfoExtensionPreparator
extends ExtensionPreparator<CachedInfoExtensionMessage> {
    private final CachedInfoExtensionMessage msg;

    public CachedInfoExtensionPreparator(Chooser chooser, CachedInfoExtensionMessage message, ExtensionSerializer<CachedInfoExtensionMessage> serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (CachedObject co : this.msg.getCachedInfo()) {
            CachedObjectPreparator preparator = new CachedObjectPreparator(this.chooser, co);
            preparator.prepare();
            CachedObjectSerializer serializer = new CachedObjectSerializer(co);
            try {
                stream.write(serializer.serialize());
            }
            catch (IOException ex) {
                throw new PreparationException("Could not write byte[] from CachedObject", ex);
            }
        }
        this.msg.setCachedInfoBytes(stream.toByteArray());
        this.msg.setCachedInfoLength(((byte[])this.msg.getCachedInfoBytes().getValue()).length);
    }
}

