/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import java.util.LinkedList;
import java.util.List;

public class KeyShareExtensionMessage
extends ExtensionMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger keyShareListLength;
    @ModifiableVariableProperty
    private ModifiableByteArray keyShareListBytes;
    @HoldsModifiableVariable
    private List<KeyShareEntry> keyShareList = new LinkedList<KeyShareEntry>();

    public KeyShareExtensionMessage() {
        super(ExtensionType.KEY_SHARE);
    }

    public KeyShareExtensionMessage(Config tlsConfig) {
        super(ExtensionType.KEY_SHARE);
        for (KeyShareStoreEntry storeEntry : tlsConfig.getDefaultClientKeyShareEntries()) {
            KeyShareEntry keyShareEntry = new KeyShareEntry(storeEntry.getGroup(), tlsConfig.getKeySharePrivate());
            this.keyShareList.add(keyShareEntry);
        }
    }

    public ModifiableInteger getKeyShareListLength() {
        return this.keyShareListLength;
    }

    public void setKeyShareListLength(ModifiableInteger serverNameListLength) {
        this.keyShareListLength = serverNameListLength;
    }

    public void setKeyShareListLength(int length) {
        this.keyShareListLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.keyShareListLength, (Integer)length);
    }

    public ModifiableByteArray getKeyShareListBytes() {
        return this.keyShareListBytes;
    }

    public void setKeyShareListBytes(ModifiableByteArray serverNameListBytes) {
        this.keyShareListBytes = serverNameListBytes;
    }

    public void setKeyShareListBytes(byte[] bytes) {
        this.keyShareListBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.keyShareListBytes, (byte[])bytes);
    }

    public List<KeyShareEntry> getKeyShareList() {
        return this.keyShareList;
    }

    public void setKeyShareList(List<KeyShareEntry> keyShareList) {
        this.keyShareList = keyShareList;
    }
}

