/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import au.com.trgtd.tr.appl.Constants;
import java.io.File;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.util.NbBundle;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.extract.ExtractData;
import tr.extract.Param;
import tr.extract.XSL;
import tr.extract.XSLFO;
import tr.extract.prefs.ExtractPrefs;
import tr.model.Data;
import tr.runtime.Open;
import tr.util.UtilsFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Extract {
    public abstract String getID();

    public abstract String getName();

    public abstract List<Param> getParams();

    public abstract void process(Data var1) throws Exception;

    public String getDialogTitleReport(String reportName) {
        return NbBundle.getMessage(Extract.class, (String)"param-dialog-title-report", (Object)reportName);
    }

    public String getDialogTitleExport(String exportName) {
        return NbBundle.getMessage(Extract.class, (String)"param-dialog-title-export", (Object)exportName);
    }

    public final String getString(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    public static final String getTimeStamp() {
        return Constants.DF_TIMESTAMP.format(Calendar.getInstance().getTime());
    }

    public static final File getTmpFile(String filename) throws Exception {
        return new File(UtilsFile.getTempDir(), filename);
    }

    public static final File getOutFile(String filename) throws Exception {
        File dataFile;
        String path = ExtractPrefs.getPath();
        if (path.trim().length() > 0) {
            return new File(path, filename);
        }
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds != null && (dataFile = new File(ds.getPath())).isFile()) {
            return new File(dataFile.getParent(), filename);
        }
        throw new Exception("Data file not found.");
    }

    public final void extractData(Data data, File extractFile, FormatType type) {
        ExtractData.process(data, extractFile, type);
    }

    public static final void openFile(File file) {
        Open.openFile((File)file);
    }

    public final void openTextFile(File file) {
        Open.openTextFile((File)file);
    }

    public final void transformXSLFO(File xml, URL xslfo, List<Param> params, File out) throws Exception {
        XSLFO.transform(xml, xslfo.openStream(), params, out);
    }

    public final void transformXSL(File xml, URL xsl, List<Param> params, File out, String encoding, boolean isXML) throws Exception {
        XSL.transform(xml, xsl.openStream(), params, out, encoding, isXML);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FormatType {
        CSV,
        XML;


        public String escape(String string) {
            if (string == null) {
                return "";
            }
            if (this == XML) {
                return StringEscapeUtils.escapeXml((String)string);
            }
            if (this == CSV) {
                string = "\"" + string.replace("\"", "\"\"") + "\"";
                return StringEscapeUtils.escapeXml((String)string);
            }
            return string;
        }
    }
}

