/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.DistributedQueue;
import org.apache.solr.client.solrj.cloud.autoscaling.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.cloud.Stats;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Pair;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDistributedQueue
implements DistributedQueue {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String PREFIX = "qn-";
    private static final Object _IMPLEMENTATION_NOTES = null;
    final String dir;
    final DistribStateManager stateManager;
    final Stats stats;
    private final ReentrantLock updateLock = new ReentrantLock();
    private TreeSet<String> knownChildren = new TreeSet();
    private final Condition changed = this.updateLock.newCondition();
    private boolean isDirty = true;
    private int watcherCount = 0;
    private final int maxQueueSize;
    private final AtomicInteger offerPermits = new AtomicInteger(0);

    public GenericDistributedQueue(DistribStateManager stateManager, String dir) {
        this(stateManager, dir, new Stats());
    }

    public GenericDistributedQueue(DistribStateManager stateManager, String dir, Stats stats) {
        this(stateManager, dir, stats, 0);
    }

    public GenericDistributedQueue(DistribStateManager stateManager, String dir, Stats stats, int maxQueueSize) {
        this.dir = dir;
        try {
            if (!stateManager.hasData(dir)) {
                try {
                    stateManager.makePath(dir);
                }
                catch (AlreadyExistsException alreadyExistsException) {}
            }
        }
        catch (IOException | KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        this.stateManager = stateManager;
        this.stats = stats;
        this.maxQueueSize = maxQueueSize;
    }

    public byte[] peek() throws Exception {
        Timer.Context time = this.stats.time(this.dir + "_peek");
        try {
            byte[] byArray = this.firstElement();
            return byArray;
        }
        finally {
            time.stop();
        }
    }

    public byte[] peek(boolean block) throws Exception {
        return block ? this.peek(Long.MAX_VALUE) : this.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] peek(long wait) throws Exception {
        Preconditions.checkArgument((wait > 0L ? 1 : 0) != 0);
        Timer.Context time = wait == Long.MAX_VALUE ? this.stats.time(this.dir + "_peek_wait_forever") : this.stats.time(this.dir + "_peek_wait" + wait);
        this.updateLock.lockInterruptibly();
        try {
            long waitNanos = TimeUnit.MILLISECONDS.toNanos(wait);
            while (waitNanos > 0L) {
                byte[] result = this.firstElement();
                if (result != null) {
                    byte[] byArray = result;
                    return byArray;
                }
                waitNanos = this.changed.awaitNanos(waitNanos);
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.updateLock.unlock();
            time.stop();
        }
    }

    public byte[] poll() throws Exception {
        Timer.Context time = this.stats.time(this.dir + "_poll");
        try {
            byte[] byArray = this.removeFirst();
            return byArray;
        }
        finally {
            time.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] remove() throws Exception {
        Timer.Context time = this.stats.time(this.dir + "_remove");
        try {
            byte[] result = this.removeFirst();
            if (result == null) {
                throw new NoSuchElementException();
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            time.stop();
        }
    }

    public void remove(Collection<String> paths) throws Exception {
        if (paths.isEmpty()) {
            return;
        }
        ArrayList<Op> ops = new ArrayList<Op>();
        for (String path : paths) {
            ops.add(Op.delete((String)(this.dir + "/" + path), (int)-1));
        }
        for (int from = 0; from < ops.size(); from += 1000) {
            int to = Math.min(from + 1000, ops.size());
            if (from >= to) continue;
            try {
                this.stateManager.multi(ops.subList(from, to));
                continue;
            }
            catch (NoSuchElementException e) {
                for (int j = from; j < to; ++j) {
                    try {
                        this.stateManager.removeData(((Op)ops.get(j)).getPath(), -1);
                        continue;
                    }
                    catch (NoSuchElementException e2) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Can not remove node which is not exist : {}", (Object)((Op)ops.get(j)).getPath());
                    }
                }
            }
        }
        int cacheSizeBefore = this.knownChildren.size();
        this.knownChildren.removeAll(paths);
        if (cacheSizeBefore - paths.size() == this.knownChildren.size() && this.knownChildren.size() != 0) {
            this.stats.setQueueLength(this.knownChildren.size());
        } else {
            this.knownChildren.clear();
            this.isDirty = true;
        }
    }

    public byte[] take() throws Exception {
        Timer.Context timer = this.stats.time(this.dir + "_take");
        this.updateLock.lockInterruptibly();
        try {
            while (true) {
                byte[] result;
                if ((result = this.removeFirst()) != null) {
                    byte[] byArray = result;
                    return byArray;
                }
                this.changed.await();
            }
        }
        finally {
            this.updateLock.unlock();
            timer.stop();
        }
    }

    public void offer(byte[] data) throws Exception {
        Timer.Context time = this.stats.time(this.dir + "_offer");
        while (true) {
            try {
                if (this.maxQueueSize > 0 && (this.offerPermits.get() <= 0 || this.offerPermits.getAndDecrement() <= 0)) {
                    if (!this.stateManager.hasData(this.dir)) {
                        throw new NoSuchElementException();
                    }
                    List children = this.stateManager.listData(this.dir);
                    int remainingCapacity = this.maxQueueSize - children.size();
                    if (remainingCapacity <= 0) {
                        throw new IllegalStateException("queue is full");
                    }
                    this.offerPermits.set(remainingCapacity / 100);
                }
                this.stateManager.createData(this.dir + "/" + PREFIX, data, CreateMode.PERSISTENT_SEQUENTIAL);
                this.isDirty = true;
                return;
            }
            catch (NoSuchElementException e) {
                try {
                    this.stateManager.createData(this.dir, new byte[0], CreateMode.PERSISTENT);
                }
                catch (NoSuchElementException noSuchElementException) {}
                continue;
            }
            break;
        }
        finally {
            time.stop();
        }
    }

    public Stats getZkStats() {
        return this.stats;
    }

    public Map<String, Object> getStats() {
        if (this.stats == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("queueLength", this.stats.getQueueLength());
        HashMap statsMap = new HashMap();
        res.put("stats", statsMap);
        this.stats.getStats().forEach((op, stat) -> {
            HashMap<String, Serializable> statMap = new HashMap<String, Serializable>();
            statMap.put("success", Integer.valueOf(stat.success.get()));
            statMap.put("errors", Integer.valueOf(stat.errors.get()));
            ArrayList failed = new ArrayList(stat.failureDetails.size());
            statMap.put("failureDetails", failed);
            stat.failureDetails.forEach(failedOp -> {
                HashMap<String, Object> fo = new HashMap<String, Object>();
                fo.put("req", failedOp.req);
                fo.put("resp", failedOp.resp);
            });
            statsMap.put(op, statMap);
        });
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String firstChild(boolean remove, boolean refetchIfDirty) throws Exception {
        this.updateLock.lockInterruptibly();
        try {
            if (!(this.knownChildren.isEmpty() || this.isDirty && refetchIfDirty)) {
                String string = remove ? this.knownChildren.pollFirst() : this.knownChildren.first();
                return string;
            }
            if (!this.isDirty && this.knownChildren.isEmpty()) {
                String string = null;
                return string;
            }
            ChildWatcher newWatcher = this.watcherCount == 0 ? new ChildWatcher() : null;
            this.knownChildren = this.fetchZkChildren(newWatcher);
            if (newWatcher != null) {
                ++this.watcherCount;
            }
            this.isDirty = false;
            if (this.knownChildren.isEmpty()) {
                String string = null;
                return string;
            }
            this.changed.signalAll();
            String string = remove ? this.knownChildren.pollFirst() : this.knownChildren.first();
            return string;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    TreeSet<String> fetchZkChildren(Watcher watcher) throws Exception {
        while (true) {
            try {
                TreeSet<String> orderedChildren = new TreeSet<String>();
                List childNames = this.stateManager.listData(this.dir, watcher);
                this.stats.setQueueLength(childNames.size());
                for (String childName : childNames) {
                    if (!childName.regionMatches(0, PREFIX, 0, PREFIX.length())) {
                        log.debug("Found child node with improper name: {}", (Object)childName);
                        continue;
                    }
                    orderedChildren.add(childName);
                }
                return orderedChildren;
            }
            catch (NoSuchElementException e) {
                try {
                    this.stateManager.makePath(this.dir);
                }
                catch (AlreadyExistsException alreadyExistsException) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Pair<String, byte[]>> peekElements(int max, long waitMillis, Predicate<String> acceptFilter) throws Exception {
        ArrayList<String> foundChildren = new ArrayList<String>();
        long waitNanos = TimeUnit.MILLISECONDS.toNanos(waitMillis);
        boolean first = true;
        while (true) {
            this.firstChild(false, !first);
            this.updateLock.lockInterruptibly();
            try {
                for (String child : this.knownChildren) {
                    if (!acceptFilter.test(child)) continue;
                    foundChildren.add(child);
                }
                if (!foundChildren.isEmpty() || waitNanos <= 0L) break;
                if (first) {
                    first = false;
                    continue;
                }
                waitNanos = this.changed.awaitNanos(waitNanos);
            }
            finally {
                this.updateLock.unlock();
                continue;
            }
            if (!foundChildren.isEmpty()) break;
        }
        ArrayList<Pair<String, byte[]>> result = new ArrayList<Pair<String, byte[]>>();
        for (String child : foundChildren) {
            if (result.size() >= max) break;
            try {
                VersionedData data = this.stateManager.getData(this.dir + "/" + child);
                result.add((Pair<String, byte[]>)new Pair((Object)child, (Object)data.getData()));
            }
            catch (NoSuchElementException e) {
                this.updateLock.lockInterruptibly();
                try {
                    this.knownChildren.remove(child);
                }
                finally {
                    this.updateLock.unlock();
                }
            }
        }
        return result;
    }

    private byte[] firstElement() throws Exception {
        String firstChild;
        while ((firstChild = this.firstChild(false, false)) != null) {
            try {
                VersionedData data = this.stateManager.getData(this.dir + "/" + firstChild);
                return data != null ? data.getData() : null;
            }
            catch (NoSuchElementException e) {
                this.updateLock.lockInterruptibly();
                try {
                    this.knownChildren.clear();
                    this.isDirty = true;
                    continue;
                }
                finally {
                    this.updateLock.unlock();
                    continue;
                }
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] removeFirst() throws Exception {
        String firstChild;
        while ((firstChild = this.firstChild(true, false)) != null) {
            try {
                String path = this.dir + "/" + firstChild;
                VersionedData result = this.stateManager.getData(path);
                this.stateManager.removeData(path, -1);
                this.stats.setQueueLength(this.knownChildren.size());
                return result.getData();
            }
            catch (NoSuchElementException e) {
                this.updateLock.lockInterruptibly();
                try {
                    this.knownChildren.clear();
                    this.isDirty = true;
                    continue;
                }
                finally {
                    this.updateLock.unlock();
                    continue;
                }
            }
            break;
        }
        return null;
    }

    @VisibleForTesting
    int watcherCount() throws InterruptedException {
        this.updateLock.lockInterruptibly();
        try {
            int n = this.watcherCount;
            return n;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    @VisibleForTesting
    boolean isDirty() throws InterruptedException {
        this.updateLock.lockInterruptibly();
        try {
            boolean bl = this.isDirty;
            return bl;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    @VisibleForTesting
    class ChildWatcher
    implements Watcher {
        ChildWatcher() {
        }

        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType()) && !Watcher.Event.KeeperState.Expired.equals((Object)event.getState())) {
                return;
            }
            GenericDistributedQueue.this.updateLock.lock();
            try {
                GenericDistributedQueue.this.isDirty = true;
                GenericDistributedQueue.this.watcherCount--;
                GenericDistributedQueue.this.changed.signalAll();
            }
            finally {
                GenericDistributedQueue.this.updateLock.unlock();
            }
        }
    }
}

