/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.util.LinkedList;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.GradleProjectLoader;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.loaders.AbstractProjectLoader;
import org.netbeans.modules.gradle.loaders.BundleProjectLoader;
import org.netbeans.modules.gradle.loaders.DiskCacheProjectLoader;
import org.netbeans.modules.gradle.loaders.FallbackProjectLoader;
import org.netbeans.modules.gradle.loaders.LegacyProjectLoader;
import org.netbeans.modules.gradle.options.GradleExperimentalSettings;

public class GradleProjectLoaderImpl
implements GradleProjectLoader {
    final Project project;
    private String actionDescription;
    private static final Logger LOGGER = Logger.getLogger(GradleProjectLoaderImpl.class.getName());

    public GradleProjectLoaderImpl(Project project) {
        this.project = project;
    }

    @Override
    public GradleProject loadProject(NbGradleProject.Quality aim, String descriptionOpt, boolean ignoreCache, boolean interactive, String ... args) {
        LOGGER.info("Load aiming " + (Object)((Object)aim) + " for " + this.project);
        GradleCommandLine cmd = new GradleCommandLine(args);
        AbstractProjectLoader.ReloadContext ctx = new AbstractProjectLoader.ReloadContext((NbGradleProjectImpl)this.project, aim, cmd, descriptionOpt);
        LinkedList<AbstractProjectLoader> loaders = new LinkedList<AbstractProjectLoader>();
        if (!ignoreCache) {
            loaders.add(new DiskCacheProjectLoader(ctx));
        }
        if (GradleExperimentalSettings.getDefault().isBundledLoading()) {
            loaders.add(new BundleProjectLoader(ctx));
            loaders.add(new DiskCacheProjectLoader(ctx));
        }
        loaders.add(new LegacyProjectLoader(ctx));
        loaders.add(new FallbackProjectLoader(ctx));
        Boolean trust = null;
        GradleProject ret = null;
        for (AbstractProjectLoader loader : loaders) {
            if (!loader.isEnabled()) continue;
            if (loader.needsTrust()) {
                if (trust == null) {
                    trust = RunUtils.isProjectTrusted(ctx.project, interactive);
                }
                if (trust.booleanValue()) {
                    ret = loader.load();
                } else {
                    ret = ctx.getPrevious();
                    if (ret != null) {
                        ret = ret.invalidate("Gradle execution is not trusted on this project.");
                    }
                }
            } else {
                ret = loader.load();
            }
            if (ret == null) continue;
            break;
        }
        if (ret == null) {
            throw new NullPointerException("Could not load Gradle Project: " + this.project);
        }
        return ret;
    }
}

