/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.tree;

import java.awt.Image;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class FileTreeElement
implements TreeElement,
Openable {
    private FileObject fo;

    FileTreeElement(FileObject fo) {
        this.fo = fo;
    }

    public TreeElement getParent(boolean isLogical) {
        if (isLogical) {
            if (FileUtil.isArchiveFile((FileObject)this.fo)) {
                FileObject root = FileUtil.getArchiveRoot((FileObject)this.fo);
                JavaPlatformManager manager = JavaPlatformManager.getDefault();
                for (JavaPlatform javaPlatform : manager.getInstalledPlatforms()) {
                    if (!javaPlatform.getSourceFolders().contains(root) && !javaPlatform.getStandardLibraries().contains(root) && !javaPlatform.getBootstrapLibraries().contains(root)) continue;
                    return TreeElementFactory.getTreeElement((Object)javaPlatform);
                }
                return null;
            }
            return TreeElementFactory.getTreeElement((Object)this.fo.getParent());
        }
        if (FileUtil.isArchiveFile((FileObject)this.fo)) {
            FileObject root = FileUtil.getArchiveRoot((FileObject)this.fo);
            JavaPlatformManager manager = JavaPlatformManager.getDefault();
            for (JavaPlatform javaPlatform : manager.getInstalledPlatforms()) {
                if (!javaPlatform.getSourceFolders().contains(root) && !javaPlatform.getStandardLibraries().contains(root) && !javaPlatform.getBootstrapLibraries().contains(root)) continue;
                return TreeElementFactory.getTreeElement((Object)javaPlatform);
            }
        }
        if (FileUtil.getArchiveFile((FileObject)this.fo) != null) {
            return TreeElementFactory.getTreeElement((Object)FileUtil.getArchiveFile((FileObject)this.fo));
        }
        if (FileUtil.isArchiveFile((FileObject)this.fo)) {
            return null;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)this.fo);
        if (p != null) {
            return TreeElementFactory.getTreeElement((Object)p);
        }
        Object orig = this.fo.getAttribute("orig-file");
        if (orig != null && orig instanceof URL) {
            URL root = FileUtil.getArchiveFile((URL)((URL)orig));
            try {
                FileObject arch = FileUtil.toFileObject((File)Utilities.toFile((URI)root.toURI()));
                return TreeElementFactory.getTreeElement((Object)arch);
            }
            catch (URISyntaxException ex) {
                return TreeElementFactory.getTreeElement((Object)this.fo.getParent());
            }
        }
        return TreeElementFactory.getTreeElement((Object)this.fo.getParent());
    }

    public Icon getIcon() {
        try {
            ImageIcon imageIcon = new ImageIcon(DataObject.find((FileObject)this.fo).getNodeDelegate().getIcon(1));
            Boolean inTestFile = ElementGripFactory.getDefault().inTestFile(this.fo);
            if (Boolean.TRUE == inTestFile) {
                Image mergeImages = ImageUtilities.mergeImages((Image)imageIcon.getImage(), (Image)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_test.png", (boolean)false).getImage(), (int)4, (int)4);
                imageIcon = new ImageIcon(mergeImages);
            }
            return imageIcon;
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    public String getText(boolean isLogical) {
        return this.fo.getNameExt();
    }

    public Object getUserObject() {
        return this.fo;
    }

    public void open() {
        try {
            if (this.fo.isValid()) {
                DataObject od = DataObject.find((FileObject)this.fo);
                NbDocument.openDocument((Lookup.Provider)od, (int)0, (Line.ShowOpenType)Line.ShowOpenType.OPEN, (Line.ShowVisibilityType)Line.ShowVisibilityType.FOCUS);
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

