/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.EnumerateNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=EnumerateNode.class)
public final class EnumerateNodeGen
extends EnumerateNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile enumerateObject_isObject_;
    @Node.Child
    private EnumerateNode enumerateJSAdapter_enumerateCallbackResultNode_;
    @Node.Child
    private EnumerateTruffleObject0Data enumerateTruffleObject0_cache;
    @Node.Child
    private EnumerateTruffleObject1Data enumerateTruffleObject1_cache;
    @Node.Child
    private JSToObjectNode nonObject_toObjectNode_;
    @Node.Child
    private EnumerateNode nonObject_enumerateNode_;

    private EnumerateNodeGen(JSContext context, boolean values, boolean requireIterable, JavaScriptNode targetNode) {
        super(context, values, requireIterable, targetNode);
    }

    @Override
    @ExplodeLoop
    public DynamicObject execute(Object targetNodeValue) {
        int state = this.state_;
        if ((state & 3) != 0 && JSTypes.isDynamicObject(targetNodeValue)) {
            DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
            if ((state & 1) != 0 && JSGuards.isJSType(targetNodeValue_) && !JSGuards.isJSAdapter(targetNodeValue_)) {
                return this.doEnumerateObject(targetNodeValue_, this.enumerateObject_isObject_);
            }
            if ((state & 2) != 0 && JSGuards.isJSAdapter(targetNodeValue_)) {
                return this.doEnumerateJSAdapter(targetNodeValue_, this.enumerateJSAdapter_enumerateCallbackResultNode_);
            }
        }
        if ((state & 0x1C) != 0) {
            EnumerateTruffleObject1Data s4_;
            if ((state & 4) != 0) {
                EnumerateTruffleObject0Data s3_ = this.enumerateTruffleObject0_cache;
                while (s3_ != null) {
                    if (s3_.interop_.accepts(targetNodeValue) && JSGuards.isForeignObject(targetNodeValue)) {
                        return this.doEnumerateTruffleObject(targetNodeValue, s3_.interop_, s3_.keysInterop_, s3_.isHostObject_, s3_.notIterable_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 8) != 0 && (s4_ = this.enumerateTruffleObject1_cache) != null && JSGuards.isForeignObject(targetNodeValue)) {
                return this.enumerateTruffleObject1Boundary(state, s4_, targetNodeValue);
            }
            if ((state & 0x10) != 0 && !JSGuards.isJSObject(targetNodeValue)) {
                return this.doNonObject(targetNodeValue, this.nonObject_toObjectNode_, this.nonObject_enumerateNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private DynamicObject enumerateTruffleObject1Boundary(int state, EnumerateTruffleObject1Data s4_, Object targetNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(targetNodeValue);
            DynamicObject dynamicObject = this.doEnumerateTruffleObject(targetNodeValue, interop__, s4_.keysInterop_, s4_.isHostObject_, s4_.notIterable_);
            return dynamicObject;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    @ExplodeLoop
    public DynamicObject execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object targetNodeValue_ = this.targetNode.execute(frameValue);
        if ((state & 3) != 0 && JSTypes.isDynamicObject(targetNodeValue_)) {
            DynamicObject targetNodeValue__ = (DynamicObject)targetNodeValue_;
            if ((state & 1) != 0 && JSGuards.isJSType(targetNodeValue__) && !JSGuards.isJSAdapter(targetNodeValue__)) {
                return this.doEnumerateObject(targetNodeValue__, this.enumerateObject_isObject_);
            }
            if ((state & 2) != 0 && JSGuards.isJSAdapter(targetNodeValue__)) {
                return this.doEnumerateJSAdapter(targetNodeValue__, this.enumerateJSAdapter_enumerateCallbackResultNode_);
            }
        }
        if ((state & 0x1C) != 0) {
            EnumerateTruffleObject1Data s4_;
            if ((state & 4) != 0) {
                EnumerateTruffleObject0Data s3_ = this.enumerateTruffleObject0_cache;
                while (s3_ != null) {
                    if (s3_.interop_.accepts(targetNodeValue_) && JSGuards.isForeignObject(targetNodeValue_)) {
                        return this.doEnumerateTruffleObject(targetNodeValue_, s3_.interop_, s3_.keysInterop_, s3_.isHostObject_, s3_.notIterable_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 8) != 0 && (s4_ = this.enumerateTruffleObject1_cache) != null && JSGuards.isForeignObject(targetNodeValue_)) {
                return this.enumerateTruffleObject1Boundary0(state, s4_, targetNodeValue_);
            }
            if ((state & 0x10) != 0 && !JSGuards.isJSObject(targetNodeValue_)) {
                return this.doNonObject(targetNodeValue_, this.nonObject_toObjectNode_, this.nonObject_enumerateNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(targetNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private DynamicObject enumerateTruffleObject1Boundary0(int state, EnumerateTruffleObject1Data s4_, Object targetNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(targetNodeValue_);
            DynamicObject dynamicObject = this.doEnumerateTruffleObject(targetNodeValue_, interop__, s4_.keysInterop_, s4_.isHostObject_, s4_.notIterable_);
            return dynamicObject;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject executeAndSpecialize(Object targetNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(targetNodeValue)) {
                DynamicObject targetNodeValue_ = (DynamicObject)targetNodeValue;
                if (JSGuards.isJSType(targetNodeValue_) && !JSGuards.isJSAdapter(targetNodeValue_)) {
                    this.enumerateObject_isObject_ = ConditionProfile.createBinaryProfile();
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doEnumerateObject(targetNodeValue_, this.enumerateObject_isObject_);
                    return dynamicObject;
                }
                if (JSGuards.isJSAdapter(targetNodeValue_)) {
                    this.enumerateJSAdapter_enumerateCallbackResultNode_ = (EnumerateNode)super.insert((Node)this.createValues());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doEnumerateJSAdapter(targetNodeValue_, this.enumerateJSAdapter_enumerateCallbackResultNode_);
                    return dynamicObject;
                }
            }
            if (exclude == 0) {
                int count3_ = 0;
                EnumerateTruffleObject0Data s3_ = this.enumerateTruffleObject0_cache;
                if ((state & 4) != 0) {
                    while (!(s3_ == null || s3_.interop_.accepts(targetNodeValue) && JSGuards.isForeignObject(targetNodeValue))) {
                        s3_ = s3_.next_;
                        ++count3_;
                    }
                }
                if (s3_ == null && JSGuards.isForeignObject(targetNodeValue) && count3_ < 3) {
                    s3_ = (EnumerateTruffleObject0Data)super.insert((Node)new EnumerateTruffleObject0Data(this.enumerateTruffleObject0_cache));
                    s3_.interop_ = (InteropLibrary)s3_.insertAccessor(INTEROP_LIBRARY_.create(targetNodeValue));
                    s3_.keysInterop_ = (InteropLibrary)s3_.insertAccessor(INTEROP_LIBRARY_.createDispatched(3));
                    s3_.isHostObject_ = ConditionProfile.createBinaryProfile();
                    s3_.notIterable_ = BranchProfile.create();
                    this.enumerateTruffleObject0_cache = s3_;
                    this.state_ = state |= 4;
                }
                if (s3_ != null) {
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doEnumerateTruffleObject(targetNodeValue, s3_.interop_, s3_.keysInterop_, s3_.isHostObject_, s3_.notIterable_);
                    return dynamicObject;
                }
            }
            InteropLibrary interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                if (JSGuards.isForeignObject(targetNodeValue)) {
                    EnumerateTruffleObject1Data s4_ = (EnumerateTruffleObject1Data)super.insert((Node)new EnumerateTruffleObject1Data());
                    interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(targetNodeValue);
                    s4_.keysInterop_ = (InteropLibrary)s4_.insertAccessor(INTEROP_LIBRARY_.createDispatched(3));
                    s4_.isHostObject_ = ConditionProfile.createBinaryProfile();
                    s4_.notIterable_ = BranchProfile.create();
                    this.enumerateTruffleObject1_cache = s4_;
                    this.exclude_ = exclude |= 1;
                    this.enumerateTruffleObject0_cache = null;
                    state &= 0xFFFFFFFB;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doEnumerateTruffleObject(targetNodeValue, interop__, s4_.keysInterop_, s4_.isHostObject_, s4_.notIterable_);
                    return dynamicObject;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            if (!JSGuards.isJSObject(targetNodeValue)) {
                this.nonObject_toObjectNode_ = (JSToObjectNode)super.insert((Node)JSToObjectNode.createToObjectNoCheck(this.context));
                this.nonObject_enumerateNode_ = (EnumerateNode)super.insert((Node)this.copyRecursive());
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.doNonObject(targetNodeValue, this.nonObject_toObjectNode_, this.nonObject_enumerateNode_);
                return dynamicObject;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.targetNode}, new Object[]{targetNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        EnumerateTruffleObject0Data s3_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s3_ = this.enumerateTruffleObject0_cache) == null || s3_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doEnumerateObject";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.enumerateObject_isObject_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doEnumerateJSAdapter";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.enumerateJSAdapter_enumerateCallbackResultNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doEnumerateTruffleObject";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            EnumerateTruffleObject0Data s3_ = this.enumerateTruffleObject0_cache;
            while (s3_ != null) {
                cached.add(Arrays.asList(s3_.interop_, s3_.keysInterop_, s3_.isHostObject_, s3_.notIterable_));
                s3_ = s3_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doEnumerateTruffleObject";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            EnumerateTruffleObject1Data s4_ = this.enumerateTruffleObject1_cache;
            if (s4_ != null) {
                cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached(), s4_.keysInterop_, s4_.isHostObject_, s4_.notIterable_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doNonObject";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.nonObject_toObjectNode_, this.nonObject_enumerateNode_}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static EnumerateNode create(JSContext context, boolean values, boolean requireIterable, JavaScriptNode targetNode) {
        return new EnumerateNodeGen(context, values, requireIterable, targetNode);
    }

    @GeneratedBy(value=EnumerateNode.class)
    private static final class EnumerateTruffleObject1Data
    extends Node {
        @Node.Child
        InteropLibrary keysInterop_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isHostObject_;
        @CompilerDirectives.CompilationFinal
        BranchProfile notIterable_;

        EnumerateTruffleObject1Data() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=EnumerateNode.class)
    private static final class EnumerateTruffleObject0Data
    extends Node {
        @Node.Child
        EnumerateTruffleObject0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        InteropLibrary keysInterop_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isHostObject_;
        @CompilerDirectives.CompilationFinal
        BranchProfile notIterable_;

        EnumerateTruffleObject0Data(EnumerateTruffleObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

