/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.RemoveAction;
import org.netbeans.modules.j2ee.earproject.ui.actions.OpenModuleProjectAction;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class ModuleNode
extends AbstractNode
implements Node.Cookie {
    static final String MODULE_NODE_NAME = "module.node";
    private final FileObject projectDirectory;
    private final ClassPathSupport.Item key;
    private ClassPathSupport cs;
    private final UpdateHelper updateHelper;
    private EarProject project;
    boolean isWAR;

    public ModuleNode(ClassPathSupport.Item key, FileObject projectDirectory, EarProject project, UpdateHelper updateHelper, ClassPathSupport cs) {
        super(Children.LEAF);
        assert (key.getType() == 2);
        this.key = key;
        this.projectDirectory = projectDirectory;
        this.setName(MODULE_NODE_NAME);
        String value = project.evaluator().evaluate(key.getReference());
        this.isWAR = value != null && value.endsWith(".war");
        String dispName = EarProjectProperties.getCompletePathInArchive(project, key);
        this.setDisplayName(dispName);
        this.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_ModuleNode"));
        this.project = project;
        this.updateHelper = updateHelper;
        this.cs = cs;
        this.getCookieSet().add((Node.Cookie)this);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(OpenModuleProjectAction.class), SystemAction.get(RemoveAction.class)};
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenModuleProjectAction.class);
    }

    public Image getIcon(int type) {
        if (this.isWAR) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/earproject/ui/resources/WebModuleNode.gif");
        }
        if (this.key.getReference().indexOf("j2ee-module-car") > 0) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/earproject/ui/resources/CarModuleNodeIcon.gif");
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/earproject/ui/resources/EjbModuleNodeIcon.gif");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    void removeFromJarContent() {
        EarProjectProperties.removeJ2eeSubprojects(this.project, new Project[]{this.key.getArtifact().getProject()});
    }

    public ClassPathSupport.Item getVCPI() {
        return this.key;
    }

    public boolean canCopy() {
        return false;
    }
}

